/*
 * Decompiled with CFR 0.152.
 */
package v1;

import java.util.List;
import v1.ConjConstraintHandler;
import v1.ConstraintHandler;
import v1.Error;
import v1.Generator;
import v1.GeneratorAll;
import v1.GeneratorFactory;
import v1.InputFileData;
import v1.NewBDDConstraintHandler;
import v1.NoConstraintHandler;
import v1.OutOfMaxNumOfTestcasesException;
import v1.Outputer;
import v1.ParameterModel;
import v1.SATConstraintHandler;
import v1.Testcase;

public class Main {
    static int randomSeed = -1;
    static String modelFile;
    static int numOfIterations;
    static String seedFile;
    static String outputFile;
    static int strength;
    static final int MAX_LEVEL = 63;
    static final int MAX_ITERATIONS = 100000;
    static final int MAX_STRENGTH = 5;
    static final int Max_RandomSeed = 65535;
    static boolean debugMode;
    static Language language;
    static Handler handler;
    static Randstar randstar;
    static int verbose;

    static {
        numOfIterations = 1;
        strength = 2;
        debugMode = false;
        language = Language.JP;
        handler = Handler.UP;
        randstar = Randstar.OFF;
        verbose = 0;
    }

    public static void main(String[] args) {
        long start = System.currentTimeMillis();
        try {
            long endbdd;
            long startbdd;
            String errorMessage = Main.processCommandArgument(args);
            Error.setOutputFile(outputFile);
            if (errorMessage != null) {
                Error.printError(errorMessage);
            }
            InputFileData inputfiledata = new InputFileData(modelFile);
            if (verbose > 0) {
                System.out.println("Parameters :\t" + inputfiledata.parameterList.size());
                System.out.println("Strength:\t" + strength);
            }
            ConstraintHandler conhndl = null;
            if (handler == Handler.UP || handler == Handler.DOWN) {
                startbdd = System.currentTimeMillis();
                conhndl = new NewBDDConstraintHandler(inputfiledata.parameterList, inputfiledata.constraintList, inputfiledata.constrainedParameters, inputfiledata.ast);
                endbdd = System.currentTimeMillis();
                if (verbose > 0) {
                    System.out.println("BDD tm:\t" + (endbdd - startbdd) + "ms");
                }
            } else if (handler == Handler.NO) {
                conhndl = new NoConstraintHandler();
            } else if (handler == Handler.CONJ) {
                startbdd = System.currentTimeMillis();
                conhndl = new ConjConstraintHandler(inputfiledata.parameterList, inputfiledata.constraintList, inputfiledata.constrainedParameters, inputfiledata.ast);
                endbdd = System.currentTimeMillis();
                if (verbose > 0) {
                    System.out.println("BDD tm:\t" + (endbdd - startbdd) + "ms");
                }
            } else if (handler == Handler.SAT) {
                conhndl = new SATConstraintHandler(inputfiledata.parameterList, inputfiledata.constraintList, inputfiledata.constrainedParameters);
            } else {
                Error.printError("something bad happened");
            }
            List<Testcase> seed = null;
            List<Testcase> testSet = null;
            if (strength == -1) {
                try {
                    testSet = GeneratorAll.generate(new ParameterModel(inputfiledata.parameterList), conhndl);
                }
                catch (OutOfMaxNumOfTestcasesException e) {
                    Error.printError(language == Language.JP ? "\u30c6\u30b9\u30c8\u30b1\u30fc\u30b9\u6570\u304c\u4e0a\u965010000\u3092\u8d85\u3048\u307e\u3057\u305f" : "The number of test cases exceeded the upper bound 10000");
                }
                new Outputer(outputFile).outputResult(testSet, inputfiledata, modelFile, outputFile);
            } else {
                Generator generator = GeneratorFactory.newGenerator(new ParameterModel(inputfiledata.parameterList), inputfiledata.groupList, conhndl, seed, randomSeed, strength);
                try {
                    testSet = generator.generate();
                }
                catch (OutOfMaxNumOfTestcasesException e) {
                    testSet = null;
                }
                if (debugMode) {
                    System.err.println("random seed: " + randomSeed);
                }
                if (testSet == null) {
                    Error.printError(language == Language.JP ? "\u30c6\u30b9\u30c8\u30b1\u30fc\u30b9\u6570\u304c\u4e0a\u965010000\u3092\u8d85\u3048\u307e\u3057\u305f" : "The number of test cases exceeded the upper bound 10000");
                }
                new Outputer(outputFile).outputResult(testSet, inputfiledata, randomSeed, modelFile, seedFile, outputFile, strength, numOfIterations);
                System.out.println("# Number of Tests : " + testSet.size());
            }
            if (debugMode) {
                System.err.println("test set size: " + testSet.size());
            }
        }
        catch (OutOfMemoryError e) {
            Error.printError(language == Language.JP ? "\u30e1\u30e2\u30ea\u4e0d\u8db3\u3067\u3059\uff0e" : "Out of memory");
        }
        catch (Exception e) {
            Error.printError(language == Language.JP ? "\u30d7\u30ed\u30b0\u30e9\u30e0\u304c\u7570\u5e38\u7d42\u4e86\u3057\u307e\u3057\u305f\uff0e" : "Abnormal termination");
        }
        long end = System.currentTimeMillis();
        System.out.println("# Time (seconds) : " + (double)(end - start) / 1000.0);
    }

    private static String processCommandArgument(String[] args) {
        if (args.length == 0) {
            Error.printError("usage: java -jar Program.jar [-i input] [-o output] [-policy] ...");
        }
        if (args.length == 1 && args[0].equals("-policy")) {
            System.out.println("This software is distributed under the zlib license.\nThe software contains Java classes from JDD, a Java BDD library developed by Arash Vahidi.\nJDD is free software distributed under the zlib license.\n\nCopyright (c) 2018, Tatsuhiro Tsuchiya\nThis software is provided 'as-is', without any express or implied \nwarranty. In no event will the authors be held liable for any damages \narising from the use of this software. \n\nPermission is granted to anyone to use this software for any purpose, \nincluding commercial applications, and to alter it and redistribute it \nfreely, subject to the following restrictions: \n \n   1. The origin of this software must not be misrepresented; you must not \n   claim that you wrote the original software. If you use this software \n   in a product, an acknowledgment in the product documentation would be \n   appreciated but is not required. \n   \n   2. Altered source versions must be plainly marked as such, and must not be \n   misrepresented as being the original software. \n   \n   3. This notice may not be removed or altered from any source \n   distribution. \n");
            System.exit(0);
        }
        String errorMessage = null;
        int i = 0;
        while (i + 1 < args.length) {
            block58: {
                String option = args[i];
                String str = args[i + 1];
                if (option.equals("-i")) {
                    modelFile = str;
                } else if (option.equals("-o")) {
                    outputFile = str;
                } else if (option.equals("-random")) {
                    try {
                        randomSeed = Integer.parseInt(str);
                    }
                    catch (NumberFormatException e) {
                        errorMessage = language == Language.JP ? "\u30e9\u30f3\u30c0\u30e0\u30b7\u30fc\u30c9\u306b\u7121\u52b9\u306a\u5024\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u3059\uff0e" : "Invalid random seed";
                        break block58;
                    }
                    randomSeed = Math.abs(randomSeed) % 65536;
                } else if (option.equals("-c")) {
                    if (str.equals("all")) {
                        strength = -1;
                    } else {
                        try {
                            strength = Integer.parseInt(str);
                        }
                        catch (NumberFormatException e) {
                            errorMessage = language == Language.JP ? "\u7db2\u7f85\u5ea6\u306b\u7121\u52b9\u306a\u5024\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u3059\uff0e" : "Invalid strength";
                            break block58;
                        }
                        if (strength < 2 || 5 < strength) {
                            errorMessage = language == Language.JP ? "\u7db2\u7f85\u5ea6\u306b\u7121\u52b9\u306a\u5024\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u3059\uff0e" : "Invalid strength";
                        }
                    }
                } else if (option.equals("-repeat")) {
                    try {
                        numOfIterations = Integer.parseInt(str);
                    }
                    catch (NumberFormatException e) {
                        errorMessage = language == Language.JP ? "\u304f\u308a\u8fd4\u3057\u6570\u306b\u7121\u52b9\u306a\u5024\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u3059\uff0e" : "Invalid number of repetition times";
                        break block58;
                    }
                    if (numOfIterations <= 0 || numOfIterations > 100000) {
                        errorMessage = language == Language.JP ? "\u304f\u308a\u8fd4\u3057\u6570\u306b\u7121\u52b9\u306a\u5024\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u3059\uff0e" : "Invalid number of repetition times";
                    }
                } else if (option.equals("-s")) {
                    seedFile = str;
                } else if (option.equals("-debug")) {
                    debugMode = true;
                } else if (option.equals("-lang")) {
                    if (str.matches("JP|jp")) {
                        language = Language.JP;
                    } else if (str.matches("EN|en")) {
                        language = Language.EN;
                    } else {
                        errorMessage = "Invalid Language";
                    }
                } else if (option.equals("-chandler")) {
                    if (str.equalsIgnoreCase("no")) {
                        handler = Handler.NO;
                    } else if (str.equalsIgnoreCase("down")) {
                        handler = Handler.DOWN;
                    } else if (str.equalsIgnoreCase("up")) {
                        handler = Handler.UP;
                    } else if (str.equalsIgnoreCase("conj")) {
                        handler = Handler.CONJ;
                    } else if (str.equalsIgnoreCase("sat")) {
                        handler = Handler.SAT;
                    } else {
                        errorMessage = language == Language.JP ? "\u7121\u52b9\u306a\u5236\u7d04\u51e6\u7406\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u3059\uff0e" : "Invalid Constraint handler";
                    }
                } else if (option.equals("-randstar")) {
                    if (str.equalsIgnoreCase("off")) {
                        randstar = Randstar.OFF;
                    } else if (str.equalsIgnoreCase("on")) {
                        randstar = Randstar.ON;
                    } else if (str.equals("empty")) {
                        randstar = Randstar.EMPTY;
                    } else {
                        errorMessage = language == Language.JP ? "\u7121\u52b9\u306a\u30c9\u30f3\u30c8\u30b1\u30a2\u51e6\u7406\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u3059\uff0e" : "Invalid don't care handling option";
                    }
                } else if (option.equals("-verbose")) {
                    try {
                        verbose = Integer.parseInt(str);
                    }
                    catch (NumberFormatException e) {
                        errorMessage = "Invalid verbose level";
                    }
                } else {
                    errorMessage = language == Language.JP ? "\u7121\u52b9\u306a\u30aa\u30d7\u30b7\u30e7\u30f3\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u3059\uff0e" : "Invalid option";
                }
            }
            i += 2;
        }
        if (randomSeed == -1) {
            randomSeed = (int)Math.floor(Math.random() * 65536.0);
        }
        return errorMessage;
    }

    static enum Handler {
        NO,
        UP,
        DOWN,
        CONJ,
        SAT;

    }

    static enum Language {
        JP,
        EN;

    }

    static enum Randstar {
        ON,
        OFF,
        EMPTY;

    }
}

