/*
 * Decompiled with CFR 0.152.
 */
package v1;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TreeSet;
import v1.Error;
import v1.GList;
import v1.Group;
import v1.Main;
import v1.NoParameterNameException;
import v1.Node;
import v1.NodeAndConstrainedParameters;
import v1.OutOfTokenStreamException;
import v1.PList;
import v1.Parameter;
import v1.Parse;
import v1.ParseForVariableOrdering;
import v1.TokenHandler;
import v1.VOAndOperator;
import v1.VONode;

public class InputFileData {
    PList parameterList;
    GList groupList;
    List<Node> constraintList;
    TreeSet<Integer> constrainedParameters;
    VONode ast;

    InputFileData(PList parameterList, GList groupList, List<Node> constraintList, TreeSet<Integer> constrainedParameters) {
        this.parameterList = parameterList;
        this.groupList = groupList;
        this.constraintList = constraintList;
        this.constrainedParameters = constrainedParameters;
    }

    InputFileData(String filename) {
        BufferedReader reader = InputFileData.openFile(filename);
        List<String> tokenList = InputFileData.makeTokenList(reader);
        TokenHandler t = new TokenHandler(tokenList);
        this.parameterList = InputFileData.readParameter(t);
        if (Main.debugMode) {
            for (Parameter p : this.parameterList) {
                System.err.print(String.valueOf(p.name) + ": ");
                for (String name : p.value_name) {
                    System.err.print(String.valueOf(name) + ", ");
                }
                System.err.println();
            }
        }
        this.groupList = InputFileData.readGroup(t, this.parameterList);
        if (Main.debugMode) {
            for (Group g : this.groupList) {
                int i = 0;
                while (i < g.size) {
                    System.out.print(String.valueOf(g.member[i]) + ", ");
                    ++i;
                }
                System.out.println();
            }
        }
        int currentToken = t.index;
        this.readConstraint(t, this.parameterList);
        int currentToken2 = t.index;
        t.index = currentToken;
        this.ast = this.readConstraintForVariableOrdering(t, this.parameterList);
        t.index = currentToken2;
        try {
            reader.close();
        }
        catch (IOException e) {
            Error.printError(Main.language == Main.Language.JP ? "\u5165\u529b\u30d5\u30a1\u30a4\u30eb\u306b\u30a2\u30af\u30bb\u30b9\u3067\u304d\u307e\u305b\u3093" : "Cannot access the input file");
        }
    }

    private static BufferedReader openFile(String filename) {
        BufferedReader reader = null;
        if (filename == null) {
            return new BufferedReader(new InputStreamReader(System.in));
        }
        try {
            reader = new BufferedReader(new FileReader(filename));
        }
        catch (FileNotFoundException e) {
            Error.printError(Main.language == Main.Language.JP ? "\u30d5\u30a1\u30a4\u30eb" + filename + "\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\uff0e" : "Cannot find file " + filename);
        }
        return reader;
    }

    private static List<String> makeTokenList(BufferedReader reader) {
        ArrayList<String> tokenList = new ArrayList<String>();
        try {
            String line;
            block2: while ((line = reader.readLine()) != null) {
                line = line.replaceAll("\\(", " ( ");
                line = line.replaceAll("\\)", " ) ");
                line = line.replaceAll("#", " # ");
                line = line.replaceAll("\\{", " { ");
                line = line.replaceAll("\\}", " } ");
                line = line.replaceAll("\\[", " [ ");
                line = line.replaceAll("\\]", " ] ");
                line = line.replaceAll(";", " ; ");
                StringTokenizer st = new StringTokenizer(line);
                while (st.hasMoreTokens()) {
                    String token = st.nextToken();
                    if (token.equals("#")) continue block2;
                    tokenList.add(token);
                }
            }
            reader.close();
        }
        catch (IOException e) {
            Error.printError(e.getMessage());
        }
        return tokenList;
    }

    private static PList readParameter(TokenHandler t) {
        PList parameterList = new PList();
        while (true) {
            try {
                while (t.peepToken() != null && !t.peepToken().equals("{") && !t.peepToken().equals("(")) {
                    String parameter_name = t.getToken();
                    InputFileData.checkParameterName(parameter_name);
                    Parameter p = new Parameter(parameter_name);
                    if (!t.getToken().equals("(")) {
                        Error.printError(Main.language == Main.Language.JP ? "( \u304c\u3042\u308a\u307e\u305b\u3093\uff0e" : "( expected");
                    }
                    do {
                        String level_name = t.getToken();
                        InputFileData.checkLevelName(level_name);
                        p.addValueName(level_name);
                        if (t.peepToken() != null) continue;
                        Error.printError(Main.language == Main.Language.JP ? "\u30d1\u30e9\u30e1\u30fc\u30bf\u6307\u5b9a\u306b\u8aa4\u308a\u304c\u3042\u308a\u307e\u3059" : "Invalid parameters");
                    } while (!t.peepToken().equals(")"));
                    t.getToken();
                    p.check();
                    parameterList.add(p);
                }
            }
            catch (OutOfTokenStreamException e) {
                Error.printError(Main.language == Main.Language.JP ? "\u30d1\u30e9\u30e1\u30fc\u30bf\u6307\u5b9a\u306b\u8aa4\u308a\u304c\u3042\u308a\u307e\u3059" : "Invalid parameters");
                continue;
            }
            break;
        }
        if (parameterList.checkNameDuplication()) {
            Error.printError(Main.language == Main.Language.JP ? "\u56e0\u5b50\u540d\u304c\u91cd\u8907\u3057\u3066\u3044\u307e\u3059" : "Duplicated parameters");
        }
        if (parameterList.size() < 2) {
            Error.printError(Main.language == Main.Language.JP ? "\u56e0\u5b50\u306f2\u500b\u4ee5\u4e0a\u5fc5\u8981\u3067\u3059" : "Multiple parameters required");
        }
        parameterList.assignID1();
        Collections.sort(parameterList);
        return parameterList;
    }

    private static void checkParameterName(String name) {
        if (name.contains("(") || name.contains(")") || name.contains("{") || name.contains("}") || name.contains("[") || name.contains("]") || name.contains(";") || name.contains(",")) {
            Error.printError(Main.language == Main.Language.JP ? "\u56e0\u5b50\u540d\u306b\u7981\u6b62\u6587\u5b57\u304c\u542b\u307e\u308c\u3066\u3044\u307e\u3059" : "Invalid symbol in parameter name");
        }
    }

    private static void checkLevelName(String name) {
        if (name.contains("(") || name.contains(")") || name.contains("{") || name.contains("}") || name.contains("[") || name.contains("]") || name.contains(";") || name.contains(",")) {
            Error.printError(Main.language == Main.Language.JP ? "\u6c34\u6e96\u540d\u306b\u7981\u6b62\u6587\u5b57\u304c\u542b\u307e\u308c\u3066\u3044\u307e\u3059" : "Invalid symbol in parameter value");
        }
    }

    private static GList readGroup(TokenHandler t, PList parameterList) {
        GList groupList = new GList();
        while (t.peepToken() != null && !t.peepToken().equals("(")) {
            try {
                if (!t.getToken().equals("{")) {
                    Error.printError("{ expected");
                }
            }
            catch (OutOfTokenStreamException e) {
                Error.printError(Main.language == Main.Language.JP ? "\u30d1\u30e9\u30e1\u30fc\u30bf\u6307\u5b9a\u306b\u8aa4\u308a\u304c\u3042\u308a\u307e\u3059" : "Invalid parameter");
            }
            TreeSet<Integer> memberSet = new TreeSet<Integer>();
            do {
                String name = null;
                try {
                    name = t.getToken();
                }
                catch (OutOfTokenStreamException e) {
                    Error.printError(Main.language == Main.Language.JP ? "\u30b0\u30eb\u30fc\u30d7\u6307\u5b9a\u306b\u8aa4\u308a\u304c\u3042\u308a\u307e\u3059" : "Invalid grouping");
                }
                try {
                    memberSet.add(parameterList.getID(name));
                }
                catch (NoParameterNameException e) {
                    Error.printError(Main.language == Main.Language.JP ? "\u30b0\u30eb\u30fc\u30d7\u6307\u5b9a\u3067\u56e0\u5b50\u540d\u306b\u8aa4\u308a\u304c\u3042\u308a\u307e\u3059" : "Invalid parameter in group");
                }
                if (t.peepToken() != null) continue;
                Error.printError(Main.language == Main.Language.JP ? "\u30b0\u30eb\u30fc\u30d7\u6307\u5b9a\u306b\u8aa4\u308a\u304c\u3042\u308a\u307e\u3059" : "Invalid grouping");
            } while (!t.peepToken().equals("}"));
            Group g = new Group(memberSet);
            groupList.add(g);
            try {
                t.getToken();
            }
            catch (OutOfTokenStreamException e) {
                Error.printError(Main.language == Main.Language.JP ? "\u30b0\u30eb\u30fc\u30d7\u6307\u5b9a\u306b\u8aa4\u308a\u304c\u3042\u308a\u307e\u3059" : "Invalid grouping");
            }
        }
        groupList.sort();
        return groupList;
    }

    private void readConstraint(TokenHandler t, PList parameterList) {
        ArrayList<Node> constraintList = new ArrayList<Node>();
        TreeSet<Integer> constrainedParameters = new TreeSet<Integer>();
        while (t.peepToken() != null) {
            NodeAndConstrainedParameters res = new Parse(t, parameterList).extendedParseExpression();
            constraintList.add(res.node);
            constrainedParameters.addAll(res.constrainedParameters);
        }
        this.constraintList = constraintList;
        this.constrainedParameters = constrainedParameters;
    }

    private VONode readConstraintForVariableOrdering(TokenHandler t, PList parameterList) {
        VOAndOperator res = new VOAndOperator();
        while (t.peepToken() != null) {
            VONode n = new ParseForVariableOrdering(t, parameterList).parseExpression();
            res.ChildList.add(n);
        }
        if (res.ChildList.size() <= 1) {
            return res.ChildList.get(0);
        }
        return res;
    }
}

