/*
 * Decompiled with CFR 0.152.
 */
package v1;

import bits.Conjunction;
import bits.Disjunction;
import bits.IBooleanVariable;
import bits.IProblem;
import bits.ProblemDenier;
import java.util.ArrayList;
import java.util.List;
import jdd.bdd.BDD;
import v1.BooleanTrinaryOperator;
import v1.ParaIDAndNumLevels;
import v1.VariableAndBDD;

class IfthenelseOperator
extends BooleanTrinaryOperator {
    IfthenelseOperator() {
    }

    @Override
    int buildBDD(BDD bdd, List<VariableAndBDD> parameters, ArrayList<Integer> restricted) {
        int f1 = this.Left.buildBDD(bdd, parameters, restricted);
        int f2 = this.Middle.buildBDD(bdd, parameters, restricted);
        int f3 = this.Right.buildBDD(bdd, parameters, restricted);
        int f = bdd.ite(f1, f2, f3);
        bdd.ref(f);
        bdd.deref(f1);
        bdd.deref(f2);
        bdd.deref(f3);
        return f;
    }

    @Override
    IProblem buildSAT(ArrayList<ParaIDAndNumLevels> restricted, IBooleanVariable[][] boolenVariables) {
        Conjunction res = null;
        try {
            IProblem p = this.Left.buildSAT(restricted, boolenVariables);
            IProblem q = this.Middle.buildSAT(restricted, boolenVariables);
            IProblem r = this.Right.buildSAT(restricted, boolenVariables);
            Disjunction ifPart = new Disjunction(new ProblemDenier(p), q);
            Disjunction thenPart = new Disjunction(p, r);
            res = new Conjunction(ifPart, thenPart);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException();
        }
        return res;
    }
}

