/*
 * Decompiled with CFR 0.152.
 */
package jdd.util;

import jdd.util.Array;
import jdd.util.JDDConsole;
import jdd.util.Test;

public class DisjointSet {
    protected int[] s;
    protected int size;

    public DisjointSet(int n) {
        this.size = n;
        this.s = new int[n];
        Array.set(this.s, -1);
    }

    public void union(int n, int n2) {
        if (n == n2) {
            return;
        }
        if (this.s[n2] < this.s[n]) {
            this.s[n] = n2;
        } else {
            if (this.s[n] == this.s[n2]) {
                int n3 = n;
                this.s[n3] = this.s[n3] - 1;
            }
            this.s[n2] = n;
        }
    }

    public int find(int n) {
        if (this.s[n] < 0) {
            return n;
        }
        this.s[n] = this.find(this.s[n]);
        return this.s[n];
    }

    public int size() {
        return this.size;
    }

    public int classes() {
        int n = 0;
        for (int i = 0; i < this.size; ++i) {
            if (this.s[i] >= 0) continue;
            ++n;
        }
        return n;
    }

    public void showClass(int n) {
        int n2 = this.find(n);
        JDDConsole.out.print("{ ");
        for (int i = 0; i < this.size; ++i) {
            if (n2 != this.find(i)) continue;
            JDDConsole.out.print(i + " ");
        }
        JDDConsole.out.println("}");
    }

    public void dump() {
        for (int i = 0; i < this.size; ++i) {
            JDDConsole.out.print(i + " ");
        }
        JDDConsole.out.println();
    }

    public static void internal_test() {
        Test.start("DisjointSet");
        DisjointSet disjointSet = new DisjointSet(8);
        Test.checkEquality(disjointSet.classes(), 8, "classes 1");
        Test.checkInequality(disjointSet.find(4), disjointSet.find(5), "4 /~ 5");
        disjointSet.union(4, 5);
        Test.checkEquality(disjointSet.find(4), disjointSet.find(5), "4 ~ 5");
        Test.checkEquality(disjointSet.classes(), 7, "classes 2");
        disjointSet.union(6, 7);
        Test.checkEquality(disjointSet.find(6), disjointSet.find(7), "6 ~ 7");
        Test.checkEquality(disjointSet.classes(), 6, "classes 3");
        disjointSet.union(4, 6);
        Test.checkEquality(disjointSet.find(4), disjointSet.find(6), "4 ~ 6");
        Test.checkEquality(disjointSet.find(5), disjointSet.find(7), "5 ~ 7");
        Test.checkInequality(disjointSet.find(3), disjointSet.find(5), "3 /~ 5");
        Test.checkEquality(disjointSet.classes(), 5, "classes 4");
        Test.end();
    }
}

