/*
 * Decompiled with CFR 0.152.
 */
package jdd.sat.gsat;

import java.io.IOException;
import java.util.Enumeration;
import jdd.sat.Clause;
import jdd.sat.DimacsReader;
import jdd.sat.gsat.GSATSolver;
import jdd.util.JDDConsole;

public class WalkSATSolver
extends GSATSolver {
    private double p;

    public WalkSATSolver(long l, double d) {
        super(l);
        this.p = d;
    }

    @Override
    public void cleanup() {
        super.cleanup();
        this.stack = null;
    }

    @Override
    public int[] solve() {
        int n = 0;
        int n2 = this.cnf.num_lits;
        long l = System.currentTimeMillis();
        long l2 = l + this.maxtime;
        boolean[] blArray = new boolean[n2];
        int n3 = Math.min(1000, 3 * n2);
        if (this.stack == null) {
            this.stack = new int[n2];
        }
        this.randomize(blArray);
        while (l2 > System.currentTimeMillis()) {
            int n4;
            ++n;
            if (this.cnf.satisfies(blArray)) {
                JDDConsole.out.println("SAT/" + (System.currentTimeMillis() - l) + "ms");
                return this.toIntVector(blArray);
            }
            if (n % n3 == 0) {
                this.randomize(blArray);
                continue;
            }
            n4 = Math.random() < this.p ? (n4 = this.random(n2)) : this.findLiteral(blArray);
            blArray[n4] = !blArray[n4];
        }
        JDDConsole.out.println("UNKNOWN(" + n + " rounds)/" + (System.currentTimeMillis() - l) + "ms");
        return null;
    }

    private int findLiteral(boolean[] blArray) {
        int n;
        int n2 = this.cnf.num_lits;
        int n3 = -2147483647;
        int n4 = 0;
        for (n = 0; n < this.cnf.curr; ++n) {
            this.cnf.clauses[n].flag = this.cnf.clauses[n].satisfies(blArray) ? 1 : 0;
        }
        for (n = 0; n < n2; ++n) {
            int n5 = 0;
            Enumeration enumeration = this.cnf.vars[n].occurs.elements();
            while (enumeration.hasMoreElements()) {
                Clause clause = (Clause)enumeration.nextElement();
                boolean bl = clause.flag == 1;
                blArray[n] = !blArray[n];
                boolean bl2 = clause.satisfies(blArray);
                boolean bl3 = blArray[n] = !blArray[n];
                if (bl && !bl2) {
                    --n5;
                }
                if (bl || !bl2) continue;
                ++n5;
            }
            if (n5 > n3) {
                n4 = 0;
                n3 = n5;
            }
            if (n3 != n5) continue;
            this.stack[n4++] = n;
        }
        return n4 == 0 ? this.random(n2) : this.stack[this.random(n4)];
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            System.err.println("Need DIMACS file as argument");
        } else {
            for (int i = 0; i < stringArray.length; ++i) {
                try {
                    System.out.print("Solving " + stringArray[i] + "\t\t");
                    DimacsReader dimacsReader = new DimacsReader(stringArray[i], true);
                    WalkSATSolver walkSATSolver = new WalkSATSolver(2000L, 0.02);
                    walkSATSolver.setFormula(dimacsReader.getFormula());
                    dimacsReader = null;
                    walkSATSolver.solve();
                    walkSATSolver.cleanup();
                    continue;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }
}

