/*
 * Decompiled with CFR 0.152.
 */
package jdd.sat.gsat;

import java.io.IOException;
import java.util.Enumeration;
import jdd.sat.Clause;
import jdd.sat.DimacsReader;
import jdd.sat.Lit;
import jdd.sat.gsat.GSATSolver;
import jdd.util.Array;
import jdd.util.JDDConsole;

public class GSAT2Solver
extends GSATSolver {
    private Clause[][] occurneses;
    private int[] assignments;
    private boolean has_assignments;
    private int ignore;

    public GSAT2Solver(long l) {
        super(l);
    }

    private void setup_occurneses() {
        int n = this.cnf.num_lits;
        this.occurneses = new Clause[n][];
        for (int i = 0; i < n; ++i) {
            int n2 = 0;
            int n3 = this.cnf.vars[i].occurs.size();
            this.occurneses[i] = new Clause[n3];
            Enumeration enumeration = this.cnf.vars[i].occurs.elements();
            while (enumeration.hasMoreElements()) {
                this.occurneses[i][n2] = (Clause)enumeration.nextElement();
                ++n2;
            }
        }
    }

    private boolean setup_assignments() {
        int n = this.cnf.num_lits;
        this.assignments = new int[n];
        this.has_assignments = false;
        Array.set(this.assignments, -1);
        for (int i = 0; i < this.cnf.curr; ++i) {
            int n2;
            if (this.cnf.clauses[i].curr != 1) continue;
            Lit lit = this.cnf.clauses[i].lits[0];
            int n3 = n2 = lit.neg ? 0 : 1;
            if (this.assignments[lit.index] != -1 && this.assignments[lit.index] != n2) {
                return false;
            }
            this.assignments[lit.index] = n2;
            this.has_assignments = true;
        }
        if (this.has_assignments) {
            System.out.println("Formula has assignments");
        }
        return true;
    }

    @Override
    public int[] solve() {
        int n;
        if (!this.setup_assignments()) {
            JDDConsole.out.println("UNSAT(trivial)");
            return null;
        }
        this.setup_occurneses();
        int n2 = this.cnf.num_lits;
        int n3 = n = Math.min(1000, 5 * n2);
        long l = System.currentTimeMillis();
        long l2 = l + this.maxtime;
        long l3 = 0L;
        boolean[] blArray = new boolean[n2];
        this.ignore = -1;
        int n4 = -1;
        while (l2 > System.currentTimeMillis()) {
            ++l3;
            if (n3 == n && n4 != 0) {
                n3 = 0;
                this.ignore = -1;
                this.randomize(blArray);
                n4 = this.cnf.conflicts(blArray);
            } else {
                ++n3;
            }
            if (n4 == 0) {
                JDDConsole.out.println("SAT/" + (System.currentTimeMillis() - l) + "ms");
                return this.toIntVector(blArray);
            }
            int n5 = this.flipAndSolve(blArray, n4);
            n4 -= n5;
        }
        JDDConsole.out.println("UNKNOWN (" + l3 + " flips)/" + (System.currentTimeMillis() - l) + "ms");
        return null;
    }

    @Override
    protected void randomize(boolean[] blArray) {
        int n = blArray.length;
        if (this.has_assignments) {
            for (int i = 0; i < n; ++i) {
                blArray[i] = this.assignments[i] == -1 ? Math.random() >= 0.5 : this.assignments[i] == 1;
            }
        } else {
            for (int i = 0; i < n; ++i) {
                blArray[i] = Math.random() >= 0.5;
            }
        }
    }

    protected int flipAndSolve(boolean[] blArray, int n) {
        int n2;
        int n3 = blArray.length;
        int n4 = -2147483647;
        int n5 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            if (n2 == this.ignore) continue;
            int n6 = this.satisfiableIfFlip(n2, blArray);
            if (n6 == n) {
                blArray[n2] = !blArray[n2];
                return n;
            }
            if (n4 < n6) {
                n5 = 0;
                n4 = n6;
            }
            if (n4 != n6) continue;
            this.stack[n5++] = n2;
        }
        n2 = this.stack[this.random(n5)];
        boolean bl = !blArray[n2];
        blArray[n2] = bl;
        this.ignore = n2;
        return n4;
    }

    @Override
    protected int satisfiableIfFlip(int n, boolean[] blArray) {
        boolean bl = blArray[n];
        int n2 = 0;
        int n3 = 0;
        Clause[] clauseArray = this.occurneses[n];
        int n4 = clauseArray.length;
        for (int i = 0; i < n4; ++i) {
            blArray[n] = true;
            if (clauseArray[i].satisfies(blArray)) {
                ++n2;
            }
            blArray[n] = false;
            if (!clauseArray[i].satisfies(blArray)) continue;
            ++n3;
        }
        blArray[n] = bl;
        return bl ? n3 - n2 : n2 - n3;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            System.err.println("Need DIMACS file as argument");
        } else {
            for (int i = 0; i < stringArray.length; ++i) {
                try {
                    System.out.print("Solving " + stringArray[i] + "\t\t");
                    DimacsReader dimacsReader = new DimacsReader(stringArray[i], true);
                    GSAT2Solver gSAT2Solver = new GSAT2Solver(2000L);
                    gSAT2Solver.setFormula(dimacsReader.getFormula());
                    dimacsReader = null;
                    gSAT2Solver.solve();
                    gSAT2Solver.cleanup();
                    continue;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }
}

