/*
 * Decompiled with CFR 0.152.
 */
package jdd.sat.bdd;

import java.io.IOException;
import jdd.bdd.BDD;
import jdd.sat.CNF;
import jdd.sat.Clause;
import jdd.sat.DimacsReader;
import jdd.sat.Lit;
import jdd.sat.Solver;
import jdd.sat.Var;
import jdd.util.JDDConsole;
import jdd.util.Options;

public class BDDSolver
implements Solver {
    protected CNF cnf;
    protected boolean verbose;
    protected int[] bdd_vars;
    protected int vars_count;
    protected int clause_count;
    protected int bdd_all;
    protected BDD jdd;

    public BDDSolver(boolean bl) {
        this.verbose = bl;
        this.cleanup();
    }

    @Override
    public void cleanup() {
        this.cnf = null;
        this.jdd = null;
    }

    @Override
    public void setFormula(CNF cNF) {
        this.cnf = cNF;
    }

    @Override
    public int[] solve() {
        Object object;
        int n;
        int n2 = Math.min(150000, 10000 + 2 * this.cnf.num_lits * this.cnf.curr);
        int n3 = 4000;
        this.jdd = new BDD(n2, n3);
        Options.verbose = this.verbose;
        long l = System.currentTimeMillis();
        this.bdd_vars = new int[this.cnf.num_lits];
        this.vars_count = 0;
        Var[] varArray = this.cnf.vars;
        for (n = 0; n < this.bdd_vars.length; ++n) {
            this.bdd_vars[n] = this.jdd.createVar();
            varArray[n].negvar.bdd = -1;
            varArray[n].var.bdd = -1;
        }
        this.clause_count = 0;
        this.bdd_all = 1;
        for (n = 0; n < this.cnf.curr; ++n) {
            object = this.nextClause();
            int n4 = this.clauseBDD((Clause)object);
            int n5 = this.jdd.ref(this.jdd.and(this.bdd_all, n4));
            this.jdd.deref(this.bdd_all);
            this.jdd.deref(n4);
            this.bdd_all = n5;
            if (this.bdd_all == 0) break;
        }
        l = System.currentTimeMillis() - l;
        object = null;
        if (this.bdd_all == 0) {
            JDDConsole.out.println("UNSAT/" + l + "ms");
        } else {
            double d = this.jdd.satCount(this.bdd_all);
            JDDConsole.out.println("SAT(" + d + " solutions)/" + l + "ms");
            int[] nArray = this.jdd.oneSat(this.bdd_all, null);
            object = new int[nArray.length];
            for (int i = 0; i < ((Object)object).length; ++i) {
                object[i] = nArray[this.cnf.vars[i].offset];
            }
        }
        this.jdd.deref(this.bdd_all);
        if (this.verbose) {
            this.jdd.showStats();
        }
        this.jdd.cleanup();
        this.jdd = null;
        return object;
    }

    protected int getBDD(Lit lit) {
        if (lit.bdd == -1) {
            Var var = lit.var;
            var.offset = this.vars_count;
            var.var.bdd = this.bdd_vars[this.vars_count];
            var.negvar.bdd = this.jdd.ref(this.jdd.not(var.var.bdd));
            ++this.vars_count;
        }
        return lit.bdd;
    }

    protected Clause nextClause() {
        return this.cnf.clauses[this.clause_count++];
    }

    protected int clauseBDD(Clause clause) {
        int n = 0;
        for (int i = 0; i < clause.curr; ++i) {
            int n2 = this.jdd.ref(this.jdd.or(n, this.getBDD(clause.lits[i])));
            this.jdd.deref(n);
            n = n2;
        }
        return n;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            System.err.println("Need DIMACS file as argument");
        } else {
            for (int i = 0; i < stringArray.length; ++i) {
                try {
                    System.out.print("Solving " + stringArray[i] + "\t\t");
                    DimacsReader dimacsReader = new DimacsReader(stringArray[i], true);
                    BDDSolver bDDSolver = new BDDSolver(false);
                    bDDSolver.setFormula(dimacsReader.getFormula());
                    dimacsReader = null;
                    bDDSolver.solve();
                    bDDSolver.cleanup();
                    continue;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }
}

