/*
 * Decompiled with CFR 0.152.
 */
package jdd.sat;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.StringTokenizer;
import jdd.sat.CNF;
import jdd.sat.Clause;
import jdd.sat.Lit;

public class DimacsReader {
    private BufferedReader br;
    private CNF ret = null;

    public DimacsReader(String string, boolean bl) throws IOException {
        Reader reader = null;
        reader = bl ? new FileReader(string) : new StringReader(string);
        this.br = new BufferedReader(reader);
        StringTokenizer stringTokenizer = this.getLine();
        if (stringTokenizer == null) {
            throw new IOException("Load failed, empty formula?? ");
        }
        this.assure(stringTokenizer, "p");
        this.assure(stringTokenizer, "cnf");
        int n = this.getInt(stringTokenizer);
        int n2 = this.getInt(stringTokenizer);
        this.ret = new CNF(n2, n);
        int[] nArray = new int[n + 1];
        while ((stringTokenizer = this.getLine()) != null) {
            int n3;
            int n4 = 0;
            while ((n3 = this.getInt(stringTokenizer)) != 0) {
                nArray[n4++] = n3;
            }
            Clause clause = new Clause(n4);
            for (int i = 0; i < n4; ++i) {
                Lit lit = this.ret.getSignedLit(nArray[i]);
                if (lit == null) {
                    throw new IOException("BAD literal; " + nArray[i]);
                }
                if (lit.index > n) {
                    throw new IOException("max literals " + n2 + " but read " + nArray[i]);
                }
                clause.insert(lit);
            }
            this.ret.insert(clause);
        }
        this.ret.adjustNumClauses();
        this.br.close();
    }

    public CNF getFormula() {
        return this.ret;
    }

    private void assure(StringTokenizer stringTokenizer, String string) throws IOException {
        if (!stringTokenizer.hasMoreTokens()) {
            throw new IOException("pre-mature end of line when waiting for " + string);
        }
        String string2 = stringTokenizer.nextToken();
        if (!string2.equalsIgnoreCase(string)) {
            throw new IOException("Expected " + string + ", got " + string2);
        }
    }

    private int getInt(StringTokenizer stringTokenizer) throws IOException {
        if (!stringTokenizer.hasMoreTokens()) {
            throw new IOException("pre-mature end of line when waiting for a number ");
        }
        return Integer.parseInt(stringTokenizer.nextToken());
    }

    private StringTokenizer getLine() throws IOException {
        String string;
        do {
            if ((string = this.br.readLine()) != null) continue;
            return null;
        } while (string.length() <= 0 || string.charAt(0) == 'c');
        return new StringTokenizer(string);
    }
}

