/*
 * Decompiled with CFR 0.152.
 */
package jdd.sat;

import java.io.IOException;
import java.util.Enumeration;
import jdd.sat.Clause;
import jdd.sat.DimacsReader;
import jdd.sat.Lit;
import jdd.sat.Var;
import jdd.util.Array;
import jdd.util.Inverse;
import jdd.util.JDDConsole;
import jdd.util.Sort;
import jdd.util.Test;

public class CNF {
    public Clause[] clauses;
    public Lit[] lits;
    public Var[] vars;
    public int curr;
    public int num_clauses;
    public int num_lits;

    public static CNF parseDimacsText(String string) throws IOException {
        DimacsReader dimacsReader = new DimacsReader(string, false);
        return dimacsReader.getFormula();
    }

    public static CNF loadDimacs(String string) throws IOException {
        DimacsReader dimacsReader = new DimacsReader(string, true);
        return dimacsReader.getFormula();
    }

    public CNF(int n, int n2) {
        this.num_clauses = n;
        this.clauses = new Clause[this.num_clauses];
        this.num_lits = n2;
        this.lits = new Lit[2 * this.num_lits];
        this.vars = new Var[this.num_lits];
        for (int i = 0; i < this.num_lits; ++i) {
            this.vars[i] = new Var(i);
            this.lits[i * 2] = new Lit(this.vars[i], false);
            this.lits[i * 2 + 1] = new Lit(this.vars[i], true);
        }
        this.curr = 0;
    }

    public Lit getSignedLit(int n) {
        Test.check(n != 0);
        int n2 = n > 0 ? 0 : 1;
        n = Math.abs(n) - 1;
        if (n < 0 || n >= this.num_lits) {
            return null;
        }
        return this.lits[n * 2 + n2];
    }

    public Lit getLit(int n, boolean bl) {
        Test.check(n != 0);
        if (--n < 0 || n >= this.num_lits) {
            return null;
        }
        return bl ? this.lits[n * 2 + 1] : this.lits[n * 2];
    }

    public void insert(Clause clause) {
        if (clause.curr <= 0) {
            JDDConsole.out.println("ERROR: ignoring EMPTY clause");
        } else if (this.curr < this.num_clauses) {
            if (!clause.simplify()) {
                clause.computeHash();
                Clause clause2 = this.findLargerOrEqualClause(clause);
                if (clause2 == null) {
                    clause.index = this.curr;
                    this.clauses[this.curr++] = clause;
                    return;
                }
                JDDConsole.out.println("Clause ignored: equal or larger clause already exists");
            }
            JDDConsole.out.println("Clause ignored: simple tautology");
        } else {
            JDDConsole.out.println("ERROR: ignoring clause due to overflow");
        }
        clause.removeFromDatabase();
    }

    public void adjustNumClauses() {
        this.num_clauses = this.curr;
    }

    public boolean satisfies(boolean[] blArray) {
        for (int i = 0; i < this.curr; ++i) {
            if (this.clauses[i].satisfies(blArray)) continue;
            return false;
        }
        return true;
    }

    public int satisfies(int n, boolean bl) {
        int n2 = 0;
        for (int i = 0; i < this.curr; ++i) {
            if (!this.clauses[i].satisfies(n, bl)) continue;
            ++n2;
        }
        return n2;
    }

    public int conflicts(boolean[] blArray) {
        int n = 0;
        for (int i = 0; i < this.curr; ++i) {
            if (this.clauses[i].satisfies(blArray)) continue;
            ++n;
        }
        return n;
    }

    public void showDIMACS() {
        JDDConsole.out.println("p cnf " + this.num_lits + " " + this.num_clauses);
        for (int i = 0; i < this.curr; ++i) {
            this.clauses[i].showDIMACS();
        }
    }

    public Clause findEqualClause(Clause clause) {
        for (int i = 0; i < this.curr; ++i) {
            if (!this.clauses[i].equals(clause)) continue;
            return this.clauses[i];
        }
        return null;
    }

    public Clause findLargerOrEqualClause(Clause clause) {
        for (int i = 0; i < this.curr; ++i) {
            if (!this.clauses[i].largerOrEquals(clause)) continue;
            return this.clauses[i];
        }
        return null;
    }

    public void order() {
    }

    void sucks_order() {
        int n;
        for (n = 0; n < this.num_lits; ++n) {
            this.vars[n].activity = this.vars[n].occurs.size();
        }
        Sort.bubble_sort(this.vars);
        for (n = 0; n < this.num_lits; ++n) {
            this.vars[n].activity = n;
        }
        for (n = 0; n < this.num_clauses; ++n) {
            Clause clause = this.clauses[n];
            double d = 0.0;
            for (int i = 0; i < clause.curr; ++i) {
                d += clause.lits[i].var.activity;
            }
            clause.heat = d / (double)clause.curr;
        }
        Sort.bubble_sort(this.clauses);
        Inverse.inverse(this.clauses);
    }

    void SATZOO_order() {
        int n;
        int n2;
        int n3;
        double d;
        Clause clause;
        int n4;
        for (n4 = 0; n4 < this.num_lits; ++n4) {
            this.vars[n4].activity = 0.0;
        }
        for (n4 = 0; n4 < this.num_clauses; ++n4) {
            clause = this.clauses[n4];
            d = Math.pow(2.0, -clause.curr);
            for (n3 = 0; n3 < clause.curr; ++n3) {
                clause.lits[n3].var.activity += d;
            }
        }
        for (n4 = 0; n4 < this.num_clauses; ++n4) {
            clause = this.clauses[n4];
            d = 0.0;
            for (n3 = 0; n3 < clause.curr; ++n3) {
                d += clause.lits[n3].var.activity;
            }
            clause.heat = d;
        }
        double d2 = 0.0;
        for (n2 = 0; n2 < this.num_clauses; ++n2) {
            Clause clause2 = this.clauses[n2];
            for (n3 = 0; n3 < clause2.curr; ++n3) {
                d2 += (double)clause2.lits[n3].var.occurs.size();
            }
        }
        n2 = Math.min((int)((double)this.num_lits / d2 * 100.0), 10);
        double d3 = 1.0 / (double)n2;
        for (n = 0; n < n2; ++n) {
            for (int i = 0; i < this.num_clauses; ++i) {
                Clause clause3 = this.clauses[i];
                for (int j = 0; j < clause3.curr; ++j) {
                    Enumeration enumeration = clause3.lits[j].var.occurs.elements();
                    while (enumeration.hasMoreElements()) {
                        Clause clause4 = (Clause)enumeration.nextElement();
                        clause3.heat += clause4.heat * d3;
                    }
                }
            }
        }
        Sort.bubble_sort(this.clauses);
        for (n = 0; n < this.num_lits; ++n) {
            this.vars[n].activity = 0.0;
        }
        double d4 = 1.0E200;
        for (int i = 0; i < this.num_clauses; ++i) {
            Clause clause5 = this.clauses[i];
            for (int j = 0; j < clause5.curr; ++j) {
                if (clause5.lits[j].var.activity != 0.0) continue;
                clause5.lits[j].var.activity = d4;
                d4 *= 0.955;
            }
        }
        Sort.bubble_sort(this.vars);
    }

    public void check() {
        for (int i = 0; i < this.num_lits; ++i) {
            Test.checkEquality(this.vars[i].index, this.vars[i].var.index, "Li.index = Vi.index");
            Test.checkEquality(this.vars[i].index, this.vars[i].negvar.index, "~Li.index = Vi.index");
        }
    }

    public static void internal_test() {
        Test.start("CNF");
        String string = "data/dimacs50a.cnf";
        try {
            int n;
            int n2;
            CNF cNF = CNF.loadDimacs(string);
            int[] nArray = new int[Math.max(cNF.curr, cNF.num_lits)];
            Array.set(nArray, 0);
            for (n2 = 0; n2 < cNF.num_lits * 2; ++n2) {
                int n3 = n = cNF.lits[n2].index;
                nArray[n3] = nArray[n3] + 1;
            }
            n2 = 0;
            for (n = 0; n2 == 0 && n < cNF.num_lits; ++n) {
                if (nArray[n] == 2) continue;
                n2 = 1;
            }
            Test.check(n2 == 0, "Needs exactly two literals of index");
        }
        catch (IOException iOException) {
            Test.check(false, iOException.toString());
        }
        Test.end();
    }
}

