/*
 * Decompiled with CFR 0.152.
 */
package jdd.graph;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import jdd.graph.Edge;
import jdd.graph.Factory;
import jdd.graph.Graph;
import jdd.graph.Node;
import jdd.graph.SimpleAlgorithms;
import jdd.util.JDDConsole;
import jdd.util.Test;

public class GraphOperation {
    public static Graph clone(Graph graph) {
        Object object;
        Graph graph2 = new Graph(graph.directed);
        HashMap<Node, Node> hashMap = new HashMap<Node, Node>();
        Enumeration enumeration = graph.getNodes().elements();
        while (enumeration.hasMoreElements()) {
            object = (Node)enumeration.nextElement();
            Node node = graph2.addCopy((Node)object);
            hashMap.put((Node)object, node);
        }
        enumeration = graph.getEdges().elements();
        while (enumeration.hasMoreElements()) {
            object = (Edge)enumeration.nextElement();
            graph2.addCopy((Node)hashMap.get(((Edge)object).n1), (Node)hashMap.get(((Edge)object).n2), (Edge)object);
        }
        return graph2;
    }

    public static Graph hajos_construction(Graph graph, Node node, Node node2, Graph graph2, Node node3, Node node4) {
        Edge edge;
        Object object;
        Graph graph3 = new Graph(graph.isDirected());
        int n = graph.numOfNodes();
        int n2 = graph2.numOfNodes();
        Node[] nodeArray = new Node[n + n2];
        int n3 = 0;
        Enumeration enumeration = graph.getNodes().elements();
        while (n3 < n) {
            object = (Node)enumeration.nextElement();
            nodeArray[n3] = graph3.addCopy((Node)object);
            ((Node)object).extra1 = n3++;
        }
        enumeration = graph2.getNodes().elements();
        while (n3 < n + n2) {
            object = (Node)enumeration.nextElement();
            nodeArray[n3] = graph3.addCopy((Node)object);
            ((Node)object).extra1 = n3++;
        }
        enumeration = graph.getEdges().elements();
        while (enumeration.hasMoreElements()) {
            object = (Edge)enumeration.nextElement();
            edge = graph3.addEdge(nodeArray[((Edge)object).n1.extra1], nodeArray[((Edge)object).n2.extra1]);
            if ((((Edge)object).flags & 4) != 0) {
                edge.setLabel(((Edge)object).getLabel());
            }
            edge.flags = ((Edge)object).flags;
            edge.weight = ((Edge)object).weight;
        }
        enumeration = graph2.getEdges().elements();
        while (enumeration.hasMoreElements()) {
            object = (Edge)enumeration.nextElement();
            edge = graph3.addEdge(nodeArray[((Edge)object).n1.extra1], nodeArray[((Edge)object).n2.extra1]);
            if ((((Edge)object).flags & 4) != 0) {
                edge.setLabel(((Edge)object).getLabel());
            }
            edge.flags = ((Edge)object).flags;
            edge.weight = ((Edge)object).weight;
        }
        GraphOperation.disconnect(graph3, nodeArray[node.extra1], nodeArray[node2.extra1]);
        GraphOperation.disconnect(graph3, nodeArray[node3.extra1], nodeArray[node4.extra1]);
        GraphOperation.contraction(graph3, nodeArray[node.extra1], nodeArray[node3.extra1]);
        GraphOperation.connection(graph3, nodeArray[node2.extra1], nodeArray[node4.extra1]);
        return graph3;
    }

    public static void disconnect(Graph graph, Node node, Node node2) {
        Edge edge = graph.findEdge(node, node2);
        if (edge != null) {
            graph.removeEdge(edge);
        }
        if ((edge = graph.findEdge(node2, node)) != null) {
            graph.removeEdge(edge);
        }
    }

    public static void connection(Graph graph, Node node, Node node2) {
        graph.addEdge(node, node2);
        if (graph.isDirected()) {
            graph.addEdge(node2, node);
        }
    }

    public static void contraction(Graph graph, Node node, Node node2) {
        Edge edge;
        Edge edge2;
        if (node == node2) {
            return;
        }
        Vector<Edge> vector = new Vector<Edge>();
        Vector<Edge> vector2 = new Vector<Edge>();
        Edge edge3 = node.firstOut;
        while (edge3 != null) {
            if (edge3.n2 != node) {
                vector2.add(edge3);
            }
            edge3 = edge3.next;
        }
        edge3 = node.firstIn;
        while (edge3 != null) {
            if (edge3.n1 != node) {
                vector.add(edge3);
            }
            edge3 = edge3.prev;
        }
        graph.removeNode(node);
        JDDConsole.out.println("Removing " + node.getLabel());
        JDDConsole.out.println("Connecting to  " + node2.getLabel());
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            edge2 = (Edge)enumeration.nextElement();
            edge = graph.addEdge(edge2.n1, node2);
            edge.flags = edge2.flags;
            edge.weight = edge2.weight;
            edge.setLabel(edge2.getLabel());
        }
        enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            edge2 = (Edge)enumeration.nextElement();
            edge = graph.addEdge(node2, edge2.n2);
            edge.flags = edge2.flags;
            edge.weight = edge2.weight;
            edge.setLabel(edge2.getLabel());
        }
    }

    public static Graph union(Graph graph, Graph graph2) {
        return GraphOperation.add_graphs(graph, graph2, false);
    }

    public static Graph join(Graph graph, Graph graph2) {
        return GraphOperation.add_graphs(graph, graph2, true);
    }

    private static Graph add_graphs(Graph graph, Graph graph2, boolean bl) {
        Edge edge;
        Object object;
        Graph graph3 = new Graph(graph.isDirected());
        int n = graph.numOfNodes();
        int n2 = graph2.numOfNodes();
        Node[] nodeArray = new Node[n + n2];
        int n3 = 0;
        Enumeration enumeration = graph.getNodes().elements();
        while (n3 < n) {
            object = (Node)enumeration.nextElement();
            nodeArray[n3] = graph3.addCopy((Node)object);
            ((Node)object).extra1 = n3++;
        }
        enumeration = graph2.getNodes().elements();
        while (n3 < n + n2) {
            object = (Node)enumeration.nextElement();
            nodeArray[n3] = graph3.addCopy((Node)object);
            ((Node)object).extra1 = n3++;
        }
        enumeration = graph.getEdges().elements();
        while (enumeration.hasMoreElements()) {
            object = (Edge)enumeration.nextElement();
            edge = graph3.addEdge(nodeArray[((Edge)object).n1.extra1], nodeArray[((Edge)object).n2.extra1]);
            if ((((Edge)object).flags & 4) != 0) {
                edge.setLabel(((Edge)object).getLabel());
            }
            edge.flags = ((Edge)object).flags;
            edge.weight = ((Edge)object).weight;
        }
        enumeration = graph2.getEdges().elements();
        while (enumeration.hasMoreElements()) {
            object = (Edge)enumeration.nextElement();
            edge = graph3.addEdge(nodeArray[((Edge)object).n1.extra1], nodeArray[((Edge)object).n2.extra1]);
            if ((((Edge)object).flags & 4) != 0) {
                edge.setLabel(((Edge)object).getLabel());
            }
            edge.flags = ((Edge)object).flags;
            edge.weight = ((Edge)object).weight;
        }
        if (bl) {
            for (n3 = 0; n3 < n; ++n3) {
                for (int i = 0; i < n2; ++i) {
                    graph3.addEdge(nodeArray[n3], nodeArray[n + i]);
                }
            }
        }
        return graph3;
    }

    public static Node heavyNode(Graph graph, boolean bl) {
        Node node = null;
        double d = Double.NEGATIVE_INFINITY;
        Enumeration enumeration = graph.getNodes().elements();
        while (enumeration.hasMoreElements()) {
            Node node2 = (Node)enumeration.nextElement();
            double d2 = 0.0;
            Edge edge = node2.firstOut;
            while (edge != null) {
                d2 += bl ? edge.weight : 1.0;
                edge = edge.next;
            }
            edge = node2.firstIn;
            while (edge != null) {
                d2 += bl ? edge.weight : 1.0;
                edge = edge.prev;
            }
            if (!(d2 > d)) continue;
            node = node2;
            d = d2;
        }
        return node;
    }

    public static Node lightNode(Graph graph, boolean bl) {
        Node node = null;
        double d = Double.POSITIVE_INFINITY;
        Enumeration enumeration = graph.getNodes().elements();
        while (enumeration.hasMoreElements()) {
            Node node2 = (Node)enumeration.nextElement();
            double d2 = 0.0;
            Edge edge = node2.firstOut;
            while (edge != null) {
                d2 += bl ? edge.weight : 1.0;
                edge = edge.next;
            }
            edge = node2.firstIn;
            while (edge != null) {
                d2 += bl ? edge.weight : 1.0;
                edge = edge.prev;
            }
            if (!(d2 < d)) continue;
            node = node2;
            d = d2;
        }
        return node;
    }

    public static void internal_test() {
        Test.start("GraphOperation");
        Graph graph = Factory.complete(2);
        Graph graph2 = Factory.complete(3);
        Graph graph3 = GraphOperation.union(graph, graph2);
        Graph graph4 = GraphOperation.join(graph, graph2);
        Test.checkEquality(SimpleAlgorithms.number_of_islands(graph3), 2, "union => not connected");
        Test.checkEquality(SimpleAlgorithms.number_of_islands(graph4), 1, "joing => still connected");
        Test.checkEquality(graph3.numOfNodes(), graph.numOfNodes() + graph2.numOfNodes(), "g1 |V|");
        Test.checkEquality(graph4.numOfNodes(), graph.numOfNodes() + graph2.numOfNodes(), "g2 |V|");
        Test.checkEquality(graph3.numOfEdges(), graph.numOfEdges() + graph2.numOfEdges(), "g1 |E|");
        Test.checkEquality(graph4.numOfEdges(), graph.numOfEdges() + graph2.numOfEdges() + graph.numOfNodes() * graph2.numOfNodes(), "g2 |E|");
        Graph graph5 = new Graph(false);
        Node node = graph5.addNode();
        Node node2 = graph5.addNode();
        Node node3 = graph5.addNode();
        graph5.addEdge(node, node2);
        graph5.addEdge(node, node3);
        Node node4 = GraphOperation.lightNode(graph5, false);
        Test.check(GraphOperation.heavyNode(graph5, false) == node, "havy node, no weights");
        Test.check(node4 == node2 || node4 == node3, "light node, no weights");
        Node node5 = graph5.addNode();
        Edge edge = graph5.addEdge(node5, node3);
        edge.setWeight(1000.0);
        edge = graph5.addEdge(node5, node2);
        edge.setWeight(1000.0);
        Test.check(GraphOperation.heavyNode(graph5, true) == node5, "havy node, no weights");
        Test.check(GraphOperation.lightNode(graph5, true) == node, "light node, no weights");
        Test.end();
    }
}

