/*
 * Decompiled with CFR 0.152.
 */
package jdd.des.automata.bdd;

import jdd.des.automata.Automata;
import jdd.des.automata.bdd.BDDAutomata;
import jdd.des.automata.bdd.BDDAutomaton;

public class BDDAutomataHelper {
    public static int suggestInitialNodes(Automata automata) {
        double d = 10000.0 * (1.0 + Math.log(1 + automata.size()));
        return (int)Math.min(d, 800000.0);
    }

    public static double countStates(BDDAutomata bDDAutomata, int n) {
        double d = bDDAutomata.satCount(n);
        double d2 = Math.pow(2.0, bDDAutomata.getSVectorLength() + bDDAutomata.getEVectorLength());
        return d / d2;
    }

    public static int getI(BDDAutomata bDDAutomata) {
        int n = 1;
        BDDAutomaton[] bDDAutomatonArray = bDDAutomata.automata;
        for (int i = 0; i < bDDAutomatonArray.length; ++i) {
            n = bDDAutomata.andTo(n, bDDAutomatonArray[i].getBDDI());
        }
        return n;
    }

    public static int getT(BDDAutomata bDDAutomata) {
        int n;
        int n2 = 1;
        BDDAutomaton[] bDDAutomatonArray = bDDAutomata.automata;
        for (n = 0; n < bDDAutomatonArray.length; ++n) {
            n2 = bDDAutomata.andTo(n2, bDDAutomatonArray[n].getBDDDeltaTop());
        }
        n = bDDAutomata.ref(bDDAutomata.exists(n2, bDDAutomata.getBDDCubeEvents()));
        bDDAutomata.deref(n2);
        return n;
    }
}

