/*
 * Decompiled with CFR 0.152.
 */
package jdd.des.automata;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import jdd.des.automata.Alphabet;
import jdd.des.automata.Automata;
import jdd.des.automata.AutomataXMLHandler;
import jdd.des.automata.Automaton;
import jdd.des.automata.Event;
import jdd.des.automata.State;
import jdd.des.automata.Transition;
import jdd.graph.Node;
import jdd.util.JDDConsole;
import jdd.util.NotCloseableInputStream;
import jdd.util.Test;
import jdd.util.XMLHelper;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class AutomataIO {
    public static void saveXML(Automaton automaton, String string) {
        AutomataIO.saveXML_internal(automaton, null, string, null);
    }

    public static void saveXML(Automata automata, String string) {
        AutomataIO.saveXML_internal(null, automata.automata, string, automata.getName());
    }

    private static void saveXML_internal(Automaton automaton, Vector vector, String string, String string2) {
        try {
            PrintStream printStream = new PrintStream(new FileOutputStream(string));
            printStream.println("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>");
            printStream.print("\t<Automata");
            if (string2 != null) {
                printStream.print(" name=\"" + string2 + "\"");
            }
            printStream.println(" >");
            if (automaton != null) {
                AutomataIO.save_one_automaton(automaton, printStream);
            }
            if (vector != null) {
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    Automaton automaton2 = (Automaton)enumeration.nextElement();
                    AutomataIO.save_one_automaton(automaton2, printStream);
                }
            }
            printStream.println("\t</Automata>");
            printStream.flush();
            printStream.close();
        }
        catch (IOException iOException) {
            JDDConsole.out.println("Unable to save automaton to " + string + ":" + iOException);
        }
    }

    private static void save_one_automaton(Automaton automaton, PrintStream printStream) {
        Object object;
        printStream.print("\t<Automaton name=\"" + automaton.getName() + "\"");
        if (automaton.getType() != null) {
            printStream.print(" type=\"" + automaton.getType() + "\"");
        }
        printStream.println(">");
        printStream.println("\t\t<Events>");
        Alphabet alphabet = automaton.getAlphabet();
        Event event = alphabet.root;
        while (event != null) {
            printStream.print("\t\t\t<Event id=\"" + event.id + "\" label=\"" + event.getLabel() + "\" ");
            if (!event.isControllable()) {
                printStream.print("controllable=\"false\" ");
            }
            if (!event.isObservable()) {
                printStream.print("observable=\"false\" ");
            }
            if (event.getWeight() != 1.0) {
                printStream.print(" cost=\"" + event.getWeight() + "\"");
            }
            printStream.println(" />");
            event = event.next;
        }
        printStream.println("\t\t</Events>");
        printStream.println("\t\t<States>");
        Enumeration enumeration = automaton.getNodes().elements();
        while (enumeration.hasMoreElements()) {
            object = (State)enumeration.nextElement();
            printStream.print("\t\t\t<State id=\"" + ((State)object).id + "\" name=\"" + ((Node)object).getLabel() + "\"");
            if (((State)object).isInitial()) {
                printStream.print(" initial=\"true\"");
            }
            if (((State)object).isMarked()) {
                printStream.print(" accepting=\"true\"");
            }
            if (((State)object).isForbidden()) {
                printStream.print(" forbidden=\"true\"");
            }
            if (((Node)object).getWeight() != 0.0) {
                printStream.print(" cost=\"" + ((Node)object).getWeight() + "\"");
            }
            printStream.println("/>");
        }
        printStream.println("\t\t</States>");
        printStream.println("\t\t<Transitions>");
        enumeration = automaton.getEdges().elements();
        while (enumeration.hasMoreElements()) {
            object = (Transition)enumeration.nextElement();
            printStream.println("\t\t\t<Transition source=\"" + ((Transition)object).n1.id + "\" dest=\"" + ((Transition)object).n2.id + "\" " + " event=\"" + ((Transition)object).event.id + "\"/>");
        }
        printStream.println("\t\t</Transitions>");
        printStream.println("\t</Automaton>");
    }

    public static Automata loadXML(String string) {
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            Automata automata = AutomataIO.loadXML(fileInputStream);
            ((InputStream)fileInputStream).close();
            return automata;
        }
        catch (Exception exception) {
            JDDConsole.out.println("Unable to load automaton from " + string + ":" + exception);
            exception.printStackTrace();
            return null;
        }
    }

    public static Automata loadXML(InputStream inputStream) throws IOException, SAXException, ParserConfigurationException {
        SAXParser sAXParser = XMLHelper.getParser();
        AutomataXMLHandler automataXMLHandler = new AutomataXMLHandler();
        sAXParser.parse((InputStream)new NotCloseableInputStream(inputStream), (DefaultHandler)automataXMLHandler);
        return automataXMLHandler.automata;
    }

    public static void internal_test() {
        Test.start("AutomataIO");
        Automata automata = AutomataIO.loadXML("data/phil.xml");
        Test.checkEquality(automata.size(), 4, "4 automata loaded");
        Test.end();
    }
}

