/*
 * Decompiled with CFR 0.152.
 */
package jdd.bed;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import jdd.bdd.NodeTable;
import jdd.bed.BED;
import jdd.util.Dot;
import jdd.util.JDDConsole;
import jdd.util.NodeName;

public class BEDPrinter {
    private static NodeTable nt;
    private static PrintStream ps;
    private static NodeName nn;
    private static BED bed_;
    private static boolean had_one;
    private static boolean had_zero;

    private static void helpGC() {
        nt = null;
        ps = null;
        nn = null;
        bed_ = null;
    }

    public static void print(int n, NodeTable nodeTable, NodeName nodeName) {
        if (n < 2) {
            JDDConsole.out.println("\nBED " + n + ": " + (n == 0 ? "FALSE" : "TRUE"));
        } else {
            nt = nodeTable;
            nn = nodeName;
            JDDConsole.out.println("\nBED " + n);
            BEDPrinter.print_rec(n);
            nodeTable.unmark_tree(n);
            BEDPrinter.helpGC();
        }
    }

    private static void print_rec(int n) {
        if (n < 2) {
            return;
        }
        if (nt.isNodeMarked(n)) {
            return;
        }
        int n2 = nt.getVar(n);
        JDDConsole.out.println("" + n + "\t" + nn.variable(n2) + "(" + n2 + ")\t" + nt.getLow(n) + "\t" + nt.getHigh(n));
        nt.mark_node(n);
        BEDPrinter.print_rec(nt.getLow(n));
        BEDPrinter.print_rec(nt.getHigh(n));
    }

    public static void printFormula(BED bED, int n, NodeTable nodeTable, NodeName nodeName) {
        if (n < 2) {
            JDDConsole.out.println(n == 0 ? nodeName.zero() : nodeName.one());
        } else {
            nt = nodeTable;
            nn = nodeName;
            bed_ = bED;
            BEDPrinter.printFormula_rec(n);
            JDDConsole.out.println();
            BEDPrinter.helpGC();
        }
    }

    private static void printFormula_rec(int n) {
    }

    public static void printDot(String string, int n, NodeTable nodeTable, NodeName nodeName) {
        try {
            ps = new PrintStream(new FileOutputStream(string));
            ps.println("digraph G {");
            nn = nodeName;
            nt = nodeTable;
            had_zero = false;
            had_one = false;
            ps.println("\tinit__ [label=\"\", style=invis, height=0, width=0];");
            ps.println("\tinit__ -> " + n + ";");
            BEDPrinter.printDot_rec(n);
            if (had_one && had_zero) {
                ps.println("\t{ rank = same; 0; 1;}");
            }
            if (had_zero) {
                ps.println("\t0 [shape=box, label=\"" + nodeName.zeroShort() + "\", style=filled, height=0.3, width=0.3];");
            }
            if (had_one) {
                ps.println("\t1 [shape=box, label=\"" + nodeName.oneShort() + "\", style=filled, height=0.3, width=0.3];\n");
            }
            ps.println("}\n");
            nodeTable.unmark_tree(n);
            ps.close();
            Dot.showDot(string);
            BEDPrinter.helpGC();
        }
        catch (IOException iOException) {
            JDDConsole.out.println("BEDPrinter.printDOT failed: " + iOException);
        }
    }

    private static void printDot_rec(int n) {
        if (n == 0) {
            had_zero = true;
            return;
        }
        if (n == 1) {
            had_one = true;
            return;
        }
        if (nt.isNodeMarked(n)) {
            return;
        }
        int n2 = nt.getVar(n);
        int n3 = nt.getLow(n);
        int n4 = nt.getHigh(n);
        int n5 = BED.GET_OPERATION(n2);
        ps.print("" + n + " [label=\"" + nn.variable(n2) + ":" + n + "\"];");
        ps.println("" + n + " -> " + n3 + (BED.IS_BDD(n2) ? " [style=dotted];" : " [style=filled];"));
        ps.println("" + n + " -> " + n4 + " [style=filled];");
        nt.mark_node(n);
        BEDPrinter.printDot_rec(n3);
        BEDPrinter.printDot_rec(n4);
    }
}

