
# This file contains Tcl code used by the scripts that generate web-pages 
# (mkwebpage.tcl, mksupportpage.tcl) to generate the boxes on the left-hand
# side of the pages.
#

# This global variable contains the complete html text of the 
# "Site Contents" box.
set ::SiteMap {
    <!--
  	The following <div> block implements the "Site Contents" box. The
  	original text (from which each page copies this block) is contained in
  	the file webpage/common.tcl of the source distribution. If you need to
  	edit it, change it in webpage/common.tcl and regenerate the site.
    -->
    <div id="sitemap">
      <h3>Site Contents</h3>
      <ul>
        <li> <a href="index.html">Home</a>
             <span class="caption">Front page of this site</span>
        <li> <a href="support.html">Standards</a>
             <span class="caption">
                 Summary of support for CSS and HTML standards</span>
        <li> <a href="tkhtml.html">Man page</a>
             <span class="caption">
                 Unix style manual page for the widget.
             </span>
        <li> <a href="hv3.html">Hv3</a>
             <span class="caption">
                 Page for the demo/test application hv3. Screenshots and
                 starpacks for windows and linux are available here.
             </span>
        <li> <a href="http://tkhtml.tcl.tk/cvstrac/timeline">Cvstrac</a>
             <span class="caption">
		  Cvstrac is used for project change-log, wiki and bug
                  tracking.
             </span>
      </ul>
    </div>
}

proc getTabs {idx} {
  set ret "<center>"
  append ret {<div id="sitemap">}
  append ret <table><tr>
  set ii 0
  foreach {label href caption} [list                                         \
    Home       index.html   "Front page of this site"                        \
    Standards  support.html "Summary of support for CSS and HTML standards"  \
    "Tkhtml3"  tkhtml.html  "Unix style manual page for the Tkhtml3 widget." \
    Hv3        hv3.html     {
		 Page for the web browser application hv3. Screenshots and
                 starpacks for windows and linux are available here. }       \
    FFAQ       ffaq.html     "tkhtml.tcl.tk FFAQ"                            \
    Cvstrac      http://tkhtml.tcl.tk/cvstrac/timeline {
		  Cvstrac is used for project change-log, wiki and bug
                  tracking. }
  ] {
    if {$ii==$idx} {
      append ret [subst {
        <td><a id="active" href="$href">$label</div></a>}]
    } else {
      append ret "<td><a href=\"$href\">$label</a>"
    }
    append ret "<span class=\"caption\">$caption</span>"

    append ret {<td width=10 class="spacer"></td>}
    incr ii
  }
  append ret </table>
  append ret </div>
  return $ret
}

set ::PageSectionList [list]
proc addPageSection {title name} {
  lappend ::PageSectionList [list $title $name]
}

proc getToc {} {
  append ret {
    <!--
    	The following <div> block implements the "Page Contents" box.
  	This is auto-generated by code in the file webpage/common.tcl.
    -->
    <div id="toc">
      <h3>Page Contents</h3>
      <ul>
  }
  foreach entry $::PageSectionList {
    foreach {caption href} $entry {}
    append ret "        <li><a href=\"#$href\">$caption</a></li>\n"
  }
  append ret "      </ul>\n    </div>"

  return $ret
}
