// This file implements the IPersistFolder Interface and Gateway for Python.
// Generated by makegw.py

#include "shell_pch.h"
#include "PyIPersist.h"
#include "PyIPersistFolder.h"

// @doc - This file contains autoduck documentation
// ---------------------------------------------------
//
// Interface Implementation

PyIPersistFolder::PyIPersistFolder(IUnknown *pdisp):
	PyIPersist(pdisp)
{
	ob_type = &type;
}

PyIPersistFolder::~PyIPersistFolder()
{
}

/* static */ IPersistFolder *PyIPersistFolder::GetI(PyObject *self)
{
	return (IPersistFolder *)PyIPersist::GetI(self);
}

// @pymethod |PyIPersistFolder|Initialize|Description of Initialize.
PyObject *PyIPersistFolder::Initialize(PyObject *self, PyObject *args)
{
	IPersistFolder *pIPF = GetI(self);
	if ( pIPF == NULL )
		return NULL;
	// @pyparm <o PyIDL>|pidl||Description for pidl
	PyObject *obpidl;
	LPITEMIDLIST pidl;
	if ( !PyArg_ParseTuple(args, "O:Initialize", &obpidl) )
		return NULL;
	BOOL bPythonIsHappy = TRUE;
	if (bPythonIsHappy && !PyObject_AsPIDL(obpidl, &pidl)) bPythonIsHappy = FALSE;
	if (!bPythonIsHappy) return NULL;
	HRESULT hr;
	PY_INTERFACE_PRECALL;
	hr = pIPF->Initialize( pidl );
	PyObject_FreePIDL(pidl);

	PY_INTERFACE_POSTCALL;

	if ( FAILED(hr) )
		return PyCom_BuildPyException(hr, pIPF, IID_IPersistFolder );
	Py_INCREF(Py_None);
	return Py_None;

}

// @object PyIPersistFolder|Description of the interface
static struct PyMethodDef PyIPersistFolder_methods[] =
{
	{ "Initialize", PyIPersistFolder::Initialize, 1 }, // @pymeth Initialize|Description of Initialize
	{ NULL }
};

PyComTypeObject PyIPersistFolder::type("PyIPersistFolder",
		&PyIPersist::type,
		sizeof(PyIPersistFolder),
		PyIPersistFolder_methods,
		GET_PYCOM_CTOR(PyIPersistFolder));
// ---------------------------------------------------
//
// Gateway Implementation
STDMETHODIMP PyGPersistFolder::GetClassID(CLSID __RPC_FAR *pClassID) {return PyGPersist::GetClassID(pClassID);}

STDMETHODIMP PyGPersistFolder::Initialize(
		/* [in] */ LPCITEMIDLIST pidl)
{
	PY_GATEWAY_METHOD;
	PyObject *obpidl;
	obpidl = PyObject_FromPIDL(pidl, FALSE);
	HRESULT hr=InvokeViaPolicy("Initialize", NULL, "O", obpidl);
	Py_XDECREF(obpidl);
	return hr;
}

