/// Copyright (C) 2017, Mocchi
/// Tcl Thin Wrapper
/// License: Boost ver.1


#include "tcl.h"
#include "tk.h"
//#include "tommath.h"

class TTW_ListObj;

#ifdef TTW_EXPORTS
#define TTW_DECL __declspec(dllexport)
#else
#define TTW_DECL
#endif

/// ===================================
/// Tcl_DString ₷NX
class TTW_DECL TTW_DString{
	/// Tcl_DString ̃GR[fBO͏󋵈ˑ
	/// ǂȃGR[fBOœĂǂɁA
	/// ǂ̃GR[fBOœĂ邩͎gp҂ǗB
	Tcl_DString dstr;
public:
	/// ====== CX^X ======
	TTW_DString();
	TTW_DString(int length);
	TTW_DString(const char *str);
	TTW_DString(const char *str, int length);
	TTW_DString(const Tcl_DString &rhs); 
	TTW_DString(const TTW_DString &rhs); 
	TTW_DString(Tcl_Obj *obj); // Tcl_Obj ̓` utf-8 

	TTW_DString &operator =(const char *rhs);
	TTW_DString &operator =(const Tcl_DString &rhs);
	TTW_DString &operator =(const TTW_DString &rhs);
	TTW_DString &operator =(Tcl_Obj *obj);
	~TTW_DString();

	/// ====== ̃ZbgAǉ ======
	//  Tcl_DString CX^XɈړB
	TTW_DString &Move(Tcl_DString &rhs);
	TTW_DString &Move(TTW_DString &rhs);

	TTW_DString &Set(const char *str, int length);
	TTW_DString &Append(const char *str, int length);

	TTW_DString &operator << (const char *rhs);
	TTW_DString &operator << (const Tcl_DString &rhs);
	TTW_DString &operator << (const TTW_DString &rhs);
	TTW_DString &operator << (Tcl_Obj *obj);

	/// ====== R[hϊ ======
	// ŗ^ꂽVXeGR[fBO UTF8 ɕϊĊi[
	TTW_DString &SysToUtf8(const char *str, bool append = true);
	TTW_DString &SysToUtf8(const char *str, int length, bool append = true);
	TTW_DString &SysToUtf8(const Tcl_DString &str, bool append = true);
	TTW_DString &SysToUtf8(const TTW_DString &str, bool append = true);

	// ŗ^ꂽ w肳ꂽGR[fBOƂ݂ȂAUTF8 ɕϊĊi[
	TTW_DString &ToUtf8(Tcl_Encoding src_enc, const char *str, bool append = true);
	TTW_DString &ToUtf8(Tcl_Encoding src_enc, const char *str, int length, bool append = true);
	TTW_DString &ToUtf8(Tcl_Encoding src_enc, const Tcl_DString &str, bool append = true);
	TTW_DString &ToUtf8(Tcl_Encoding src_enc, const TTW_DString &str, bool append = true);

	// ŗ^ꂽ UTF8 VXeGR[fBOɕϊĊi[
	TTW_DString &Utf8ToSys(const char *str, bool append = true);
	TTW_DString &Utf8ToSys(const char *str, int length, bool append = true);
	TTW_DString &Utf8ToSys(const Tcl_DString &str, bool append = true);
	TTW_DString &Utf8ToSys(const TTW_DString &str, bool append = true);
	TTW_DString &Utf8ToSys(Tcl_Obj *obj, bool append = true);

	// ŗ^ꂽ UTF8 w肳ꂽGR[fBOɕϊĊi[
	TTW_DString &Utf8To(Tcl_Encoding dst_enc, const char *utf8_str, bool append = true);
	TTW_DString &Utf8To(Tcl_Encoding dst_enc, const char *utf8_str, int length, bool append = true);
	TTW_DString &Utf8To(Tcl_Encoding dst_enc, const Tcl_DString &utf8_str, bool append = true);
	TTW_DString &Utf8To(Tcl_Encoding dst_enc, const TTW_DString &utf8_str, bool append = true);
	TTW_DString &Utf8To(Tcl_Encoding dst_enc, Tcl_Obj *obj, bool append = true);

	/// ====== 擾 ======
	operator const char *() const;
	operator char *();
	const char *Value() const;
	char *Value();

	/// ====== 񒷎擾AύX ======
	int Length() const;
	void SetLength(int len);
	void Clear();

	/// ====== Tcl List֘A ======
	//  { B Ō̕Xy[XnłȂꍇ̓Xy[XB
	void StartSubList();
	//  } B
	void EndSubList();

	TTW_DString &AppendElement(const char *rhs);
	TTW_DString &AppendElement(const Tcl_DString &rhs);
	TTW_DString &AppendElement(const TTW_DString &rhs);
	TTW_DString &AppendElement(Tcl_Obj *obj);

};

/// UTF-8 񏈗pTcl C APIQ 
// r
// Tcl_UtfNcmp         : 啶E̋ʂr
// Tcl_UtfNcasecmp     : 啶E𓯂Ƃr
// Tcl_StringCaseMatch : p^[(*?\[])grB3ڂ̈͑啶E̋ʂ̗L̎w(0:ʂATCL_MATCH_NOCASE:)

// 
// Tcl_UtfFindFirst    : w肵 Unicode AŏɈṽ|C^ԂB
// Tcl_UtfFindLast     : w肵 Unicode AŌɈṽ|C^ԂB

// 啶Eϊ
// Tcl_UtfToUpper      : 啶ɕϊB
// Tcl_UtfToLower      : 啶ɕϊB
// Tcl_UtfToTitle      : ŏ1啶ɁA2ڈȍ~ɕϊB

// |C^ړ
// Tcl_UtfNext         : ̃̕|C^ԂB
// Tcl_UtfPrev         : Õ̕|C^ԂBSɏׁA擪ʒu|C^2Ԗڂ̈Ɏw肷B߂Ȃʒuw肵ꍇ͐擪ʒũ|C^ԂB
// Tcl_UtfAtIndex      : N Ԗ(NoCgڂł͂Ȃ)̃̕|C^ԂB

// 
// Tcl_NumUtfChars     : (oCgł͂Ȃ)擾B
// Tcl_UtfCharComplete : UTF-8 ƂĊĂ邩mFB

// TTW_UtfToUniChar    : UTF-8 ꕶ擾BUnicode chPtr ɁAUTF-8 ߂lɕԂB
#define TTW_UtfToUniChar(src, chPtr) \
	((static_cast<unsigned int>(*(src)) < 0x80) ? (((*(chPtr)) = static_cast<Tcl_UniChar>(*(src))), 1) : \
	::Tcl_UtfToUniChar(src, chPtr))

// XPG3 Ή printf
TTW_DECL TTW_DString &TTW_Format(Tcl_Interp *interp, TTW_DString &utf8_lhs, const char *utf8_fmt, const TTW_ListObj &rhs);
TTW_DECL TTW_DString &TTW_Format(TTW_DString &utf8_lhs, const char *utf8_fmt, const TTW_ListObj &rhs);

/// UTF-8 Cӂ̃f~^ Split NX
class TTW_DECL TTW_SplitUTF8String{
	const char *utf8str, *utf8delimiter, *iter, *utf8str_e;
	int delimiter_len;
	TTW_SplitUTF8String();
	TTW_SplitUTF8String(const TTW_SplitUTF8String &);
	TTW_SplitUTF8String &operator =(const TTW_SplitUTF8String &);
public:
	TTW_SplitUTF8String(const char *utf8str, const char *utf8delimiter);
	bool Next(const char *&utf8tok_start, int &tok_len);
	~TTW_SplitUTF8String();
};

/// ===================================
/// Tcl_ListObj ₷NX
/// グ邽߁Â悤ȋB
/// ȂRXgN^Őꂽꍇ  : listObj  NULL 
/// listObj  NULL ̏Ԃł̊e̋
/// EXgvf擾悤Ƃꍇ         : listObj  NULL ̂܂܁A NULL ԂB
/// EXĝ̃|C^擾悤Ƃꍇ : listObj 𐶐Ã|C^ԂB
/// EXgvfɍڂǉ悤Ƃꍇ     : listObj 𐶐AvfǉB
/// EXgvf獀ڂ폜悤Ƃꍇ   : listObj  NULL ̂܂܂ŉȂB
/// borrow Ԃ̃IuWFNǵA TTW_ListObj ŐԂ̊ǗȂ(TTW_ListObj ͎QƃJE^𑝌Ȃ)B
/// ȊÕIuWFNǵATTW_ListObj ̐ԂƃN悤ɎQƃJE^𑝌B 
class TTW_DECL TTW_ListObj{
	Tcl_Obj *listObj;
	bool borrowed;
	Tcl_Interp *interp; // G[擾p
public:
	/// ====== CX^X ======
	TTW_ListObj();
	TTW_ListObj(int objc, Tcl_Obj *objv[]);
	TTW_ListObj(const TTW_ListObj &rhs);
	TTW_ListObj & operator = (const TTW_ListObj &rhs);

	/// IuWFNg̐ԊǗ̃Reiɑ܂܁Ae푀ɌĂяoB
	///    Tcl ̎QƃJE^́A2 ȏ(L)̂܂܂ł͊eҏWłȂ悤ɂȂĂB
	///    ǂRs[ICg(LԂŕҏWĂяoꂽƂɃRs[{)̖ړIŎĂ炵B
	///    Tcl_Interp ǗĂIuWFNg TTW_ListObj gđEҏW邽߂ɁA
	///    IuWFNg؂(QƃJE^グɃ|C^)Ƃł悤ɂB
	TTW_ListObj & Borrow(Tcl_Obj *listObj);
	TTW_ListObj & Copy(Tcl_Obj *listObj);
	~TTW_ListObj();

	/// ====== interpݒ ======
	void SetInterp(Tcl_Interp *interp);
	Tcl_Interp *GetInterp();

	/// ====== XgObj擾 ======
	// Xg Obj ̎QƃJE^͂ɕςȂ
	// spӂ Tcl_IncrRefCount ƁABorrow ̂ƂŋLڂRɂAvfǉ Tcl_Panic B
	// ܂spӂ Tcl_DecrRefCount Ƃ̏uԂɃIuWFNgjA  TTW_ListObj (Borrow ꍇ Borrow ̃Rei)
	// jꂽɔjς̃IuWFNg𑀍삵Ă܂߁AsG[B
	operator Tcl_Obj *();
//	operator Tcl_Obj *() const;
	Tcl_Obj *operator [](int idx);
	const Tcl_Obj *operator [](int idx) const;
	int Count() const;

	/// ====== X^bN̏ ======
	Tcl_Obj *Push(Tcl_Obj *); // X^bN̑ɁARAII \[XǗpRei(TTW_ListObj ̃^C~O Push  Tcl_Obj Q)ƂĂgB
	Tcl_Obj *Push(bool b);
	Tcl_Obj *Push(int i);
	Tcl_Obj *Push(long l);
	Tcl_Obj *Push(double d);
	Tcl_Obj *Push(Tcl_WideInt &wi);
	Tcl_Obj *Push(mp_int &mp);

	// ɓńAUTF-8 ŃGR[fBOĂ邱
	Tcl_Obj *Push(const char *utf8);
	Tcl_Obj *Push(Tcl_DString &utf8);
	Tcl_Obj *Push(const TTW_DString &utf8);

	Tcl_Obj *Last();
	void Pop(); // ߂lƂ Tcl_Obj * ƂłȂ̂́A ԂꂽƂɂ͂łɎQƃJEgĉꂽ̉\邽߁B

	/// ====== vfǉ ======
	TTW_ListObj &operator << (bool b);
	TTW_ListObj &operator << (int i);
	TTW_ListObj &operator << (long l);
	TTW_ListObj &operator << (double d);
	TTW_ListObj &operator << (Tcl_WideInt &wi);
	TTW_ListObj &operator << (mp_int &mp);

	// ɓńAUTF-8 ŃGR[fBOĂ邱
	TTW_ListObj &operator << (const char *utf8);
	TTW_ListObj &operator << (Tcl_DString &utf8);
	TTW_ListObj &operator << (const TTW_DString &utf8);

	TTW_ListObj &operator << (Tcl_Obj *obj);     // ̃ReiɏLĂꍇASharedɂȂ_ɒ
	TTW_ListObj &operator << (TTW_ListObj &obj); // ̃ReiɏLĂꍇASharedɂȂ_ɒ
	
	/// ====== vfύX ======
	Tcl_Obj *Set (int idx, bool b);
	Tcl_Obj *Set (int idx, int i);
	Tcl_Obj *Set (int idx, long l);
	Tcl_Obj *Set (int idx, double d);
	Tcl_Obj *Set (int idx, const Tcl_WideInt &wi);
	Tcl_Obj *Set (int idx, mp_int &mp);

	// ɓńAUTF-8 ŃGR[fBOĂ邱
	Tcl_Obj *Set (int idx, const char *utf8);
	Tcl_Obj *Set (int idx, Tcl_DString &utf8);
	Tcl_Obj *Set (int idx, const TTW_DString &utf8);

	Tcl_Obj *Set (int idx, Tcl_Obj *obj);     // ̃ReiɏLĂꍇASharedɂȂ_ɒ
	Tcl_Obj *Set (int idx, TTW_ListObj &obj); // ̃ReiɏLĂꍇASharedɂȂ_ɒ

	/// ====== vfS폜 ======
	void Clear();

	/// ====== Tcl R}hs ======
	Tcl_Obj *Eval(Tcl_Interp *interp, int flags = 0); /// CX^X̃XgEvalsB߂lResultIuWFNg
};

/// Tcl_List pTcl C APIQ
// Tcl_ListObjGetElements : Xg̓e\ Tcl_Obj z̐擪|C^Ɨvf擾B
// Tcl_ListObjReplace     : Xg͈̓̔͂Aw肵 Tcl_Obj z̓eɍւB
// Tcl_ListObjAppendList  : Xg̖ɕʂ̃Xg̓eǉB
// Tcl_SetListObj         : ܂ł̃Xg̓eāAw肵Tcl_ObjzXgɃZbgB

/// ===================================
/// Tcl_Obj l擾֐Q
TTW_DECL bool TTW_GetBoolean(Tcl_Interp *interp, Tcl_Obj *obj, bool when_null = false);
TTW_DECL bool TTW_GetBoolean(Tcl_Obj *obj, bool when_null = false);

// ByteArray

TTW_DECL double TTW_GetDouble(Tcl_Interp *interp, Tcl_Obj *obj, double when_null = 0);
TTW_DECL double TTW_GetDouble(Tcl_Obj *obj, double when_null = 0);

// Index

TTW_DECL int TTW_GetInt(Tcl_Interp *interp, Tcl_Obj *obj, int when_null = 0);
TTW_DECL int TTW_GetInt(Tcl_Obj *obj, int when_null = 0);

TTW_DECL long TTW_GetLong(Tcl_Interp *interp, Tcl_Obj *obj, long when_null = 0);
TTW_DECL long TTW_GetLong(Tcl_Obj *obj, long when_null = 0);

TTW_DECL const char *TTW_GetString(Tcl_Obj *obj, const char *when_null = 0);
TTW_DECL const char *TTW_GetString(Tcl_Obj *obj, int &length, const char *when_null = 0);

TTW_DECL Tcl_UniChar *TTW_GetUnicode(Tcl_Obj *obj, Tcl_UniChar *when_null = 0);
TTW_DECL Tcl_UniChar *TTW_GetUnicode(Tcl_Obj *obj, int &length, Tcl_UniChar *when_null = 0);

TTW_DECL Tcl_WideInt TTW_GetWideInt(Tcl_Interp *interp, Tcl_Obj *obj, Tcl_WideInt when_null = 0);
TTW_DECL Tcl_WideInt TTW_GetWideInt(Tcl_Obj *obj, Tcl_WideInt when_null = 0);

//mp_int TTW_GetBignum(Tcl_Interp *interp, Tcl_Obj *obj);
//mp_int TTW_GetBignum(Tcl_Obj *obj);

// RegExp

/// ===================================
/// t@C֘A
// t@C̏
// Tcl_FSAccess          : t@C̑݊mFAѓǂ݁EEs(R_OKAW_OKAX_OK)[hmF
// Tcl_FSStat            : w肵pXt@C/fBNg̏ڍ׏̎擾(쐬EXVAt@CTCYAQƐAt@CfBNgA)
//                         Tcl_StatBuf  stat  typedef ̂߁Agpۂ #include <sys/stat.h> 邱

// t@C
// Tcl_FSCopyFile        : t@CRs[B
// Tcl_FSRenameFile      : t@CύXB
// Tcl_FSDeleteFile      : t@C폜B
// Tcl_FSLink            : t@C/fBNg̃V{bN/n[hN쐬BWindowsTcl(8.5.15)̏ꍇ̑Ή󋵂͉L̒ʂ
//                                       V{bN   n[h
//                        t@C            ~          Z       (Win Vistaȍ~ t@C̃V{bNN悤ɂȂALo[W Tcl ͖Ή)
//                        fBNg        Z          ~

// t@Ceǂݏ(`l)
// Tcl_FSOpenFileChannel : t@C`lJ
// Tcl_Seek              : `l̓ǂݏ̃|WVړB
// Tcl_Tell              : `l̓ǂݏ̃|WV擾B
// Tcl_Flush             : `ltbVB
// Tcl_Eof               : `l̏I[ɒBǂ𔻒肷B
// Tcl_Close             : `lB
// Tcl_SetChannelOption  : `l̃IvV(ubLOLAobt@OLAobt@TCYAs[hAGR[fBO)ݒ肷
// Tcl_GetsObj           : `l 1 s̕ UTF-8 ɕϊȂ擾Aw肵 Tcl_Obj ɒǋLB
// Tcl_WriteChars        : UTF-8 Aw肳ꂽGR[fBOɕϊȂ`lɏށB
//                         s "\n" Ŏw肷BsR[h͎w肳ꂽs[hɉēKXϊB
// Tcl_Read, Tcl_ReadRaw : `lw肵oCg̃f[^ǂݍށBGR[fBO̕ϊ͎{ȂB
// Tcl_Write,Tcl_WriteRaw: `lɎw肵oCg̃f[^ށBGR[fBO̕ϊ͎{ȂB

// fBNg
// Tcl_FSCreateDirectory : fBNg쐬B
// Tcl_FSCopyDirectory   : fBNgRs[B
// Tcl_FSRemoveDirectory : fBNg폜B̏ꍇ폜邩AłȂĂSč폜邩tOőIłB
// Tcl_FSGetCwd          : JgfBNg擾Binterp ̓G[擾̂߂ɎgpĂ邽߁AG[񂪕svȏꍇ NULL łȂB
// Tcl_FSChdir           : JgfBNgύXB

// pXҏW
// Tcl_FSJoinPath          : Xgŗ^ꂽevfăpXɂB
// Tcl_FSSplitPath         : pX𕪉ăXgɊi[B
// Tcl_FSEqualPaths        : pXwĂ邩ǂ𔻒肷B Kvɉ  Tcl_FSGetNormalizedPath gpB
// Tcl_FSGetNormalizedPath : pX𐳋KB΃pX vs. ΃pXA../ ̗LAy Windows ̏ꍇshortname/longnameAyё啶ꈵɂΉĂB
// Tcl_FSJoinToPath        : pXɃfBNgt@CvfB
Tcl_Obj *TTW_FSJoinToPath (Tcl_Obj *pathPtr, TTW_ListObj &list); // Tcl_FSJoinToPath  TTW_ListObj 
// Tcl_FSGetNativePath     : lCeBuȃpX擾B
// Tcl_FSGetPathType       : pX΃pXA{[΃pXA΃pX𒲂ׂB

/// ===================================
/// ԏ֘A
// Tcl_GetTime             : 1970N11̌oߎԂ擾B
// Tcl_Sleep               : w肵~bAXbh~߂B
class TTW_DECL TTW_LapTimeWatch {
	struct Impl;
	Impl *pimpl;
	TTW_LapTimeWatch(const TTW_LapTimeWatch &);
	TTW_LapTimeWatch &operator =(const TTW_LapTimeWatch &);
public:
	enum Type{
		Sequence = 0, 
		// Lap ĂяoɁAname ƌoߎ(~b)̃yA擾B
		// :
		// tw.Lap("line:100", Sequence); // [1]
		// ...
		// tw.Lap("line:110", Sequence); // [2]
		// ...
		// tw.Lap("line:130", Sequence); // [3]
		// TTW_ListObj &r = tw.AnalyzeSequenceResult();
		// ƂꍇA
		//   { {line:100} 0 {line:110} xxx {line:130} yyy } }
		//   xxx : [1]->[2] ̌o߃~b
		//   yyy : [2]->[3] ̌o߃~b
		//  ƂXgBXg̐Ԃ TTW_LapTimeWatch ƓB
		LoopPoint = 1,
		// [v̎w肵ʒuŌv(ʉ߉ - 1)ƁAϒʉߊԊu擾B
		// :
		// for (int j = 0; j < 100; ++j){
		//   tw.Lap("loop 1", LoopPoint);
		//   ...
		// }
		// for (int j = 0; j < 150; ++j){
		//   tw.Lap("loop 2", LoopPoint);
		//   ...
		// }
		// TTW_ListObj &r = tw.AnalyzeLoopPoint();
		// ƂꍇA
		//   { {loop 1} 99 xxx {loop 2} 149 yyy } (OAv(= ʉ߉ - 1)AϒʉߊԊȕ)
		//  ƂXgBXg̐Ԃ TTW_LapTimeWatch ƓB
		LoopStart = 2, LoopEnd = 3
		// [v̎w肵͈͂ʂ񐔂ƁAϒʉߊԊu擾B
		// :
		// for (int j = 0; j < 100; ++j){
		//   ...
		//   tw.Lap("range 1", LoopStart);
		//   ...
		//   tw.Lap("range 1", LoopEnd);
		//   ...
		// }
		// for (int j = 0; j < 150; ++j){
		//   ...
		//   tw.Lap("range 2", LoopStart);
		//   ...
		//   tw.Lap("range 2", LoopEnd);
		//   ...
		// }
		// TTW_ListObj &r = tw.AnalyzeLoopPoint();
		// ƂꍇA
		//   { {range 1} 100 xxx {range 2} 150 yyy } (OAʉ߉񐔁AϒʉߊԊȕ)
		//  ƂXgBXg̐Ԃ TTW_LapTimeWatch ƓB
	};
	TTW_LapTimeWatch();
	~TTW_LapTimeWatch();
	void Reset();
	void Lap(const char *name = "", Type type = Sequence);

	// Sequence ^Cv Lap ʂ𕶎`ŏo͂B
	TTW_ListObj &AnalyzeSequenceResult();
	TTW_ListObj &AnalyzeLoopPoint();
	// [ : O LoopStartALoopEnd ́AŏɌĂяoꂽ̂珇ɏāAԋ߂̓mŃyAɂB
	//  ΉȂ LoopStart/LoopEnd ͉L[ŏB
	//  * LoopStart ĂяoOɏo LoopEnd ͖B
	//  * LoopStart ̌ LoopEnd oȂ LoopStart ͖B
	//  * OŘA LoopStart Ăяoꍇ́AɌĂяo LoopStart 𖳎B
	//  * OŘA LoopEnd Ăяoꍇ́AɌĂяo LoopEnd 𖳎B
	TTW_ListObj &AnalyzeLoopRange();
};
