<?php
// PukiWiki - Yet another WikiWikiWeb clone
// $Id: rss.inc.php 7 2008-07-03 06:13:57Z kojima $
//
// RSS plugin: Publishing RSS of RecentChanges
//
// Usage: plugin=rss[&ver=[0.91|1.0|2.0]] (Default: 1.0)
//
// NOTE for acronyms
//   RSS 0.9,  1.0  : RSS means 'RDF Site Summary'
//   RSS 0.91, 0.92 : RSS means 'Rich Site Summary'
//   RSS 2.0        : RSS means 'Really Simple Syndication' (born from RSS 0.92)

// siteDev+AT akko@2007/01/08
// V[gAhXϊǉ
// #norss ̒ǉ@ʓrvOCKv
// siteDev+AT akko@2007/06/08
//@@rssdȂRSSo͂Ȃ悤ɕύX
// #rssd ̒ǉ@dlύX@
// IE7̃ftHg΍Ł@V1.0ftHgɕύX
// ̔M𖳌ɂ

//define('CRLF',"\n");
define('CRLF',"<br />");

function plugin_rss_action()
{
	global $vars, $rss_max, $page_title, $whatsnew, $trackback;
	global $sd_rss_set,$is_admin;

	if( !$sd_rss_set || $is_admin) exit;

	$version = isset($vars['ver']) ? $vars['ver'] : '';
	switch($version){
	case '':  $version = '1.0'; $fn = '10'; break; // Default
	case '1': $version = '1.0';  $fn = '10'; break; // Sugar
	case '2': $version = '2.0';  $fn = '20'; break; // Sugar
	case '0.91': $fn = '91'; break; /* FALLTHROUGH */
	case '1.0' : $fn = '10'; break; /* FALLTHROUGH */
	case '2.0' : $fn = '20'; break;
	default: die('Invalid RSS version!!');
	}

	$recent = CACHE_DIR . 'recent.dat';
	if (! file_exists($recent)) die('recent.dat is not found');

	$rssfn = CACHE_DIR . 'rss'. $fn.'.dat';

//łɍ쐬ς݂Ȃ炻gpB

	if (file_exists($rssfn)) {
		if(filemtime($rssfn) > filemtime($recent) ){
			pkwk_common_headers();
			header('Content-type: application/xml');
			print file_get_contents($rssfn);
			exit;
		}
	}

	$lang = LANG;
	$page_title_utf8 = mb_convert_encoding($page_title, 'UTF-8', SOURCE_ENCODING);
	$self = get_script_uri();

	// Creating <item>
	$items = $rdf_li = '';
//file_headɕύX /lib/file.php̍XVKv
//	foreach (array_splice(file($recent), 0, $rss_max) as $line) {
	foreach (file_head($recent, $rss_max) as $line) {
		list($time, $page) = explode("\t", rtrim($line));
//add akko
                if(preg_match("/^".XPAGE."/",$page)) continue;
		$sd_link = sd_url($page);

		$discr = '';
		$rss_mode = 0;
		foreach (get_source($page) as $line) {
			if ( preg_match('/^#norss/', $line)){
				$rss_mode = 0;
				break;
			}
			if ( preg_match('/^#rssd/', $line)){
				 preg_match('/^#rssd\((.*)\)/i', $line, $m);
				if( $discr == '') {
					$discr  = $m[1] ;
				}else{
					$discr  .= CRLF.$m[1] ;
				}

				$rss_mode = 1;
			}
			if ( preg_match('/^\*/', $line)){
				 $d = str_replace('&null;',"",$line);
			 	$d = str_replace('&%date;',"",$d);
			 	$d = preg_replace('/^\*+/',"",$d);
			 	$d = preg_replace('/\[#.*\]/',"",$d);
			 	$i++;
				if( $discr == '') {
					$discr  = $d ;
				}else{
					$discr  .= CRLF.$d ;
				}
			}
		}

		if ($rss_mode == 0) { continue; }
/****akko 07/06/14
		if ( preg_match('/^#norss/', $line)){	continue; }
****/		
		if ( preg_match('/^#rssd/', $line)){; } else { continue; }
		$discr  = mb_convert_encoding($discr, 'UTF-8', 'EUC-JP');
//		$discr  = htmlspecialchars($discr);

		$r_page = rawurlencode($page);
		$title  = mb_convert_encoding($page, 'UTF-8', SOURCE_ENCODING);

		switch ($version) {
		case '0.91': /* FALLTHROUGH */
		case '2.0':
			$date = get_date('D, d M Y H:i:s T', $time);
			$date = ($version == '0.91') ?
				' <description>' . $date . '</description>' :
				' <pubDate>'     . $date . '</pubDate>';
			$items .= <<<EOD
<item>
<title>$title</title>
<link>$sd_link</link>
 <description> $discr  </description>
$date
</item>

EOD;



			break;

		case '1.0':
			// Add <item> into <items>
			$rdf_li .= '    <rdf:li rdf:resource="' . $sd_link. '" />' . "\n";

			$date = substr_replace(get_date('Y-m-d\TH:i:sO', $time), ':', -2, 0);
			$trackback_ping = '';
			if ($trackback) {
				$tb_id = md5($r_page);
				$trackback_ping = ' <trackback:ping>' . $self .
					'?tb_id=' . $tb_id . '</trackback:ping>';
			}
			$items .= <<<EOD
<item rdf:about="$sd_link">
 <title>$title</title>
 <link>$sd_link</link>
 <description> $discr  </description>
 <dc:date>$date</dc:date>
 <dc:identifier>$sd_link</dc:identifier>
$trackback_ping
</item>

EOD;
			break;
		}
	}

	// Feeding start

	$buf =  '<?xml version="1.0" encoding="UTF-8"?>' . "\n\n";


	$r_whatsnew = rawurlencode($whatsnew);
//SiteDEv+AT
	$sd_whatsnew = sd_url($whatsnew);

	switch ($version) {
	case '0.91':
		$buf .= '<!DOCTYPE rss PUBLIC "-//Netscape Communications//DTD RSS 0.91//EN"' .
		' "http://my.netscape.com/publish/formats/rss-0.91.dtd">' . "\n";
		 /* FALLTHROUGH */

	case '2.0':
		$buf .= <<<EOD
<rss version="$version">
 <channel>
  <title>$page_title_utf8</title>
  <link>$self?cmd=rss&amp;var=$version</link>
  <description>$page_title_utf8 RecentChanges</description>
  <language>$lang</language>

$items
 </channel>
</rss>
EOD;
		break;

	case '1.0':
		$xmlns_trackback = $trackback ?
			'  xmlns:trackback="http://madskills.com/public/xml/rss/module/trackback/"' : '';
		$buf .= <<<EOD
<rdf:RDF
  xmlns:dc="http://purl.org/dc/elements/1.1/"
$xmlns_trackback
  xmlns="http://purl.org/rss/1.0/"
  xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#"
  xml:lang="$lang">
 <channel rdf:about="$self?cmd=rss&amp;var=$version">
  <title>$page_title_utf8</title>
  <link>$self?cmd=rss&amp;var=$version</link>
  <description>$page_title_utf8 RecentChanges</description>
  <items>
   <rdf:Seq>
$rdf_li
   </rdf:Seq>
  </items>
 </channel>

$items
</rdf:RDF>
EOD;
		break;
	}

	pkwk_common_headers();
	header('Content-type: application/xml');
	print $buf;

	$fp = fopen($rssfn,'w');
	fwrite($fp,$buf);
	fclose( $fp);
	exit;
}
?>
