<?php
/*
 * PukiWiki 饤桼ꥹȥץ饰
 *
 * (C) Katsumi@jo1upk.ymt.prug.or.jp
 *
 * $Id: onlinelist.inc.php 1 2008-07-02 09:04:21Z kojima $
 */

if (!defined('USR_LST'))
{
	define('USR_LST', COUNTER_DIR.'user.dat');
}

if (!defined('TIMEOUT'))
{
	define('TIMEOUT', 300);
}

function plugin_onlinelist_init()
{
  switch (LANG) {
    case 'ja':
      $messages = onlinelist_init_ja();
      continue;
    default:
      $messages = onlinelist_init_en();
  }
  set_plugin_messages($messages);
}

function onlinelist_init_ja()
{
  $messages = array(
    '_onlinelist_messages' => array(
      'msg_th_IP'		=> 'FQDN(IP)',
      'msg_th_TimeStamp'	=> '',
      'msg_no_data'		=> 'ǡޤ',
      'msg_Fmt_Date'		=> 'Yǯnj H:i',
    )
  );
  return $messages;
}

function onlinelist_init_en()
{
  $messages = array(
    '_onlinelist_messages' => array(
      'msg_th_IP'		=> 'FQDN(IP)',
      'msg_th_TimeStamp'	=> 'STAMP',
      'msg_no_data'		=> 'no data.',
      'msg_Fmt_Date'		=> 'F j, Y, g:i A',
    )
  );
  return $messages;
}

function plugin_onlinelist_convert()
{
	global $_onlinelist_messages;

	if (!file_exists(USR_LST))
	{
		return "<p>".$_onlinelist_messages['msg_no_data']."</p>";
	}

	$rc  = "<table class=\"style_table\" cellspacing=\"1\" border=\"0\">\n";
	$rc .= "<thead>\n<tr>\n";
	$rc .= "\t<td class=\"style_td\">".$_onlinelist_messages['msg_th_IP']."</td>\n";
	$rc .= "\t<td class=\"style_td\" colspan=\"2\">".$_onlinelist_messages['msg_th_TimeStamp']."</td>\n";
	$rc .= "</tr>\n</thead>\n";

	$usr_arr = file(USR_LST);

	$rc .= "<tbody>\n";
	for ($i = 0; $i < count($usr_arr); $i++)
	{
		list($ip_addr,$time_stamp) = explode('|', $usr_arr[$i]);
		$rc .= "<tr>\n";
		$rc .= "\t<td class=\"style_td\">".gethostbyaddr($ip_addr)."</td>\n";
		$ts = get_date($_onlinelist_messages['msg_Fmt_Date'],$time_stamp);
		$rc .= "\t<td class=\"style_td\">".$ts."</td>\n";
		$rc .= "\t<td class=\"style_td\">".get_passage($time_stamp,FALSE)."</td>\n";
		$rc .= "</tr>\n";
	}
	$rc .= "</tbody>\n";
	$rc .= "</table>";

	return $rc;
}

?>
