<?php

// Wrap into class
function plugin_contentsx_init()
{
    // Initialize. This is called once in a page view
    global $plugin_contentsx;
    if (PLUGIN_UNITTEST === true) {
        $plugin_contentsx = new PluginContentsxUnitTest();
    } else {
        $plugin_contentsx = new PluginContentsx();
    }
}

function plugin_contentsx_convert()
{
    global $plugin_contentsx; // $plugin_contentsx = new PluginContentsx();
    $args = func_get_args();
    return call_user_func_array(array($plugin_contentsx, 'convert'), $args);
}

class PluginContentsx
{
    function PluginContentsx()
    {
        // Modify here for default values
        $this->options = array(
            'page'      => array('string',  ''),
            'fromhere'  => array('bool',    true),
            'hierarchy' => array('bool',    true),
            'compact'   => array('bool',    true),
            'num'       => array('number',  ''),
            'depth'     => array('number',  ''),
            'except'    => array('string',  ''),
            'filter'    => array('string',  ''),
            'include'   => array('bool',    true),
            'cache'     => array('enum',    'on',  array('on', 'off', 'reset')),
        );
    }

    var $def_headline = '/^(\*{1,3})/';
    var $max_depth    = 3;
    var $def_include  = '/^#include.*\((.+)\)/';
    var $args;
    var $options;
    var $error = "";
    var $plugin = "contentsx";
    var $metalines;
    var $visited = array();

    function convert()
    {
        // Execute at a call as #plugin()
        $args = func_get_args();
        $this->args = $args;
        return $this->body();
    }
    
    
    function body()
    {
        $this->decompose_args();
        if ($this->error !== "") { return $this->error; }
        $this->parse_args();
        if ($this->error !== "") { return $this->error; }
        
        $this->check_page();
        if ($this->error !== "") { return $this->error; }
        
        if ($this->read_cache() === false) {
            $this->metalines = $this->metalines($this->options['page'][1]);
            $this->write_cache();
        }
        if ($this->error !== "") { return $this->error; }
        
        $this->fromhere_metalines();
        $this->include_metalines();
        $this->filter_metalines();
        $this->except_metalines();
        
        $this->parse_numoption('depth', 0, $this->max_depth);
        if ($this->error !== "") { return $this->error; }
        $this->depth_filter_metalines();
        
        $num = sizeof($this->metalines);
        $this->parse_numoption('num', 1, $num);
        if ($this->error !== "") { return $this->error; }
        $this->num_filter_metalines();
        
        $this->hierarchy_metalines();
        $this->compact_metalines();
        $this->makelink_metalines();
        
        $body = $this->list_metalines();
        //$body .= $this->option_debug_print();
        return $body;
    }
    
    // false: cache is unavailable
    function read_cache()
    {
        if ($this->options['cache'][1] == 'off' || $this->options['cache'][1] == 'reset') {
            return false;
        }
        $cache = CACHE_DIR . encode($this->options['page'][1]) . ".$this->plugin";
        if (! $this->file_exists($cache)) {
            return false;
        }
        if (! $this->is_readable($cache)) {
            $this->error = "$this->plugin was aborted. ";
            $this->error .= "Cache file, $cache is not readable. ";
            return;
        }

        $lines = file($cache);
        $visited = csv_explode(',', rtrim(array_shift($lines)));

        // To simplify, cache saves headlines of included pages also
        // cache does not use cache files of included pages
        // so, renew cache even if just an included page was newer
        $cachestamp = filemtime($cache);
        foreach ($visited as $page) {
            $pagestamp  = get_filetime($page);
            if ($pagestamp > $cachestamp) {
                return false;
            }
        }

        $this->visited = $visited;
        $metalines = array();
        foreach ($lines as $line) {
            $metas = csv_explode(',', rtrim($line));
            $metaline = array();
            foreach ($metas as $meta) {
                list($key, $val) = explode('=', $meta, 2);
                $metaline[$key] = $val;
            }
            $metalines[] = $metaline;
        }
        $this->metalines = $metalines;
    }

    function write_cache()
    {
        if ($this->options['cache'][1] == 'off') {
                return;
        }
        $cache = CACHE_DIR . encode($this->options['page'][1]) . ".$this->plugin";
        if ($this->file_exists($cache) && ! $this->is_writable($cache)) {
            $this->error = "$this->plugin was aborted. ";
            $this->error .= "Cache file, $cache is not writable. ";
            return;
        }
        $lines = csv_implode(',', $this->visited) . "\n";        
        foreach ($this->metalines as $metaline) {
            $metas = array();
            foreach ($metaline as $key => $val) {
                $metas[] = "$key=$val";
            }
            $lines .= csv_implode(',', $metas) . "\n";
        }
        // file_put_contents($cache, $lines); // PHP5
        if (! $fp = fopen($cache, "w")) {
            $this->error = "$this->plugin was aborted. ";
            $this->error .= "Can not open $cache. ";
            return;
        }
        if (! fwrite($fp, $lines)) {
            $this->error = "$this->plugin was aborted. ";
            $this->error .= "Can not write to $cache. ";
            return;
        }
        fclose($fp);
    }

    function list_metalines()
    {
        if (sizeof($this->metalines) == 0) {
            return;
        }
        
        /* HTML validate (without <ul><li style="list-type:none"><ul><li>, we have to do as 
           <ul><li style="padding-left:16*2px;margin-left:16*2px"> as pukiwiki standard. I did not like it)
           
        <ul>              <ul><li>1
        <li>1</li>        </li><li>1
        <li>1             <ul><li>2
        <ul>              </li></ul></li><li>1
        <li>2</li>        </li><li>1
        </ul>        =>   <ul><li style="list-type:none"><ul><li>3
        </li>             </li></ul></li></ul></li></ul>
        <li>1</li>
        <li>1</li>
        <ul><li style="list-type:none"><ul>
        <li>3</li>
        </ul></li></ul>
        </li>
        </ul>
        */
        
        $ul = $pdepth = 0;
        foreach ($this->metalines as $metaline) {
            $display  = $metaline['display'];
            $depth = $metaline['listdepth'];
            if ($depth > $pdepth) {
                $diff = $depth - $pdepth;
                $html .= str_repeat('<ul><li style="list-style:none">', $diff - 1);
                $html .= '<ul><li>';
                $ul += $diff;
            } elseif ($depth == $pdepth) {
                $html .= '</li><li>';
            } elseif ($depth < $pdepth) {
                $diff = $pdepth - $depth;
                $html .= str_repeat('</li></ul>', $diff);
                $html .= '</li><li>';
                $ul -= $diff;
            }
            $html .= $display;
            $pdepth = $depth;
        }
        $html .= str_repeat('</li></ul>', $ul);
        return $html;
    }
    
    function makelink_metalines()
    {
        $metalines = array();
        foreach ($this->metalines as $metaline) {
            $anchor = $metaline['anchor'];
            $headline = $metaline['headline'];
            $headline = strip_htmltag(make_link($headline)); // convert inline plugin
            if ($anchor != ''){
                $metaline['display'] = $this->make_link($headline, $this->options['page'][1], $anchor);
            }
            $metalines[] = $metaline;
        }
        $this->metalines = $metalines;
    }
    
    function make_link($alias, $page, $anchor)
    {
        // make_link("[[${alias}>${page}]]") -> <a href="URL" title="PageName (29d)">Alias</a>
        global $vars;
        global $script;
        if ($page == $vars['page']) {
            $url = $anchor;
            $title = '';
        } else {
            $url = $script . '?' . rawurlencode($page). $anchor;
            $title = htmlspecialchars($page);
        }
        $text = htmlspecialchars($alias);
        //$title .= ' ' . get_passage($timestamp); // (29d). burdonsome, and do not think as useful
        return '<a href="' . $url . '" title="' . $title . '">' . $text . '</a>';
    }

    function compact_metalines()
    {
        // Hmmmmm, complex
        if (!$this->options['compact'][1]) {
            return;
        }
        if (! $this->options['hierarchy'][1]) {
            return;
        }
        // 1) fill in list spaces for each page
        // 1 3 1 1 3 3 1 => 1 2 1 1 2 2 1 (2 was none, move 3 to 2)
        // 2 2 2 => 1 1 1
        $listdepthstack = array();
        foreach ($this->metalines as $metaline) {
            $page  = $metaline['page'];
            $listdepth = $metaline['listdepth'];
            if(! in_array($listdepth, $listdepthstack[$page])) {
                $listdepthstack[$page][] = $listdepth;
            }
        }
        foreach (array_keys($listdepthstack) as $page) {
            sort($listdepthstack[$page]);
        }
        // 1 2 4 == (0=>1, 1=>2, 2=>4) -> (1=>1, 1=>2, 3=>4) -exchange keys and values-> (1=>1, 2=>1, 4=>3)
        $listdepthfill = array();
        foreach ($listdepthstack as $page => $stack) {
            foreach($stack as $i => $listdepth) {
                $listdepthfill[$page][$listdepth] = $i + 1;
            }
        }
        $metalines = array();
        foreach ($this->metalines as $metaline) {
            $page  = $metaline['page'];
            $listdepth = $metaline['listdepth'];
            $metaline['listdepth'] = $listdepthfill[$page][$listdepth];
            $metalines[] = $metaline;
        } 
        $this->metalines = $metalines;

        // 2) fill in previous list space, seperately for each page
        // 1 3 2 => 1 2 2
        $pdepth = array(); $plistdepth = array();
        foreach (array_keys($listdepthstack) as $page) {
            $pdepth[$page] = -1;
            $plistdepth[$page] = 0;
        }
        $metalines = array();
        $this->hoge = array();
        foreach ($this->metalines as $metaline) {
            $page = $metaline['page']; 
            if ($metaline['depth'] > $pdepth[$page]) {
                $metaline['listdepth'] = $plistdepth[$page] + 1;
            } elseif($metaline['depth'] == $pdepth[$page]) {
                $metaline['listdepth'] = $plistdepth[$page];
            } else {
                $metaline['listdepth'] = ($plistdepth[$page] < $metaline['listdepth']) ? $plistdepth[$page]: $metaline['listdepth'];
            }
            $pdepth[$page] = $metaline['depth'];
            $plistdepth[$page] = $metaline['listdepth'];
            $metalines[] = $metaline;
        }
        $this->metalines = $metalines;
    }
    
    function hierarchy_metalines()
    {
        $include = 0;
        if ($this->options['include'][1] && sizeof($this->visited) >= 2) { // include (0,1,2,3...) -> (1,2,3,4...)
            $include = 1;
        }
        $metalines = array();
        foreach($this->metalines as $metaline) {
            if ($this->options['hierarchy'][1]) {
                $metaline['listdepth'] = $metaline['depth'] + $include;
            } else {
                $metaline['listdepth'] = 1;
            }
            $metalines[] = $metaline;
        }
        $this->metalines = $metalines;
    }
    
    function num_filter_metalines()
    {
        if ($this->options['num'][1] === '') {
            return;
        }
        $metalines = array();
        foreach ($this->options['num'][1] as $num) {
            $metalines[] = $this->metalines[$num - 1];
        }
        $this->metalines = $metalines;
    }

    function depth_filter_metalines()
    {
        if ($this->options['depth'][1] === '') {
            return;
        }
        $metalines = array();
        foreach ($this->metalines as $metaline) {
            $depth = $metaline['depth'];
            if (in_array($depth, $this->options['depth'][1])) {
                $metalines[] = $metaline;
            }
        }
        $this->metalines = $metalines;
    }
    
    function filter_metalines()
    {
        if ($this->options['filter'][1] === "") {
            return;
        }
        $metalines = array();
        foreach ($this->metalines as $metaline) {
            $headline = $metaline['headline'];
            if (ereg($this->options['filter'][1], $headline)) {
                $metalines[] = $metaline;
            }
        }
        $this->metalines = $metalines;
    }

    function except_metalines()
    {
        if ($this->options['except'][1] === "") {
            return;
        }
        $metalines = array();
        foreach ($this->metalines as $metaline) {
            $headline = $metaline['headline'];
            if (!ereg($this->options['except'][1], $headline)) {
                $metalines[] = $metaline;
            }
        }
        $this->metalines = $metalines;
    }
    
    function include_metalines()
    {
        if ($this->options['include'][1]) {
            return;
        }
        $metalines = array();
        foreach ($this->metalines as $metaline) {
            if ($metaline['page'] == $this->options['page'][1]) {
                $metalines[] = $metaline;
            }
        }
        $this->metalines = $metalines;
    }

    function fromhere_metalines()
    {
        if (! $this->options['fromhere'][1]) {
            return;
        }
        $metalines = array();
        foreach ($this->metalines as $metaline) {
            if ($metaline['fromhere']) {
                $metalines[] = $metaline;
            }
        }
        $this->metalines = $metalines;
    }

    function metalines($page, $detected = false)
    {
        if (in_array($page, $this->visited)) {
            return array();
        }
        $this->visited[] = $page;
        $lines = $this->get_source($page);
        $multiline = 0;
        $metalines = array();
        foreach ($lines as $i => $line) {
            // multiline plugin. refer lib/convert_html
            if(defined('PKWKEXP_DISABLE_MULTILINE_PLUGIN_HACK') && PKWKEXP_DISABLE_MULTILINE_PLUGIN_HACK === 0) {
                $matches = array();
                if ($multiline < 2) {
                    if(preg_match('/^#([^\(\{]+)(?:\(([^\r]*)\))?(\{*)/', $line, $matches)) {
                        $multiline  = strlen($matches[3]);
                    }
                } else {
                    if (preg_match('/^\}{' . $multiline . '}$/', $line, $matches)) {
                        $multiline = 0;
                    }
                    continue;
                }
            }

            // fromhere
            if ($this->options['page'][1] == $page && !$detected) {
                if (preg_match('/^#' . $this->plugin . '/', $line, $matches)) {
                    $detected = true;
                    continue;
                }
            }
            
            if (preg_match($this->def_headline, $line, $matches)) {
                $depth    = strlen($matches[1]);
                $anchor   = '#' . $this->make_heading($line); // *** [id] is removed from $line
                $headline = trim($line);
                $metalines[] = array(page=>$page, headline=>$headline, anchor=>$anchor, depth=>$depth, linenum=>$i, fromhere=>$detected);
                continue;
            }
            
            if (preg_match($this->def_include, $line, $matches)) {
                $include = $matches[1];
                $include = get_fullname($include, $page);
                if (! $this->is_page($include)) {
                    continue;
                }
                $metalines[] = array(page=>$include, headline=>$include, anchor=>'#'.rawurlencode($include), depth=>0, linenum=>$i, fromhere=>$detected);
                $metalines = array_merge($metalines, $this->metalines($include, $detected));
                continue;
            }
        }
        return $metalines;
    }

    // copy from lib/html.php
    function make_heading(& $str, $strip = TRUE)
    {
        global $NotePattern;

        // Cut fixed-heading anchors
        $id = '';
        $matches = array();
        if (preg_match('/^(\*{0,3})(.*?)\[#([A-Za-z][\w-]+)\](.*?)$/m', $str, $matches)) {
            $str = $matches[2] . $matches[4];
            $id  = & $matches[3];
        } else {
            $str = preg_replace('/^\*{0,3}/', '', $str);
        }
        
        // Cut footnotes and tags
        if ($strip === TRUE) {
            // $str = strip_htmltag(make_link(preg_replace($NotePattern, '', $str))); // sonots
            $str = preg_replace($NotePattern, '', $str); // sonots
        }
        
        return $id;
    }

    function check_page()
    {
        global $vars;
        if ($this->options['page'][1] == "") {
            $this->options['page'][1] = $vars['page'];
        } else {
            $this->options['page'][1] = get_fullname($this->options['page'][1], $vars['page']);
            $this->options['fromhere'][1] = false;
        }
        if (! $this->is_page($this->options['page'][1])) {
            $this->error = "$this->plugin was aborted. "; 
            $this->error .= "No such a page, " . $this->options['page'][1];
            return;
        }
    }
    
    function decompose_args()
    {
        $this->args = $this->compose_array_args($this->args);
        if ($this->error !== "") { return $this->error; }

        $args = array();
        foreach ($this->args as $arg) {
            list($key, $val) = explode("=", $arg, 2);
            if (! isset($this->options[$key])) {
                $this->error = "$this->plugin was aborted. ";
                $this->error .= "No such a option, $key. ";
                return;
            }
            $args[$key] = $val;
        }
        $this->args = $args;
    }
    
    function compose_array_args($comma_exploded_args)
    {
        $args = $comma_exploded_args;
        $result = array();
        while (($arg = current($args)) !== false) {
            list($key, $val) = explode("=", $arg, 2);
            if (isset($val)) {
                if ($val[0] === '(') {
                    while(true) {
                        if ($val[strlen($val) - 1] === ')'
                            && substr_count($val, '(') == substr_count($val, ')')) {
                            break;
                        }
                        $arg = next($args);
                        if ($arg === false) {
                            $this->error = "$this->plugin was aborted. ";
                            $this->error .= "The # of open and close parentheses of one of your arguments did not match. ";
                            return;
                        }
                        $val .= ',' . $arg;
                    }
                }
                $result[] = "$key=$val";
            } else {
                $result[] = $key;
            }
            next($args);
        }
        return $result;
    }
    
    function parse_args()
    {
        foreach ($this->args as $key => $val) {
            if ( !isset($this->options[$key]) ) { continue; } // for action ($vars)
            $type = $this->options[$key][0];

            switch ($type) {
            case 'bool':
                if($val == "" || $val == "on" || $val == "true") {
                    $this->options[$key][1] = true;
                } elseif ($val == "off" || $val == "false" ) {
                    $this->options[$key][1] = false;
                } else {
                    $this->error = "$this->plugin was aborted. $key=$val is invalid. ";
                    $this->error .= "The option, $key, accepts only a boolean value.";
                    $this->error .= "#$this->plugin($key) or #$this->plugin($key=on) or #$this->plugin($key=true) for true. ";
                    $this->error .= "#$this->plugin($key=off) or #$this->plugin($key=false) for false. ";
                    return;
                }
                break;
            case 'string':
                $this->options[$key][1] = $val;
                break;
            case 'sanitize':
                $this->options[$key][1] = htmlspecialchars($val);
                break;
            case 'number':
                // Do not parse yet, parse after getting min and max. Here, just format checking
                if ($val === '') {
                    $this->options[$key][1] = '';
                    break;
                }
                if ($val[0] === '(' && $val[strlen($val) - 1] == ')') {
                    $val = substr($val, 1, strlen($val) - 2);
                }
                foreach (explode(",", $val) as $range) {
                    if (preg_match('/^-?\d+$/', $range)) {
                    } elseif (preg_match('/^-?\d*\:-?\d*$/', $range)) {
                    } elseif (preg_match('/^-?\d+\+-?\d+$/', $range)) {
                    } else {
                        $this->error = "$this->plugin was aborted. $key=$val is invalid. ";
                        $this->error .= "The option, " . $key . ", accepts number values such as 1, 1:3, 1+3, 1,2,4. ";
                        $this->error .= "Specify options as \"$key=1,2,4\" or $key=(1,2,3) when you want to use \",\". ";
                        $this->error .= "In more details, a style like (1:3,5:7,9:) is also possible. 9: means from 9 to the last. ";
                        $this->error .= "Furtermore, - means backward. -1:-3 means 1,2,3 from the tail. ";
                        return;
                    }
                }
                $this->options[$key][1] = $val;
                break;
            case 'enum':
                if($val == "") {
                    $this->options[$key][1] = $this->options[$key][2][0];
                } elseif (in_array($val, $this->options[$key][2])) {
                    $this->options[$key][1] = $val;
                } else {
                    $this->error = "$this->plugin was aborted. $key=$val is invalid. ";
                    $this->error .= "The option, " . $key . ", accepts values from one of (" . join(",", $this->options[$key][2]) . "). ";
                    $this->error .= "By the way, #$this->plugin($key) equals to #$this->plugin($key=" . $this->options[$key][2][0] . "). ";
                    return;
                }
                break;
            case 'array':
                if ($val === '') {
                    $this->options[$key][1] = array();
                    break;
                }
                if ($val[0] === '(' && $val[strlen($val) - 1] == ')') {
                    $val = substr($val, 1, strlen($val) - 2);
                }
                $val = explode(',', $val);
                $val = $this->compose_array_args($val); // allows recursive parens such as (())
                $this->options[$key][1] = $val;
                break;
            case 'enumarray':
                if ($val === '') {
                    $this->options[$key][1] = $this->options[$key][2];
                    break;
                }
                if ($val[0] === '(' && $val[strlen($val) - 1] == ')') {
                    $val = substr($val, 1, strlen($val) - 2);
                }
                $val = explode(',', $val);
                $val = $this->compose_array_args($val); // allows recursive parens such as (())
                $this->options[$key][1] = $val;
                foreach ($this->options[$key][1] as $each) {
                    if (! in_array($each, $this->options[$key][2])) {
                        $this->error = "$this->plugin was aborted. $key=" . join(",", $this->options[$key][1]) . " is invalid. ";
                        $this->error .= "The option, " . $key . ", accepts sets of values from (" . join(",", $this->options[$key][2]) . "). ";
                        $this->error .= "By the way, #$this->plugin($key) equals to #$this->plugin($key=(" . join(',',$this->options[$key][2]) . ")). ";
                        return;
                    }
                } 
                break;
            default:
            }
        }
    }
    
    function parse_numoption($key, $min, $max)
    {
        $val = $this->options[$key][1];
        if ($val === '') {
            return;
        }
        $result = array();
        foreach (explode(",", $val) as $range) {
            if (preg_match('/^-?\d+$/', $range)) {
                $left = $right = $range;
            } elseif (preg_match('/^-?\d*\:-?\d*$/', $range)) {
                list($left, $right) = explode(":", $range, 2);
                if ($left == "" && $right == "") {
                    $left = $min;
                    $right = $max;
                } elseif($left == "") {
                    $left = $min;
                } elseif ($right == "") {
                    $right = $max;
                }
            } elseif (preg_match('/^-?\d+\+-?\d+$/', $range)) {
                list($left, $right) = explode("+", $range, 2);
                $right += $left;
            }
            if ($left < 0) {
                $left += $max + 1;
            }
            if ($right < 0) {
                $right += $max + 1;
            }
            $result = array_merge($result, range($left, $right));
            // range allows like range(5, 3) also
        }
        // filter
        foreach (array_keys($result) as $i) {
            if ($result[$i] < $min || $result[$i] > $max) {
                unset($result[$i]);
            }
        }
        sort($result);
        $result = array_unique($result);
        $this->options[$key][1] = $result;
    }

    function option_debug_print() {
        foreach ($this->options as $key => $val) {
            $type = $val[0];
            $val = $val[1];
            if(is_array($val)) {
                $val=join(',', $val);
            }
            $body .= "$key=>($type, $val),";
        }
        return $body;
    }
    
    function get_source($page)
    {
        return get_source($page);
    }
    
    function is_page($page)
    {
        return is_page($page);
    }

    function file_exists($file)
    {
        return file_exists($file);
    }

    function is_readable($file)
    {
        return is_readable($file);
    }

    function is_writable($file)
    {
        return is_writable($file);
    }
}

?>
