<?php
// PukiWiki - Yet another WikiWikiWeb clone
// $Id: auth.php 1 2008-07-02 09:04:21Z kojima $
//
// Basic authentication related functions
//SiteDev+AT AKKO
//basicǧڤѤʤ
//

// Authentication related functions

define('PKWK_PASSPHRASE_LIMIT_LENGTH', 512);

// Compute RFC2307 'userPassword' value, like slappasswd (OpenLDAP)
// $phrase : Pass-phrase
// $scheme : Specify '{scheme}' or '{scheme}salt'
// $prefix : Output with a scheme-prefix or not
// $canonical : Correct or Preserve $scheme prefix
function pkwk_hash_compute($phrase = '', $scheme = '{x-php-md5}', $prefix = TRUE, $canonical = FALSE)
{
	if (! is_string($phrase) || ! is_string($scheme)) return FALSE;

	if (strlen($phrase) > PKWK_PASSPHRASE_LIMIT_LENGTH)
		die('pkwk_hash_compute(): malicious message length');

	// With a {scheme}salt or not
	$matches = array();
	if (preg_match('/^(\{.+\})(.*)$/', $scheme, $matches)) {
		$scheme = & $matches[1];
		$salt   = & $matches[2];
	} else if ($scheme != '') {
		$scheme  = ''; // Cleartext
		$salt    = '';
	}

	// Compute and add a scheme-prefix
	switch (strtolower($scheme)) {

	// PHP crypt()
	case '{x-php-crypt}' :
		$hash = ($prefix ? ($canonical ? '{x-php-crypt}' : $scheme) : '') .
			($salt != '' ? crypt($phrase, $salt) : crypt($phrase));
		break;

	// PHP md5()
	case '{x-php-md5}'   :
		$hash = ($prefix ? ($canonical ? '{x-php-md5}' : $scheme) : '') .
			md5($phrase);
		break;

	// PHP sha1()
	case '{x-php-sha1}'  :
		$hash = ($prefix ? ($canonical ? '{x-php-sha1}' : $scheme) : '') .
			sha1($phrase);
		break;

	// LDAP CRYPT
	case '{crypt}'       :
		$hash = ($prefix ? ($canonical ? '{CRYPT}' : $scheme) : '') .
			($salt != '' ? crypt($phrase, $salt) : crypt($phrase));
		break;

	// LDAP MD5
	case '{md5}'         :
		$hash = ($prefix ? ($canonical ? '{MD5}' : $scheme) : '') .
			base64_encode(hex2bin(md5($phrase)));
		break;

	// LDAP SMD5
	case '{smd5}'        :
		// MD5 Key length = 128bits = 16bytes
		$salt = ($salt != '' ? substr(base64_decode($salt), 16) : substr(crypt(''), -8));
		$hash = ($prefix ? ($canonical ? '{SMD5}' : $scheme) : '') .
			base64_encode(hex2bin(md5($phrase . $salt)) . $salt);
		break;

	// LDAP SHA
	case '{sha}'         :
		$hash = ($prefix ? ($canonical ? '{SHA}' : $scheme) : '') .
			base64_encode(hex2bin(sha1($phrase)));
		break;

	// LDAP SSHA
	case '{ssha}'        :
		// SHA-1 Key length = 160bits = 20bytes
		$salt = ($salt != '' ? substr(base64_decode($salt), 20) : substr(crypt(''), -8));
		$hash = ($prefix ? ($canonical ? '{SSHA}' : $scheme) : '') .
			base64_encode(hex2bin(sha1($phrase . $salt)) . $salt);
		break;

	// LDAP CLEARTEXT and just cleartext
	case '{cleartext}'   : /* FALLTHROUGH */
	case ''              :
		$hash = ($prefix ? ($canonical ? '{CLEARTEXT}' : $scheme) : '') .
			$phrase;
		break;

	// Invalid scheme
	default:
		$hash = FALSE;
		break;
	}

	return $hash;
}

// ԽԲǽʥڡԽ褦ȤȤ
function check_editable($page, $auth_flag = TRUE, $exit_flag = TRUE)
{
	global $script, $_title_cannotedit, $_msg_unfreeze;

	if (edit_auth($page, $auth_flag, $exit_flag) && is_editable($page))
		return TRUE;

	if (! $exit_flag) return FALSE;

	$body = $title = str_replace('$1', htmlspecialchars(strip_bracket($page)), $_title_cannotedit);

	if (is_freeze($page))
		$body .= '(<a href="' . $script . '?cmd=unfreeze&amp;page=' .
			rawurlencode($page) . '">' . $_msg_unfreeze . '</a>)';

	$page = str_replace('$1', make_search($page), $_title_cannotedit);

	catbody($title, $page, $body);
	exit;
}

// Բǽʥڡ褦ȤȤ ()
function check_readable($page, $auth_flag = TRUE, $exit_flag = TRUE)
{

	return read_auth($page, $auth_flag, $exit_flag);
}

// Խǧ
function edit_auth($page, $auth_flag = TRUE, $exit_flag = TRUE)
{
	global $edit_auth, $edit_auth_pages, $_title_cannotedit;

	return $edit_auth ?  basic_auth($page, $auth_flag, $exit_flag,
		$edit_auth_pages, $_title_cannotedit) : TRUE;
}

// ǧ
function read_auth($page, $auth_flag = TRUE, $exit_flag = TRUE)
{
	global $read_auth, $read_auth_pages, $_title_cannotread;

	return $read_auth ?  basic_auth($page, $auth_flag, $exit_flag,
		$read_auth_pages, $_title_cannotread) : TRUE;
}

// Basic authentication
function basic_auth($page, $auth_flag, $exit_flag, $auth_pages, $title_cannot)
{
	global $auth_users, $auth_method_type;
	global $_msg_auth;
//SiteDev+AT  akko
        global $is_admin;


        if ($is_admin) return TRUE;

	// ǧȽо
	$target_str = '';
	if ($auth_method_type == 'pagename') {
		// ڡ̾ǥå
		$target_str = $page;

	} else if ($auth_method_type == 'contents') {
		// ڡʸǥå
		$target_str = join('', get_source($page));
	}

	// פѥ줿桼Υꥹ
	$user_list = array();
	foreach($auth_pages as $key=>$val)
		if (preg_match($key, $target_str))
			$user_list = array_merge($user_list, explode(',', $val));

	if (empty($user_list)) return TRUE; // No limit
//ѹ

	 if(in_array($_SESSION['usr'],$user_list)){
		return TRUE; //ߤΥå˥桼̾ޤޤOK
	}
	
// 桼ꥹȤ˴ޤޤ뤤줫Υ桼ǧڤOK
//ȥ桼򥻥åѿϿƤ
        $fg = FALSE;
	if ($auth_flag){
		$fg = sd_ckusr("User check",$auth_users);
		if($fg){
			$_SESSION['usr'] = $_POST['username'];
		 	return TRUE;
		}
	}


	if ($exit_flag) {
		$body = $title = str_replace('$1',
		htmlspecialchars(strip_bracket($page)), $title_cannot);
		$page = str_replace('$1', make_search($page), $title_cannot);
		catbody($title, $page, $body);
		exit;
	}
	return FALSE;
}
?>
