/*
 * Copyright(C) 2012 orinos Co.,Ltd. All rights reserved.
 * http://www.orinos.co.jp/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.aimluck.eip.modules.screens;

import org.apache.jetspeed.portal.portlets.VelocityPortlet;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

import com.aimluck.eip.lunchorder.LunchOrderMonthTotalSelectData;
import com.aimluck.eip.lunchorder.LunchOrderSelectData;
import com.aimluck.eip.lunchorder.util.LunchOrderUtils;
import com.aimluck.eip.util.ALEipUtils;

/**
 * 弁当注文ポートレットの一覧を処理するクラスです。 <br />
 *
 */
public class LunchOrderMonthTotalScreen extends ALVelocityScreen {
  /** logger */
  private static final JetspeedLogger logger = JetspeedLogFactoryService
      .getLogger(LunchOrderMonthTotalScreen.class.getName());

  /**
   * @see org.apache.turbine.modules.screens.RawScreen#doOutput(org.apache.turbine.util.RunData)
   */
  @Override
  protected void doOutput(RunData rundata, Context context) throws Exception {
    try {

      LunchOrderMonthTotalSelectData listData = new LunchOrderMonthTotalSelectData();

      // PSMLからパラメータをロードする
      listData.doViewList(this, rundata, context);// DBからのオブジェクトをコンテキストに入れる処理
      String layout_template = "portlets/html/ja/ajax-lunchorder-month-total.vm";// 使用するテンプレート選択
      setTemplate(rundata, context, layout_template);// 使用するテンプレートを指定

    } catch (Exception ex) {
      logger.error("[LunchOrderMonthTotalScreen] Exception.", ex);
      ALEipUtils.redirectDBError(rundata);
    }
  }

  /**
   * @return
   */
  @Override
  protected String getPortletName() {
    return LunchOrderUtils.LUNCHORDER_PORTLET_NAME;
  }


}
