-----------------------------------------------------------------------------
-- AVZ_T_LUNCH_ORDER
-----------------------------------------------------------------------------

CREATE TABLE avz_t_lunch_order
(
  order_map_id serial NOT NULL,
  user_id integer NOT NULL,
  store_name character varying NOT NULL,
  "comment" character varying,
  item_num integer,
  item_num_status character varying,
  create_date timestamp without time zone,
  update_date timestamp without time zone,
  min_status character varying,
  min_plice integer,
  min_num integer,
  deadline_date integer,
  CONSTRAINT avz_t_lunch_order_pkey PRIMARY KEY (order_map_id)
);

-----------------------------------------------------------------------------
-- AVZ_T_LUNCH_ORDER_ITEM
-----------------------------------------------------------------------------

CREATE TABLE avz_t_lunch_order_item
(
  item_id serial NOT NULL,
  order_map_id integer NOT NULL,
  item_number integer,
  item_title character varying(99) NOT NULL,
  price integer NOT NULL,
  "comment" character varying(99),
  min_order_flag integer,
  CONSTRAINT avz_t_lunch_order_item_pkey PRIMARY KEY (item_id),
  CONSTRAINT avz_t_lunch_order_item_order_map_id_fkey FOREIGN KEY (order_map_id)
      REFERENCES avz_t_lunch_order (order_map_id) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE CASCADE
);

-----------------------------------------------------------------------------
-- AVZ_T_LUNCH_USER_ORDER
-----------------------------------------------------------------------------

CREATE TABLE avz_t_lunch_user_order
(
  id serial NOT NULL,
  item_id integer,
  user_id integer,
  order_amount integer,
  order_date timestamp without time zone,
  CONSTRAINT avz_t_lunch_user_order_pkey PRIMARY KEY (id),
  CONSTRAINT avz_t_lunch_user_order_item_id_fkey FOREIGN KEY (item_id)
      REFERENCES avz_t_lunch_order_item (item_id) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE CASCADE,
  CONSTRAINT avz_t_lunch_user_order_user_id_fkey FOREIGN KEY (user_id)
      REFERENCES turbine_user (user_id) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE CASCADE
);