/*
 * Copyright(C) 2012 - 2013 orinos Co.,Ltd. All rights reserved.
 * http://www.orinos.co.jp/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

dojo.require("aipo.widget.MemberNormalSelectList");

dojo.provide("aipo.improveope");



aipo.improveope.onLoadImproveopeDetail = function(portlet_id){
  aipo.portletReload('whatsnew');
}

aipo.improveope.onLoadImproveopeDialog = function(portlet_id){
  var obj = dojo.byId("topic_name");
  if(obj){
     obj.focus();
  }
}

aipo.improveope.onLoadImproveopeApplyDialog = function(portlet_id){
	  var obj = dojo.byId("topic_name");
	  if(obj){
	     obj.focus();
	  }
    var mpicker = dijit.byId("mapnormalselect");
	if(mpicker){
	    var select = dojo.byId('init_maplist');
	    var i;
	    var s_o = select.options;
	    if (s_o.length == 1 && s_o[0].value == "") return;
	    for(i = 0 ; i < s_o.length; i ++ ) {
	        mpicker.addOptionSync(s_o[i].value,s_o[i].text,true);
	    }
	}
}

aipo.improveope.onChangeFilter=aipo.improveope.onChangeSearch=function (baseuri,portlet_id){
	var search = encodeURIComponent(dojo.byId("q").value);
	baseuri+="?template=ImproveopeTopicListScreen";
	baseuri+="&filter="+dojo.byId("topic").value;
	baseuri+="&filtertype=category";
	baseuri+="&search="+search;
	aipo.viewPage(baseuri,portlet_id);
}

aipo.improveope.onLoadCategoryDialog = function(portlet_id){
  var obj = dojo.byId("category_name");
  if(obj){
     obj.focus();
  }

  var mpicker = dijit.byId("membernormalselect");
  if(mpicker){
    var select = dojo.byId('init_memberlist');
    var i;
    var s_o = select.options;
    if (s_o.length == 1 && s_o[0].value == "") return;
    for(i = 0 ; i < s_o.length; i ++ ) {
        mpicker.addOptionSync(s_o[i].value,s_o[i].text,true);
    }
  }
}



aipo.improveope.showMember = function(button) {
  dojo.byId('Block-GroupMember-Show').style.display="";
  dojo.byId('is_member').value = "TRUE";
}

aipo.improveope.hideMember = function(button) {
  dojo.byId('Block-GroupMember-Show').style.display="none";
  dojo.byId('member_to').options.length = 0;
  dojo.byId('is_member').value = "FALSE";
}

aipo.improveope.expandImageWidth = function(img) {
  var class_name = img.className;
  if(! class_name.match(/width_auto/i)) {
    img.className = img.className.replace( /\bwidth_thumbs\b/g, "width_auto");
  } else {
    img.className = img.className.replace( /\bwidth_auto\b/g, "width_thumbs");
  }
}

aipo.improveope.formSwitchCategoryInput = function(button) {
    if(button.form.is_new_category.value == 'TRUE' || button.form.is_new_category.value == 'true') {
        button.value = aimluck.io.escapeText("improveope_val_switch1");
        aipo.improveope.formCategoryInputOff(button.form);
    } else {
        button.value = aimluck.io.escapeText("improveope_val_switch2");
        aipo.improveope.formCategoryInputOn(button.form);
    }
}

aipo.improveope.formCategoryInputOn = function(form) {
    dojo.byId('improveopeCategorySelectField').style.display = "none";
    dojo.byId('improveopeCategoryInputField').style.display = "";

    form.is_new_category.value = 'TRUE';
}

aipo.improveope.formCategoryInputOff = function(form) {
    dojo.byId('improveopeCategoryInputField').style.display = "none";
    dojo.byId('improveopeCategorySelectField').style.display = "";

    form.is_new_category.value = 'FALSE';
}

aipo.improveope.onReceiveMessage = function(msg){
    //送信時に作成した場合selectを削除。
	var select=dojo.byId("attachments_select");
	if(typeof select!="undefined"&& select!=null)
		select.parentNode.removeChild(select);
    if(!msg) {
        var arrDialog = dijit.byId("modalDialog");
        if(arrDialog){
            arrDialog.hide();
        }
        aipo.portletReload('improveope');
        aipo.portletReload('timeline');
    }
    if (dojo.byId('messageDiv')) {
        dojo.byId('messageDiv').innerHTML = msg;
    }
}

aipo.improveope.onListReceiveMessage = function(msg){
    if(!msg) {
        var arrDialog = dijit.byId("modalDialog");
        if(arrDialog){
            arrDialog.hide();
        }
        aipo.portletReload('improveope');
    }
    if (dojo.byId('listmessageDiv')) {
        dojo.byId('listmessageDiv').innerHTML = msg;
    }
}

aipo.improveope.ajaxCheckboxDeleteSubmit = function(button, url, indicator_id, portlet_id, receive) {
  aimluck.io.ajaxVerifyCheckbox( button.form, aipo.improveope.ajaxMultiDeleteSubmit, button, url, indicator_id, portlet_id, receive );
}

aipo.improveope.ajaxMultiDeleteSubmit = function(button, url, indicator_id, portlet_id, receive) {
  if(confirm('選択した'+button.form._name.value+'を削除してよろしいですか？なお、カテゴリに含まれるトピックはすべて削除されます。')) {
    aimluck.io.disableForm(button.form, true);
    aimluck.io.setHiddenValue(button);
    button.form.action = url;
    aimluck.io.submit(button.form,indicator_id,portlet_id,receive);
  }
}

aipo.improveope.ajaxDeleteSubmit = function(button, url, indicator_id, portlet_id, receive) {
  if(confirm('この'+button.form._name.value+'を削除してよろしいですか？なお、カテゴリに含まれるトピックはすべて削除されます。')) {
    aimluck.io.disableForm(button.form, true);
    aimluck.io.setHiddenValue(button);
    button.form.action = url;
    aimluck.io.submit(button.form, indicator_id, portlet_id, receive);
  }
}
