/*
 * Copyright(C) 2012 - 2013 orinos Co.,Ltd. All rights reserved.
 * http://www.orinos.co.jp/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.aimluck.eip.modules.screens;

import java.text.SimpleDateFormat;
import java.util.List;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;

import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;

import com.aimluck.eip.cayenne.om.portlet.OriTImproveopeApplyCheck;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.improveope.util.ImproveopeApplyUtils;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.util.ALEipUtils;

/**
 * 評価ファイル出力を取り扱うクラスです
 */
public class ImproveopeApplyCsvExportScreen extends ALCSVScreen {
  /**
   * logger
   */
  private static final JetspeedLogger logger = JetspeedLogFactoryService
    .getLogger(ImproveopeApplyCsvExportScreen.class.getName());

  /**
   * HTTP コンテンツタイプ
   *
   * @see org.apache.turbine.modules.screens.RawScreen#getContentType(org.apache.turbine.util.RunData)
   */
  @Override
  protected String getContentType(RunData rundata) {
    return "application/octet-stream";
  }

  /**
   * 出力ファイル名（接頭辞）
   */
  public static String FILE_NAME = "";

  /**
   * 拡張子名
   */
  public static final String FILE_EXTENTION = ".csv";

  /**
   * CSVデータ改行値
   */
  public static final String LINE_SEPARATOR = System
    .getProperty("line.separator");

  /**
   * CSVデータ区切り文字
   */
  public static final String COLOMN_SEPARATOR = ",";

  private String entityid;

  @Override
  protected void doOutput(RunData rundata) throws Exception {
    ServletOutputStream out = null;

    try {

      entityid = rundata.getParameters().getString("entityid");
      String result = getCSVString(rundata);
      FILE_NAME = "社内評価-" + entityid + FILE_EXTENTION;
      String fileName =
        new String(FILE_NAME.getBytes("Shift_JIS"), "ISO-8859-1");

      HttpServletResponse response = rundata.getResponse();
      // ファイル名の送信(attachment部分をinlineに変更すればインライン表示)
      response.setHeader("Content-disposition", "attachment; filename=\""
        + fileName
        + "\"");
      response.setHeader("Cache-Control", "no-cache");
      response.setHeader("Pragma", "No-cache");

      // ファイル内容の出力
      out = response.getOutputStream();
      out.write(result.getBytes("Shift_JIS"));
      out.flush();
      out.close();
    } catch (Exception e) {
      logger.error("[ERROR]", e);
    }

  }

  /**
   * CSV文字列取り出し用メソッド。<br />
   * CSV文字列を返します。
   *
   * @param rundata
   *          RunData
   * @return
   */
  @Override
  protected String getCSVString(RunData rundata) {
    StringBuffer sb = new StringBuffer();
    // ヘッダライン設定
    makeHeaderLine(sb);

    // SQLの作成
    StringBuffer idStatement = new StringBuffer();
    idStatement.append("SELECT * ");
    idStatement.append("FROM ori_t_improveope_apply_check ");
    idStatement.append("WHERE apply_id = #bind($apply_id) ");
    idStatement.append("ORDER BY CREATE_DATE ASC");

    String idQuery = idStatement.toString();

    List<OriTImproveopeApplyCheck> list =
      Database.sql(OriTImproveopeApplyCheck.class, idQuery).param(
        "apply_id",
        Integer.valueOf(entityid)).fetchList();

    if (list != null && list.size() > 0) {
      for (int i = 0; i < list.size(); i++) {

    	OriTImproveopeApplyCheck check = list.get(i);
        // 名前
    	try {
   		  ALEipUser user = ALEipUtils.getALEipUser(Integer.valueOf(check.getUserId()));
          setColumn(sb, user.getAliasName().toString());
    	} catch (Exception ex) {
          setColumn(sb, "");
          logger.error("Exception", ex);
        }
        // 評価
        String answer = "";
        if (ImproveopeApplyUtils.APPLY_ANSWER_GOOD.equals(check.getAnswer().toString())) {
        	answer = "賛成";
        } else if (ImproveopeApplyUtils.APPLY_ANSWER_BAD.equals(check.getAnswer().toString())) {
        	answer = "反対";
        } else if (ImproveopeApplyUtils.APPLY_ANSWER_NEITHER.equals(check.getAnswer().toString())) {
        	answer = "どちらでもない";
        }
        setColumn(sb, answer);
        // コメント
        setColumn(sb, check.getNote());
        // 評価日
        SimpleDateFormat sf = new SimpleDateFormat("yyyy年MM月dd日 HH:mm");
        setColumn(sb, sf.format(check.getCreateDate()), false);

        sb.append(LINE_SEPARATOR);
      }
    }

    // 生成文字列 デバック用出力
    logger.debug(sb.toString());

    return sb.toString();
  }

  @Override
  protected String getFileName() {

    return null;
  }

  private void setColumn(StringBuffer sb, String value) {
    setColumn(sb, value, true);
  }

  /**
   * カラムをセットする
   */
  private void setColumn(StringBuffer sb, String value, boolean separator) {

    if (value == null || "0".equals(value) || "0.0".equals(value)) {
      value = "";
    }

    sb.append("\"" + value + "\"");

    if (separator) {
      sb.append(COLOMN_SEPARATOR);
    }
  }

  /**
   * CSVのヘッダ情報を生成します。
   *
   * @param sb
   *          StringBuffer
   */
  private void makeHeaderLine(StringBuffer sb) {
    sb.append("\"名前\"" + COLOMN_SEPARATOR);
    sb.append("\"評価\"" + COLOMN_SEPARATOR);
    sb.append("\"コメント\"" + COLOMN_SEPARATOR);
    sb.append("\"評価日\"" + COLOMN_SEPARATOR);
    sb.append(LINE_SEPARATOR);
  }
}
