/*
 * Copyright(C) 2012 - 2013 orinos Co.,Ltd. All rights reserved.
 * http://www.orinos.co.jp/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.aimluck.eip.modules.actions.improveope;

import java.util.ArrayList;
import java.util.List;

import org.apache.jetspeed.portal.portlets.VelocityPortlet;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

import com.aimluck.eip.common.ALEipConstants;
import com.aimluck.eip.improveope.ImproveopeActionSelectData;
import com.aimluck.eip.improveope.ImproveopeApplySelectData;
import com.aimluck.eip.improveope.ImproveopeCheckSelectData;
import com.aimluck.eip.improveope.ImproveopeGrantSelectData;
import com.aimluck.eip.improveope.ImproveopePointManagementSelectData;
import com.aimluck.eip.improveope.ImproveopePointSelectData;
import com.aimluck.eip.improveope.ImproveopeReceiveSelectData;
import com.aimluck.eip.improveope.ImproveopeTopicFormData;
import com.aimluck.eip.improveope.ImproveopeTopicMultiDelete;
import com.aimluck.eip.improveope.ImproveopeTopicReplyFormData;
import com.aimluck.eip.improveope.ImproveopeTopicSelectData;
import com.aimluck.eip.improveope.util.ImproveopeUtils;
import com.aimluck.eip.modules.actions.common.ALBaseAction;
import com.aimluck.eip.util.ALEipUtils;
//import com.aimluck.eip.improveope.ImproveopeCategoryFormData;
//import com.aimluck.eip.improveope.ImproveopeCategoryMultiDelete;
//import com.aimluck.eip.improveope.ImproveopeCategorySelectData;

/**
 * 掲示板のアクションクラス <BR>
 *
 */
public class ImproveopeAction extends ALBaseAction {

  /** logger */
  private static final JetspeedLogger logger = JetspeedLogFactoryService
    .getLogger(ImproveopeAction.class.getName());

  /** 返信用キー */
  private final String RESULT_ON_TOPIC_DETAIL = "resultOnTopicDetail";

  /** 返信用エラーメッセージキー */
  private final String ERROR_MESSAGE_LIST_ON_TOPIC_DETAIL =
    "errmsgsOnTopicDetail";

  /** 返信用 result */
  private Object resultOnTopicDetail;

  /** 返信用異常系のメッセージを格納するリスト */
  private List<String> errmsgListOnTopicDetail;


  /** 業務改善申請 詳細 */
  /** 返信用キー */
  private final String RESULT_ON_RECEIVE_FORM = "resultOnReceiveForm";

  /** 返信用エラーメッセージキー */
  private final String ERROR_MESSAGE_LIST_ON_RECEIVE_FORM =
    "errmsgsOnReceiveForm";

  /** 返信用 result */
  private Object resultOnReceiveForm;

  /** 返信用異常系のメッセージを格納するリスト */
  private List<String> errmsgListOnReceiveForm;


  /** 業務改善申請 評価中 */
  /** 返信用キー */
  private final String RESULT_ON_CHECK_FORM = "resultOnCheckForm";

  /** 返信用エラーメッセージキー */
  private final String ERROR_MESSAGE_LIST_ON_CHECK_FORM =
    "errmsgsOnCheckForm";

  /** 返信用 result */
  private Object resultOnCheckForm;

  /** 返信用異常系のメッセージを格納するリスト */
  private List<String> errmsgListOnCheckForm;


  /** 業務改善実施要項作成 */
  /** 返信用キー */
  private final String RESULT_ON_ACTION_FORM = "resultOnActionForm";

  /** 返信用エラーメッセージキー */
  private final String ERROR_MESSAGE_LIST_ON_ACTION_FORM =
    "errmsgsOnActionForm";

  /** 返信用 result */
  private Object resultOnActionForm;

  /** 返信用異常系のメッセージを格納するリスト */
  private List<String> errmsgListOnActionForm;


  /** 業務改善実施要項報告 */
  /** 返信用キー */
  private final String RESULT_ON_REPORT_FORM = "resultOnReportForm";

  /** 返信用エラーメッセージキー */
  private final String ERROR_MESSAGE_LIST_ON_REPORT_FORM =
    "errmsgsOnReportForm";

  /** 返信用 result */
  private Object resultOnReportForm;

  /** 返信用異常系のメッセージを格納するリスト */
  private List<String> errmsgListOnReportForm;

  /**
   * 通常表示の際の処理を記述します。 <BR>
   *
   * @param portlet
   * @param context
   * @param rundata
   * @throws Exception
   */
  @Override
  protected void buildNormalContext(VelocityPortlet portlet, Context context,
      RunData rundata) throws Exception {

    // セッション情報をクリアする．
    clearImproveopeSession(rundata, context);
    ImproveopeUtils.resetFilter(rundata, context, ImproveopeTopicSelectData.class
      .getName());

    ImproveopeTopicSelectData listData = new ImproveopeTopicSelectData();
    listData.initField();
//    listData.loadCategoryList(rundata, context);
    listData.setRowsNum(Integer.parseInt(portlet
      .getPortletConfig()
      .getInitParameter("p1a-rows")));
    listData.setTableColumNum(Integer.parseInt(portlet
      .getPortletConfig()
      .getInitParameter("p1e-rows")));
    listData.doViewList(this, rundata, context);
    setTemplate(rundata, "improveope-topic");
  }

  /**
   * 最大化表示の際の処理を記述します。 <BR>
   *
   * @param portlet
   * @param context
   * @param rundata
   */
  @Override
  protected void buildMaximizedContext(VelocityPortlet portlet,
      Context context, RunData rundata) {

    // MODEを取得
    String mode = rundata.getParameters().getString(ALEipConstants.MODE);
    try {
      if (ALEipConstants.MODE_FORM.equals(mode)) {
        doImproveope_topic_form(rundata, context);
      } else if (ALEipConstants.MODE_DETAIL.equals(mode)) {
        doImproveope_topic_detail(rundata, context);
      } else if (ALEipConstants.MODE_LIST.equals(mode)) {
    	/** 掲示板 */
        doImproveope_topic_list(rundata, context);
      } else if ("check".equals(mode)) {
    	/** 評価待ち一覧 */
        doImproveope_check_list(rundata, context);
      } else if ("apply".equals(mode)) {
    	/** 申請一覧 */
        doImproveope_apply_list(rundata, context);
      } else if ("receive".equals(mode)) {
    	/** 受信一覧 */
        doImproveope_receive_list(rundata, context);
      } else if ("action".equals(mode)) {
    	/** 実施一覧 */
        doImproveope_action_list(rundata, context);
      } else if ("point".equals(mode)) {
    	/** ポイント履歴 */
        doImproveope_point_list(rundata, context);
      } else if ("grant".equals(mode)) {
    	/** ポイント付与 */
        doImproveope_grant_list(rundata, context);
      } else if ("category_detail".equals(mode)) {
        doImproveope_category_detail(rundata, context);
      } else if ("point_management".equals(mode)) {
    	/** ポイント管理 */
    	doImproveope_point_management_list(rundata, context);
      }
      if (getMode() == null) {
        doImproveope_topic_list(rundata, context);
      }
    } catch (Exception ex) {
      logger.error("Exception", ex);
    }

  }

  /**
   * トピック登録のフォームを表示する. <BR>
   *
   * @param rundata
   * @param context
   * @throws Exception
   */
  public void doImproveope_topic_form(RunData rundata, Context context)
      throws Exception {
    ImproveopeTopicFormData formData = new ImproveopeTopicFormData();
    formData.initField();
//    formData.loadCategoryList(rundata, context);
    formData.doViewForm(this, rundata, context);
    setTemplate(rundata, "improveope-topic-form");
  }

  /**
   * トピックを登録します。 <BR>
   *
   * @param rundata
   * @param context
   * @throws Exception
   */
  public void doImproveope_topic_insert(RunData rundata, Context context)
      throws Exception {
    ImproveopeTopicFormData formData = new ImproveopeTopicFormData();
    formData.initField();
//    formData.loadCategoryList(rundata, context);
    if (formData.doInsert(this, rundata, context)) {
      // データ登録が成功したとき
      doImproveope_topic_list(rundata, context);
      // JetspeedLink jsLink = JetspeedLinkFactory.getInstance(rundata);
      // rundata.setRedirectURI(jsLink.getPortletById(
      // ALEipUtils.getPortlet(rundata, context).getID()).addQueryData(
      // "eventSubmit_doImproveope_topic_list", "1").toString());
      // rundata.getResponse().sendRedirect(rundata.getRedirectURI());
      // jsLink = null;
    } else {
      setTemplate(rundata, "improveope-topic-form");
    }

  }

  /**
   * トピックを削除します。 <BR>
   *
   * @param rundata
   * @param context
   * @throws Exception
   */
  public void doImproveope_topic_delete(RunData rundata, Context context)
      throws Exception {
    ImproveopeTopicFormData formData = new ImproveopeTopicFormData();
    formData.initField();
    if (formData.doDelete(this, rundata, context)) {
      // データ削除が成功したとき
      doImproveope_topic_list(rundata, context);
      // JetspeedLink jsLink = JetspeedLinkFactory.getInstance(rundata);
      // rundata.setRedirectURI(jsLink.getPortletById(
      // ALEipUtils.getPortlet(rundata, context).getID()).addQueryData(
      // "eventSubmit_doImproveope_topic_list", "1").toString());
      // rundata.getResponse().sendRedirect(rundata.getRedirectURI());
      // jsLink = null;
    }

  }

  /**
   * 返信記事を削除します。 <BR>
   *
   * @param rundata
   * @param context
   * @throws Exception
   */
  public void doImproveope_topic_reply_delete(RunData rundata, Context context)
      throws Exception {
    ImproveopeTopicReplyFormData formData = new ImproveopeTopicReplyFormData();
    formData.initField();
    if (formData.doDelete(this, rundata, context)) {
      // データ削除が成功したとき
      doImproveope_topic_detail(rundata, context);
      // JetspeedLink jsLink = JetspeedLinkFactory.getInstance(rundata);
      // rundata.setRedirectURI(jsLink.getPortletById(
      // ALEipUtils.getPortlet(rundata, context).getID()).addQueryData(
      // "eventSubmit_doImproveope_topic_detail", "1").toString());
      // rundata.getResponse().sendRedirect(rundata.getRedirectURI());
      // jsLink = null;
    }
  }

  /**
   * トピックを削除します。（複数） <BR>
   *
   * @param rundata
   * @param context
   * @throws Exception
   */
  public void doImproveope_topic_multi_delete(RunData rundata, Context context)
      throws Exception {
    ImproveopeTopicMultiDelete delete = new ImproveopeTopicMultiDelete();
    delete.doMultiAction(this, rundata, context);
    doImproveope_topic_list(rundata, context);
    // JetspeedLink jsLink = JetspeedLinkFactory.getInstance(rundata);
    // rundata.setRedirectURI(jsLink.getPortletById(
    // ALEipUtils.getPortlet(rundata, context).getID()).addQueryData(
    // "eventSubmit_doImproveope_topic_list", "1").toString());
    // rundata.getResponse().sendRedirect(rundata.getRedirectURI());
    // jsLink = null;
  }

  /**
   * トピックを一覧表示します。 <BR>
   *
   * @param rundata
   * @param context
   * @throws Exception
   */
  public void doImproveope_topic_list(RunData rundata, Context context)
      throws Exception {
    ImproveopeTopicSelectData listData = new ImproveopeTopicSelectData();
    listData.initField();
//    listData.loadCategoryList(rundata, context);
    // PSMLからパラメータをロードする
    // 最大表示件数（最大化時）
    listData.setRowsNum(Integer.parseInt(ALEipUtils
      .getPortlet(rundata, context)
      .getPortletConfig()
      .getInitParameter("p1b-rows")));
    listData.doViewList(this, rundata, context);
    setTemplate(rundata, "improveope-topic-list");
  }

  /**
   * 評価待ちを一覧表示します。 <BR>
   *
   * @param rundata
   * @param context
   * @throws Exception
   */
  public void doImproveope_check_list(RunData rundata, Context context)
      throws Exception {
	ImproveopeCheckSelectData listData = new ImproveopeCheckSelectData();
    listData.initField();
    // PSMLからパラメータをロードする
    // 最大表示件数（最大化時）
    listData.setRowsNum(Integer.parseInt(ALEipUtils
      .getPortlet(rundata, context)
      .getPortletConfig()
      .getInitParameter("p1b-rows")));
    listData.doViewList(this, rundata, context);
    setTemplate(rundata, "improveope-check-list");
  }

  /**
   * 申請を一覧表示します。 <BR>
   *
   * @param rundata
   * @param context
   * @throws Exception
   */
  public void doImproveope_apply_list(RunData rundata, Context context)
      throws Exception {
	ImproveopeApplySelectData listData = new ImproveopeApplySelectData();
    listData.initField();
    // PSMLからパラメータをロードする
    // 最大表示件数（最大化時）
    listData.setRowsNum(Integer.parseInt(ALEipUtils
      .getPortlet(rundata, context)
      .getPortletConfig()
      .getInitParameter("p1b-rows")));
    listData.doViewList(this, rundata, context);
    setTemplate(rundata, "improveope-apply-list");
  }

  /**
   * 受信を一覧表示します。 <BR>
   *
   * @param rundata
   * @param context
   * @throws Exception
   */
  public void doImproveope_receive_list(RunData rundata, Context context)
      throws Exception {
	ImproveopeReceiveSelectData listData = new ImproveopeReceiveSelectData();
    listData.initField();
    // PSMLからパラメータをロードする
    // 最大表示件数（最大化時）
    listData.setRowsNum(Integer.parseInt(ALEipUtils
      .getPortlet(rundata, context)
      .getPortletConfig()
      .getInitParameter("p1b-rows")));
    listData.doViewList(this, rundata, context);
    setTemplate(rundata, "improveope-receive-list");
  }

  /**
   * 実施を一覧表示します。 <BR>
   *
   * @param rundata
   * @param context
   * @throws Exception
   */
  public void doImproveope_action_list(RunData rundata, Context context)
      throws Exception {
	  ImproveopeActionSelectData listData = new ImproveopeActionSelectData();
    listData.initField();
    // PSMLからパラメータをロードする
    // 最大表示件数（最大化時）
    listData.setRowsNum(Integer.parseInt(ALEipUtils
      .getPortlet(rundata, context)
      .getPortletConfig()
      .getInitParameter("p1b-rows")));
    listData.doViewList(this, rundata, context);
    setTemplate(rundata, "improveope-action-list");
  }

  /**
   * ポイント履歴を一覧表示します。 <BR>
   *
   * @param rundata
   * @param context
   * @throws Exception
   */
  public void doImproveope_point_list(RunData rundata, Context context)
      throws Exception {
    ImproveopePointSelectData listData = new ImproveopePointSelectData();
    listData.initField();
//    listData.loadCategoryList(rundata, context);
    // PSMLからパラメータをロードする
    // 最大表示件数（最大化時）
    listData.setRowsNum(Integer.parseInt(ALEipUtils
      .getPortlet(rundata, context)
      .getPortletConfig()
      .getInitParameter("p1b-rows")));
    listData.setMode("point");
    listData.doViewList(this, rundata, context);
    setTemplate(rundata, "improveope-point-list");
  }

  /**
   * ポイント付与を一覧表示します。 <BR>
   *
   * @param rundata
   * @param context
   * @throws Exception
   */
  public void doImproveope_grant_list(RunData rundata, Context context)
      throws Exception {
	ImproveopeGrantSelectData listData = new ImproveopeGrantSelectData();
    listData.initField();
//    listData.loadCategoryList(rundata, context);
    // PSMLからパラメータをロードする
    // 最大表示件数（最大化時）
    listData.setRowsNum(Integer.parseInt(ALEipUtils
      .getPortlet(rundata, context)
      .getPortletConfig()
      .getInitParameter("p1b-rows")));
    listData.setMode("grant");
    listData.doViewList(this, rundata, context);
    setTemplate(rundata, "improveope-grant-list");
  }

  /**
   * ポイント管理一覧表示します。 <BR>
   *
   * @param rundata
   * @param context
   * @throws Exception
   */
  public void doImproveope_point_management_list(RunData rundata, Context context)
      throws Exception {
	ImproveopePointManagementSelectData listData = new ImproveopePointManagementSelectData();
    listData.initField();
//    listData.loadCategoryList(rundata, context);
    // PSMLからパラメータをロードする
    // 最大表示件数（最大化時）
    listData.setRowsNum(Integer.parseInt(ALEipUtils
      .getPortlet(rundata, context)
      .getPortletConfig()
      .getInitParameter("p1b-rows")));
    listData.setMode("point_management");
    listData.doViewList(this, rundata, context);
    setTemplate(rundata, "improveope-point-management-list");
  }

  /**
   * トピックを詳細表示します。 <BR>
   *
   * @param rundata
   * @param context
   * @throws Exception
   */
  public void doImproveope_topic_detail(RunData rundata, Context context)
      throws Exception {
    ImproveopeTopicSelectData detailData = new ImproveopeTopicSelectData();
    detailData.initField();
    if (detailData.doViewDetail(this, rundata, context)) {
      if (detailData.showReplyForm()) {
        ImproveopeTopicReplyFormData formData = new ImproveopeTopicReplyFormData();
        formData.initField();
        formData.doViewForm(this, rundata, context);
      }
      setTemplate(rundata, "improveope-topic-detail");
    } else {
      doImproveope_topic_list(rundata, context);
    }
  }

  /**
   * カテゴリ登録のフォームを表示します。 <BR>
   *
   * @param rundata
   * @param context
   * @throws Exception
   */
  public void doImproveope_category_form(RunData rundata, Context context)
      throws Exception {
//    ImproveopeCategoryFormData formData = new ImproveopeCategoryFormData();
//    formData.initField();
//    formData.doViewForm(this, rundata, context);
//    setTemplate(rundata, "improveope-category-form");
  }

  /**
   * カテゴリを登録します。 <BR>
   *
   * @param rundata
   * @param context
   * @throws Exception
   */
  public void doImproveope_category_insert(RunData rundata, Context context)
      throws Exception {
//    ImproveopeCategoryFormData formData = new ImproveopeCategoryFormData();
//    formData.initField();
//    if (formData.doInsert(this, rundata, context)) {
//      // データ登録に成功したとき
//      doImproveope_category_list(rundata, context);
//      // JetspeedLink jsLink = JetspeedLinkFactory.getInstance(rundata);
//      // rundata.setRedirectURI(jsLink.getPortletById(
//      // ALEipUtils.getPortlet(rundata, context).getID()).addQueryData(
//      // "eventSubmit_doImproveope_category_list", "1").toString());
//      // rundata.getResponse().sendRedirect(rundata.getRedirectURI());
//      // jsLink = null;
//    } else {
//      setTemplate(rundata, "improveope-category-form");
//    }

  }

  /**
   * カテゴリを更新します。 <BR>
   *
   * @param rundata
   * @param context
   * @throws Exception
   */
  public void doImproveope_category_update(RunData rundata, Context context)
      throws Exception {
//    ImproveopeCategoryFormData formData = new ImproveopeCategoryFormData();
//    formData.initField();
//    if (formData.doUpdate(this, rundata, context)) {
//      // データ更新に成功したとき
//      doImproveope_category_list(rundata, context);
//      // JetspeedLink jsLink = JetspeedLinkFactory.getInstance(rundata);
//      // rundata.setRedirectURI(jsLink.getPortletById(
//      // ALEipUtils.getPortlet(rundata, context).getID()).addQueryData(
//      // "eventSubmit_doImproveope_category_list", "1").toString());
//      // rundata.getResponse().sendRedirect(rundata.getRedirectURI());
//      // jsLink = null;
//    } else {
//      setTemplate(rundata, "improveope-category-form");
//    }

  }

  /**
   * カテゴリを削除します。 <BR>
   *
   * @param rundata
   * @param context
   * @throws Exception
   */
  public void doImproveope_category_delete(RunData rundata, Context context)
      throws Exception {
//    ImproveopeCategoryFormData formData = new ImproveopeCategoryFormData();
//    formData.initField();
//    if (formData.doDelete(this, rundata, context)) {
//      // データ削除に成功したとき
//      doImproveope_category_list(rundata, context);
//      // JetspeedLink jsLink = JetspeedLinkFactory.getInstance(rundata);
//      // rundata.setRedirectURI(jsLink.getPortletById(
//      // ALEipUtils.getPortlet(rundata, context).getID()).addQueryData(
//      // "eventSubmit_doImproveope_category_list", "1").toString());
//      // rundata.getResponse().sendRedirect(rundata.getRedirectURI());
//      // jsLink = null;
//    }
//
  }

  /**
   * カテゴリを削除します。（複数） <BR>
   *
   * @param rundata
   * @param context
   * @throws Exception
   */
  public void doImproveope_category_multi_delete(RunData rundata, Context context)
      throws Exception {
//    ImproveopeCategoryMultiDelete delete = new ImproveopeCategoryMultiDelete();
//    delete.doMultiAction(this, rundata, context);
//    doImproveope_category_list(rundata, context);
//    // JetspeedLink jsLink = JetspeedLinkFactory.getInstance(rundata);
//    // rundata.setRedirectURI(jsLink.getPortletById(
//    // ALEipUtils.getPortlet(rundata, context).getID()).addQueryData(
//    // "eventSubmit_doImproveope_category_list", "1").toString());
//    // rundata.getResponse().sendRedirect(rundata.getRedirectURI());
//    // jsLink = null;
  }

  /**
   * カテゴリを一覧表示します。 <BR>
   *
   * @param rundata
   * @param context
   * @throws Exception
   */
  public void doImproveope_category_list(RunData rundata, Context context)
      throws Exception {
//    VelocityPortlet portlet = ALEipUtils.getPortlet(rundata, context);
//    ImproveopeCategorySelectData listData = new ImproveopeCategorySelectData();
//    listData.initField();
//    listData.loadCategoryList(rundata);
//    // PSMLからパラメータをロードする
//    // 最大表示件数（通常時）
//    listData.setRowsNum(Integer.parseInt(portlet
//      .getPortletConfig()
//      .getInitParameter("p1c-rows")));
//
//    listData.doViewList(this, rundata, context);
//    setTemplate(rundata, "improveope-category-list");
//
  }

  /**
   * カテゴリを詳細表示します。 <BR>
   *
   * @param rundata
   * @param context
   * @throws Exception
   */
  public void doImproveope_category_detail(RunData rundata, Context context)
      throws Exception {
//    ImproveopeCategorySelectData detailData = new ImproveopeCategorySelectData();
//    detailData.initField();
//    if (detailData.doViewDetail(this, rundata, context)) {
//      setTemplate(rundata, "improveope-category-detail");
//    } else {
//      doImproveope_category_list(rundata, context);
//    }
//    setTemplate(rundata, "improveope-category-detail");
//
  }

  /**
   * トピックを別のカテゴリに移動する． <BR>
   *
   * @param rundata
   * @param context
   * @throws Exception
   */
  // public void doImproveope_topic_change_category_form(RunData rundata,
  // Context context) throws Exception {
  // // ユーザ情報の詳細画面や編集画面からの遷移時に，
  // // セッションに残る ENTITY_ID を削除する．
  // ALEipUtils.removeTemp(rundata, context, ALEipConstants.ENTITY_ID);
  //
  // ImproveopeTopicChangeCategoryFormData formData = new
  // ImproveopeTopicChangeCategoryFormData();
  // formData.initField();
  // formData.loadCategoryList(rundata, context);
  // if (formData.doViewForm(this, rundata, context)) {
  // setTemplate(rundata, "improveope-topic-change-category");
  // } else {
  // doImproveope_topic_list(rundata, context);
  // }
  // }
  //
  //
  // public void doImproveope_topic_change_category_update(RunData rundata,
  // Context context) throws Exception {
  //
  // ImproveopeTopicChangeCategoryFormData formData = new
  // ImproveopeTopicChangeCategoryFormData();
  // formData.initField();
  // formData.loadCategoryList(rundata, context);
  // if (formData.doUpdate(this, rundata, context)) {
  // setTemplate(rundata, "improveope-topic-change-category");
  // } else {
  // doImproveope_topic_list(rundata, context);
  // }
  // }
  /**
   * 掲示板で使用したセッション情報を消去する．
   *
   */
  public void clearImproveopeSession(RunData rundata, Context context) {
    List<String> list = new ArrayList<String>();
    list.add("entityid");
    list.add("com.aimluck.eip.improveope.ImproveopeTopicSelectDatasort");
    list.add("com.aimluck.eip.improveope.ImproveopeTopicSelectDatasorttype");
    list.add("com.aimluck.eip.improveope.ImproveopeTopicSelectDatafilter");
    list.add("com.aimluck.eip.improveope.ImproveopeTopicSelectDatafiltertype");
    list.add("com.aimluck.eip.improveope.ImproveopeTopicSelectDatasearch");
    ALEipUtils.removeTemp(rundata, context, list);

    // JetspeedRunData jdata = (JetspeedRunData) rundata;
    // VelocityPortlet portlet = ((VelocityPortlet) context.get("portlet"));
    // String portletName = portlet.getName();
    // String peid = portlet.getID();
    //
    // // エンティティIDの初期化
    // jdata.getUser().removeTemp(portletName + peid + "entityid");
    //
    // jdata.getUser().removeTemp(
    // portletName + peid
    // + "com.aimluck.eip.improveope.ImproveopeTopicSelectDatasort");
    // jdata.getUser().removeTemp(
    // portletName + peid
    // + "com.aimluck.eip.improveope.ImproveopeTopicSelectDatasorttype");
    // jdata.getUser().removeTemp(
    // portletName + peid
    // + "com.aimluck.eip.improveope.ImproveopeTopicSelectDatasorttype");
    // jdata.getUser().removeTemp(
    // portletName + peid
    // + "com.aimluck.eip.improveope.ImproveopeTopicSelectDatafilter");
    // jdata.getUser().removeTemp(
    // portletName + peid
    // + "com.aimluck.eip.improveope.ImproveopeTopicSelectDatafiltertype");
    // jdata.getUser().removeTemp(
    // portletName + peid
    // + "com.aimluck.eip.improveope.ImproveopeTopicSelectDatasort");
    // jdata.getUser().removeTemp(
    // portletName + peid
    // + "com.aimluck.eip.improveope.ImproveopeTopicSelectDatasorttype");

  }

  /**
   * トピックに返信します。 <BR>
   *
   * @param rundata
   * @param context
   * @throws Exception
   */
  public void doImproveope_topic_reply(RunData rundata, Context context)
      throws Exception {
    ImproveopeTopicReplyFormData formData = new ImproveopeTopicReplyFormData();
    formData.initField();
    if (formData.doInsert(this, rundata, context)) {
      // データ登録が成功したとき
      doImproveope_topic_detail(rundata, context);
      // JetspeedLink jsLink = JetspeedLinkFactory.getInstance(rundata);
      // rundata.setRedirectURI(jsLink.getPortletById(
      // ALEipUtils.getPortlet(rundata, context).getID()).addQueryData(
      // "eventSubmit_doImproveope_topic_detail", "1").toString());
      // rundata.getResponse().sendRedirect(rundata.getRedirectURI());
      // jsLink = null;
    } else {
      // トピック詳細表示用の情報を再取得
      ImproveopeTopicSelectData detailData = new ImproveopeTopicSelectData();
      detailData.initField();
      if (detailData.doViewDetail(this, rundata, context)) {
        setTemplate(rundata, "improveope-topic-detail");
      } else {
        doImproveope_topic_list(rundata, context);
      }
    }
  }

  /**
   *
   * @param obj
   */
  public void setResultDataOnTopicDetail(Object obj) {
    resultOnTopicDetail = obj;
  }

  /**
   *
   * @param msg
   */
  public void addErrorMessagesOnTopicDetail(List<String> msgs) {
    if (errmsgListOnTopicDetail == null) {
      errmsgListOnTopicDetail = new ArrayList<String>();
    }
    errmsgListOnTopicDetail.addAll(msgs);
  }

  /**
   *
   * @param context
   */
  public void putDataOnTopicDetail(RunData rundata, Context context) {
    context.put(RESULT_ON_TOPIC_DETAIL, resultOnTopicDetail);
    context.put(ERROR_MESSAGE_LIST_ON_TOPIC_DETAIL, errmsgListOnTopicDetail);

    // For security
    context.put(ALEipConstants.SECURE_ID, rundata.getUser().getTemp(
      ALEipConstants.SECURE_ID));
  }


  /**
  *
  * @param obj
  */
 public void setResultDataOnReceiveForm(Object obj) {
	 resultOnReceiveForm = obj;
 }

 /**
  *
  * @param msg
  */
 public void addErrorMessagesOnReceiveForm(List<String> msgs) {
   if (errmsgListOnReceiveForm == null) {
	   errmsgListOnReceiveForm = new ArrayList<String>();
   }
   errmsgListOnReceiveForm.addAll(msgs);
 }

 /**
  *
  * @param context
  */
 public void putDataOnReceiveForm(RunData rundata, Context context) {
   context.put(RESULT_ON_RECEIVE_FORM, resultOnReceiveForm);
   context.put(ERROR_MESSAGE_LIST_ON_RECEIVE_FORM, errmsgListOnReceiveForm);
   context.put(ALEipConstants.SECURE_ID, rundata.getUser().getTemp(
		      ALEipConstants.SECURE_ID));
 }

 /**
 *
 * @param obj
 */
public void setResultDataOnCheckForm(Object obj) {
	 resultOnCheckForm = obj;
}

/**
 *
 * @param msg
 */
public void addErrorMessagesOnCheckForm(List<String> msgs) {
  if (errmsgListOnCheckForm == null) {
	   errmsgListOnCheckForm = new ArrayList<String>();
  }
  errmsgListOnCheckForm.addAll(msgs);
}

/**
 *
 * @param context
 */
public void putDataOnCheckForm(RunData rundata, Context context) {
  context.put(RESULT_ON_CHECK_FORM, resultOnCheckForm);
  context.put(ERROR_MESSAGE_LIST_ON_CHECK_FORM, errmsgListOnCheckForm);
  context.put(ALEipConstants.SECURE_ID, rundata.getUser().getTemp(
	      ALEipConstants.SECURE_ID));
}

/**
*
* @param obj
*/
public void setResultDataOnActionForm(Object obj) {
	 resultOnActionForm = obj;
}

/**
*
* @param msg
*/
public void addErrorMessagesOnActionForm(List<String> msgs) {
 if (errmsgListOnActionForm == null) {
	   errmsgListOnActionForm = new ArrayList<String>();
 }
 errmsgListOnActionForm.addAll(msgs);
}

/**
*
* @param context
*/
public void putDataOnActionForm(RunData rundata, Context context) {
 context.put(RESULT_ON_ACTION_FORM, resultOnActionForm);
 context.put(ERROR_MESSAGE_LIST_ON_ACTION_FORM, errmsgListOnActionForm);
 context.put(ALEipConstants.SECURE_ID, rundata.getUser().getTemp(
	      ALEipConstants.SECURE_ID));
}
/**
*
* @param obj
*/
public void setResultDataOnReportForm(Object obj) {
	 resultOnReportForm = obj;
}

/**
*
* @param msg
*/
public void addErrorMessagesOnReportForm(List<String> msgs) {
 if (errmsgListOnReportForm == null) {
	   errmsgListOnReportForm = new ArrayList<String>();
 }
 errmsgListOnReportForm.addAll(msgs);
}

/**
*
* @param context
*/
public void putDataOnReportForm(RunData rundata, Context context) {
 context.put(RESULT_ON_REPORT_FORM, resultOnReportForm);
 context.put(ERROR_MESSAGE_LIST_ON_REPORT_FORM, errmsgListOnReportForm);
 context.put(ALEipConstants.SECURE_ID, rundata.getUser().getTemp(
	      ALEipConstants.SECURE_ID));
}

}
