/*
 * Copyright(C) 2012 - 2013 orinos Co.,Ltd. All rights reserved.
 * http://www.orinos.co.jp/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.aimluck.eip.improveope.util;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

import javax.imageio.ImageIO;

import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.om.security.UserIdPrincipal;
import org.apache.jetspeed.services.JetspeedSecurity;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.resources.JetspeedResources;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

import com.aimluck.eip.cayenne.om.account.EipTAclUserRoleMap;
import com.aimluck.eip.cayenne.om.portlet.OriTImproveopeApply;
import com.aimluck.eip.cayenne.om.portlet.OriTImproveopeApplyAction;
import com.aimluck.eip.cayenne.om.portlet.OriTImproveopeApplyActionFile;
import com.aimluck.eip.cayenne.om.portlet.OriTImproveopeApplyActionMap;
import com.aimluck.eip.cayenne.om.portlet.OriTImproveopeApplyActionReportFile;
import com.aimluck.eip.cayenne.om.portlet.OriTImproveopeApplyCheck;
import com.aimluck.eip.cayenne.om.portlet.OriTImproveopeApplyFile;
import com.aimluck.eip.cayenne.om.portlet.OriTImproveopeApplyMemberMap;
import com.aimluck.eip.cayenne.om.portlet.OriTImproveopeFile;
import com.aimluck.eip.cayenne.om.portlet.OriTImproveopeTopic;
import com.aimluck.eip.cayenne.om.security.TurbineUser;
import com.aimluck.eip.common.ALActivity;
import com.aimluck.eip.common.ALBaseUser;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALEipConstants;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.fileupload.beans.FileuploadBean;
import com.aimluck.eip.fileupload.beans.FileuploadLiteBean;
import com.aimluck.eip.fileupload.util.FileuploadUtils;
import com.aimluck.eip.mail.util.ALMailUtils;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.services.accessctl.ALAccessControlConstants;
import com.aimluck.eip.services.accessctl.ALAccessControlFactoryService;
import com.aimluck.eip.services.accessctl.ALAccessControlHandler;
import com.aimluck.eip.services.orgutils.ALOrgUtilsService;
import com.aimluck.eip.services.social.ALActivityService;
import com.aimluck.eip.services.social.model.ALActivityPutRequest;
import com.aimluck.eip.services.storage.ALStorageService;
import com.aimluck.eip.util.ALCellularUtils;
import com.aimluck.eip.util.ALCommonUtils;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.whatsnew.util.WhatsNewUtils;
//import com.aimluck.eip.cayenne.om.portlet.EipTMsgboardCategory;
//import com.aimluck.eip.cayenne.om.portlet.EipTMsgboardCategoryMap;
//import com.aimluck.eip.cayenne.om.portlet.EipTMsgboardFile;
//import com.aimluck.eip.cayenne.om.portlet.EipTMsgboardTopic;
//import com.aimluck.eip.cayenne.om.portlet.EipTMsgboardCategory;
//import com.aimluck.eip.cayenne.om.portlet.EipTMsgboardCategoryMap;
//import com.aimluck.eip.cayenne.om.portlet.EipTMsgboardFile;
//import com.aimluck.eip.cayenne.om.portlet.EipTMsgboardTopic;
//import com.aimluck.eip.improveope.ImproveopeCategoryResultData;

/**
 * 業務改善申請のユーティリティクラス <BR>
 *
 */
public class ImproveopeApplyUtils {

  /** logger */
  private static final JetspeedLogger logger = JetspeedLogFactoryService
    .getLogger(ImproveopeUtils.class.getName());

  /** 所有者の識別子 */
  public static final String OWNER_ID = "ownerid";

  /** 業務改善申請の添付ファイルを保管するディレクトリの指定 */
  private static final String FOLDER_FILEDIR_IMPROVEOPE_APPLY = JetspeedResources
    .getString("aipo.filedir", "");

  /** 掲示板の添付ファイルを保管するディレクトリのカテゴリキーの指定 */
  protected static final String CATEGORY_KEY = JetspeedResources.getString(
    "aipo.improveope.categorykey",
    "");

  /** デフォルトエンコーディングを表わすシステムプロパティのキー */
  public static final String FILE_ENCODING = JetspeedResources.getString(
    "content.defaultencoding",
    "UTF-8");

  public static final String MSGBOARD_PORTLET_NAME = "Improveope";

  /** 検索キーワード変数の識別子 */
  public static final String TARGET_KEYWORD = "keyword";
  /** 検索ステータス変数の識別子 */
  public static final String TARGET_STATUS = "target_status";
  /** 検索時期変数の識別子 */
  public static final String TARGET_TIME = "target_time";

  /** パラメータリセットの識別子 */
  private static final String RESET_FLAG = "reset_params";

  /** ステータス （申請） */
  public static final String APPLY_STATUS_APPLY = "A";
  /** ステータス （評価） */
  public static final String APPLY_STATUS_CHECK = "C";
  /** ステータス （採用） */
  public static final String APPLY_STATUS_ADOPT = "D";
  /** ステータス （却下） */
  public static final String APPLY_STATUS_REJECT = "R";

  /** 評価（賛成） */
  public static final String APPLY_ANSWER_GOOD = "1";
  /** 評価（反対） */
  public static final String APPLY_ANSWER_BAD = "2";
  /** 評価（どちらでもない） */
  public static final String APPLY_ANSWER_NEITHER = "9";



  /**
   * 申請オブジェクトモデルを取得します。 <BR>
   *
   * @param rundata
   * @param context
   * @param isJoin
   *          カテゴリテーブルをJOINするかどうか
   * @return
   */
  public static OriTImproveopeApply getOriTImproveopeApply(RunData rundata,
      Context context) throws ALPageNotFoundException,
      ALDBErrorException {
    String applyid =
      ALEipUtils.getTemp(rundata, context, ALEipConstants.ENTITY_ID);
    try {
      if (applyid == null || Integer.valueOf(applyid) == null) {
        // トピック ID が空の場合
        logger.debug("[ImproveopeTopic] Empty ID...");
        throw new ALPageNotFoundException();
      }

      int userid = ALEipUtils.getUserId(rundata);

      SelectQuery<OriTImproveopeApply> query =
        Database.query(OriTImproveopeApply.class);
      Expression exp1 =
        ExpressionFactory.matchDbExp(
        		OriTImproveopeApply.APPLY_ID_PK_COLUMN,
          Integer.valueOf(applyid));
      query.setQualifier(exp1);
      query.distinct(true);

      List<OriTImproveopeApply> applys = query.fetchList();
      if (applys == null || applys.size() == 0) {
        // 指定した トピック ID のレコードが見つからない場合
        logger.debug("[ImproveopeAplly] Not found ID...");
        throw new ALPageNotFoundException();
      }

      OriTImproveopeApply apply = applys.get(0);

      return apply;
    } catch (ALPageNotFoundException pageNotFound) {
      // logger.error("[ImproveopeUtils]", pageNotFound);
      throw pageNotFound;
    } catch (Exception ex) {
      logger.error("[ImproveopeApplyUtils]", ex);
      throw new ALDBErrorException();

    }
  }

  /**
   * 評価オブジェクトモデルを取得します。 <BR>
   *
   * @param rundata
   * @param context
   * @param isJoin
   *          カテゴリテーブルをJOINするかどうか
   * @return
   */
  public static OriTImproveopeApplyCheck getOriTImproveopeApplyCheck(RunData rundata,
      Context context) throws ALPageNotFoundException,
      ALDBErrorException {
    String applyid =
      ALEipUtils.getTemp(rundata, context, ALEipConstants.ENTITY_ID);
    try {
      if (applyid == null || Integer.valueOf(applyid) == null) {
        // トピック ID が空の場合
        logger.debug("[ImproveopeTopic] Empty ID...");
        throw new ALPageNotFoundException();
      }

      SelectQuery<OriTImproveopeApplyCheck> query =
        Database.query(OriTImproveopeApplyCheck.class);
      Expression exp1 =
        ExpressionFactory.matchDbExp(OriTImproveopeApplyCheck.ORI_TIMPROVEOPE_APPLY_PROPERTY
                + "."
                + OriTImproveopeApply.APPLY_ID_PK_COLUMN,
          Integer.valueOf(applyid));
      query.setQualifier(exp1);

      Expression exp2 =
              ExpressionFactory.matchExp(
            		  OriTImproveopeApplyCheck.USER_ID_PROPERTY,
                Integer.valueOf(ALEipUtils.getUserId(rundata)));
      query.andQualifier(exp2);

      query.distinct(true);

      List<OriTImproveopeApplyCheck> applys = query.fetchList();
      if (applys == null || applys.size() == 0) {
    	return null;
//        // 指定した トピック ID のレコードが見つからない場合
//        logger.debug("[ImproveopeApllyCheck] Not found ID...");
//        throw new ALPageNotFoundException();
      }

      OriTImproveopeApplyCheck apply = applys.get(0);

      return apply;
    } catch (ALPageNotFoundException pageNotFound) {
      // logger.error("[ImproveopeUtils]", pageNotFound);
      throw pageNotFound;
    } catch (Exception ex) {
      logger.error("[ImproveopeApplyUtils]", ex);
      throw new ALDBErrorException();

    }
  }

  /**
   * 実施要項オブジェクトモデルを取得します。 <BR>
   *
   * @param rundata
   * @param context
   * @param isJoin
   *          カテゴリテーブルをJOINするかどうか
   * @return
   */
  public static OriTImproveopeApplyAction getOriTImproveopeApplyAction(RunData rundata,
      Context context) throws ALPageNotFoundException,
      ALDBErrorException {
    String applyid =
      ALEipUtils.getTemp(rundata, context, ALEipConstants.ENTITY_ID);
    try {
      if (applyid == null || Integer.valueOf(applyid) == null) {
        // トピック ID が空の場合
        logger.debug("[ImproveopeTopic] Empty ID...");
        throw new ALPageNotFoundException();
      }

      SelectQuery<OriTImproveopeApplyAction> query =
        Database.query(OriTImproveopeApplyAction.class);
      Expression exp1 =
        ExpressionFactory.matchDbExp(OriTImproveopeApplyAction.ORI_TIMPROVEOPE_APPLY_PROPERTY
                + "."
                + OriTImproveopeApply.APPLY_ID_PK_COLUMN,
          Integer.valueOf(applyid));
      query.setQualifier(exp1);

      query.distinct(true);

      List<OriTImproveopeApplyAction> applys = query.fetchList();
      if (applys == null || applys.size() == 0) {
    	return null;
//        // 指定した トピック ID のレコードが見つからない場合
//        logger.debug("[ImproveopeApllyCheck] Not found ID...");
//        throw new ALPageNotFoundException();
      }

      OriTImproveopeApplyAction apply = applys.get(0);

      return apply;
    } catch (ALPageNotFoundException pageNotFound) {
      // logger.error("[ImproveopeUtils]", pageNotFound);
      throw pageNotFound;
    } catch (Exception ex) {
      logger.error("[ImproveopeApplyUtils]", ex);
      throw new ALDBErrorException();

    }
  }

  /**
   * 実施要項オブジェクトモデルを取得します。 <BR>
   *
   * @param rundata
   * @param context
   * @param isJoin
   *          カテゴリテーブルをJOINするかどうか
   * @return
   */
  public static OriTImproveopeApplyAction getOriTImproveopeApplyAction(int applyid) throws ALPageNotFoundException,
      ALDBErrorException {
    try {
      if (Integer.valueOf(applyid) == null) {
        // トピック ID が空の場合
        logger.debug("[ImproveopeTopic] Empty ID...");
        throw new ALPageNotFoundException();
      }

      SelectQuery<OriTImproveopeApplyAction> query =
        Database.query(OriTImproveopeApplyAction.class);
      Expression exp1 =
        ExpressionFactory.matchDbExp(OriTImproveopeApplyAction.ORI_TIMPROVEOPE_APPLY_PROPERTY
                + "."
                + OriTImproveopeApply.APPLY_ID_PK_COLUMN,
          Integer.valueOf(applyid));
      query.setQualifier(exp1);

      query.distinct(true);

      List<OriTImproveopeApplyAction> applys = query.fetchList();
      if (applys == null || applys.size() == 0) {
    	return null;
//        // 指定した トピック ID のレコードが見つからない場合
//        logger.debug("[ImproveopeApllyCheck] Not found ID...");
//        throw new ALPageNotFoundException();
      }

      OriTImproveopeApplyAction apply = applys.get(0);

      return apply;
    } catch (ALPageNotFoundException pageNotFound) {
      // logger.error("[ImproveopeUtils]", pageNotFound);
      throw pageNotFound;
    } catch (Exception ex) {
      logger.error("[ImproveopeApplyUtils]", ex);
      throw new ALDBErrorException();

    }
  }
  /**
   * 返信記事オブジェクトモデルを取得します。 <BR>
   *
   * @param rundata
   * @param context
   * @param isSuperUser
   *          カテゴリテーブルをJOINするかどうか
   * @return
   */
  public static OriTImproveopeTopic getOriTImproveopeTopicReply(RunData rundata,
      Context context, String topicid, boolean isSuperUser)
      throws ALPageNotFoundException, ALDBErrorException {
    try {
      if (topicid == null || Integer.valueOf(topicid) == null) {
        // トピック ID が空の場合
        logger.debug("[ImproveopeTopic] Empty ID...");
        throw new ALPageNotFoundException();
      }

      SelectQuery<OriTImproveopeTopic> query =
        Database.query(OriTImproveopeTopic.class);
      Expression exp1 =
        ExpressionFactory.matchDbExp(
        		OriTImproveopeTopic.TOPIC_ID_PK_COLUMN,
          Integer.valueOf(topicid));
      query.setQualifier(exp1);

      if (!isSuperUser) {
        Expression exp2 =
          ExpressionFactory.matchExp(
        		  OriTImproveopeTopic.OWNER_ID_PROPERTY,
            Integer.valueOf(ALEipUtils.getUserId(rundata)));
        query.andQualifier(exp2);
      }

      List<OriTImproveopeTopic> topics = query.fetchList();
      if (topics == null || topics.size() == 0) {
        // 指定した トピック ID のレコードが見つからない場合
        logger.debug("[ImproveopeTopic] Not found ID...");
        throw new ALPageNotFoundException();
      }
      return topics.get(0);
    } catch (Exception ex) {
      logger.error("[ImproveopeUtils]", ex);
      throw new ALDBErrorException();

    }
  }

  /**
   * ファイルオブジェクトモデルを取得します。 <BR>
   *
   * @param rundata
   * @param context
   * @return
   */
  public static OriTImproveopeApplyFile getOriTImproveopeApplyFile(RunData rundata)
      throws ALPageNotFoundException, ALDBErrorException {
    try {
      int attachmentIndex =
        rundata.getParameters().getInt("attachmentIndex", -1);
      if (attachmentIndex < 0) {
        // ID が空の場合
        logger.debug("[ImproveopeApplyUtils] Empty ID...");
        throw new ALPageNotFoundException();

      }

      SelectQuery<OriTImproveopeApplyFile> query =
        Database.query(OriTImproveopeApplyFile.class);
      Expression exp =
        ExpressionFactory.matchDbExp(
        		OriTImproveopeApplyFile.FILE_ID_PK_COLUMN,
          Integer.valueOf(attachmentIndex));
      query.andQualifier(exp);

      List<OriTImproveopeApplyFile> files = query.fetchList();
      if (files == null || files.size() == 0) {
        // 指定した ID のレコードが見つからない場合
        logger.debug("[ImproveopeApplyUtils] Not found ID...");
        throw new ALPageNotFoundException();
      }
      return files.get(0);
    } catch (Exception ex) {
      logger.error("[ImproveopeApplyUtils]", ex);
      throw new ALDBErrorException();
    }
  }

  /**
   * ファイルオブジェクトモデルを取得します。 <BR>
   *
   * @param rundata
   * @param context
   * @return
   */
  public static OriTImproveopeApplyActionFile getOriTImproveopeApplyActionFile(RunData rundata)
      throws ALPageNotFoundException, ALDBErrorException {
    try {
      int attachmentIndex =
        rundata.getParameters().getInt("attachmentIndex", -1);
      if (attachmentIndex < 0) {
        // ID が空の場合
        logger.debug("[ImproveopeApplyUtils] Empty ID...");
        throw new ALPageNotFoundException();

      }

      SelectQuery<OriTImproveopeApplyActionFile> query =
        Database.query(OriTImproveopeApplyActionFile.class);
      Expression exp =
        ExpressionFactory.matchDbExp(
        		OriTImproveopeApplyActionFile.FILE_ID_PK_COLUMN,
          Integer.valueOf(attachmentIndex));
      query.andQualifier(exp);

      List<OriTImproveopeApplyActionFile> files = query.fetchList();
      if (files == null || files.size() == 0) {
        // 指定した ID のレコードが見つからない場合
        logger.debug("[ImproveopeApplyUtils] Not found ID...");
        throw new ALPageNotFoundException();
      }
      return files.get(0);
    } catch (Exception ex) {
      logger.error("[ImproveopeApplyUtils]", ex);
      throw new ALDBErrorException();
    }
  }

  /**
   * ファイルオブジェクトモデルを取得します。 <BR>
   *
   * @param rundata
   * @param context
   * @return
   */
  public static OriTImproveopeApplyActionReportFile getOriTImproveopeApplyReportFile(RunData rundata)
      throws ALPageNotFoundException, ALDBErrorException {
    try {
      int attachmentIndex =
        rundata.getParameters().getInt("attachmentIndex", -1);
      if (attachmentIndex < 0) {
        // ID が空の場合
        logger.debug("[ImproveopeApplyUtils] Empty ID...");
        throw new ALPageNotFoundException();

      }

      SelectQuery<OriTImproveopeApplyActionReportFile> query =
        Database.query(OriTImproveopeApplyActionReportFile.class);
      Expression exp =
        ExpressionFactory.matchDbExp(
        		OriTImproveopeApplyActionReportFile.FILE_ID_PK_COLUMN,
          Integer.valueOf(attachmentIndex));
      query.andQualifier(exp);

      List<OriTImproveopeApplyActionReportFile> files = query.fetchList();
      if (files == null || files.size() == 0) {
        // 指定した ID のレコードが見つからない場合
        logger.debug("[ImproveopeApplyUtils] Not found ID...");
        throw new ALPageNotFoundException();
      }
      return files.get(0);
    } catch (Exception ex) {
      logger.error("[ImproveopeApplyUtils]", ex);
      throw new ALDBErrorException();
    }
  }

  /**
   * トピックオブジェクトモデルを取得します。 <BR>
   *
   * @param rundata
   * @param context
   * @param isJoin
   *          カテゴリテーブルをJOINするかどうか
   * @return
   */
  public static List<OriTImproveopeTopic> getEipTMsgboardTopicList(
      RunData rundata, Context context, boolean isJoin)
      throws ALPageNotFoundException, ALDBErrorException {
    String topicid =
      ALEipUtils.getTemp(rundata, context, ALEipConstants.ENTITY_ID);
    try {
      if (topicid == null || Integer.valueOf(topicid) == null) {
        // トピック ID が空の場合
        logger.debug("[ImproveopeTopic] Empty ID...");
        throw new ALPageNotFoundException();
      }

      SelectQuery<OriTImproveopeTopic> query =
        Database.query(OriTImproveopeTopic.class);
      Expression exp001 =
        ExpressionFactory.matchExp(
        		OriTImproveopeTopic.PARENT_ID_PROPERTY,
          Integer.valueOf(topicid));

      // アクセス制御
      Expression exp01 =
        ExpressionFactory.matchDbExp(
        		OriTImproveopeTopic.TOPIC_ID_PK_COLUMN,
          Integer.valueOf(topicid));
//      Expression exp11 =
//        ExpressionFactory.matchExp(
//        		OriTImproveopeTopic.EIP_TMSGBOARD_CATEGORY_PROPERTY
//            + "."
//            + OriTImproveopeTopic.PUBLIC_FLAG_PROPERTY,
//          "T");
//      Expression exp21 =
//        ExpressionFactory.matchExp(
//          EipTMsgboardTopic.EIP_TMSGBOARD_CATEGORY_PROPERTY
//            + "."
//            + EipTMsgboardCategory.PUBLIC_FLAG_PROPERTY,
//          "F");
//      Expression exp22 =
//        ExpressionFactory.matchExp(
//          EipTMsgboardTopic.EIP_TMSGBOARD_CATEGORY_PROPERTY
//            + "."
//            + EipTMsgboardCategory.EIP_TMSGBOARD_CATEGORY_MAPS_PROPERTY
//            + "."
//            + EipTMsgboardCategoryMap.USER_ID_PROPERTY,
//          Integer.valueOf(ALEipUtils.getUserId(rundata)));
//      query.setQualifier((exp01.andExp(exp11.orExp(exp21.andExp(exp22))))
//        .orExp(exp001));
      query.distinct(true);

      List<OriTImproveopeTopic> topics = query.fetchList();
      if (topics == null || topics.size() == 0) {
        // 指定した トピック ID のレコードが見つからない場合
        logger.debug("[ImproveopeTopic] Not found ID...");
        throw new ALPageNotFoundException();
      }
      return topics;
    } catch (Exception ex) {
      logger.error("[ImproveopeUtils]", ex);
      throw new ALDBErrorException();

    }
  }

  /**
   * 申請オブジェクトモデルを取得します。 <BR>
   *
   * @param rundata
   * @param context
   * @param isSuperUser
   *          カテゴリテーブルをJOINするかどうか
   * @return
   */
  public static List<OriTImproveopeApply> getOriTImproveopeApplyListToDeleteApply(
      RunData rundata, Context context)
      throws ALPageNotFoundException, ALDBErrorException {
    String topicid =
      ALEipUtils.getTemp(rundata, context, ALEipConstants.ENTITY_ID);
    try {
      if (topicid == null || Integer.valueOf(topicid) == null) {
        // トピック ID が空の場合
        logger.debug("[ImproveopeApply] Empty ID...");
        throw new ALPageNotFoundException();
      }

      int userid = ALEipUtils.getUserId(rundata);

      SelectQuery<OriTImproveopeApply> query =
        Database.query(OriTImproveopeApply.class);

      Expression exp01 =
        ExpressionFactory.matchExp(OriTImproveopeApply.OWNER_ID_PROPERTY, Integer
          .valueOf(userid));
      Expression exp02 =
        ExpressionFactory.matchDbExp(
        		OriTImproveopeApply.APPLY_ID_PK_COLUMN,
          Integer.valueOf(topicid));

      query.andQualifier((exp01.andExp(exp02)));

      List<OriTImproveopeApply> topics = query.fetchList();
      if (topics == null || topics.size() == 0) {
        // 指定した トピック ID のレコードが見つからない場合
        logger.debug("[ImproveopeApply] Not found ID...");
        throw new ALPageNotFoundException();
      }

      boolean isdelete = false;
      int size = topics.size();
      for (int i = 0; i < size; i++) {
    	  OriTImproveopeApply topic = topics.get(i);
        if (topic.getOwnerId().intValue() == userid) {
          isdelete = true;
          break;
        }
      }
      if (!isdelete) {
        // 指定した トピック ID のレコードが見つからない場合
        logger.debug("[ImproveopeApply] Not found ID...");
        throw new ALPageNotFoundException();
      }

      return topics;
    } catch (Exception ex) {
      logger.error("[ImproveopeUtils]", ex);
      throw new ALDBErrorException();

    }
  }

  /**
   * 実施要項オブジェクトモデルを取得します。 <BR>
   *
   * @param rundata
   * @param context
   * @param isSuperUser
   *          カテゴリテーブルをJOINするかどうか
   * @return
   */
  public static List<OriTImproveopeApplyAction> getOriTImproveopeApplyActionListToDeleteApply(
      RunData rundata, Context context)
      throws ALPageNotFoundException, ALDBErrorException {
    String applyid =
      ALEipUtils.getTemp(rundata, context, ALEipConstants.ENTITY_ID);
    try {
      if (applyid == null || Integer.valueOf(applyid) == null) {
        // トピック ID が空の場合
        logger.debug("[ImproveopeApplyAction] Empty ID...");
        throw new ALPageNotFoundException();
      }

      int userid = ALEipUtils.getUserId(rundata);

      SelectQuery<OriTImproveopeApplyAction> query =
        Database.query(OriTImproveopeApplyAction.class);

      Expression exp02 =
        ExpressionFactory.matchDbExp(
        		OriTImproveopeApplyAction.ORI_TIMPROVEOPE_APPLY_PROPERTY
        		+ "."
        		+ OriTImproveopeApply.APPLY_ID_PK_COLUMN,
          Integer.valueOf(applyid));

      query.andQualifier(exp02);

      List<OriTImproveopeApplyAction> topics = query.fetchList();
      if (topics == null || topics.size() == 0) {
        // 指定した トピック ID のレコードが見つからない場合
        logger.debug("[ImproveopeApplyAction] Not found ID...");
        throw new ALPageNotFoundException();
      }

      boolean isdelete = false;
      int size = topics.size();
      for (int i = 0; i < size; i++) {
    	  OriTImproveopeApplyAction topic = topics.get(i);
      }
      if (!isdelete) {
        // 指定した トピック ID のレコードが見つからない場合
        logger.debug("[ImproveopeApply] Not found ID...");
        throw new ALPageNotFoundException();
      }

      return topics;
    } catch (Exception ex) {
      logger.error("[ImproveopeUtils]", ex);
      throw new ALDBErrorException();

    }
  }

  /**
   * 添付ファイルを取得します。
   *
   * @param uid
   * @return
   */
  public static ArrayList<FileuploadLiteBean> getFileuploadList(RunData rundata) {
    String[] fileids =
      rundata
        .getParameters()
        .getStrings(FileuploadUtils.KEY_FILEUPLOAD_ID_LIST);
    if (fileids == null) {
      return null;
    }

    ArrayList<String> hadfileids = new ArrayList<String>();
    ArrayList<String> newfileids = new ArrayList<String>();

    for (int j = 0; j < fileids.length; j++) {
      if (fileids[j].trim().startsWith("s")) {
        hadfileids.add(fileids[j].trim().substring(1));
      } else {
        newfileids.add(fileids[j].trim());
      }
    }

    ArrayList<FileuploadLiteBean> fileNameList =
      new ArrayList<FileuploadLiteBean>();
    FileuploadLiteBean filebean = null;

    // 新規にアップロードされたファイルの処理
    if (newfileids.size() > 0) {
      String folderName =
        rundata.getParameters().getString(
          FileuploadUtils.KEY_FILEUPLOAD_FODLER_NAME);
      if (folderName == null || folderName.equals("")) {
        return null;
      }

      for (String newfileid : newfileids) {
        if ("".equals(newfileid)) {
          continue;
        }
        int fileid = 0;
        try {
          fileid = Integer.parseInt(newfileid);
        } catch (Exception e) {
          continue;
        }

        if (fileid == 0) {
          filebean = new FileuploadLiteBean();
          filebean.initField();
          filebean.setFolderName("photo");
          filebean.setFileName("以前の写真ファイル");
          fileNameList.add(filebean);
        } else {
          BufferedReader reader = null;
          try {
            reader =
              new BufferedReader(new InputStreamReader(ALStorageService
                .getFile(
                  FileuploadUtils.FOLDER_TMP_FOR_ATTACHMENT_FILES,
                  ALEipUtils.getUserId(rundata)
                    + ALStorageService.separator()
                    + folderName,
                  fileid + FileuploadUtils.EXT_FILENAME), FILE_ENCODING));
            String line = reader.readLine();
            if (line == null || line.length() <= 0) {
              continue;
            }
            filebean = new FileuploadLiteBean();
            filebean.initField();
            filebean.setFolderName(newfileid);
            filebean.setFileId(fileid);
            filebean.setFileName(line);
            fileNameList.add(filebean);
          } catch (Exception e) {
            logger.error("Exception", e);
          } finally {
            try {
              reader.close();
            } catch (Exception e) {
              logger.error("Exception", e);
            }
          }
        }
      }
    }

    // すでにあるファイルの処理
    if (hadfileids.size() > 0) {
      ArrayList<Integer> hadfileidsValue = new ArrayList<Integer>();
      for (String hadfileid : hadfileids) {
        int fileid = 0;
        try {
          fileid = Integer.parseInt(hadfileid);
          hadfileidsValue.add(fileid);
        } catch (Exception e) {
          continue;
        }
      }

      try {
        SelectQuery<OriTImproveopeApplyFile> reqquery =
          Database.query(OriTImproveopeApplyFile.class);
        Expression reqexp1 =
          ExpressionFactory.inDbExp(
        		  OriTImproveopeApplyFile.FILE_ID_PK_COLUMN,
            hadfileidsValue);
        reqquery.setQualifier(reqexp1);
        List<OriTImproveopeApplyFile> requests = reqquery.fetchList();
        for (OriTImproveopeApplyFile file : requests) {
          filebean = new FileuploadBean();
          filebean.initField();
          filebean.setFileId(file.getFileId());
          filebean.setFileName(file.getFileName());
          filebean.setFlagNewFile(false);
          fileNameList.add(filebean);
        }
      } catch (Exception ex) {
        logger.error("[BlogUtils] Exception.", ex);
      }
    }
    return fileNameList;
  }

  /**
   * 添付ファイル(実施要項)を取得します。
   *
   * @param uid
   * @return
   */
  public static ArrayList<FileuploadLiteBean> getActionFileuploadList(RunData rundata) {
    String[] fileids =
      rundata
        .getParameters()
        .getStrings(FileuploadUtils.KEY_FILEUPLOAD_ID_LIST);
    if (fileids == null) {
      return null;
    }

    ArrayList<String> hadfileids = new ArrayList<String>();
    ArrayList<String> newfileids = new ArrayList<String>();

    for (int j = 0; j < fileids.length; j++) {
      if (fileids[j].trim().startsWith("s")) {
        hadfileids.add(fileids[j].trim().substring(1));
      } else {
        newfileids.add(fileids[j].trim());
      }
    }

    ArrayList<FileuploadLiteBean> fileNameList =
      new ArrayList<FileuploadLiteBean>();
    FileuploadLiteBean filebean = null;

    // 新規にアップロードされたファイルの処理
    if (newfileids.size() > 0) {
      String folderName =
        rundata.getParameters().getString(
          FileuploadUtils.KEY_FILEUPLOAD_FODLER_NAME);
      if (folderName == null || folderName.equals("")) {
        return null;
      }

      for (String newfileid : newfileids) {
        if ("".equals(newfileid)) {
          continue;
        }
        int fileid = 0;
        try {
          fileid = Integer.parseInt(newfileid);
        } catch (Exception e) {
          continue;
        }

        if (fileid == 0) {
          filebean = new FileuploadLiteBean();
          filebean.initField();
          filebean.setFolderName("photo");
          filebean.setFileName("以前の写真ファイル");
          fileNameList.add(filebean);
        } else {
          BufferedReader reader = null;
          try {
            reader =
              new BufferedReader(new InputStreamReader(ALStorageService
                .getFile(
                  FileuploadUtils.FOLDER_TMP_FOR_ATTACHMENT_FILES,
                  ALEipUtils.getUserId(rundata)
                    + ALStorageService.separator()
                    + folderName,
                  fileid + FileuploadUtils.EXT_FILENAME), FILE_ENCODING));
            String line = reader.readLine();
            if (line == null || line.length() <= 0) {
              continue;
            }
            filebean = new FileuploadLiteBean();
            filebean.initField();
            filebean.setFolderName(newfileid);
            filebean.setFileId(fileid);
            filebean.setFileName(line);
            fileNameList.add(filebean);
          } catch (Exception e) {
            logger.error("Exception", e);
          } finally {
            try {
              reader.close();
            } catch (Exception e) {
              logger.error("Exception", e);
            }
          }
        }
      }
    }

    // すでにあるファイルの処理
    if (hadfileids.size() > 0) {
      ArrayList<Integer> hadfileidsValue = new ArrayList<Integer>();
      for (String hadfileid : hadfileids) {
        int fileid = 0;
        try {
          fileid = Integer.parseInt(hadfileid);
          hadfileidsValue.add(fileid);
        } catch (Exception e) {
          continue;
        }
      }

      try {
        SelectQuery<OriTImproveopeApplyActionFile> reqquery =
          Database.query(OriTImproveopeApplyActionFile.class);
        Expression reqexp1 =
          ExpressionFactory.inDbExp(
        		  OriTImproveopeApplyActionFile.FILE_ID_PK_COLUMN,
            hadfileidsValue);
        reqquery.setQualifier(reqexp1);
        List<OriTImproveopeApplyActionFile> requests = reqquery.fetchList();
        for (OriTImproveopeApplyActionFile file : requests) {
          filebean = new FileuploadBean();
          filebean.initField();
          filebean.setFileId(file.getFileId());
          filebean.setFileName(file.getFileName());
          filebean.setFlagNewFile(false);
          fileNameList.add(filebean);
        }
      } catch (Exception ex) {
        logger.error("[BlogUtils] Exception.", ex);
      }
    }
    return fileNameList;
  }
  /**
   * ファイルを登録
   * @param rundata
   * @param context
   * @param apply
   * @param fileuploadList
   * @param folderName
   * @param msgList
   * @return
   */
  public static boolean insertFileDataDelegate(RunData rundata,
      Context context, OriTImproveopeApply apply,
      List<FileuploadLiteBean> fileuploadList, String folderName,
      List<String> msgList) {
    if (fileuploadList == null || fileuploadList.size() <= 0) {
      fileuploadList = new ArrayList<FileuploadLiteBean>();
    }

    int uid = ALEipUtils.getUserId(rundata);
    String orgId = Database.getDomainName();

    List<Integer> hadfileids = new ArrayList<Integer>();
    for (FileuploadLiteBean file : fileuploadList) {
      if (!file.isNewFile()) {
        hadfileids.add(file.getFileId());
      }
    }

    SelectQuery<OriTImproveopeApplyFile> dbquery =
      Database.query(OriTImproveopeApplyFile.class);
    dbquery.andQualifier(ExpressionFactory.matchDbExp(
    		OriTImproveopeApplyFile.ORI_TIMPROVEOPE_APPLY_PROPERTY,
    		apply.getApplyId()));
    List<OriTImproveopeApplyFile> existsFiles = dbquery.fetchList();
    List<OriTImproveopeApplyFile> delFiles = new ArrayList<OriTImproveopeApplyFile>();
    for (OriTImproveopeApplyFile file : existsFiles) {
      if (!hadfileids.contains(file.getFileId())) {
        delFiles.add(file);
      }
    }

    // ローカルファイルに保存されているファイルを削除する．
    if (delFiles.size() > 0) {
      int delsize = delFiles.size();
      for (int i = 0; i < delsize; i++) {
        ALStorageService.deleteFile(ImproveopeApplyUtils.getSaveDirPath(orgId, uid)
          + (delFiles.get(i)).getFilePath());
      }
      // データベースから添付ファイルのデータ削除
      Database.deleteAll(delFiles);
    }

    // ファイル追加処理
    try {
      for (FileuploadLiteBean filebean : fileuploadList) {
        if (!filebean.isNewFile()) {
          continue;
        }

        // サムネイル処理
        String[] acceptExts = ImageIO.getWriterFormatNames();
        byte[] fileThumbnail =
          FileuploadUtils.getBytesShrinkFilebean(
            orgId,
            folderName,
            uid,
            filebean,
            acceptExts,
            FileuploadUtils.DEF_THUMBNAIL_WIDTH,
            FileuploadUtils.DEF_THUMBNAIL_HEIGHT,
            msgList);

        String filename = "0_" + String.valueOf(System.nanoTime());

        // 新規オブジェクトモデル
        OriTImproveopeApplyFile file = Database.create(OriTImproveopeApplyFile.class);
        // 所有者
        file.setOwnerId(Integer.valueOf(uid));
        // 申請ID
        file.setOriTImproveopeApply(apply);
        // ファイル名
        file.setFileName(filebean.getFileName());
        // ファイルパス
        file.setFilePath(ImproveopeUtils.getRelativePath(filename));
        // サムネイル画像
        if (fileThumbnail != null) {
          file.setFileThumbnail(fileThumbnail);
        }
        // 作成日
        file.setCreateDate(Calendar.getInstance().getTime());
        // 更新日
        file.setUpdateDate(Calendar.getInstance().getTime());

        // ファイルの移動
        ALStorageService.copyTmpFile(uid, folderName, String.valueOf(filebean
          .getFileId()), FOLDER_FILEDIR_IMPROVEOPE_APPLY, CATEGORY_KEY
          + ALStorageService.separator()
          + uid, filename);
      }

      // 添付ファイル保存先のフォルダを削除
      ALStorageService.deleteTmpFolder(uid, folderName);
    } catch (Exception e) {
      Database.rollback();
      logger.error("Exception", e);
      return false;
    }
    return true;
  }

  /**
   * 実施ファイルを登録
   * @param rundata
   * @param context
   * @param apply
   * @param fileuploadList
   * @param folderName
   * @param msgList
   * @return
   */
  public static boolean insertFileDataDelegateAction(RunData rundata,
      Context context, OriTImproveopeApplyAction action,
      List<FileuploadLiteBean> fileuploadList, String folderName,
      List<String> msgList) {
    if (fileuploadList == null || fileuploadList.size() <= 0) {
      fileuploadList = new ArrayList<FileuploadLiteBean>();
    }

    int uid = ALEipUtils.getUserId(rundata);
    String orgId = Database.getDomainName();

    List<Integer> hadfileids = new ArrayList<Integer>();
    for (FileuploadLiteBean file : fileuploadList) {
      if (!file.isNewFile()) {
        hadfileids.add(file.getFileId());
      }
    }

    SelectQuery<OriTImproveopeApplyActionFile> dbquery =
      Database.query(OriTImproveopeApplyActionFile.class);
    dbquery.andQualifier(ExpressionFactory.matchDbExp(
    		OriTImproveopeApplyActionFile.ORI_TIMPROVEOPE_APPLY_ACTION_PROPERTY,
    		action.getActionId()));
    List<OriTImproveopeApplyActionFile> existsFiles = dbquery.fetchList();
    List<OriTImproveopeApplyActionFile> delFiles = new ArrayList<OriTImproveopeApplyActionFile>();
    for (OriTImproveopeApplyActionFile file : existsFiles) {
      if (!hadfileids.contains(file.getFileId())) {
        delFiles.add(file);
      }
    }

    // ローカルファイルに保存されているファイルを削除する．
    if (delFiles.size() > 0) {
      int delsize = delFiles.size();
      for (int i = 0; i < delsize; i++) {
        ALStorageService.deleteFile(ImproveopeApplyUtils.getSaveDirPath(orgId, uid)
          + (delFiles.get(i)).getFilePath());
      }
      // データベースから添付ファイルのデータ削除
      Database.deleteAll(delFiles);
    }

    // ファイル追加処理
    try {
      for (FileuploadLiteBean filebean : fileuploadList) {
        if (!filebean.isNewFile()) {
          continue;
        }

        // サムネイル処理
        String[] acceptExts = ImageIO.getWriterFormatNames();
        byte[] fileThumbnail =
          FileuploadUtils.getBytesShrinkFilebean(
            orgId,
            folderName,
            uid,
            filebean,
            acceptExts,
            FileuploadUtils.DEF_THUMBNAIL_WIDTH,
            FileuploadUtils.DEF_THUMBNAIL_HEIGHT,
            msgList);

        String filename = "0_" + String.valueOf(System.nanoTime());

        // 新規オブジェクトモデル
        OriTImproveopeApplyActionFile file = Database.create(OriTImproveopeApplyActionFile.class);
        // 所有者
        file.setOwnerId(Integer.valueOf(uid));
        // 申請ID
        file.setOriTImproveopeApplyAction(action);
        // ファイル名
        file.setFileName(filebean.getFileName());
        // ファイルパス
        file.setFilePath(ImproveopeUtils.getRelativePath(filename));
        // サムネイル画像
        if (fileThumbnail != null) {
          file.setFileThumbnail(fileThumbnail);
        }
        // 作成日
        file.setCreateDate(Calendar.getInstance().getTime());
        // 更新日
        file.setUpdateDate(Calendar.getInstance().getTime());

        // ファイルの移動
        ALStorageService.copyTmpFile(uid, folderName, String.valueOf(filebean
          .getFileId()), FOLDER_FILEDIR_IMPROVEOPE_APPLY, CATEGORY_KEY
          + ALStorageService.separator()
          + uid, filename);
      }

      // 添付ファイル保存先のフォルダを削除
      ALStorageService.deleteTmpFolder(uid, folderName);
    } catch (Exception e) {
      Database.rollback();
      logger.error("Exception", e);
      return false;
    }
    return true;
  }
  /**
   * 報告ファイルを登録
   * @param rundata
   * @param context
   * @param apply
   * @param fileuploadList
   * @param folderName
   * @param msgList
   * @return
   */
  public static boolean insertFileDataDelegateReport(RunData rundata,
      Context context, OriTImproveopeApplyAction action,
      List<FileuploadLiteBean> fileuploadList, String folderName,
      List<String> msgList) {
    if (fileuploadList == null || fileuploadList.size() <= 0) {
      fileuploadList = new ArrayList<FileuploadLiteBean>();
    }

    int uid = ALEipUtils.getUserId(rundata);
    String orgId = Database.getDomainName();

    List<Integer> hadfileids = new ArrayList<Integer>();
    for (FileuploadLiteBean file : fileuploadList) {
      if (!file.isNewFile()) {
        hadfileids.add(file.getFileId());
      }
    }

    SelectQuery<OriTImproveopeApplyActionReportFile> dbquery =
      Database.query(OriTImproveopeApplyActionReportFile.class);
    dbquery.andQualifier(ExpressionFactory.matchDbExp(
    		OriTImproveopeApplyActionReportFile.ORI_TIMPROVEOPE_APPLY_ACTION_PROPERTY,
    		action.getActionId()));
    List<OriTImproveopeApplyActionReportFile> existsFiles = dbquery.fetchList();
    List<OriTImproveopeApplyActionReportFile> delFiles = new ArrayList<OriTImproveopeApplyActionReportFile>();
    for (OriTImproveopeApplyActionReportFile file : existsFiles) {
      if (!hadfileids.contains(file.getFileId())) {
        delFiles.add(file);
      }
    }

    // ローカルファイルに保存されているファイルを削除する．
    if (delFiles.size() > 0) {
      int delsize = delFiles.size();
      for (int i = 0; i < delsize; i++) {
        ALStorageService.deleteFile(ImproveopeApplyUtils.getSaveDirPath(orgId, uid)
          + (delFiles.get(i)).getFilePath());
      }
      // データベースから添付ファイルのデータ削除
      Database.deleteAll(delFiles);
    }

    // ファイル追加処理
    try {
      for (FileuploadLiteBean filebean : fileuploadList) {
        if (!filebean.isNewFile()) {
          continue;
        }

        // サムネイル処理
        String[] acceptExts = ImageIO.getWriterFormatNames();
        byte[] fileThumbnail =
          FileuploadUtils.getBytesShrinkFilebean(
            orgId,
            folderName,
            uid,
            filebean,
            acceptExts,
            FileuploadUtils.DEF_THUMBNAIL_WIDTH,
            FileuploadUtils.DEF_THUMBNAIL_HEIGHT,
            msgList);

        String filename = "0_" + String.valueOf(System.nanoTime());

        // 新規オブジェクトモデル
        OriTImproveopeApplyActionReportFile file = Database.create(OriTImproveopeApplyActionReportFile.class);
        // 所有者
        file.setOwnerId(Integer.valueOf(uid));
        // 申請ID
        file.setOriTImproveopeApplyAction(action);
        // ファイル名
        file.setFileName(filebean.getFileName());
        // ファイルパス
        file.setFilePath(ImproveopeUtils.getRelativePath(filename));
        // サムネイル画像
        if (fileThumbnail != null) {
          file.setFileThumbnail(fileThumbnail);
        }
        // 作成日
        file.setCreateDate(Calendar.getInstance().getTime());
        // 更新日
        file.setUpdateDate(Calendar.getInstance().getTime());

        // ファイルの移動
        ALStorageService.copyTmpFile(uid, folderName, String.valueOf(filebean
          .getFileId()), FOLDER_FILEDIR_IMPROVEOPE_APPLY, CATEGORY_KEY
          + ALStorageService.separator()
          + uid, filename);
      }

      // 添付ファイル保存先のフォルダを削除
      ALStorageService.deleteTmpFolder(uid, folderName);
    } catch (Exception e) {
      Database.rollback();
      logger.error("Exception", e);
      return false;
    }
    return true;
  }
  /**
   * ユーザ毎のルート保存先（絶対パス）を取得します。
   *
   * @param uid
   * @return
   */
  public static String getSaveDirPath(String orgId, int uid) {
    return ALStorageService.getDocumentPath(
    		FOLDER_FILEDIR_IMPROVEOPE_APPLY,
      CATEGORY_KEY + ALStorageService.separator() + uid);
  }

  /**
   * ユーザ毎の保存先（相対パス）を取得します。
   *
   * @param uid
   * @return
   */
  public static String getRelativePath(String fileName) {
    return new StringBuffer().append("/").append(fileName).toString();
  }

  @Deprecated
  public static void shiftWhatsNewReadFlag(RunData rundata, int entityid) {
    int uid = ALEipUtils.getUserId(rundata);
    boolean isPublic = false;

    SelectQuery<OriTImproveopeTopic> query =
      Database.query(OriTImproveopeTopic.class);
    Expression exp =
      ExpressionFactory
        .matchExp(OriTImproveopeTopic.PARENT_ID_PROPERTY, entityid);
    query.setQualifier(exp);
    query.select(OriTImproveopeTopic.TOPIC_ID_PK_COLUMN);
    query.distinct(true);

    List<OriTImproveopeTopic> topics = query.fetchList();

    query = Database.query(OriTImproveopeTopic.class);
    exp =
      ExpressionFactory.matchDbExp(
    		  OriTImproveopeTopic.TOPIC_ID_PK_COLUMN,
        entityid);
    query.setQualifier(exp);

    List<OriTImproveopeTopic> topic = query.fetchList();
//    if (topic != null
//      && ((topic.get(0)).getEipTMsgboardCategory().getPublicFlag().equals("T"))) {
//      isPublic = true;
//    }

    if (topics != null) {

      int size = topics.size();
      Integer _id = null;

      for (int i = 0; i < size; i++) {
      	OriTImproveopeTopic record = topics.get(i);
        _id = record.getTopicId();
        WhatsNewUtils.shiftWhatsNewReadFlag(
          WhatsNewUtils.WHATS_NEW_TYPE_MSGBOARD_TOPIC,
          _id.intValue(),
          uid);
      }

    WhatsNewUtils.shiftWhatsNewReadFlag(
    WhatsNewUtils.WHATS_NEW_TYPE_MSGBOARD_TOPIC,
    entityid,
    uid);

    }

  }

  /**
   * 表示切り替えで指定した検索キーワードを取得する．
   *
   * @param rundata
   * @param context
   * @return
   */
  public static String getTargetKeyword(RunData rundata, Context context) {
    String target_keyword = null;
    String keywordParam = rundata.getParameters().getString(TARGET_KEYWORD);
    target_keyword = ALEipUtils.getTemp(rundata, context, TARGET_KEYWORD);

    if (keywordParam == null && (target_keyword == null)) {
      ALEipUtils.setTemp(rundata, context, TARGET_KEYWORD, "");
      target_keyword = "";
    } else if (keywordParam != null) {
      ALEipUtils.setTemp(rundata, context, TARGET_KEYWORD, keywordParam.trim());
      target_keyword = keywordParam;
    }
    return target_keyword;
  }

  /**
   * 表示切り替えで指定した検索ステータスを取得する．
   *
   * @param rundata
   * @param context
   * @return
   */
  public static String getTargetStatus(RunData rundata, Context context) {
    String target_status = null;
    String statusParam = rundata.getParameters().getString(TARGET_STATUS);
    target_status = ALEipUtils.getTemp(rundata, context, TARGET_STATUS);

    if (statusParam == null && (target_status == null)) {
      ALEipUtils.setTemp(rundata, context, TARGET_STATUS, "A");
      target_status = "A";
    } else if (statusParam != null) {
      ALEipUtils.setTemp(rundata, context, TARGET_STATUS, statusParam.trim());
      target_status = statusParam;
    }
    return target_status;
  }

  /**
   * 表示切り替えで指定した検索時期を取得する．
   *
   * @param rundata
   * @param context
   * @return
   */
  public static String getTargetTime(RunData rundata, Context context) {
    String target_time = null;
    String timeParam = rundata.getParameters().getString(TARGET_TIME);
    target_time = ALEipUtils.getTemp(rundata, context, TARGET_TIME);

    if (timeParam == null && (target_time == null)) {
      ALEipUtils.setTemp(rundata, context, TARGET_TIME, "on");
      target_time = "on";
    } else if (timeParam != null) {
      ALEipUtils.setTemp(rundata, context, TARGET_TIME, timeParam.trim());
      target_time = timeParam;
    }
    return target_time;
  }

  /**
   * 表示切り替えのリセットフラグがあるかを返す．
   *
   * @param rundata
   * @param context
   * @return
   */
  public static boolean hasResetFlag(RunData rundata, Context context) {
    String resetflag = rundata.getParameters().getString(RESET_FLAG);
    return resetflag != null;
  }

  /**
   * フィルターを初期化する．
   *
   * @param rundata
   * @param context
   * @param className
   */
  public static void resetFilter(RunData rundata, Context context,
      String className) {
    ALEipUtils.setTemp(rundata, context, TARGET_KEYWORD, "");
    ALEipUtils.setTemp(rundata, context, TARGET_STATUS, "");
    ALEipUtils.setTemp(rundata, context, TARGET_TIME, "");
  }

  /**
   * アクセス権限をチェックします。
   *
   * @return
   */
  public static boolean checkPermission(RunData rundata, Context context,
      int defineAclType, String pfeature) {

    if (defineAclType == 0) {
      return true;
    }

    if (pfeature == null || "".equals(pfeature)) {
      return true;
    }

    ALAccessControlFactoryService aclservice =
      (ALAccessControlFactoryService) ((TurbineServices) TurbineServices
        .getInstance()).getService(ALAccessControlFactoryService.SERVICE_NAME);
    ALAccessControlHandler aclhandler = aclservice.getAccessControlHandler();
    boolean hasAuthority =
      aclhandler.hasAuthority(
        ALEipUtils.getUserId(rundata),
        pfeature,
        defineAclType);

    return hasAuthority;
  }

  /**
   * トピックに対する返信数を返します
   *
   * @param topic_id
   * @return
   */
  public static Integer countReply(Integer topic_id) {
    SelectQuery<OriTImproveopeTopic> query =
      Database.query(OriTImproveopeTopic.class);

    Expression exp1 =
      ExpressionFactory
        .matchDbExp(OriTImproveopeTopic.PARENT_ID_COLUMN, topic_id);
    query.setQualifier(exp1);

    return query.getCount();
  }

  public static void createApplyActivity(OriTImproveopeApply topic,
      String loginName, boolean isNew) {
	  createApplyActivity(topic, loginName, null, isNew);
  }

  public static void createApplyActivity(OriTImproveopeApply apply,
      String loginName, List<String> recipients, boolean isNew) {
    ALActivity RecentActivity =
      ALActivity.getRecentActivity("ImproveopeApply", apply.getApplyId(), 1f);
    boolean isDeletePrev =
      RecentActivity != null && RecentActivity.isReplace(loginName);

    String title =
      new StringBuilder("業務改善申請「")
        .append(apply.getApplyName())
        .append("」")
        .append(isNew ? "が行われました。" : "が編集されました。")
        .toString();
    String portletParams =
      new StringBuilder("?template=ImproveopeReceiveFormScreen").append(
        "&entityid=").append(apply.getApplyId()).toString();

    if (recipients != null && recipients.size() > 0) {
      ALActivityService.create(new ALActivityPutRequest()
        .withAppId("ImproveopeApply")
        .withUserId(apply.getOwnerId())
        .withLoginName(loginName)
        .withPortletParams(portletParams)
        .withRecipients(recipients)
        .withTitle(title)
        .withPriority(1f)
        .withExternalId(String.valueOf(apply.getApplyId())));
    } else {
      ALActivityService.create(new ALActivityPutRequest()
        .withAppId("ImproveopeApply")
        .withLoginName(loginName)
        .withUserId(apply.getOwnerId())
        .withPortletParams(portletParams)
        .withTitle(title)
        .withPriority(1f)
        .withExternalId(String.valueOf(apply.getApplyId())));
    }
    if (isDeletePrev) {
      RecentActivity.Delete();
    }
  }

  public static void createCheckActivity(OriTImproveopeApply apply,
	      String loginName, List<String> recipients) {
	    ALActivity RecentActivity =
	      ALActivity.getRecentActivity("ImproveopeApplyCheck", apply.getApplyId(), 1f);
	    boolean isDeletePrev =
	      RecentActivity != null && RecentActivity.isReplace(loginName);

	    String title =
	      new StringBuilder("業務改善案「")
	        .append(apply.getApplyName())
	        .append("」のスタッフ評価を募集しています。")
	        .toString();
	    String portletParams =
	      new StringBuilder("?template=ImproveopeCheckFormScreen").append(
	        "&entityid=").append(apply.getApplyId()).toString();

	    if (recipients != null && recipients.size() > 0) {
	      ALActivityService.create(new ALActivityPutRequest()
	        .withAppId("ImproveopeApplyCheck")
	        .withUserId(apply.getOwnerId())
	        .withLoginName(loginName)
	        .withPortletParams(portletParams)
	        .withRecipients(recipients)
	        .withTitle(title)
	        .withPriority(1f)
	        .withExternalId(String.valueOf(apply.getApplyId())));
	    } else {
	      ALActivityService.create(new ALActivityPutRequest()
	        .withAppId("ImproveopeApplyCheck")
	        .withLoginName(loginName)
	        .withUserId(apply.getOwnerId())
	        .withPortletParams(portletParams)
	        .withTitle(title)
	        .withPriority(1f)
	        .withExternalId(String.valueOf(apply.getApplyId())));
	    }
	    if (isDeletePrev) {
	      RecentActivity.Delete();
	    }
	  }

  public static void createActionActivity(OriTImproveopeApply apply,
	      String loginName, List<String> recipients, boolean isNew) {
	    ALActivity RecentActivity =
	      ALActivity.getRecentActivity("ImproveopeApplyAction", apply.getApplyId(), 1f);
	    boolean isDeletePrev =
	      RecentActivity != null && RecentActivity.isReplace(loginName);

	    String title =
	      new StringBuilder("業務改善案「")
	        .append(apply.getApplyName())
	        .append("」の実施要項が")
	        .append(isNew ? "作成されました。" : "編集されました。")
	        .toString();
	    String portletParams =
	      new StringBuilder("?template=ImproveopeReportDetailScreen").append(
	        "&entityid=").append(apply.getApplyId()).toString();

	    if (recipients != null && recipients.size() > 0) {
	      ALActivityService.create(new ALActivityPutRequest()
	        .withAppId("ImproveopeApplyAction")
	        .withUserId(apply.getOwnerId())
	        .withLoginName(loginName)
	        .withPortletParams(portletParams)
	        .withRecipients(recipients)
	        .withTitle(title)
	        .withPriority(1f)
	        .withExternalId(String.valueOf(apply.getApplyId())));
	    } else {
	      ALActivityService.create(new ALActivityPutRequest()
	        .withAppId("ImproveopeApplyAction")
	        .withLoginName(loginName)
	        .withUserId(apply.getOwnerId())
	        .withPortletParams(portletParams)
	        .withTitle(title)
	        .withPriority(1f)
	        .withExternalId(String.valueOf(apply.getApplyId())));
	    }
	    if (isDeletePrev) {
	      RecentActivity.Delete();
	    }
	  }

  public static void createRejectActivity(OriTImproveopeApply apply,
      String loginName, List<String> recipients) {
    ALActivity RecentActivity =
      ALActivity.getRecentActivity("ImproveopeApplyReject", apply.getApplyId(), 1f);
    boolean isDeletePrev =
      RecentActivity != null && RecentActivity.isReplace(loginName);

    String title =
      new StringBuilder("業務改善案「")
        .append(apply.getApplyName())
        .append("」が却下されました。")
        .toString();
    String portletParams =
      new StringBuilder("?template=ImproveopeReceiveFormScreen").append(
        "&entityid=").append(apply.getApplyId()).toString();

    if (recipients != null && recipients.size() > 0) {
      ALActivityService.create(new ALActivityPutRequest()
        .withAppId("ImproveopeApplyReject")
        .withUserId(apply.getOwnerId())
        .withLoginName(loginName)
        .withPortletParams(portletParams)
        .withRecipients(recipients)
        .withTitle(title)
        .withPriority(1f)
        .withExternalId(String.valueOf(apply.getApplyId())));
    } else {
      ALActivityService.create(new ALActivityPutRequest()
        .withAppId("ImproveopeApplyReject")
        .withLoginName(loginName)
        .withUserId(apply.getOwnerId())
        .withPortletParams(portletParams)
        .withTitle(title)
        .withPriority(1f)
        .withExternalId(String.valueOf(apply.getApplyId())));
    }
    if (isDeletePrev) {
      RecentActivity.Delete();
    }
  }

  public static void createAdoptActivity(OriTImproveopeApply apply,
      String loginName, List<String> recipients) {
    ALActivity RecentActivity =
      ALActivity.getRecentActivity("ImproveopeApplyAdopt", apply.getApplyId(), 1f);
    boolean isDeletePrev =
      RecentActivity != null && RecentActivity.isReplace(loginName);

    String title =
      new StringBuilder("業務改善案「")
        .append(apply.getApplyName())
        .append("」が採用されました。")
        .toString();
    String portletParams =
      new StringBuilder("?template=ImproveopeReceiveFormScreen").append(
        "&entityid=").append(apply.getApplyId()).toString();

    if (recipients != null && recipients.size() > 0) {
      ALActivityService.create(new ALActivityPutRequest()
        .withAppId("ImproveopeApplyAdopt")
        .withUserId(apply.getOwnerId())
        .withLoginName(loginName)
        .withPortletParams(portletParams)
        .withRecipients(recipients)
        .withTitle(title)
        .withPriority(1f)
        .withExternalId(String.valueOf(apply.getApplyId())));
    } else {
      ALActivityService.create(new ALActivityPutRequest()
        .withAppId("ImproveopeApplyAdopt")
        .withLoginName(loginName)
        .withUserId(apply.getOwnerId())
        .withPortletParams(portletParams)
        .withTitle(title)
        .withPriority(1f)
        .withExternalId(String.valueOf(apply.getApplyId())));
    }
    if (isDeletePrev) {
      RecentActivity.Delete();
    }
  }

  public static void createReportActivity(OriTImproveopeApply apply,
	      String loginName, List<String> recipients, boolean isNew) {
	    ALActivity RecentActivity =
	      ALActivity.getRecentActivity("ImproveopeReport", apply.getApplyId(), 1f);
	    boolean isDeletePrev =
	      RecentActivity != null && RecentActivity.isReplace(loginName);

	    String title =
	      new StringBuilder("業務改善申請「")
	        .append(apply.getApplyName())
	        .append("」の実施要項に対する報告")
	        .append(isNew ? "が行われました。" : "が編集されました。")
	        .toString();
	    String portletParams =
	      new StringBuilder("?template=ImproveopeReportDetailScreen").append(
	        "&entityid=").append(apply.getApplyId()).toString();

	    if (recipients != null && recipients.size() > 0) {
	      ALActivityService.create(new ALActivityPutRequest()
	        .withAppId("ImproveopeReport")
	        .withUserId(apply.getOwnerId())
	        .withLoginName(loginName)
	        .withPortletParams(portletParams)
	        .withRecipients(recipients)
	        .withTitle(title)
	        .withPriority(1f)
	        .withExternalId(String.valueOf(apply.getApplyId())));
	    } else {
	      ALActivityService.create(new ALActivityPutRequest()
	        .withAppId("ImproveopeReport")
	        .withLoginName(loginName)
	        .withUserId(apply.getOwnerId())
	        .withPortletParams(portletParams)
	        .withTitle(title)
	        .withPriority(1f)
	        .withExternalId(String.valueOf(apply.getApplyId())));
	    }
	    if (isDeletePrev) {
	      RecentActivity.Delete();
	    }
	  }

  /**
   * アクティビティを通知先・社内参加者の「あなた宛のお知らせ」に表示させる（返信用）
   *
   * @param topic
   * @param loginName
   * @param recipients
   */
  public static void createNewTopicActivity(OriTImproveopeTopic topic,
      String loginName, List<String> recipient) {
    ALActivity RecentActivity =
      ALActivity.getRecentActivity("Improveope", topic.getTopicId(), 1f);
    boolean isDeletePrev =
      RecentActivity != null && RecentActivity.isReplace(loginName);

    if (recipient != null) {
      StringBuilder b = new StringBuilder("掲示板「");

      b.append(ALCommonUtils.compressString(topic.getTopicName(), 30)).append(
        "」").append("に返信しました。");

      String portletParams =
        new StringBuilder("?template=ImproveopeTopicDetailScreen").append(
          "&entityid=").append(topic.getTopicId()).toString();
      ALActivityService.create(new ALActivityPutRequest()
        .withAppId("Improveope")
        .withUserId(topic.getOwnerId())
        .withLoginName(loginName)
        .withPortletParams(portletParams)
        .withRecipients(recipient)
        .withTitle(b.toString())
        .withPriority(1f)
        .withExternalId(String.valueOf(topic.getTopicId())));
    } else {
      StringBuilder b = new StringBuilder("掲示板「");

      b.append(ALCommonUtils.compressString(topic.getTopicName(), 30)).append(
        "」").append("に返信しました。");

      String portletParams =
        new StringBuilder("?template=ImproveopeTopicDetailScreen").append(
          "&entityid=").append(topic.getTopicId()).toString();
      ALActivityService.create(new ALActivityPutRequest()
        .withAppId("Improveope")
        .withUserId(topic.getOwnerId())
        .withLoginName(loginName)
        .withPortletParams(portletParams)
        .withTitle(b.toString())
        .withPriority(1f)
        .withExternalId(String.valueOf(topic.getTopicId())));
    }
    if (isDeletePrev) {
      RecentActivity.Delete();
    }
  }

  public static void createNewCommentActivity(OriTImproveopeTopic topic,
      String loginName) {
    createNewCommentActivity(topic, loginName, null);
  }

  public static void createNewCommentActivity(OriTImproveopeTopic topic,
      String loginName, List<String> recipients) {
    String title =
      new StringBuilder("掲示板「")
        .append(ALCommonUtils.compressString(topic.getTopicName(), 30))
        .append("」に")
        .append("返信しました。")
        .toString();
    String portletParams =
      new StringBuilder("?template=ImproveopeTopicDetailScreen").append(
        "&entityid=").append(topic.getTopicId()).toString();

    if (recipients != null && recipients.size() > 0) {
      ALActivityService.create(new ALActivityPutRequest()
        .withAppId("Improveope")
        .withUserId(topic.getOwnerId())
        .withLoginName(loginName)
        .withPortletParams(portletParams)
        .withRecipients(recipients)
        .withTitle(title)
        .withPriority(0f)
        .withExternalId(String.valueOf(topic.getTopicId())));
    } else {
      ALActivityService.create(new ALActivityPutRequest()
        .withUserId(topic.getOwnerId())
        .withAppId("Improveope")
        .withLoginName(loginName)
        .withPortletParams(portletParams)
        .withTitle(title)
        .withPriority(0f)
        .withExternalId(String.valueOf(topic.getTopicId())));
    }
  }

  /**
   * パソコンへ送信するメールの内容を作成する（返信用）．
   *
   * @return
   */
  public static String createReplyMsgForPc(RunData rundata,
		  OriTImproveopeTopic topic, OriTImproveopeTopic parenttopic) {
    boolean enableAsp = JetspeedResources.getBoolean("aipo.asp", false);
    ALEipUser loginUser = null;
    ALBaseUser user = null;

    try {
      loginUser = ALEipUtils.getALEipUser(rundata);
      user =
        (ALBaseUser) JetspeedSecurity.getUser(new UserIdPrincipal(loginUser
          .getUserId()
          .toString()));
    } catch (Exception e) {
      return "";
    }
    String CR = System.getProperty("line.separator");
    StringBuffer body = new StringBuffer("");
    body.append(loginUser.getAliasName().toString());
    if (!"".equals(user.getEmail())) {
      body.append("(").append(user.getEmail()).append(")");
    }
    body.append("さんが掲示板").append("に返信しました。").append(CR).append(CR);
    body.append("[タイトル]").append(CR).append(
      parenttopic.getTopicName().toString()).append(CR);

    if (topic.getNote().toString().length() > 0) {
      body
        .append("[返信内容]")
        .append(CR)
        .append(topic.getNote().toString())
        .append(CR);
    }
    body.append(CR);
    body
      .append("[")
      .append(ALOrgUtilsService.getAlias())
      .append("へのアクセス]")
      .append(CR);
    if (enableAsp) {
      body.append("　").append(ALMailUtils.getGlobalurl()).append(CR);
    } else {
      body.append("・社外").append(CR);
      body.append("　").append(ALMailUtils.getGlobalurl()).append(CR);
      body.append("・社内").append(CR);
      body.append("　").append(ALMailUtils.getLocalurl()).append(CR).append(CR);
    }

    body.append("---------------------").append(CR);
    body.append(ALOrgUtilsService.getAlias()).append(CR);

    return body.toString();
  }

  /**
   * 携帯電話へ送信するメールの内容を作成する（返信用）．
   *
   * @return
   */
  public static String createReplyMsgForCellPhone(RunData rundata,
		  OriTImproveopeTopic topic, OriTImproveopeTopic parenttopic, int destUserID) {
    ALEipUser loginUser = null;
    ALBaseUser user = null;
    try {
      loginUser = ALEipUtils.getALEipUser(rundata);
      user =
        (ALBaseUser) JetspeedSecurity.getUser(new UserIdPrincipal(loginUser
          .getUserId()
          .toString()));
    } catch (Exception e) {
      return "";
    }
    String CR = System.getProperty("line.separator");
    StringBuffer body = new StringBuffer("");
    body.append(loginUser.getAliasName().toString());
    if (!"".equals(user.getEmail())) {
      body.append("(").append(user.getEmail()).append(")");
    }
    body.append("さんが掲示板").append("に返信しました。").append(CR).append(CR);
    body.append("[タイトル]").append(CR).append(
      parenttopic.getTopicName().toString()).append(CR);
    body.append(CR);

    ALEipUser destUser;
    try {
      destUser = ALEipUtils.getALEipUser(destUserID);
    } catch (ALDBErrorException ex) {
      logger.error("Exception", ex);
      return "";
    }
    body
      .append("[")
      .append(ALOrgUtilsService.getAlias())
      .append("へのアクセス]")
      .append(CR);
    body.append("　").append(ALMailUtils.getGlobalurl()).append("?key=").append(
      ALCellularUtils.getCellularKey(destUser)).append(CR);
    body.append("---------------------").append(CR);
    body.append(ALOrgUtilsService.getAlias()).append(CR);
    return body.toString();
  }

  /**
   * トピックに添付されたすべての添付ファイルを物理削除します。
   *
   * @param topic
   */
  @SuppressWarnings("unchecked")
  public static void deleteAttachmentFiles(OriTImproveopeTopic topic) {
    String orgId = Database.getDomainName();
    List<OriTImproveopeFile> files = topic.getOriTImproveopeFile();
    int uid = topic.getOwnerId();
    for (OriTImproveopeFile file : files) {
      ALStorageService.deleteFile(ImproveopeUtils.getSaveDirPath(orgId, uid)
        + file.getFilePath());
    }
  }

  /**
   * 業務改善管理者リストを取得する
   * @return
   */
  public static List<String> getAdminMemberList() {
      List<String> memberList = new ArrayList<String>();
      List<EipTAclUserRoleMap> aclUserRoleMaps = getEipTAclUserRoleMaps();
      if (aclUserRoleMaps != null && aclUserRoleMaps.size() > 0) {
        EipTAclUserRoleMap rolemap = null;
        TurbineUser tuser = null;
        int size = aclUserRoleMaps.size();
        for (int i = 0; i < size; i++) {
          rolemap = aclUserRoleMaps.get(i);
          try {
			tuser = ALEipUtils.getTurbineUser(rolemap.getUserId());
//          tuser = rolemap.getTurbineUser();
			memberList.add(tuser.getLoginName());
          } catch (ALDBErrorException e) {}
        }
      }

	  return memberList;
  }

  public static List<EipTAclUserRoleMap> getEipTAclUserRoleMaps() {
	    try {
	      // SQLの作成
	      StringBuffer idStatement = new StringBuffer();
	      idStatement.append("SELECT T1.* ");
	      idStatement.append("FROM eip_t_acl_user_role_map T1 ");
	      idStatement.append("JOIN turbine_user T2 ");
	      idStatement.append("ON T1.USER_ID = T2.USER_ID ");
	      idStatement.append("JOIN eip_t_acl_role T3 ");
	      idStatement.append("ON T1.ROLE_ID = T3.ROLE_ID ");
	      idStatement.append("JOIN eip_t_acl_portlet_feature T4 ");
	      idStatement.append("ON T3.FEATURE_ID = T4.FEATURE_ID ");
	      idStatement.append("WHERE T2.DISABLED != #bind($disabled) ");
	      idStatement.append("AND T4.FEATURE_NAME = #bind($feature_name) ");

	      String idQuery = idStatement.toString();

	      List<EipTAclUserRoleMap> aclroles =
	        Database.sql(EipTAclUserRoleMap.class, idQuery).param(
	          "disabled",
	          "T").param(
	          "feature_name",
	          ALAccessControlConstants.POERTLET_FEATURE_IMPROVEOPE_ADMIN)
	          .fetchList();

	      if (aclroles == null || aclroles.size() == 0) {
	        // 指定したIDのレコードが見つからない場合
	        logger.debug("[AccessControlUtils] Not found ID...");
	        return null;
	      }
	      return aclroles;
	    } catch (Exception ex) {
	      logger.error("Exception", ex);
	      return null;
	    }
	  }

  /**
   * マップオブジェクトモデルを取得します。 <BR>
   *
   * @param rundata
   * @param context
   * @return
   */
  public static List<OriTImproveopeApplyMemberMap> getOriTImproveopeApplyMemberMap(OriTImproveopeApply apply) {
    try {
      SelectQuery<OriTImproveopeApplyMemberMap> query = Database.query(OriTImproveopeApplyMemberMap.class);
      Expression exp =
        ExpressionFactory.matchDbExp(OriTImproveopeApplyMemberMap.ORI_TIMPROVEOPE_APPLY_PROPERTY
          + "."
          + OriTImproveopeApply.APPLY_ID_PK_COLUMN, apply.getApplyId());
      query.setQualifier(exp);

      List<OriTImproveopeApplyMemberMap> maps = query.fetchList();

      if (maps == null || maps.size() == 0) {
        // 指定した Apply IDのレコードが見つからない場合
        logger.debug("[OriTImproveopeApplyMemberMap] Not found ID...");
        return null;
      }
      return maps;
    } catch (Exception ex) {
      logger.error("Exception", ex);
      return null;
    }
  }


  /**
   * 実施対象者マップオブジェクトモデルを取得します。 <BR>
   *
   * @param rundata
   * @param context
   * @return
   */
  public static List<OriTImproveopeApplyActionMap> getOriTImproveopeApplyActionMap(OriTImproveopeApplyAction action) {
    try {
      SelectQuery<OriTImproveopeApplyActionMap> query = Database.query(OriTImproveopeApplyActionMap.class);
      Expression exp =
        ExpressionFactory.matchDbExp(OriTImproveopeApplyActionMap.ORI_TIMPROVEOPE_APPLY_ACTION_PROPERTY
          + "."
          + OriTImproveopeApplyAction.ACTION_ID_PK_COLUMN, action.getActionId());
      query.setQualifier(exp);

      List<OriTImproveopeApplyActionMap> maps = query.fetchList();

      if (maps == null || maps.size() == 0) {
        // 指定した Apply IDのレコードが見つからない場合
        logger.debug("[OriTImproveopeApplyActionMap] Not found ID...");
        return null;
      }
      return maps;
    } catch (Exception ex) {
      logger.error("Exception", ex);
      return null;
    }
  }

  /**
   * 指定した評価数を返します
   *
   * @param apply_id
   * @return
   */
  public static Integer countCheck(Integer apply_id, String answer) {
    SelectQuery<OriTImproveopeApplyCheck> query =
      Database.query(OriTImproveopeApplyCheck.class);

    Expression exp1 =
      ExpressionFactory
        .matchDbExp(OriTImproveopeApplyCheck.ORI_TIMPROVEOPE_APPLY_PROPERTY
                + "."
                + OriTImproveopeApply.APPLY_ID_PK_COLUMN,
                Integer.valueOf(apply_id));

    Expression exp2 =
      ExpressionFactory
        .matchDbExp(OriTImproveopeApplyCheck.ANSWER_PROPERTY, answer);

    query.setQualifier((exp1.andExp(exp2)));

    return query.getCount();
  }

  /**
   * 指定した評価数を返します
   *
   * @param apply_id
   * @return
   */
  public static Integer countCheck(Integer apply_id) {
    SelectQuery<OriTImproveopeApplyCheck> query =
      Database.query(OriTImproveopeApplyCheck.class);

    Expression exp1 =
      ExpressionFactory
        .matchDbExp(OriTImproveopeApplyCheck.ORI_TIMPROVEOPE_APPLY_PROPERTY
                + "."
                + OriTImproveopeApply.APPLY_ID_PK_COLUMN,
                Integer.valueOf(apply_id));

    query.setQualifier(exp1);

    return query.getCount();
  }

  /**
   * 実施要項数を返します。
   *
   * @param apply_id
   * @return
   */
  public static Integer countAction(Integer apply_id) {
    SelectQuery<OriTImproveopeApplyAction> query =
      Database.query(OriTImproveopeApplyAction.class);

    Expression exp1 =
      ExpressionFactory
        .matchDbExp(OriTImproveopeApplyAction.ORI_TIMPROVEOPE_APPLY_PROPERTY
                + "."
                + OriTImproveopeApply.APPLY_ID_PK_COLUMN,
                Integer.valueOf(apply_id));

    query.setQualifier(exp1);

    return query.getCount();
  }

}
