/*
 * Copyright(C) 2012 - 2013 orinos Co.,Ltd. All rights reserved.
 * http://www.orinos.co.jp/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.aimluck.eip.improveope;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.jar.Attributes;

import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.portal.portlets.VelocityPortlet;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

import com.aimluck.commons.field.ALStringField;
import com.aimluck.commons.utils.ALStringUtil;
import com.aimluck.eip.cayenne.om.portlet.OriTImproveopeApply;
import com.aimluck.eip.cayenne.om.portlet.OriTImproveopeApplyFile;
import com.aimluck.eip.cayenne.om.portlet.OriTImproveopeApplyMemberMap;
import com.aimluck.eip.common.ALAbstractSelectData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALData;
import com.aimluck.eip.common.ALEipConstants;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.common.ALPermissionException;
import com.aimluck.eip.fileupload.beans.FileuploadBean;
import com.aimluck.eip.fileupload.util.FileuploadUtils;
import com.aimluck.eip.improveope.util.ImproveopeApplyUtils;
import com.aimluck.eip.improveope.util.ImproveopeUtils;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.ResultList;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.services.accessctl.ALAccessControlConstants;
import com.aimluck.eip.services.accessctl.ALAccessControlFactoryService;
import com.aimluck.eip.services.accessctl.ALAccessControlHandler;
import com.aimluck.eip.util.ALEipUtils;

/**
 * 業務改善申請の評価待ち検索データを管理するクラスです。 <BR>
 *
 */
public class ImproveopeCheckSelectData extends
    ALAbstractSelectData<OriTImproveopeApply, OriTImproveopeApply> implements
    ALData {

  /** logger */
  private static final JetspeedLogger logger = JetspeedLogFactoryService
    .getLogger(ImproveopeCheckSelectData.class.getName());

  /** 申請オブジェクト */
  private Object apply;

  /** トピックの総数 */
  private int applySum;

  /** ログインユーザ ID */
  private int uid;

  /** 初期表示 */
  private int table_colum_num;

  private final String MODE = "check";

  /** <code>target_time</code> 表示対象の時期 */
  private ALStringField target_time;

  private boolean hasAclMenuAdmin;
  private boolean hasAclMenuView;

  /** 現在選択されているタブ */
  private String currentTab;


  /**
   *
   * @param action
   * @param rundata
   * @param context
   */
  @Override
  public void init(ALAction action, RunData rundata, Context context)
      throws ALPageNotFoundException, ALDBErrorException {
    super.init(action, rundata, context);

    String sort = ALEipUtils.getTemp(rundata, context, LIST_SORT_STR);
    if (sort == null || sort.equals("")) {
      VelocityPortlet portlet = ALEipUtils.getPortlet(rundata, context);
      String sortStr = null;
      if (portlet != null) {
        sortStr = portlet.getPortletConfig().getInitParameter("p2a-sort");
      } else {
        sortStr = "update_date";
      }
      ALEipUtils.setTemp(rundata, context, LIST_SORT_STR, sortStr);
      if ("update_date".equals(sortStr)) {
        ALEipUtils.setTemp(rundata, context, LIST_SORT_TYPE_STR, "desc");
      }
    }


    ALAccessControlFactoryService aclservice =
  	      (ALAccessControlFactoryService) ((TurbineServices) TurbineServices
  	        .getInstance()).getService(ALAccessControlFactoryService.SERVICE_NAME);
  	    ALAccessControlHandler aclhandler = aclservice.getAccessControlHandler();
    hasAclMenuAdmin =
	      aclhandler.hasAuthority(
	        ALEipUtils.getUserId(rundata),
	        ALAccessControlConstants.POERTLET_FEATURE_IMPROVEOPE_ADMIN,
	        ALAccessControlConstants.VALUE_ACL_UPDATE);

    hasAclMenuView =
  	      aclhandler.hasAuthority(
  	        ALEipUtils.getUserId(rundata),
  	        ALAccessControlConstants.POERTLET_FEATURE_IMPROVEOPE_ADMIN,
  	        ALAccessControlConstants.VALUE_ACL_LIST);

    uid = ALEipUtils.getUserId(rundata);

    target_time = new ALStringField();

    String tabParam = rundata.getParameters().getString("tab");
    currentTab = ALEipUtils.getTemp(rundata, context, "tab");
    if (tabParam == null && currentTab == null) {
      ALEipUtils.setTemp(rundata, context, "tab", "check");
      currentTab = "check";
    } else if (tabParam != null) {
      ALEipUtils.setTemp(rundata, context, "tab", tabParam);
      currentTab = tabParam;
    }
  }

  /**
   * 一覧データを取得します。 <BR>
   *
   * @param rundata
   * @param context
   * @return
   */
  @Override
  public ResultList<OriTImproveopeApply> selectList(RunData rundata,
      Context context) {
    try {
        if (ImproveopeUtils.hasResetFlag(rundata, context)) {
            ImproveopeApplyUtils.resetFilter(rundata, context, this.getClass().getName());
            target_time.setValue("");
          } else {
        	  target_time.setValue(ImproveopeApplyUtils
                    .getTargetTime(rundata, context));
          }

      SelectQuery<OriTImproveopeApply> query = getSelectQuery(rundata, context);
      buildSelectQueryForListView(query);
      buildSelectQueryForListViewSort(query, rundata, context);

      // 表示するカラムのみデータベースから取得する．
      ResultList<OriTImproveopeApply> list = query.getResultList();
      // 件数をセットする．
      applySum = list.getTotalCount();
      return list;
    } catch (Exception ex) {
      logger.error("Exception", ex);
      return null;

    }
  }

  /**
   * 検索条件を設定した SelectQuery を返します。 <BR>
   *
   * @param rundata
   * @param context
   * @return
   */

  private SelectQuery<OriTImproveopeApply> getSelectQuery(RunData rundata,
      Context context) {

    SelectQuery<OriTImproveopeApply> query =
      Database.query(OriTImproveopeApply.class);
    query.distinct();

    return buildSelectQueryForFilter(query, rundata, context);
  }

  // ::TODO
  @Override
  protected SelectQuery<OriTImproveopeApply> buildSelectQueryForFilter(
      SelectQuery<OriTImproveopeApply> query, RunData rundata, Context context) {

	  // 評価が登録されているもののみ
//   	  Expression ex1 =
//			ExpressionFactory.noMatchDbExp(
//				OriTImproveopeApply.ORI_TIMPROVEOPE_APPLY_CHECK_PROPERTY
//				+ "."
//				+ OriTImproveopeApplyCheck.ID_PK_COLUMN,
//				null);
	  // 申請中でない
      Expression ex1 =
   	      ExpressionFactory.noMatchExp(OriTImproveopeApply.STATUS_PROPERTY,
   	    		  ImproveopeApplyUtils.APPLY_STATUS_APPLY);
	  // 評価中のみ
       Expression ex2 =
    	      ExpressionFactory.matchExp(OriTImproveopeApply.STATUS_PROPERTY,
    	    		  ImproveopeApplyUtils.APPLY_STATUS_CHECK);

		if ((target_time != null) && (target_time.getValue().equals("on"))) {
	        query.andQualifier(ex2);
	    } else if ((target_time != null) && (target_time.getValue().equals("end"))) {
		       Expression ex3 =
		     	      ExpressionFactory.noMatchExp(OriTImproveopeApply.STATUS_PROPERTY,
		     	    		  ImproveopeApplyUtils.APPLY_STATUS_CHECK);
	        query.andQualifier(ex3.andExp(ex1));
	    } else {
	    	query.setQualifier(ex1);
//	    	query.orQualifier(ex2);
	    }

    return query;
  }

  /**
   * ResultData に値を格納して返します。（一覧データ） <BR>
   *
   * @param obj
   * @return
   */
  @Override
  protected Object getResultData(OriTImproveopeApply record) {
    try {
      ImproveopeApplyResultData rd = new ImproveopeApplyResultData();
      rd.initField();
      rd.setApplyId(record.getApplyId().longValue());
      rd.setApplyName(record.getApplyName());
      rd.setStatus(record.getStatus());
      rd.setOwnerId(record.getOwnerId().longValue());
      rd.setOwnerName(ALEipUtils
        .getUserFullName(record.getOwnerId().intValue()));
      rd.setUpdateUser(ALEipUtils.getUserFullName(record
        .getUpdateUserId()
        .intValue()));
      rd.setUpdateDate(record.getUpdateDate());

      // 新着を設定する（期限は最終更新日からの 1 日間）．
      Date date = record.getUpdateDate();
      Calendar now = Calendar.getInstance();
      now.add(Calendar.DATE, -1);
      rd.setNewTopicFlag(date.after(now.getTime()));
      //TODO::評価数を取得する
//      rd.setReplyCount(ImproveopeUtils.countReply(record.getApplyId()));

      return rd;
    } catch (Exception ex) {
      logger.error("Exception", ex);
      return null;
    }
  }

  /**
   * 詳細表示します。
   *
   * @param action
   * @param rundata
   * @param context
   * @return TRUE 成功 FASLE 失敗
   */
  @Override
  public boolean doViewDetail(ALAction action, RunData rundata, Context context) {
    try {
      init(action, rundata, context);
      doCheckAclPermission(
        rundata,
        context,
        ALAccessControlConstants.VALUE_ACL_DETAIL);
      action.setMode(ALEipConstants.MODE_DETAIL);

      apply = getResultDataDetail(ImproveopeApplyUtils.getOriTImproveopeApply(
    	          rundata,
    	          context));

      action.setResultData(this);
      action.putData(rundata, context);
      return true;
    } catch (ALPermissionException e) {
      ALEipUtils.redirectPermissionError(rundata);
      return false;
    } catch (ALPageNotFoundException e) {
      ALEipUtils.redirectPageNotFound(rundata);
      return false;
    } catch (ALDBErrorException e) {
      ALEipUtils.redirectDBError(rundata);
      return false;
    }
  }

  @Override
  public OriTImproveopeApply selectDetail(RunData rundata, Context context) {
    ALEipUtils.redirectPageNotFound(rundata);
    return null;
  }

  private SelectQuery<OriTImproveopeApplyFile> getSelectQueryForFiles(int topicid) {
    SelectQuery<OriTImproveopeApplyFile> query =
      Database.query(OriTImproveopeApplyFile.class);
    Expression exp =
      ExpressionFactory.matchDbExp(
   		  OriTImproveopeApply.APPLY_ID_PK_COLUMN,
        Integer.valueOf(topicid));
    query.setQualifier(exp);
    return query;
  }

  /**
   * ResultData に値を格納して返します。（詳細データ） <BR>
   *
   * @param obj
   * @return
   */
  @Override
  protected Object getResultDataDetail(OriTImproveopeApply record)
      throws ALPageNotFoundException, ALDBErrorException {
    try {

      ImproveopeApplyResultData rd = new ImproveopeApplyResultData();
      rd.initField();
      rd.setApplyId(record.getApplyId().longValue());
      rd.setApplyName(record.getApplyName());
      rd.setOwnerId(record.getOwnerId().longValue());
      rd.setOwnerName(ALEipUtils
        .getUserFullName(record.getOwnerId().intValue()));
      rd.setNote(record.getNote());
      rd.setStatus(record.getStatus());
      rd.setCreateDate(record.getCreateDate());
      rd.setUpdateDate(record.getUpdateDate());

      // 提案者
      List<OriTImproveopeApplyMemberMap> maps = ImproveopeApplyUtils.getOriTImproveopeApplyMemberMap(record);
      List<ALEipUser> mapList = new ArrayList<ALEipUser>();
      OriTImproveopeApplyMemberMap map = null;
      int mapsize = maps.size();
      for (int i = 0; i < mapsize; i++) {
        map = maps.get(i);
        int user_id = map.getUserId().intValue();
        mapList.add(ALEipUtils.getALEipUser(user_id));
      }
      rd.setMembersList(mapList);

      // ファイル
      List<OriTImproveopeApplyFile> list =
        getSelectQueryForFiles(record.getApplyId().intValue()).fetchList();
      if (list != null && list.size() > 0) {
        List<FileuploadBean> attachmentFileList =
          new ArrayList<FileuploadBean>();
        FileuploadBean filebean = null;
        OriTImproveopeApplyFile file = null;
        int size = list.size();
        for (int i = 0; i < size; i++) {
          file = list.get(i);
          String realname = file.getFileName();
          javax.activation.DataHandler hData =
            new javax.activation.DataHandler(
              new javax.activation.FileDataSource(realname));

          filebean = new FileuploadBean();
          filebean.setFileId(file.getFileId().intValue());
          filebean.setFileName(realname);
          if (hData != null) {
            filebean.setContentType(hData.getContentType());
          }
          filebean.setIsImage(FileuploadUtils.isImage(realname));
          attachmentFileList.add(filebean);
        }
        rd.setAttachmentFiles(attachmentFileList);
      }

      return rd;
    } catch (Exception e) {
      logger.error("[ImproveopeApplySelectData]", e);
      throw new ALDBErrorException();
    }
  }

  /**
   * トピックの総数を返す． <BR>
   *
   * @return
   */
  public int getApplySum() {
    return applySum;
  }

  /**
   * @return
   *
   */
  @Override
  protected Attributes getColumnMap() {
    Attributes map = new Attributes();
    map.putValue("apply_name", OriTImproveopeApply.APPLY_NAME_PROPERTY);
    map.putValue("update_date", OriTImproveopeApply.UPDATE_DATE_PROPERTY);
    map.putValue("owner_name", OriTImproveopeApply.OWNER_ID_PROPERTY);
    map.putValue("update_user", OriTImproveopeApply.UPDATE_USER_ID_PROPERTY);
    map.putValue("status", OriTImproveopeApply.STATUS_PROPERTY);

    return map;
  }

  /**
   *
   * @param id
   * @return
   */
  public boolean isMatch(int id1, long id2) {
    return id1 == (int) id2;
  }

  public List<ALEipUser> getUsers(String groupname) {
    return ALEipUtils.getUsers(groupname);
  }

  public Object getApply() {
    return apply;
  }

  public int getUserId() {
    return uid;
  }

  /**
   * アクセス権限チェック用メソッド。 アクセス権限の機能名を返します。
   *
   * @return
   */
  @Override
  public String getAclPortletFeature() {
    return ALAccessControlConstants.POERTLET_FEATURE_IMPROVEOPE_SELF;
  }

  /**
   * 管理者用のメニュー表示権限
   *
   * @return
   */
  public boolean hasAclMenuAdmin() {
    return hasAclMenuAdmin;
  }

  public String getCurrentSearchWithSanitize() {
    return ALStringUtil.sanitizing(getCurrentSearch());
  }

  /**
   * @return table_colum_num
   */
  public int getTableColumNum() {
    return table_colum_num;
  }
  /**
  * @return target_keyword
  */
  public ALStringField getTargetTime() {
   return target_time;
  }

  /**
   * @param table_colum_num
   *          セットする table_colum_num
   */
  public void setTableColumNum(int table_colum_num) {
    this.table_colum_num = table_colum_num;
  }

  public String getMode() {
    return MODE;
  }
  /**
   * 管理者用のメニュー表示権限
   *
   * @return
   */
  public boolean hasAclMenuView() {
    return hasAclMenuView;
  }
  // 現在選択されているタブを取得
  public String getCurrentTab() {
    return currentTab;
  }
 }
