/*
 * Copyright(C) 2012 - 2013 orinos Co.,Ltd. All rights reserved.
 * http://www.orinos.co.jp/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.aimluck.eip.improveope;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

import com.aimluck.commons.field.ALDateTimeField;
import com.aimluck.commons.field.ALNumberField;
import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.cayenne.om.portlet.OriTImproveopeApplyAction;
import com.aimluck.eip.cayenne.om.portlet.OriTImproveopeApplyActionMap;
import com.aimluck.eip.common.ALData;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.fileupload.beans.FileuploadBean;
import com.aimluck.eip.improveope.util.ImproveopeApplyUtils;
import com.aimluck.eip.util.ALCommonUtils;
import com.aimluck.eip.util.ALEipUtils;

/**
 * 業務改善案申請のResultData <BR>
 *
 */
public class ImproveopeApplyResultData implements ALData {

  /** 申請 ID */
  private ALNumberField apply_id;

  /** 申請名 */
  private ALStringField apply_name;

  /** 所有者 ID */
  private ALNumberField owner_id;

  /** 所有者名 */
  private ALStringField owner_name;

  /** 新着フラグ */
  private boolean new_topic;

  /** メモ */
  private ALStringField note;

  /** ステータス */
  private ALStringField status;

  /** 返信数 */
  private ALNumberField reply_count;

  /** 登録者名 */
  private ALStringField create_user;

  /** 更新者名 */
  private ALStringField update_user;

  /** 登録日 */
  private ALDateTimeField create_date;

  /** 更新日 */
  private ALDateTimeField update_date;

  /** 添付ファイルリスト */
  private List<FileuploadBean> attachmentFileList = null;

  /** 提案者リスト */
  private List<ALEipUser> membersList = null;

  /** 実施要項 */
  private OriTImproveopeApplyAction apply_action;

  /** ログインユーザーID */
  private Integer login_user_id;


  /**
   *
   *
   */
  @Override
  public void initField() {
    apply_id = new ALNumberField();
    apply_name = new ALStringField();
    owner_id = new ALNumberField();
    owner_name = new ALStringField();

    note = new ALStringField();
    note.setTrim(false);
    status = new ALStringField();
    reply_count = new ALNumberField();
    create_user = new ALStringField();
    update_user = new ALStringField();
    create_date = new ALDateTimeField();
    update_date = new ALDateTimeField();

    attachmentFileList = new ArrayList<FileuploadBean>();

    new_topic = false;
  }

  /**
   * @return
   */
  public ALNumberField getApplyId() {
    return apply_id;
  }

  /**
   * @return
   */
  public String getApplyName() {
    return apply_name.toString();
  }

  public String getApplyNameHtml() {
    return ALCommonUtils.replaceToAutoCR(apply_name.toString());
  }

  /**
   * @param i
   */
  public void setApplyId(long i) {
	apply_id.setValue(i);
  }

  /**
   * @param string
   */
  public void setApplyName(String string) {
	apply_name.setValue(string);
  }

  /**
   * @param i
   */
  public void setOwnerId(long i) {
    owner_id.setValue(i);
  }

  /**
   * @return
   */
  public ALNumberField getOwnerId() {
    return owner_id;
  }

  public void setOwnerName(String string) {
    owner_name.setValue(string);
  }

  public ALStringField getOwnerName() {
    return owner_name;
  }

  public String getOwnerNameHtml() {
    return ALCommonUtils.replaceToAutoCR(owner_name.toString());
  }

  /**
   * @return
   */
  public String getNote() {
    return ALEipUtils.getMessageList(note.getValue());
  }

  /**
   * @param string
   */
  public void setNote(String string) {
    note.setValue(string);
  }

  /**
   * @return
   */
  public ALDateTimeField getCreateDate() {
    return ALEipUtils.getFormattedTime(create_date);
  }

  /**
   * @return
   */
  public ALDateTimeField getUpdateDate() {
    return ALEipUtils.getFormattedTime(update_date);
  }

  /**
   * @param string
   */
  public void setCreateDate(Date date) {
    create_date.setValue(date);
  }

  /**
   * @param string
   */
  public void setUpdateDate(Date date) {
    if (date == null) {
      return;
    }
    this.update_date.setValue(date);
  }

  public ALStringField getCreateUser() {
    return create_user;
  }

  public void setCreateUser(String str) {
    create_user.setValue(str);
  }

  public ALStringField getUpdateUser() {
    return update_user;
  }

  public void setUpdateUser(String str) {
    update_user.setValue(str);
  }

  public List<FileuploadBean> getAttachmentFileList() {
    return attachmentFileList;
  }

  public void setAttachmentFiles(List<FileuploadBean> list) {
    attachmentFileList = list;
  }

  public List<ALEipUser> getMembersList() {
	  return membersList;
  }

  public void setMembersList(List<ALEipUser> list) {
	  membersList = list;
  }

  public boolean isNew() {
    return new_topic;
  }

  public void setNewTopicFlag(boolean bool) {
    new_topic = bool;
  }

  public void setReplyCount(long count) {
    reply_count.setValue(count);
  }

  public ALNumberField getReplyCount() {
    return reply_count;
  }

  public void setLoginUserId(int id) {
	  login_user_id = id;
  }

  public Integer getLoginUserId() {
	  return login_user_id;
  }

  /**
   * @return
   */
  public String getStatus() {
    return status.toString();
  }

  public String getStatusValue() {
	  if (status.toString().equals(ImproveopeApplyUtils.APPLY_STATUS_CHECK)) {
		  return "評価中";
	  } else if (status.toString().equals(ImproveopeApplyUtils.APPLY_STATUS_ADOPT)) {
		  return "採用";
	  } else if (status.toString().equals(ImproveopeApplyUtils.APPLY_STATUS_REJECT)) {
		  return "却下";
	  } else {
		  return "申請中";
	  }
  }

  /**
   * @param string
   */
  public void setStatus(String string) {
	  status.setValue(string);
  }

  /**
   * 賛成数を取得する
   */
  public int getGoodCount() {
	  return ImproveopeApplyUtils.countCheck(
			  Integer.valueOf(apply_id.toString()),
			  ImproveopeApplyUtils.APPLY_ANSWER_GOOD);
  }

  /**
   * 反対数を取得する
   */
  public int getBadCount() {
	  return ImproveopeApplyUtils.countCheck(
			  Integer.valueOf(apply_id.toString()),
			  ImproveopeApplyUtils.APPLY_ANSWER_BAD);
  }

  /**
   * どちらでもない数を取得する
   */
  public int getNeitherCount() {
	  return ImproveopeApplyUtils.countCheck(
			  Integer.valueOf(apply_id.toString()),
			  ImproveopeApplyUtils.APPLY_ANSWER_NEITHER);
  }

  /**
   * 評価中か
   */
  public boolean hasApply() {
    if (status.toString().equals(ImproveopeApplyUtils.APPLY_STATUS_APPLY)) {
      return true;
    }
    return false;
  }
  /**
   * 評価が行われているか
   */
  public boolean hasCheck() {
	  if (status.toString().equals(ImproveopeApplyUtils.APPLY_STATUS_CHECK)
		|| ImproveopeApplyUtils.countCheck(Integer.valueOf(apply_id.toString())) > 0) {
		  return true;
	  }
	  return false;
  }
  /**
   * 評価中か
   */
  public boolean hasCheckTime() {
	  if (status.toString().equals(ImproveopeApplyUtils.APPLY_STATUS_CHECK)) {
		  return true;
	  }
	  return false;
  }
  /**
   * 採用されているか
   */
  public boolean hasAdopt() {
      if (status.toString().equals(ImproveopeApplyUtils.APPLY_STATUS_ADOPT)) {
        return true;
      }
      return false;
    }

  /**
   * 実施要項が登録されているか
   */
  public boolean hasAction() {
	  if (ImproveopeApplyUtils.countAction(Integer.valueOf(apply_id.toString())) > 0) {
		  return true;
	  }
	  return false;
  }

  /**
   * 実施要項を返す
   */
  public OriTImproveopeApplyAction getApplyAction() {
	  if (apply_action == null && hasAction()) {
  		try {
			apply_action = ImproveopeApplyUtils.getOriTImproveopeApplyAction(Integer.valueOf(apply_id.toString()));
  	    } catch (Exception ex) {
  	      return apply_action;
  	    }
		  return apply_action;
	  } else {
		  return apply_action;
  	  }
  }

  /**
   * 実施開始日を返す
   */
  public String getStartDateValue() {
	  OriTImproveopeApplyAction action = getApplyAction();
	  if (action != null) {
	      SimpleDateFormat format = new SimpleDateFormat("yyyy年M月dd日");
	      return format.format(action.getStartDate().getTime());
	  }
	  return "";
  }
  /**
   * 実施前かどうか
   */
  public boolean hasActionBeforStart() {
	  OriTImproveopeApplyAction action = getApplyAction();
	  if (action != null) {
	      Calendar now = Calendar.getInstance();
	      Date today = now.getTime();
	      Date start_date = action.getStartDate();

	      if (start_date.after(today)) {
	    	  return true;
	      }
	  }
	  return false;
  }

  /**
   * 実施終了日を返す
   */
  public String getEndDateValue() {
	  OriTImproveopeApplyAction action = getApplyAction();
	  if (action != null) {
	      SimpleDateFormat format = new SimpleDateFormat("yyyy年M月d日");
	      return format.format(action.getEndDate().getTime());
	  }
	  return "";
  }
  /**
   * 実施ステータスを返す
   */
  public String getActionStatusValue() {
	  OriTImproveopeApplyAction action = getApplyAction();
	  if (action != null) {
	      Calendar now = Calendar.getInstance();
	      Date today = now.getTime();
	      Date start_date = action.getStartDate();
	      Date end_date = action.getEndDate();

	      if (start_date.after(today)) {
	    	  return "実施前";
	      } else if (end_date.before(today)) {
	    	  return "終了";
	      } else {
	    	  return "実施中";
	      }
	  }
	  return "";
  }
  /**
   * 実施終了しているか
   */
  public boolean hasActionEnd() {
	  OriTImproveopeApplyAction action = getApplyAction();
	  if (action != null) {
	      Calendar now = Calendar.getInstance();
	      Date today = now.getTime();
	      Date end_date = action.getEndDate();

	      if (end_date.before(today)) {
	    	  return true;
	      }
	  }
	  return false;
  }
  /**
   * 実施対象者
   */
  public String getActionMemberListValue() {
	  OriTImproveopeApplyAction action = getApplyAction();
	  String member = "";
	  if (action != null) {
	      // 実施対象者
	      List<OriTImproveopeApplyActionMap> maps = ImproveopeApplyUtils.getOriTImproveopeApplyActionMap(action);
	      OriTImproveopeApplyActionMap map = null;
	      int size = maps.size();
	      int count = 0;
	      for (int i = 0; i < size; i++) {
	        map = maps.get(i);
	        if (i < 3 || map.getUserId().intValue() == login_user_id) {
	        	try {
		        	ALEipUser user = ALEipUtils.getALEipUser(map.getUserId().intValue());
		        	if (!member.equals("")) {
		        		member+="、";
		        	}
		        	member+= user.getAliasName().toString();
	            } catch (Exception e) {}
	        } else {
	        	count++;
	        }
	      }
	      if (count > 0) {
	    	  member+= "、、他"+String.valueOf(count) + "名";
	      }
	  }
	  return member;
  }
  /**
   * 実施報告が行われているか
   */
  public boolean hasReport() {
	  OriTImproveopeApplyAction action = getApplyAction();
	  if (action != null && action.getReportUserId() != null && Integer.valueOf(action.getReportUserId().toString()) > 0) {
	      return true;
	  }
	  return false;
  }
  /**
   * 自分自身（ログインユーザー）が報告可能かどうか
   */
  public boolean hasReportUser() {
	  OriTImproveopeApplyAction action = getApplyAction();
	  if (action != null) {
	      // 実施対象者
	      List<OriTImproveopeApplyActionMap> maps = ImproveopeApplyUtils.getOriTImproveopeApplyActionMap(action);
	      OriTImproveopeApplyActionMap map = null;
	      int size = maps.size();
	      for (int i = 0; i < size; i++) {
	        map = maps.get(i);
	        if (map.getUserId().intValue() == login_user_id) {
	        	return true;
	        }
	      }
	  }
	  return false;
  }

}
