/*
 * Copyright(C) 2012 - 2013 orinos Co.,Ltd. All rights reserved.
 * http://www.orinos.co.jp/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.aimluck.eip.exttimecard;

import com.aimluck.commons.field.ALDateTimeField;
import com.aimluck.commons.field.ALNumberField;
import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.common.ALData;

/**
 * 『役職』のResultDataです。 <br />
 */
public class ExtTimecardSystemPayrollSystemResultData implements ALData {

	/** ID **/
	private ALNumberField id;

	/** 給与体系CD **/
	private ALStringField payroll_system_cd;

	/** 給与体系名 **/
	private ALStringField payroll_system_name;

	/** 給与体系タイプ **/
	private ALStringField payroll_system_type;

	/** 作成者 */
	private ALStringField create_create_user;

	/** 作成時間 **/
	private ALDateTimeField create_date;

	/** 更新者 **/
	private ALStringField update_user;

	/** 更新時間 **/
	private ALDateTimeField update_date;

  /**
   *
   *
   */
  public void initField() {
	  id = new ALNumberField();
	  payroll_system_cd = new ALStringField();
	  payroll_system_name = new ALStringField();
	  payroll_system_type = new ALStringField();
	  create_create_user = new ALStringField();
	  create_date = new ALDateTimeField();
	  update_user = new ALStringField();
	  update_date = new ALDateTimeField();

  }

/**
 * @return id
 */
public ALNumberField getId() {
	return id;
}

/**
 * @return payroll_system_cd
 */
public ALStringField getPayrollSystemCd() {
	return payroll_system_cd;
}

/**
 * @return payroll_system_name
 */
public ALStringField getPayrollSystemName() {
	return payroll_system_name;
}

/**
 * @return payroll_system_type
 */
public ALStringField getPayrollSystemType() {
	return payroll_system_type;
}

/**
 * @return create_create_user
 */
public ALStringField getCreateCreateUser() {
	return create_create_user;
}

/**
 * @return create_date
 */
public ALDateTimeField getCreateDate() {
	return create_date;
}

/**
 * @return update_user
 */
public ALStringField getUpdateUser() {
	return update_user;
}

/**
 * @return update_date
 */
public ALDateTimeField getUpdateDate() {
	return update_date;
}

/**
 * @param id セットする id
 */
public void setId(int id) {
	this.id.setValue(id);
}

/**
 * @param payroll_system_cd セットする payroll_system_cd
 */
public void setPayrollSystemCd(String str) {
	this.payroll_system_cd.setValue(str);
}

/**
 * @param payroll_system_name セットする payroll_system_name
 */
public void setPayrollSystemName(String str) {
	this.payroll_system_name.setValue(str);
}

/**
 * @param payroll_system_type セットする payroll_system_type
 */
public void setPayrollSystemType(String str) {
	this.payroll_system_type.setValue(str);
}

/**
 * @param create_create_user セットする create_create_user
 */
public void setCreateCreateUser(String str) {
	this.create_create_user.setValue(str);
}

/**
 * @param create_date セットする create_date
 */
public void setCreateDate(String str) {
	this.create_date.setValue(str);
}

/**
 * @param update_user セットする update_user
 */
public void setUpdateUser(String str) {
	this.update_user.setValue(str);
}

/**
 * @param update_date セットする update_date
 */
public void setUpdateDate(String str) {
	this.update_date.setValue(str);
}




}
