/*
 * Copyright(C) 2012 - 2013 orinos Co.,Ltd. All rights reserved.
 * http://www.orinos.co.jp/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.aimluck.eip.exttimecard;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import com.aimluck.eip.cayenne.om.portlet.EipTTimecardSettings;
import com.aimluck.eip.common.ALData;
import com.aimluck.eip.exttimecard.util.ExtTimecardUtils;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.SelectQuery;

/**
 * 一日分のタイムカード(出勤・退勤の履歴)を保持する。<br>
 * 一日ごとの勤務時間・残業時間などを計算し、その結果を保持する。
 *
 * morimoto-junichi add 2012/10/10
 */
public class ExtTimecardApprovalResultData implements ALData {

  private List<ExtTimecardResultData> list = null;

  /** タイムカードのID */
  private int timecard_id;

  // 種類
  private String type;

  // 打刻時間
  private String punch_date;

  /** 出勤時間 */
  private String clock_in_time;

  /** 退勤時間 */
  private String clock_out_time;

  /** 理由 */
  private String reason;

  /** 連絡事項 */
  private String remarks;

  private String user_name;

  private String systemName;

  /** ステータス morimoto-junichi add 2012/10/09 */
  private String status = "";

  /** 時間有休 */
  private String used_time = "";

  /** 待機時間 */
  private String waiting_time = "";

  /** 当直 */
  private String watch_flag = "";

  /** 一人応援 */
  private String support_flag = "";

  /** 移動手当 */
  private String move_flag = "";

  /** 車出手当 */
  private String car_flag = "";

  /** 休日加算 */
  private String addholiday_flag = "";

  /** 休消手当 */
  private String subholiday_flag = "";

  /** 手当て（表示用） */
  private String allowance = "";

  /** 休憩時間 */
  private String break_time = "";

  /** 部署 */
  private String post_name = "";

  /** 役職 */
  private String position_name = "";

  /**
   *
   *
   */
  @Override
  public void initField() {

    // timecard_id = new ALStringField();
    // punch_date = new ALDateTimeField();
    // clock_in_time = new ALDateTimeField();
    // clock_out_time = new ALDateTimeField();
    // reason = new ALStringField();

    list = new ArrayList<ExtTimecardResultData>();
  }

  /**
   *
   * @param minute
   * @return
   */
  @SuppressWarnings("unused")
  private String minuteToHour(long minute) {
    BigDecimal decimal = new BigDecimal(minute / 60.0);
    DecimalFormat dformat = new DecimalFormat("##.#");
    String str =
      dformat.format(decimal.setScale(1, BigDecimal.ROUND_FLOOR).doubleValue());
    return str;
  }

  /**
   *
   * @return
   */
  public List<ExtTimecardResultData> getList() {
    return list;
  }

  public void setUserName(String user_name) {
    this.user_name = user_name;
  }

  public String getUserName() {
    return user_name;
  }

  public void setSystemName(String systemName) {
    this.systemName = systemName;
  }

  public String getSystemName() {
    return systemName;
  }

  /**
   *
   * @return
   */
  public List<ExtTimecardResultData> getViewList() {
    ArrayList<ExtTimecardResultData> viewlist =
      new ArrayList<ExtTimecardResultData>();

    ExtTimecardResultData rd = null;

    int size = list.size();
    for (int i = 0; i < size; i++) {
      rd = list.get(i);
      if (!ExtTimecardUtils.WORK_FLG_DUMMY.equals(rd.getWorkFlag().getValue())) {
        viewlist.add(rd);
      }
    }
    return viewlist;
  }

  /**
   *
   * @param rd
   */
  public void addExtTimecardResultData(ExtTimecardResultData rd) {
    list.add(rd);
  }

  /**
   * ExtTimecardResultDataオブジェクトのインスタンスを作る
   *
   * @param date
   * @param workflag
   * @return
   */
  @SuppressWarnings("unused")
  private ExtTimecardResultData createExtTimecardResultData(Date date,
      String workflag) {
    ExtTimecardResultData rd = new ExtTimecardResultData();
    rd.initField();
    rd.setWorkDate(date);
    rd.setWorkFlag(workflag);
    return rd;
  }

  /**
   * 勤務時間設定をDBから取得する
   *
   * @return
   */
  @SuppressWarnings("unused")
  private EipTTimecardSettings loadEipTTimecardSettings() {

    SelectQuery<EipTTimecardSettings> query =
      Database.query(EipTTimecardSettings.class);
    List<EipTTimecardSettings> aList = query.fetchList();
    if (aList != null && aList.size() > 0) {
      EipTTimecardSettings record = aList.get(0);
      return record;
    } else {
      return null;
    }
  }

  public String getType() {
	return type;
  }

  public void setType(String type) {
	this.type = type;
  }

/**
   * @return status
   */
  public String getStatus() {
    return status;
  }

  /**
   * @param status
   *          セットする status
   */
  public void setStatus(String str) {
    this.status = str;
  }

  /**
   * @return timecard_id
   */
  public int getTimecardId() {
    return timecard_id;
  }

  /**
   * @param timecard_id
   *          セットする timecard_id
   */
  public void setTimecardId(long i) {
    this.timecard_id = (int)i;
  }

  /**
   * @return punch_date
   */
  public String getPunchDate() {
    return this.punch_date;
  }

  /**
   * @param punch_date
   *          セットする punch_date
   */
  public void setPunchDate(String punch_date) {
    this.punch_date = punch_date;
  }

  /**
   * @return clock_in_time
   */
  public String getClockInTime() {
    return this.clock_in_time;
  }

  /**
   * @param clock_in_time
   *          セットする clock_in_time
   */
  public void setClockInTime(String clock_in_time) {
    this.clock_in_time = clock_in_time;
  }

  /**
   * @return clock_out_time
   */
  public String getClockOutTime() {
    return this.clock_out_time;
  }

  /**
   * @param clock_out_time
   *          セットする clock_out_time
   */
  public void setClockOutTime(String clock_out_time) {
    this.clock_out_time = clock_out_time;
  }

  /**
   * @return reason
   */
  public String getReason() {
    return this.reason;
  }

  /**
   * @param reason
   *          セットする reason
   */
  public void setReason(String reason) {
    this.reason = reason;
  }

public String getUsedTime() {
	return used_time;
}

public void setUsedTime(String used_time) {
	this.used_time = used_time;
}

public String getWaitingTime() {
	return waiting_time;
}

public void setWaitingTime(String waiting_time) {
	this.waiting_time = waiting_time;
}

public String getWatchFlag() {
	return watch_flag;
}

public void setWatchFlag(String watch_flag) {
	this.watch_flag = watch_flag;
}

public String getSupportFlag() {
	return support_flag;
}

public void setSupportFlag(String support_flag) {
	this.support_flag = support_flag;
}

public String getMoveFlag() {
	return move_flag;
}

public void setMoveFlag(String move_flag) {
	this.move_flag = move_flag;
}

public String getCarFlag() {
	return car_flag;
}

public void setCarFlag(String car_flag) {
	this.car_flag = car_flag;
}

public String getAllowance() {
	return allowance;
}

public void setAllowance(String allowance) {
	this.allowance = allowance;
}

public String getRemarks() {
	return remarks;
}

public void setRemarks(String remarks) {
	this.remarks = remarks;
}

public String getBreakTime() {
	return break_time;
}

public void setBreakTime(String time) {
	this.break_time = time;
}

public String getPostName() {
	return post_name;
}

public void setPostName(String post_name) {
	this.post_name = post_name;
}

public String getPositionName() {
	return position_name;
}

public void setPositionName(String position_name) {
	this.position_name = position_name;
}

public String getAddholidayFlag() {
	return addholiday_flag;
}

public void setAddholidayFlag(String flag) {
	this.addholiday_flag = flag;
}

public String getSubholidayFlag() {
	return subholiday_flag;
}

public void setSubholidayFlag(String flag) {
	this.subholiday_flag = flag;
}

}
