/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * Copyright (C) 2004-2011 Aimluck,Inc.
 * http://www.aipo.com
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.aimluck.eip.modules.screens;

import java.io.IOException;

import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.resources.JetspeedResources;
import org.apache.jetspeed.services.security.LoginException;
import org.apache.jetspeed.util.template.JetspeedLink;
import org.apache.jetspeed.util.template.JetspeedLinkFactory;
import org.apache.turbine.util.DynamicURI;
import org.apache.turbine.util.RunData;
import org.apache.turbine.util.TurbineException;
import org.apache.velocity.context.Context;

import com.aimluck.eip.account.util.AccountUtils;
import com.aimluck.eip.cayenne.om.security.TurbineUser;
import com.aimluck.eip.modules.actions.ALJLoginUser;
import com.aimluck.eip.util.ALEipUtils;

/**
 * 代理ログインを処理するクラスです。 <br />
 *
 */
public class AccountUserReLoginScreen extends ALVelocityScreen {

  /** logger */
  private static final JetspeedLogger logger = JetspeedLogFactoryService
    .getLogger(AccountUserReLoginScreen.class.getName());

  /**
   *
   * @param rundata
   * @param context
   * @throws Exception
   */
  @Override
  protected void doOutput(RunData rundata, Context context) throws Exception {
    try {
      try {
        // 代理ログイン
        String username = rundata.getParameters().getString("entityid");
        TurbineUser turbineuser = ALEipUtils.getTurbineUser(username);
        ALJLoginUser login = new ALJLoginUser();
        rundata.getParameters().add("username", username);
        rundata.getParameters().add("password", turbineuser.getPasswordValue());
        login.doPerform(rundata);

        // ホームリダイレクト
        JetspeedLink jsLink = JetspeedLinkFactory.getInstance(rundata);
        DynamicURI uri = jsLink.getLink(JetspeedLink.USER, username, "default.psml", JetspeedLink.DEFAULT, "");
        rundata.setRedirectURI(uri
        		.addQueryData(JetspeedResources.PATH_ACTION_KEY,"controls.Restore")
            		.toString());
        	rundata.getResponse().sendRedirect(rundata.getRedirectURI());

      } catch (IOException e) {
        // TODO 自動生成された catch ブロック
        e.printStackTrace();
      } catch (LoginException e) {
        // TODO 自動生成された catch ブロック
        e.printStackTrace();
      } catch (TurbineException e) {
        // TODO 自動生成された catch ブロック
        e.printStackTrace();
      } catch (Exception e) {
        // TODO 自動生成された catch ブロック
        e.printStackTrace();
      }
    } catch (Exception ex) {
      logger.error("[AccountUserDetailScreen] Exception.", ex);
      ALEipUtils.redirectDBError(rundata);
    }
  }

  /**
   * @return
   */
  @Override
  protected String getPortletName() {
    return AccountUtils.ACCOUNT_PORTLET_NAME;
  }

}
