/*
 *	epgrec channel form assist
 *	フォームのチャンネルをキー入力で選択可能に
 * 	チャンネルフォームがフォーカス状態の時、
 * 	チャンネル名の頭文字を入力することで
 *		次の候補チャンネルを選択します
 *		shiftキーを押している場合は前の候補チャンネルを選択
 *
 * Version 0.1
 * 18:04 2012/02/22
 *
 * Author : osamu - atelier TRUMPHOUSE
 *
 */


var ER_sub = ER_sub || {};
ER_sub.FRM ={
	// ひらがなカタカタ
	Astr : {
		a : 'あいうえおアイウエオ',
		i : 'いイ', u : 'うウ', e : 'えエ', o : 'おオ',
		k : 'かきくけこカキクケコがぎぐげごガギギゲゴ',
		g : 'がぎぐげごガギギゲゴ',
		s : 'さしすせそサシスセソざじずぜぞザジズゼゾ',
		z : 'ざじずぜぞザジズゼゾ',
		t : 'たちつてとタチツテトだぢづでどダヂヅデド',
		d : 'だぢづでどダヂヅデド',
		n : 'なにぬねのナニヌネノ',
		h : 'はひふへほハヒフヘホぱぴぷぺぽパピプペポばびぶべぼバビブベボ',
		p : 'ぱぴぷぺぽパピプペポ',
		b : 'ばびぶべぼバビブベボ',
		m : 'まみむめもマミムメモ',
		y : 'やゆよヤユヨ',
		r : 'らりるれろラリルレロ',
		w : 'わワ'
	},
	// 漢字等
	Kstr : {a : '朝衛',e : '衛', h : '放', n : '日', t : '東宝', y : '洋', j : '時'},
	// エイリアス
	Xstr : {f : 'h', j : 'z', l : 'r'},
	key_is : function(key, str) {
		if (!key && !str) {return false;}
		key = String.fromCharCode(key).toLowerCase();
		str = ER_sub.STR.toHan(str[0]).toLowerCase();
		if ( key == str ) { return true;}
		if ( this.Xstr[key] != undefined ) { key = this.Xstr[key];}
		if ( this.Astr[key] != undefined && this.Astr[key].indexOf(str) > -1 ){ return true;}
		if ( this.Kstr[key] != undefined && this.Kstr[key].indexOf(str) > -1 ){ return true;}
	}
}

ER_sub.STR ={
	Zstr : '０１２３４５６７８９ａｂｃｄｅｆｇｈｉｊｋｌｍｎｏｐｑｒｓｔｕｖｗｘｙｚＡＢＣＤＥＦＧＨＩＪＫＬＭＮＯＰＱＲＳＴＵＶＷＸＹＺ',
	Hstr : '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ',
	toHan : function (str) {
		var i,iMax,T,N='';
		for (i = 0, iMax = str.length; i < iMax; i++) {
			T = this.Zstr.indexOf(str[i]);
			if (T > -1) { N += this.Hstr[T];
			} else { N += str[i];}
		}
		return N;
	}
}


$(document).ready(function () {
	var $st_tg = $('select[name=station]');
	$st_tg.focus(function(){
		$st_tg .bind('keydown', (function(ev){
			if (ER_sub.STR.Hstr.indexOf(String.fromCharCode(ev.keyCode)) < 0) {
				return ;
			}
			var S = $('select[name=station] option:selected'),
			select, i=0,iMax=$st_tg.find('option').length;
			while (!select) {
				if ( ev.shiftKey ){
					if (S.prevAll().length == 1) {
						S = $st_tg.find('option:eq('+(iMax-1)+')');
					} else {
						S = S.prev();
					}
				} else {
					if (S.prevAll().length == iMax-1) {
						S = $st_tg.find('option:eq(1)');
					} else {
						S = S.next();
					}
				}
				if ( ER_sub.FRM.key_is(ev.keyCode, S.html()) ){
					select = S;
				} else {
					i++;
					if ( i == iMax -1 ) {
						select = S;
					}
				}
			}
			$st_tg.val(S.attr('value'));
		}));
	}).blur(function(){
		$st_tg .unbind('keydown');
	});
});

