/*
 * Decompiled with CFR 0.152.
 */
package saccubus.net;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.regex.Pattern;
import javax.net.ssl.HttpsURLConnection;
import javax.swing.JLabel;
import saccubus.ConvertStopFlag;
import saccubus.MyDateFormat;

public class NicoClient {
    private final String User;
    private final String Pass;
    private boolean Logged_in = false;
    private final ConvertStopFlag StopFlag;
    private final Proxy ConProxy;
    private boolean Debug = false;
    private static final String DEBUG_PROXY = "debug/";
    private String Cookie = null;
    private static Pattern safeFileName_SPACE = Pattern.compile(" {2}+");
    private String VideoTitle = null;
    private int VideoLength = -1;
    private static final String TITLE_PARSE_STR_START = "<title>";
    private static final String TITLE_END = "\u2010";
    private boolean NeedsKey = false;
    private byte[] buf = new byte[0x400000];
    private String VideoUrl = null;
    private String UserID = null;
    private String ThreadID = null;
    private String MsgUrl = null;
    private static final String STR_OWNER_COMMENT = "500";
    private String threadKey = null;
    private String force184 = null;
    private String WayBackKey = "0";
    private String WayBackTime = "0";
    private static final String WAYBACKKEY_STR = "waybackkey=";
    private int dsCount = 0;
    private int dsMax;
    private int dsMin;
    private int dsSum;

    public NicoClient(String user, String pass, ConvertStopFlag flag, String proxy, int proxy_port) {
        this.User = user;
        this.Pass = pass;
        this.StopFlag = flag;
        if (proxy != null && proxy.startsWith(DEBUG_PROXY)) {
            System.out.println("Print debug information.");
            this.Debug = true;
            proxy = proxy.substring(DEBUG_PROXY.length());
        }
        if (proxy != null && proxy.length() > 0 && proxy_port >= 0 && proxy_port <= 65535) {
            Proxy tmpProxy;
            try {
                tmpProxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxy, proxy_port));
            }
            catch (Exception ex) {
                System.out.println("Unable to make Proxy. maybe bug.");
                ex.printStackTrace();
                this.ConProxy = null;
                return;
            }
            this.ConProxy = tmpProxy;
        } else {
            this.ConProxy = Proxy.NO_PROXY;
        }
        this.Logged_in = this.login();
    }

    private void debug(String messege) {
        if (this.Debug) {
            System.out.print(messege);
        }
    }

    private HttpURLConnection reqConnectionGet(String url) {
        try {
            this.debug("\n\u25a0URL<" + url + ">\n");
            HttpURLConnection con = (HttpURLConnection)new URL(url).openConnection(this.ConProxy);
            this.debug("\u25a0Connect: GET,Cookie<" + this.Cookie + ">,DoInput,Connection close\n");
            con.setRequestMethod("GET");
            con.addRequestProperty("Cookie", this.Cookie);
            con.addRequestProperty("Connection", "close");
            con.setDoInput(true);
            con.connect();
            this.debug("\u25a0Response:" + Integer.toString(con.getResponseCode()) + " " + con.getResponseMessage() + "\n");
            if (con.getResponseCode() == 200) {
                return con;
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        catch (IllegalStateException ex) {
            ex.printStackTrace();
        }
        return null;
    }

    private String readConnection(HttpURLConnection con) {
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(con.getInputStream()));
            String ret = br.readLine();
            br.close();
            this.debug("\u25a0readLine:" + ret + "\n");
            con.disconnect();
            return ret;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return "";
        }
    }

    private String detectCookie(HttpURLConnection con) {
        String key;
        String cookie = null;
        int i = 1;
        while ((key = con.getHeaderFieldKey(i)) != null) {
            String value = con.getHeaderField(i);
            this.debug("\u25a0header(" + i + ")<" + key + "><" + value + ">\n");
            if (key.equalsIgnoreCase("Set-Cookie") && (value = con.getHeaderField(i)) != null) {
                cookie = value.substring(0, value.indexOf(";"));
            }
            ++i;
        }
        this.debug("\u25a0set-cookie<" + cookie + ">\n");
        return cookie;
    }

    private boolean login() {
        block5: {
            HttpsURLConnection con;
            block4: {
                try {
                    System.out.print("Trying login...");
                    con = (HttpsURLConnection)new URL("https://secure.nicovideo.jp/secure/login?site=niconico").openConnection(this.ConProxy);
                    this.debug("\n\u25a0connection<" + con.toString() + ">\n");
                    con.setDoOutput(true);
                    HttpURLConnection.setFollowRedirects(false);
                    con.setInstanceFollowRedirects(false);
                    con.setRequestMethod("POST");
                    con.addRequestProperty("Connection", "close");
                    this.debug("\u25a0connect: POST,DoOuput,Connection close,FollowRedirects false\n");
                    con.connect();
                    StringBuffer sb = new StringBuffer(4096);
                    sb.append("next_url=&");
                    sb.append("mail=");
                    sb.append(URLEncoder.encode(this.User, "Shift_JIS"));
                    sb.append("&password=");
                    sb.append(URLEncoder.encode(this.Pass, "Shift_JIS"));
                    sb.append("&submit.x=103&submit.y=16");
                    this.debug("\u25a0write:" + sb.toString() + "\n");
                    OutputStream os = con.getOutputStream();
                    os.write(sb.substring(0).getBytes());
                    os.flush();
                    os.close();
                    this.debug("\u25a0Response:" + Integer.toString(con.getResponseCode()) + " " + con.getResponseMessage() + "\n");
                    int code = con.getResponseCode();
                    if (code >= 200 && code < 400) break block4;
                    System.out.println("Can't login:" + con.getResponseMessage());
                    return false;
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                    return false;
                }
            }
            this.Cookie = this.detectCookie(con);
            con.disconnect();
            if (this.Cookie != null) break block5;
            System.out.println("Can't login: cannot set cookie.");
            return false;
        }
        System.out.println("Logged in.");
        return true;
    }

    public boolean isLoggedIn() {
        return this.Logged_in;
    }

    public String getVideoTitle() {
        return this.VideoTitle;
    }

    private static String safeFileName(String str) {
        int old_index = 0;
        int new_index = 0;
        StringBuffer sb = new StringBuffer();
        while ((new_index = str.indexOf("&#", old_index)) >= 0) {
            sb.append(str, old_index, new_index);
            old_index = str.indexOf(";", new_index);
            String ch = str.substring(new_index + 2, old_index);
            sb.append(new String(new char[]{(char)Integer.parseInt(ch)}));
            ++old_index;
        }
        sb.append(str, old_index, str.length());
        str = sb.toString();
        str = str.replace('/', '\uff0f');
        str = str.replace('\\', '\uffe5');
        str = str.replace('?', '\uff1f');
        str = str.replace('*', '\uff0a');
        str = str.replace(':', '\uff1a');
        str = str.replace('|', '\uff5c');
        str = str.replace('\"', '\u201d');
        str = str.replace('<', '\uff1c');
        str = str.replace('>', '\uff1e');
        str = str.replace('.', '\uff0e');
        str = safeFileName_SPACE.matcher(str).replaceAll(" ");
        str = str.trim();
        return str;
    }

    public boolean getVideoHistoryAndTitle(String tag) {
        String new_cookie;
        block6: {
            HttpURLConnection con;
            block5: {
                String url = "http://www.nicovideo.jp/watch/" + tag;
                System.out.print("Getting video history...");
                con = this.reqConnectionGet(url);
                if (con != null) break block5;
                System.out.println("ng.\nCan't getVideoHistory:" + url);
                return false;
            }
            try {
                String ret;
                new_cookie = this.detectCookie(con);
                BufferedReader br = new BufferedReader(new InputStreamReader(con.getInputStream(), "UTF-8"));
                System.out.print("ok.\nCheking VideoTitle...");
                this.debug("\n");
                int index = -1;
                while ((ret = br.readLine()) != null) {
                    this.debug("\u25a0readLine(UTF-8):" + ret + "\n");
                    index = ret.indexOf(TITLE_PARSE_STR_START);
                    if (index < 0) continue;
                    this.VideoTitle = NicoClient.safeFileName(ret.substring(index + TITLE_PARSE_STR_START.length(), ret.lastIndexOf(TITLE_END)));
                    break;
                }
                br.close();
                con.disconnect();
                if (new_cookie != null) break block6;
                System.out.println("ng.\nCan't getVideoHistory: cannot get cookie.");
                return false;
            }
            catch (IOException ex) {
                ex.printStackTrace();
                return false;
            }
        }
        System.out.println("ok.");
        this.Cookie = String.valueOf(this.Cookie) + "; ";
        this.Cookie = String.valueOf(this.Cookie) + new_cookie;
        return true;
    }

    public boolean getVideoInfo(String tag, String time) {
        block28: {
            String ret;
            block27: {
                HttpURLConnection con;
                block26: {
                    if (!this.getVideoHistoryAndTitle(tag)) {
                        return false;
                    }
                    String url = "http://flapi.nicovideo.jp/api/getflv/" + tag;
                    if (tag.startsWith("nm")) {
                        url = String.valueOf(url) + "?as3=1";
                    }
                    System.out.print("Getting video informations...");
                    con = this.reqConnectionGet(url);
                    if (con != null) break block26;
                    System.out.println("ng.\nCan't getVideoInfo:" + url);
                    return false;
                }
                ret = this.readConnection(con);
                if (ret != null && !ret.equals("")) break block27;
                System.out.println("ng.\nCan't getVideoInfo: null respense.");
                return false;
            }
            try {
                String[] array = ret.split("&");
                if (this.Debug) {
                    int i = 0;
                    while (i < array.length) {
                        String a = URLDecoder.decode(array[i], "UTF-8");
                        if (a.indexOf(37) >= 0) {
                            a = "DoubleDecode\u25a0" + URLDecoder.decode(a, "UTF-8");
                        }
                        this.debug("\u25a0array_UTF-8(" + i + ")" + a + "\n");
                        ++i;
                    }
                }
                ret = URLDecoder.decode(ret, "Shift_JIS");
                this.debug("\u25a0Decoded(Shift_JIS):" + ret + "\n");
                array = ret.split("&");
                int cnt = 0;
                int i = 0;
                while (i < array.length) {
                    int idx = array[i].indexOf("=");
                    if (idx >= 0) {
                        String key = array[i].substring(0, idx);
                        String value = array[i].substring(idx + 1);
                        if (this.ThreadID == null && key.equalsIgnoreCase("thread_id")) {
                            this.ThreadID = value;
                            ++cnt;
                        } else if (this.VideoUrl == null && key.equalsIgnoreCase("url")) {
                            this.VideoUrl = value;
                            ++cnt;
                        } else if (this.MsgUrl == null && key.equalsIgnoreCase("ms")) {
                            this.MsgUrl = value;
                            ++cnt;
                        } else if (this.UserID == null && key.equalsIgnoreCase("user_id")) {
                            this.UserID = value;
                            ++cnt;
                        } else if (key.equalsIgnoreCase("needs_key")) {
                            this.NeedsKey = true;
                        } else if (this.VideoLength < 0 && key.equalsIgnoreCase("l")) {
                            try {
                                this.VideoLength = Integer.parseInt(value);
                            }
                            catch (NumberFormatException e) {
                                this.VideoLength = -1;
                            }
                        }
                    }
                    ++i;
                }
                if (cnt >= 4) break block28;
                System.out.println("ng.\nCan't get video information keys.");
                return false;
            }
            catch (IOException ex) {
                ex.printStackTrace();
                return false;
            }
        }
        System.out.println("ok.");
        System.out.println("Video:<" + this.VideoUrl + ">; Comment:<" + this.MsgUrl + (this.NeedsKey ? ">; needs_key=1" : ">"));
        System.out.println("Video time length: " + this.VideoLength + "sec");
        System.out.println("ThreadID:<" + this.ThreadID + "> Uploaded on " + MyDateFormat.formatTime(this.ThreadID));
        if (time != null && !time.equals("") && !this.getWayBackKey(time)) {
            System.out.println("It may be wrong Date.");
        }
        return true;
    }

    public File getVideo(File file, JLabel status) {
        try {
            System.out.print("Getting video size...");
            if (this.VideoUrl == null) {
                System.out.println("Video url is not detected.");
                return null;
            }
            if (file.canRead()) {
                file.delete();
            }
            HttpURLConnection con = (HttpURLConnection)new URL(this.VideoUrl).openConnection(this.ConProxy);
            this.debug("\n\u25a0connection<" + con.toString() + ">\n");
            this.debug("\u25a0connect: GET,Cookie<" + this.Cookie + ">,DoInput\n");
            con.setDoInput(true);
            con.setRequestMethod("GET");
            con.addRequestProperty("Cookie", this.Cookie);
            con.connect();
            this.debug("\u25a0Response:" + Integer.toString(con.getResponseCode()) + " " + con.getResponseMessage() + "\n");
            if (con.getResponseCode() != 200) {
                System.out.println("Can't get video:" + this.VideoUrl);
                return null;
            }
            InputStream is = con.getInputStream();
            FileOutputStream os = new FileOutputStream(file);
            String content_length_str = con.getHeaderField("Content-length");
            int max_size = 0;
            if (content_length_str != null && !content_length_str.equals("")) {
                max_size = Integer.parseInt(content_length_str);
            }
            int size = 0;
            System.out.println("size=" + max_size / 1000 + "Kbytes");
            System.out.print("Downloading video...");
            int read = 0;
            this.debugsInit();
            while ((read = is.read(this.buf, 0, this.buf.length)) > 0) {
                this.debugsAdd(read);
                ((OutputStream)os).write(this.buf, 0, read);
                this.sendStatus(status, "\u52d5\u753b", max_size, size += read);
                if (!this.StopFlag.needStop()) continue;
                System.out.println("\nStopped.");
                is.close();
                os.flush();
                ((OutputStream)os).close();
                con.disconnect();
                if (file.delete()) {
                    System.out.println("video deleted.");
                }
                return null;
            }
            System.out.println("ok.");
            is.close();
            os.flush();
            ((OutputStream)os).close();
            con.disconnect();
            File file2 = file;
            return file2;
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            this.debug("\u25a0read+write statistics(bytes) ");
            this.debugsOut();
        }
        return null;
    }

    public File getComment(File file, JLabel status, String back_comment) {
        return this.downloadComment(file, status, back_comment, false);
    }

    public File getOwnerComment(File file, JLabel status) {
        return this.downloadComment(file, status, STR_OWNER_COMMENT, true);
    }

    private File downloadComment(File file, JLabel status, String back_comment, boolean isOwnerComment) {
        System.out.print("Downloading " + (isOwnerComment ? "owner " : "") + "comment size:" + back_comment + "...");
        String official = "";
        if (this.NeedsKey) {
            if (!(this.force184 != null && this.threadKey != null || this.getOfficialOption(this.ThreadID))) {
                return null;
            }
            official = "force_184=\"" + this.force184 + "\" threadkey=\"" + this.threadKey + "\" ";
        }
        try {
            if (file.canRead()) {
                file.delete();
            }
            FileOutputStream fos = new FileOutputStream(file);
            HttpURLConnection con = (HttpURLConnection)new URL(this.MsgUrl).openConnection(this.ConProxy);
            this.debug("\n\u25a0connection<" + con.toString() + ">\n");
            this.debug("\u25a0connect: POST,Cookie<" + this.Cookie + ">,DoInput,DoOutput,Connection close\n");
            con.setDoOutput(true);
            con.setDoInput(true);
            con.setRequestMethod("POST");
            con.addRequestProperty("Cookie", this.Cookie);
            con.addRequestProperty("Connection", "close");
            con.connect();
            OutputStream os = con.getOutputStream();
            String req = isOwnerComment ? "<thread user_id=\"" + this.UserID + "\" when=\"0\" waybackkey=\"0" + "\" res_from=\"-" + back_comment + "\" version=\"20061206\" thread=\"" + this.ThreadID + "\" fork=\"1\"  " + official + "/>" : "<thread user_id=\"" + this.UserID + "\" when=\"" + this.WayBackTime + "\" waybackkey=\"" + this.WayBackKey + "\" res_from=\"-" + back_comment + "\" version=\"20061206\" thread=\"" + this.ThreadID + "\" " + official + "/>";
            this.debug("\u25a0write:" + req + "\n");
            os.write(req.getBytes());
            os.flush();
            os.close();
            this.debug("\u25a0Response:" + Integer.toString(con.getResponseCode()) + " " + con.getResponseMessage() + "\n");
            if (con.getResponseCode() != 200) {
                System.out.println("ng.\nCan't download comment:" + this.MsgUrl);
                return null;
            }
            InputStream is = con.getInputStream();
            int read = 0;
            int max_size = 0;
            String content_length_str = con.getHeaderField("Content-length");
            if (content_length_str != null && !content_length_str.equals("")) {
                max_size = Integer.parseInt(content_length_str);
            }
            int size = 0;
            String dlmsg = String.valueOf(isOwnerComment ? "\u6295\u7a3f\u8005" : "") + "\u30b3\u30e1\u30f3\u30c8\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9";
            this.debugsInit();
            while ((read = is.read(this.buf, 0, this.buf.length)) > 0) {
                this.debugsAdd(read);
                ((OutputStream)fos).write(this.buf, 0, read);
                this.sendStatus(status, dlmsg, max_size, size += read);
                if (!this.StopFlag.needStop()) continue;
                System.out.println("\nStopped.");
                is.close();
                os.flush();
                os.close();
                con.disconnect();
                if (file.delete()) {
                    System.out.println("comment deleted.");
                }
                return null;
            }
            System.out.println("ok.");
            is.close();
            fos.flush();
            ((OutputStream)fos).close();
            con.disconnect();
            File file2 = file;
            return file2;
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            this.debug("\u25a0read+write statistics(bytes) ");
            this.debugsOut();
        }
        return null;
    }

    private boolean getOfficialOption(String threadId) {
        String url = "http://flapi.nicovideo.jp/api/getthreadkey?thread=" + threadId;
        System.out.print("\nGetting Official options (threadkey)...");
        if (this.force184 != null && this.threadKey != null) {
            System.out.println("ok. But this call twice, not necessary.");
            return true;
        }
        HttpURLConnection con = this.reqConnectionGet(url);
        if (con == null) {
            System.out.println("ng.\nCan't get Oficial option:" + url);
            return false;
        }
        String ret = this.readConnection(con);
        if (ret == null || ret.equals("")) {
            System.out.println("ng.\nNull response.");
            return false;
        }
        String[] array = ret.split("&");
        int i = 0;
        while (i < array.length) {
            this.debug("\u25a0array(" + i + ")" + array[i] + "\n");
            ++i;
        }
        i = 0;
        while (i < array.length) {
            int idx = array[i].indexOf("=");
            if (idx >= 0) {
                String key = array[i].substring(0, idx);
                String value = array[i].substring(idx + 1);
                if (this.threadKey == null && key.equalsIgnoreCase("threadkey")) {
                    this.threadKey = value;
                } else if (this.force184 == null && key.equalsIgnoreCase("force_184")) {
                    this.force184 = value;
                }
            }
            ++i;
        }
        if (this.threadKey == null || this.force184 == null) {
            System.out.println("ng.\nCan't get Oficial option.");
            System.out.println("\nret: " + ret);
            return false;
        }
        System.out.print("ok...");
        return true;
    }

    private boolean getWayBackKey(String time) {
        System.out.print("Setting wayback time...");
        if (!this.WayBackKey.equals("0")) {
            System.out.println("ok. But this call twice, not necessary.");
            return true;
        }
        MyDateFormat mdf = new MyDateFormat();
        if (!mdf.makeTime(time)) {
            System.out.println("ng.\nCannot parse time.\"" + time + "\"");
            return false;
        }
        String waybacktime = mdf.getWayBackTime();
        System.out.println("ok.(" + mdf.formatDate() + "): " + waybacktime);
        System.out.print("Getting wayback key...");
        String url = "http://flapi.nicovideo.jp/api/getwaybackkey?thread=" + this.ThreadID;
        HttpURLConnection con = this.reqConnectionGet(url);
        if (con == null) {
            System.out.println("ng.\nCan't get wayback key:" + url);
            return false;
        }
        String ret = this.readConnection(con);
        int idx = 0;
        if (ret == null || (idx = ret.indexOf(WAYBACKKEY_STR)) < 0) {
            System.out.println("ng.\nCannot find wayback key from response.");
            return false;
        }
        String waybackkey = ret.substring(idx + WAYBACKKEY_STR.length());
        if ((idx = waybackkey.indexOf("&")) >= 0) {
            waybackkey = waybackkey.substring(0, idx);
        }
        if (waybackkey == null || waybackkey.equals("")) {
            System.out.println("ng.\nCannot get wayback key.");
            return false;
        }
        System.out.println("ok.\nwayback key: " + waybackkey);
        this.WayBackTime = waybacktime;
        this.WayBackKey = waybackkey;
        return true;
    }

    public String getBackCommentFromLength(String def) {
        if (this.VideoLength < 0) {
            return def;
        }
        if (this.VideoLength < 600) {
            return Integer.toString((this.VideoLength + 59) / 60 * 100);
        }
        return "1000";
    }

    private void debugsInit() {
        if (!this.Debug) {
            return;
        }
        this.dsSum = 0;
        this.dsMax = 0;
        this.dsCount = 0;
        this.dsMin = Integer.MAX_VALUE;
    }

    private void debugsAdd(int data) {
        if (!this.Debug) {
            return;
        }
        ++this.dsCount;
        this.dsSum += data;
        this.dsMax = Math.max(this.dsMax, data);
        this.dsMin = Math.min(this.dsMin, data);
    }

    private void debugsOut() {
        if (!this.Debug) {
            return;
        }
        if (this.dsCount == 0) {
            System.out.println("Count 0");
        } else {
            System.out.print("Count " + this.dsCount + ", Min " + this.dsMin + ", Max " + this.dsMax);
            System.out.println(", Sum " + this.dsSum + ", Avg " + this.dsSum / this.dsCount);
        }
    }

    private void sendStatus(JLabel status, String msg, int max_size, int size) {
        if (max_size != 0) {
            String per = Double.toString((double)size * 100.0 / (double)max_size);
            per = per.substring(0, Math.min(per.indexOf(".") + 3, per.length()));
            status.setText(String.valueOf(msg) + "\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9\uff1a" + per + "\u30d1\u30fc\u30bb\u30f3\u30c8\u5b8c\u4e86");
        } else {
            status.setText(String.valueOf(msg) + "\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9\u4e2d\uff1a" + Integer.toString(size >> 10) + "kbytes\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9");
        }
    }
}

