/*
 * Decompiled with CFR 0.152.
 */
package saccubus.conv;

import java.util.regex.Pattern;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;
import saccubus.conv.Chat;
import saccubus.conv.Packet;

public class NicoXMLReader
extends DefaultHandler {
    private final Packet nicopacket;
    private Chat item;
    private boolean item_kicked;
    Object waitObject = new Object();
    private final Pattern NG_Word;
    private final Pattern NG_ID;
    private boolean item_fork;

    public NicoXMLReader(Packet packet, String ng_id, String ng_word) {
        this.nicopacket = packet;
        this.NG_Word = NicoXMLReader.makePattern(ng_word);
        this.NG_ID = NicoXMLReader.makePattern(ng_id);
    }

    private static final Pattern makePattern(String word) {
        Pattern pat;
        if (word == null || word.length() <= 0) {
            return null;
        }
        String[] tmp = word.split(" ");
        String[] tmp2 = new String[tmp.length];
        int tmp_index = 0;
        int index = 0;
        while (index < tmp.length && tmp_index < tmp.length) {
            String str;
            if (tmp[tmp_index].startsWith("/")) {
                str = tmp[tmp_index];
                ++tmp_index;
                while (tmp_index < tmp.length) {
                    str = String.valueOf(str) + " " + tmp[tmp_index];
                    if (tmp[tmp_index].endsWith("/")) {
                        ++tmp_index;
                        break;
                    }
                    ++tmp_index;
                }
                tmp2[index] = str;
            } else if (tmp[tmp_index].startsWith("\"")) {
                str = tmp[tmp_index];
                ++tmp_index;
                while (tmp_index < tmp.length) {
                    str = String.valueOf(str) + " " + tmp[tmp_index];
                    if (tmp[tmp_index].endsWith("\"")) {
                        ++tmp_index;
                        break;
                    }
                    ++tmp_index;
                }
                tmp2[index] = str;
            } else {
                tmp2[index] = tmp[tmp_index];
                ++tmp_index;
            }
            ++index;
        }
        String[] elt = new String[index];
        int i = 0;
        while (i < index) {
            elt[i] = tmp2[i];
            ++i;
        }
        String reg = "";
        int i2 = 0;
        while (i2 < elt.length) {
            String e = elt[i2];
            System.out.println(e);
            if (i2 > 0) {
                reg = String.valueOf(reg) + "|";
            }
            reg = e.length() > 1 && e.indexOf("/") == 0 && e.lastIndexOf("/") == e.length() - 1 ? String.valueOf(reg) + "(" + e.substring(1, e.length() - 1) + ")" : (e.length() > 1 && e.indexOf("\"") == 0 && e.lastIndexOf("\"") == e.length() - 1 ? String.valueOf(reg) + "(" + Pattern.quote(e.substring(1, e.length() - 1)) + ")" : String.valueOf(reg) + "(.*(" + Pattern.quote(e) + ")+.*)");
            ++i2;
        }
        System.out.println("reg:" + reg);
        try {
            pat = Pattern.compile(reg);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            pat = Pattern.compile(reg, 128);
        }
        return pat;
    }

    private static final boolean match(Pattern pat, String word) {
        if (word == null || word.length() <= 0 || pat == null) {
            return false;
        }
        return pat.matcher(word).matches();
    }

    @Override
    public void startDocument() {
        System.out.println("Start converting to internal file.");
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        if (qName.toLowerCase().equals("chat")) {
            this.item = new Chat();
            this.item_kicked = false;
            this.item_fork = false;
            String deleted = attributes.getValue("deleted");
            if (deleted != null && deleted.toLowerCase().equals("1")) {
                this.item_kicked = true;
                return;
            }
            this.item.setDate(attributes.getValue("date"));
            String mail = attributes.getValue("mail");
            if (NicoXMLReader.match(this.NG_Word, mail)) {
                this.item_kicked = true;
                return;
            }
            this.item.setMail(mail);
            this.item.setNo(attributes.getValue("no"));
            String user_id = attributes.getValue("user_id");
            if (NicoXMLReader.match(this.NG_ID, user_id)) {
                this.item_kicked = true;
                return;
            }
            String forkval = attributes.getValue("fork");
            if (forkval != null && forkval.equals("1")) {
                this.item_fork = true;
            }
            this.item.setUserID(user_id);
            this.item.setVpos(attributes.getValue("vpos"));
        }
    }

    @Override
    public void characters(char[] ch, int offset, int length) {
        char[] input = new String(ch, offset, length).toCharArray();
        int i = 0;
        while (i < input.length) {
            if (!Character.isDefined(input[i])) {
                input[i] = 63;
            }
            ++i;
        }
        if (this.item != null) {
            String com = new String(input);
            if (NicoXMLReader.match(this.NG_Word, com)) {
                this.item_kicked = true;
                return;
            }
            if (this.item_fork && com.startsWith("/")) {
                this.item_kicked = true;
                return;
            }
            this.item.setComment(com);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        if (qName.toLowerCase().equals("chat")) {
            if (!this.item_kicked) {
                this.nicopacket.addChat(this.item);
            }
            this.item = null;
        }
    }

    @Override
    public void endDocument() {
        System.out.println("Converting finished.");
    }
}

