/*
 * Decompiled with CFR 0.152.
 */
package saccubus.conv;

import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;
import saccubus.conv.Chat;
import saccubus.conv.ChatArray;

public class MultiXMLHandler
extends DefaultHandler {
    private final ChatArray chatArray;
    private Chat chat;
    private boolean chat_kicked;
    private String forkStr;

    public MultiXMLHandler(ChatArray chatArray) {
        this.chatArray = chatArray;
    }

    @Override
    public void startDocument() {
        System.out.println("Convert muliti_XML to a combined file.");
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        if (qName.equals("thread")) {
            String thread = attributes.getValue("thread");
            this.chatArray.setThread(thread);
            System.out.print("(thread " + thread + ")");
            return;
        }
        if (qName.equals("chat")) {
            this.chat = new Chat();
            this.chat_kicked = false;
            String deleted = attributes.getValue("deleted");
            if (deleted != null && deleted.equals("1")) {
                this.chat_kicked = true;
                return;
            }
            this.chat.setDate(attributes.getValue("date"));
            this.chat.setMail(attributes.getValue("mail"));
            this.chat.setNo(attributes.getValue("no"));
            this.chat.setUserID(attributes.getValue("user_id"));
            this.chat.setVpos(attributes.getValue("vpos"));
            this.forkStr = attributes.getValue("fork");
            if (this.forkStr != null) {
                this.chat.setFork(this.forkStr);
            }
            System.out.print(".");
            return;
        }
        System.out.print(String.valueOf(qName) + " ");
    }

    @Override
    public void characters(char[] ch, int offset, int length) {
        char[] input = new String(ch, offset, length).toCharArray();
        int i = 0;
        while (i < input.length) {
            if (!Character.isDefined(input[i])) {
                input[i] = 63;
            }
            ++i;
        }
        if (this.chat != null) {
            this.chat.setComment(new String(input));
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        if (qName.equals("chat")) {
            if (!this.chat_kicked) {
                this.chatArray.addChat(this.chat);
            }
            this.chat = null;
        }
    }

    @Override
    public void endDocument() {
        System.out.println("\nEach convert finished.");
    }
}

