/*
 * Decompiled with CFR 0.152.
 */
package saccubus.conv;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import saccubus.conv.Chat;

public class ChatArray {
    private ArrayList<Chat> chatList = new ArrayList();
    private ArrayList<Integer> chatIndex = new ArrayList();
    private String thread = null;

    public void addChat(Chat chat) {
        int no = chat.getNo();
        if (no < 0) {
            System.out.println("Can't add chat()");
            return;
        }
        if (this.chatIndex.size() <= no) {
            int i = this.chatIndex.size();
            while (i < no) {
                this.chatIndex.add(i, -1);
                ++i;
            }
            this.chatIndex.add(no, this.chatList.size());
            this.chatList.add(this.chatList.size(), chat);
            return;
        }
        int idx = this.chatIndex.get(no);
        if (idx == -1) {
            this.chatIndex.set(no, this.chatList.size());
            this.chatList.add(this.chatList.size(), chat);
            return;
        }
    }

    public void writeXML(File file) throws IOException {
        PrintWriter pw = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8")));
        pw.print("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        pw.println("<packet><thread thread=\"" + this.thread + "\" />");
        pw.flush();
        int no = 0;
        while (no < this.chatIndex.size()) {
            int idx = this.chatIndex.get(no);
            if (idx >= 0 && idx < this.chatList.size()) {
                Chat chat = this.chatList.get(idx);
                chat.printXML(pw);
            }
            ++no;
        }
        pw.println("</packet>");
        pw.flush();
        pw.close();
    }

    public void setThread(String newThread) {
        if (this.thread == null) {
            this.thread = newThread;
            return;
        }
        try {
            int t = Integer.parseInt(this.thread);
            int nt = Integer.parseInt(newThread);
            if (nt < t) {
                this.thread = newThread;
            }
        }
        catch (NumberFormatException ex) {
            System.out.println("thread is not number, maybe no problem.");
        }
    }
}

