<?php
/**
 * c_imageテーブルにc_member_idをひもづける
 *
 *
 */
error_reporting(E_ALL ^ E_NOTICE);
ini_set('display_errors', true);
//ini_set('memory_limit', '32M');

set_time_limit(0);

require_once './config.inc.php';
require_once OPENPNE_WEBAPP_DIR . '/init.inc';

$dbimage =& db_get_instance('image');
$db      =& db_get_instance('main');

//c_imageファイルのファイル名からdiary、diary_commentなどを選択する
$sql_img = "SELECT SQL_CALC_FOUND_ROWS * FROM ".MYNETS_PREFIX_NAME."c_image ";
$result  = db_get_all($sql_img);

$sql_img_cnt = "SELECT FOUND_ROWS() ";
$img_cnt     = db_get_one($sql_img_cnt);
echo "Begin Image set c_member_id " . $img_cnt . " converter.\r\n";
foreach ($result as $value)
{
    $filename = $value['filename'];
    if (substr($filename, 0, 2) == 'd_')    //日記テーブル
    {
        $sql_data = "SELECT c_member_id FROM ".MYNETS_PREFIX_NAME."c_diary WHERE "
                    . "(image_filename_1 = ? OR image_filename_2 = ? OR image_filename_3 = ? )";
        $params   = array($filename, $filename, $filename);
    }
    else if (substr($filename, 0, 2) == 'dc')   //日記コメントテーブル
    {
        $sql_data = "SELECT c_member_id FROM ".MYNETS_PREFIX_NAME."c_diary_comment WHERE "
                    . "(image_filename_1 = ? OR image_filename_2 = ? OR image_filename_3 = ? )";
        $params   = array($filename, $filename, $filename);
    }
    else if (substr($filename, 0, 2) == 'ms')   //メッセージテーブル
    {
        $sql_data = "SELECT c_member_id_from FROM ".MYNETS_PREFIX_NAME."c_message WHERE "
                    . "(image_filename_1 = ? OR image_filename_2 = ? OR image_filename_3 = ? )";
        $params   = array($filename, $filename, $filename);
    }
    else if (substr($filename, 0, 2) == 't_')   //topicテーブル
    {
        $sql_data = "SELECT c_member_id FROM ".MYNETS_PREFIX_NAME."c_commu_topic_comment WHERE "
                    . "(image_filename1 = ? OR image_filename2 = ? OR image_filename3 = ? )";
        $params   = array($filename, $filename, $filename);
    }
    else if (substr($filename, 0, 3) == 'tc_')   //topicコメントテーブル
    {
        $sql_data = "SELECT c_member_id FROM ".MYNETS_PREFIX_NAME."c_commu_topic_comment WHERE "
                    . "(image_filename1 = ? OR image_filename2 = ? OR image_filename3 = ? )";
        $params   = array($filename, $filename, $filename);
    }
    else if (substr($filename, 0, 2) == 'c_')   //コミュニティテーブル
    {
        $sql_data = "SELECT c_member_id_admin FROM ".MYNETS_PREFIX_NAME."c_commu WHERE "
                    . "image_filename = ? ";
        $params   = array($filename);
    }
    else if (substr($filename, 0, 2) == 'm_')   //メンバープロフィール
    {
        $sql_data = "SELECT c_member_id FROM ".MYNETS_PREFIX_NAME."c_member WHERE "
                    . "(image_filename_1 = ? OR image_filename_2 = ? OR image_filename_3 = ? )";
        $params   = array($filename, $filename, $filename);
    }
    $c_member_id = getMemberId($sql_data, $params, $filename);
    setMemberId($value['c_image_id'], $c_member_id);
}

//特定された投稿者のIDをc_imageに書き込む
echo "End Image set c_member_id converter.\r\n";

//ここまでをループする

function getMemberId($sql, $params, $filename)
{
    if ($c_member_id = db_get_one($sql, $params))
    {
        return $c_member_id;
    }
    else
    {
        return 0;
    }
}

function setMemberId($c_image_id, $c_member_id)
{
    if ($c_member_id == 0)
    {
        return ;
    }
    $data = array(
        'c_member_id' => intval($c_member_id),
    );
    $where = array(
        'c_image_id' => intval($c_image_id),
    );
    return db_update(MYNETS_PREFIX_NAME."c_image", $data, $where);
}
?>
