
CREATE TABLE `c_etsuran` (
 `c_etsuran_id` int(11) NOT NULL auto_increment,
 `c_member_id_from` int(11) NOT NULL default '0',
 `c_diary_id` int(11) NOT NULL default '0',
 `r_datetime` datetime NOT NULL default '0000-00-00 00:00:00',
 PRIMARY KEY  (`c_etsuran_id`),
 KEY `c_member_id_from` (`c_member_id_from`),
 KEY `c_diary_id` (`c_diary_id`),
 KEY `c_member_from_diary_id` (`c_member_id_from`,`c_diary_id`,`r_datetime`)
 ) TYPE=MyISAM;

ALTER TABLE `c_diary` ADD COLUMN `etsuran_count` int(11) NOT NULL default '0';
ALTER TABLE `c_diary` ADD COLUMN `comment_count` int(11) NOT NULL default '0';
ALTER TABLE `c_diary` ADD COLUMN `e_datetime` date NOT NULL default '0000-00-00 00:00:00';
ALTER TABLE `c_diary` ADD INDEX `e_datetime` (`c_member_id`,`e_datetime`);
ALTER TABLE `c_member` ADD COLUMN `is_diary_comment_mail` int(1) NOT NULL default '0';
ALTER TABLE `c_ashiato` ADD COLUMN `is_mobile` varchar(8) NOT NULL default 'pc';
ALTER TABLE `c_diary_comment` ADD COLUMN `comment_number` INT( 11 ) NOT NULL DEFAULT '0';
ALTER TABLE `c_member_secure` ADD COLUMN `pc_address_aes` text NOT NULL DEFAULT '';
ALTER TABLE `c_member_secure` ADD COLUMN `ktai_address_aes` text NOT NULL DEFAULT '';
ALTER TABLE `c_member_secure` ADD COLUMN `regist_address_aes` text NOT NULL DEFAULT '';
ALTER TABLE `c_member_secure` ADD COLUMN `easy_access_id_aes` text NOT NULL DEFAULT '';

CREATE TABLE `c_ranking` (
  `c_ranking_id` int(11) NOT NULL auto_increment,
  `ranking_date` date NOT NULL,
  `ranking_flag` int(1) NOT NULL,
  `id` int(11) NOT NULL,
  `ranking_count` int(11) NOT NULL,
  PRIMARY KEY  (`c_ranking_id`),
  KEY `ranking_date` (`ranking_date`,`ranking_count`)
) TYPE=MyISAM AUTO_INCREMENT=1 ;

CREATE TABLE `c_tags` (
  `c_tags_id` int(11) NOT NULL auto_increment,
  `c_tags_name` varchar(36) NOT NULL ,
  `c_member_id` int(11) NOT NULL default '0',
  `r_datetime` datetime NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY (`c_tags_id`),
  KEY `c_tags_name` (`c_tags_name`),
  KEY `c_member_id` (`c_member_id`)
) TYPE=MyISAM AUTO_INCREMENT=1;
INSERT INTO `c_tags` (`c_tags_name`,`c_member_id`) VALUES ('その他','1');

CREATE TABLE `c_entry_tag` (
  `c_entry_tag_id` int(11) NOT NULL auto_increment,
  `c_entry_id` int(11) NOT NULL default '0',
  `c_entry_flag` tinyint(1) NOT NULL default '0',
  `c_tags_id` int(11) NOT NULL default '0',
  `c_member_id` int(11) NOT NULL default '0',
  `r_datetime` datetime NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY (`c_entry_tag_id`),
  KEY `c_entry_id` (`c_entry_id`),
  KEY `c_entry_id_flag` (`c_entry_id`,`c_entry_flag`)
) TYPE=MyISAM AUTO_INCREMENT=1 ;

CREATE TABLE `c_dengon_comment` (
  `c_dengon_comment_id` int(11) NOT NULL auto_increment,
  `c_member_id_to` int(11) NOT NULL default '0',
  `c_member_id_from` int(11) NOT NULL default '0',
  `body` text NOT NULL,
  `r_datetime` datetime NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (`c_dengon_comment_id`),
  KEY `c_member_id_to` (`c_member_id_to`,`r_datetime`)
) TYPE=MyISAM ;

INSERT INTO `c_review_category` VALUES (12,'hpc-jp','ヘルス＆ビューティー',12);
INSERT INTO `c_admin_config` (`c_admin_config_id`, `name`, `value`) VALUES ( null, 'SKIN_FOLDER', 'default');
UPDATE `c_review_category` SET `category_disp` = 'ホーム＆キッチン' WHERE `c_review_category_id` =9 LIMIT 1 ;
INSERT INTO `c_review_category` VALUES (13,'watches-jp','時計',13);

ALTER TABLE `c_member` ADD `mobile_view` INT(11) NOT NULL DEFAULT '0';
ALTER TABLE `c_member` ADD `pc_view` INT(11) NOT NULL DEFAULT '0';
ALTER TABLE `c_access_log` ADD `ip_address` varchar(16) NOT NULL DEFAULT '';
ALTER TABLE `c_diary` MODIFY COLUMN public_flag enum('public','friend','private','open') NOT NULL default 'public';
CREATE TABLE `c_display_view` (
    `c_display_view_id` int(11) NOT NULL auto_increment,
    `c_display_name` varchar(60) NOT NULL,
    `is_pc` tinyint(1) NOT NULL default '0',
    `is_money_flag` int(11) NOT NULL default '0',
    `template_foldername` text NOT NULL,
    PRIMARY KEY (`c_display_view_id`),
    KEY `is_money_flag` (`is_money_flag`)
) TYPE=MyISAM ;
INSERT INTO `c_display_view` (`c_display_name`,`is_pc`,`is_money_flag`,`template_foldername`) values (
    'ノーマル画面','0','0','') ;
INSERT INTO `c_display_view` (`c_display_name`,`is_pc`,`is_money_flag`,`template_foldername`) values (
    'サムネイル付き画面','0','0','new_templates') ;
INSERT INTO `c_display_view` (`c_display_name`,`is_pc`,`is_money_flag`,`template_foldername`) values (
    'Mixi風画面','1','0','new_templates') ;

CREATE TABLE `c_admin_information` (
    `c_admin_information_id` int(11) NOT NULL auto_increment,
    `subject` text NOT NULL,
    `body` text NOT NULL,
    `category` varchar(64) NOT NULL,
    `r_datetime` datetime NOT NULL default '0000-00-00 00:00:00',
    `c_view_flag` tinyint(1) NOT NULL default '0',
    `public_flag` tinyint(1) NOT NULL default '0',
    PRIMARY KEY (`c_admin_information_id`),
    KEY `category` (`category`)
) TYPE=MyISAM ;
CREATE TABLE `c_delete_member_data` (
 `c_delete_member_data_id` int(11) NOT NULL auto_increment,
 `c_member_id` int(11) NOT NULL ,
 `nickname` text NOT NULL,
 `pc_address` text NOT NULL,
 `ktai_address` text NOT NULL,
 `regist_address` text NOT NULL,
 `easy_access_id` text NOT NULL,
 `ip_address` text NOT NULL,
 `user_agent` text NOT NULL,
 `delete_comment` text NOT NULL,
 `delete_flag` tinyint(1) NOT NULL default '0',
 `regist_datetime` datetime NOT NULL default '0000-00-00 00:00:00',
 `delete_datetime` datetime NOT NULL default '0000-00-00 00:00:00',
  `c_member_id_invite` int(11) NOT NULL,
 PRIMARY KEY  (`c_delete_member_data_id`),
 KEY `ktai_address` (`ktai_address`(100)),
 KEY `pc_address` (`pc_address`(100)),
 KEY `regist_address` (`regist_address`(100)),
 KEY `easy_access_id` (`easy_access_id`(50)),
 KEY `delete_datetime` (`delete_datetime`),
 KEY `regist_datetime` (`regist_datetime`)
) TYPE=MyISAM;

CREATE TABLE `c_version` (
 c_version_id int(11) NOT NULL auto_increment,
 old_version_name text NOT NULL ,
 new_version_name text NOT NULL ,
 r_datetime datetime NOT NULL default '0000-00-00 00:00:00',
 PRIMARY KEY (`c_version_id`)
) TYPE=MyISAM;
