#include <assert.h>
#include <stdio.h>
#include <stdint.h>
#include <stdbool.h>
#include <stdlib.h>
#include <string.h>

struct record{
	long count;
	long address;
	long type;
	uint8_t *data;
	uint32_t checksum;
};
struct record *ihex_new(void)
{
	return malloc(sizeof(struct record));
}
void ihex_destory(struct record *t)
{
	free(t);
}
static long tolong(const char *hex, int length)
{
	char str[5];
	assert(length < 5);
	memcpy(str, hex, length);
	str[length] = '\0';
	return strtol(str, NULL, 0x10);
}
bool ihex_load(const char *hex, struct record *t)
{
	t->count = 0;
	t->address = 0;
	t->data = NULL;
	if(*hex != ':'){
		puts("illigal prefix");
		return false;
	}
	hex++;
	
	t->count = tolong(hex, 2);
	hex += 2;
	
	t->address = tolong(hex, 4);
	hex += 4;
	
	t->type = tolong(hex, 2);
	hex += 2;
	switch(t->type){
	case 0: //data
		t->data = malloc(t->count);
		break;
	case 1: //end
		break;
	case 2: //extended
		puts("extended record not supported");
		return false;
	default:
		puts("unkown record type");
		return false;
	}
	int i;
	for(i = 0; i < t->count; i++){
		t->data[i] = (uint8_t) tolong(hex, 2);
		hex += 2;
	}
	t->checksum = (uint32_t) tolong(hex, 2);
	
	uint32_t sum = t->count;
	sum += t->address & 0xff;
	sum += (t->address >> 8) & 0xff;
	sum += t->type;
	for(i = 0; i < t->count; i++){
		sum += t->data[i];
	}
	sum += t->checksum;
	sum &= 0xff;
	if(sum != 0){
		puts("checksum error");
	}
	return sum == 0;
}
void ihex_write(struct record *t, long filter, uint8_t *image)
{
	if(t->count == 0){
		return;
	}
	if((t->address + t->count) > filter){
		return;
	}
	image += t->address;
	memcpy(image, t->data, t->count);
	free(t->data);
	t->data = NULL;
}
