#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>
#include <stdbool.h>
#include "file.h"

bool buf_load(uint8_t *buf, const char *file, int size)
{
	FILE *fp;

	fp = fopen(file, "rb");
	if(fp == NULL){
		return false;
	}
	fseek(fp, 0, SEEK_SET);
	fread(buf, sizeof(uint8_t), size, fp);
	fclose(fp);
	return true;
}

void* buf_load_full(const char *file, int *size)
{
	FILE *fp;
	uint8_t *buf;

	*size = 0;
	fp = fopen(file, "rb");
	if(fp == NULL){
		return NULL;
	}
	fseek(fp, 0, SEEK_END);
	*size = ftell(fp);
	if(*size == 0){
		fclose(fp);
		return NULL;
	}
	fseek(fp, 0, SEEK_SET);
	buf = malloc(*size);
	fread(buf, sizeof(uint8_t), *size, fp);
	fclose(fp);
	return buf;
}

bool buf_save(const void *buf, const char *file, int size)
{
	FILE *fp;

	fp = fopen(file, "wb");
	if(fp == NULL){
		return false;
	}
	fseek(fp, 0, SEEK_SET);
	fwrite(buf, sizeof(uint8_t), size, fp);
	fclose(fp);
	return true;
}

