package pbl2011.model;

import java.util.ArrayList;
import java.util.List;

import pbl2011.common.CommonConst;

/**
 * \bh
 * <p>
 *
 * @author 10745104 Y.Ishii
 *
 */
public class Method implements CommonConst, Cloneable {

	public Method(String methodName, String dataTypeId, VisibilityType visibilityType) {
		this.methodName = methodName;
		this.dataTypeId = dataTypeId;
		this.visibility = visibilityType;
}

	public Method(Method clone) {
		methodName = clone.methodName;
		dataTypeId = clone.dataTypeId;
		visibility = clone.visibility;
		delFlag = clone.delFlag;
		for(Parameter p : clone.parameterList) {
			Parameter copy = p.clone();
			parameterList.add(copy);
		}
	}

	/** \bh */
	public String methodName;

	/** ߂l^ */
	public String dataTypeId;

	/**  */
	public VisibilityType visibility;

	/** Xg */
	public List<Parameter> parameterList = new ArrayList<Parameter>();

	/** 폜tO */
	public boolean delFlag;

	public String toString(int classId) {
		return MethodAndAttrType.METHOD.alias() + DELIMITER + methodName + DELIMITER + dataTypeId
				+ DELIMITER + visibility.alias();

	}

	public void change(String name, String dataTypeId, VisibilityType visi) {
		this.methodName = name;
		this.dataTypeId = dataTypeId;
		this.visibility = visi;

	}

	public void change(String name) {
		methodName = name;
	}

	public void addParameter(int classId) {
		parameterList.add(new Parameter("new parameter", String.valueOf(DEFAULT_DATA_TYPE_ID)));

	}

	public void changeParameter(int sc, String name, String typeId) {
		Parameter p = parameterList.get(sc);
		p.change(name, typeId);

	}

	public String visibilityMark() {
		return visibility.mark();
	}

	public void changeVisi(VisibilityType visi) {
		visibility = visi;

	}

	public void changeDataTypeId(String dataTypeId) {
		this.dataTypeId = dataTypeId;

	}

	public Method clone() {
		try {
			return new Method((Method) super.clone());
		} catch (CloneNotSupportedException e) {
			throw new InternalError();
		}
	}
	
	public boolean equals(Object o) {
		
		if (o == null) {
			return false;
		}
		Method m = (Method)o;
		
		if (!this.methodName.equals(m.methodName)) {
			return false;
		}
		
		if (this.dataTypeId != m.dataTypeId) {
			return false;
		}
		
		if (!this.visibility.equals(m.visibility)) {
			return false;
		}
		
		if (!this.parameterList.equals(m.parameterList)) {
			return false;
		}
		
		if (this.delFlag != m.delFlag) {
			return false;
		}
		
		return true;
	}
}
