package pbl2011.gui;

import java.util.ArrayList;
import java.util.List;

import pbl2011.model.Method;
import pbl2011.mvc.Model;

public class MethodForm extends DetailForm {

	private ParameterEditor paramEditer;

	public MethodForm(Model m, ParameterEditor paramEditer) {
		super(m);
		this.paramEditer = paramEditer;
	}

	@Override
	protected void changeLine() {
		paramEditer.setSelectLine(table.getSelectedRow());
	}

	@Override
	List<String[]> getComboData() {
		List<String[]> l = new ArrayList<String[]>();
		l.add(null);
		l.add(myModel.getReturnTypeList());
		l.add(VISIBILITY_LIST);
		return l;
	}

	@Override
	String[] getTableCol() {
		return new String[] { "O", "Ԃl", "" };
	}

	@Override
	String[][] getTableData() {
		String[][] data;
		if (clone != null) {
			data = new String[clone.methodList.size()][3];

			int i = 0;
			for (Method m : clone.methodList) {
				data[i][0] = m.methodName;
				data[i][1] = myModel.getTypeNameByTypeId(m.dataTypeId);
				data[i][2] = m.visibility.alias();
				i++;
			}
		} else {
			data = new String[0][3];
		}
		return data;
	}

	@Override
	void updateModel(int sc) {
		clone.changeMethod(sc, (String) table.getValueAt(sc, 0),
				myModel.getTypeIdByTypeName((String) table.getValueAt(sc, 1)),
				VisibilityType.aliasOf((String) table.getValueAt(sc, 2)));

	}
}
