package pbl2011.common;

/**
 * ʒ萔`NX
 * <p>
 *
 * @author 10745104 Y.Ishii
 *
 */
public interface CommonConst {

	public static final String FRAME_TITLE = "Class Diagrams Editer";

	public static final int CANVAS_WIDTH = 2048;

	public static final int CANVAS_HEIGHT = 1280;

	/**
	 * 
	 */
    public enum VisibilityType {
        PUBLIC("public", "public", "+", 1),
        PROTECTED("protected", "protected", "#", 2),
        PACKAGE("package", "", "~", 3),
        PRIVATE("private", "private", "-", 4),
        UNDEF("", "", "", 0);

        private String alias;
        private String code;
        private String mark;
        private int level;
        VisibilityType(String alias, String code, String mark, int level) {
        	this.alias = alias;
        	this.code = code;
        	this.mark = mark;
        	this.level = level;
        }
        public String alias() { return alias; }
        public String code() { return code; }
        public String mark() { return mark; }
        public int level() { return level; }
        public static int level(String alias) {
        	VisibilityType type = aliasOf(alias);
        	if (type != null) {
        		return type.level;
        	} else {
        		return 0;
        	}
        }
        public static VisibilityType aliasOf(String alias) {
        	for (VisibilityType type : VisibilityType.values()) {
        		if (type.alias.equals(alias)) {
        			return type;
        		}
        	}
        	return UNDEF;
        }
    }

	public static final String[] VISIBILITY_LIST = new String[] { VisibilityType.PUBLIC.alias(),
		VisibilityType.PROTECTED.alias(), VisibilityType.PACKAGE.alias(), VisibilityType.PRIVATE.alias() };

	public static final String[] MULTIPLE_LIST = new String[] { "0...*", "*",
			"1", "n" };;

	public static final String[] NAVIGABLE_LIST = new String[] { "true",
			"false" };

	/**
	 * pbP[W
	 */
	public enum PackageType {
		PACKAGE("PACKAGE", "package");

        private String alias;
        private String code;
        PackageType(String alias, String code) { this.alias = alias; this.code = code; }
        public String alias() { return alias; }
        public String code() { return code; }
	}

	/**
	 * NX
	 */
	public enum ClassType {
		CLASS("CLASS", "class", ""),
		ABSTRACT_CLASS("@CLASS", "abstract class", "@"),
		INTERFACE("INTERFACE", "interface", "!"),
		ENUM("ENUM", "enum", "%");

        private String alias;
        private String code;
        private String mark;

        ClassType(String alias, String code, String mark) { this.alias = alias; this.code = code; this.mark = mark; }
        public String alias() { return alias; }
        public String code() { return code; }
        public String mark() { return mark; }
        public static ClassType aliasOf(String alias) {
        	for (ClassType classType : ClassType.values()) {
        		if (classType.alias.equals(alias)) {
        			return classType;
        		}
        	}
        	return null;
        }
        public boolean isINTERFACE() {
        	return INTERFACE == this; 
        }
	}

	/**
	 * \bhEp[^
	 */
	public enum MethodAndAttrType {
		METHOD("METHOD"),
		ABSTRACT_METHOD("@METHOD"),
		ATTRIB("ATTRIB"),
		PARAM("PARAM");

        private String alias;
        MethodAndAttrType(String alias) { this.alias = alias; }
        public String alias() { return alias; }
	}

	/**
	 * ֘A
	 */
	public enum AssocType {
		ASSOC("ASSOC", ""),
		INNER("INNER", ""),
		EXTENDS("EXTENDS", "extends"),
		DEPENDS("DEPENDS", "");

        private String alias;
        private String code;
        AssocType(String alias, String code) { this.alias = alias; this.code = code; }
        public String alias() { return alias; }
        public String code() { return code; }
        
        public boolean isASSOC() {
        	return ASSOC == this;
        }
        public boolean isINNER() {
        	return INNER == this;
        }
        public boolean isEXTENDS() {
        	return EXTENDS == this;
        }
        public boolean isDEPENDS() {
        	return DEPENDS == this;
        }
        public static AssocType aliasOf(String alias) {
        	for (AssocType asscType : AssocType.values()) {
        		if (asscType.alias.equals(alias)) {
        			return asscType;
        		}
        	}
        	return null;
        }
	}
	
	/**
	 * Treevf
	 */
	public enum TreeType {
		ROOT,
		CLASS,
		ATTR,
		METHOD,
		PACKAGE;
		public boolean isCLASS() {
			return CLASS == this;
		}
	}
	
	public static final String CREATE = "CREATE";

	public static final String READ = "READ";

	public static final String SAVE = "SAVE";

	public static final String SELECT = "SELECT";

	public static final String GRID = "GRID";

	public static final String GRIDLINE = "GRIDLINE";

	public static final String ADD = "ADD";

	public static final String DELETE = "DELETE";

	public static final String UP = "UP";

	public static final String DOWN = "DOWN";

	public static final String UPDATE = "UPDATE";

	public static final String PACKAGE_DEFAULT = "(default)";

	public static final Integer PACKAGE_DEFAULT_ID = 90000;

	public static final String PACKAGE_JAVA_LANG = "java.lang";

	public static final Integer PACKAGE_JAVA_LANG_ID = 90001;

	public static final String DELIMITER = "\t";

	public static final String DELIMITER_P = ":";

	public static final String DELIMITER_PACKAGE = ".";

	public static final int GRID_SIZE = 8;

	public static final int ARROW_SIZE_A = 10;

	public static final double ARROW_ANGLE_A = Math.PI / 8.0;

	public static final int ARROW_SIZE_E = 12;

	public static final double ARROW_ANGLE_E = Math.PI / 6.0;


	public static final int KNOB_SIZE = 6; //muTCY

	public static final int INNER_SIZE = 4; //Ci[NX̃}[NTCY

	public static final int POINT_SIZE = 8; //֘Ã|CgTCY

	public static final int CLASS_HEIGHT1 = GRID_SIZE * 3;

	public static final int CLASS_HEIGHT2 = GRID_SIZE;

	public static final int CLASS_HEIGHT3 = GRID_SIZE;

	public static final int CLASS_WIDTH = GRID_SIZE * 10;
	
	public static final int CLASS_COLOR_RED = 204;
	
	public static final int CLASS_COLOR_GREEN = 255;
	
	public static final int CLASS_COLOR_BLUE = 255;

	public static final float MAIN_LINE_SIZE = 1.5f;

	public static final float SUB_LINE_SIZE = 1.0f;

	public static final int LINE_SPACE = 2; //s

	public static final int LINE_MARGINE = 2; //㉺]

	public static final int SIDE_MARGINE = 8; //E]

	/**
	 * ֘A
	 */
	public enum AssocLineType {
		STRAIGHT_LINE, // 
		RIGHT_ANGLE, // p()
		RIGHT_ANGLE_H, // p()
		FREE_LINE; // RȐ
		
		public boolean isSTRAIGHT_LINE() {
			return  STRAIGHT_LINE == this;
		}
		public boolean isRIGHT_ANGLE() {
			return RIGHT_ANGLE == this;
		}
		public boolean isRIGHT_ANGLE_H() {
			return RIGHT_ANGLE_H == this;
		}
		public boolean isFREE_LINE() {
			return FREE_LINE == this;
		}
	}

	public static final int SYSTESM_USE_MIN_ID = 90000;

	public static int DEFAULT_RETURN_TYPE_ID = 90000;

	public static String DEFAULT_RETURN_TYPE_NAME = "void";

	public static int DEFAULT_DATA_TYPE_ID = 90001;

	public static String CONSTRACTOR_RETURN_TYPE_NAME = "";

	public static int CONSTRACTOR_DATA_TYPE_ID = 90009;

	public static String DEFAULT_DATA_TYPE_NAME = "boolean";

	public static final String SPACE = " ";
	
	public static final String NULL = "null";

	public static final String SEMI_COLON = ";";

}
