package ash.reverse.uml;

import java.util.Map;
import java.awt.Rectangle;

/**
 * UMLNX}̊֌WL^B
 */
class Relationship implements UMLConst {
	private String type;		// ֘Ǎ^iUMLtH[}bg̃^Oj
	protected int source;		// ֌W̃\[X
	protected int target;		// ֌W̃^[Qbg
	private String label;		// ֌W̃x

	Relationship(String type, int source, int target, String label) {
		this.type = type;
		this.source = source;
		this.target = target;
		this.label = label;
	}

	String linkID() { return "" + source + "." + target; }

	/**
	 * UMLNX}tH[}bgł̊֌W̕\LԂB
	 * @return ֌W̕\L
	 */
	String umlFormat() {
		return type +SEP+ source +SEP+ target +SEP+ label;
	}
}

/**
 * UMLNX}̓NX̓֌WL^B
 */
class InnerRel extends Relationship {
	InnerRel(int source, int target, String label) {
		super(INNER, source, target, label);
	}
	@Override String umlFormat() {		// b菈
		return super.umlFormat() + RELPARAMS;
	}
}

/**
 * UMLNX}̊g֌WL^B
 */
class Extends extends Relationship {
	Extends(int source, int target, String label) {
		super(EXTENDS, source, target, label);
	}
	
	@Override String umlFormat() {		// b菈
		return super.umlFormat() + RELPARAMS;
	}
}

/**
 * UMLNX}̈ˑ֌WL^B
 */
class Depends extends Relationship {
	int count = 0;
	int ncount = 0;
	int bcount = 0;
	int pcount = 0;
	int rcount = 0;
	Depends(int source, int target, String label) {
		super(DEPENDS, source, target, label);
	}
	Depends(int source, int target, Stereotype tag) {
		super(DEPENDS, source, target, tag.label);
		count(tag);
	}
	void count(Stereotype tag) {
		switch(tag) {
		case NEW: ncount++; break;
		case BODY: bcount++; break;
		case PARAM: pcount++; break;
		case RETURN: rcount++; break;
		}
		count++;
	}
	@Override String umlFormat() {		// b菈
		return super.umlFormat() + RELPARAMS;
	}
}

/**
 * UMLNX}̊֘AL^B
 */
class Assoc extends Relationship {
	private String multiplicity_s;		// \[X̑dx
	private String multiplicity_t;		// ^[Qbg̑dx
	private boolean navigability_s;		// \[X̗U\
	private boolean navigability_t;		// ^[Qbg̗U\
	private String role_s;				// \[X̖
	private String role_t;				// ^[Qbg̖
	private ClassNode classNode;		// \[Xƃ^[Qbgꍇ̃m[h

	Assoc(int source, int target, String label) {
		super(ASSOCIATION, source, target, label);
	}

	/**
	 * \[X̃vpeBݒ肷B
	 * @param multiplicity dx
	 * @param navigability U\
	 * @param role 
	 */
	void setSource(String multiplicity, boolean navigability, String role) {
		this.multiplicity_s = multiplicity;
		this.navigability_s  = navigability;
		this.role_s  = role;
	}

	/**
	 * ^[Qbg̃vpeBݒ肷B
	 * @param multiplicity dx
	 * @param navigability U\
	 * @param role 
	 */
	void setTarget(String multiplicity, boolean navigability, String role) {
		this.multiplicity_t = multiplicity;
		this.navigability_t = navigability;
		this.role_t = role;
	}

	/**
	 * ċAIȊ֘ANXm[hݒ肷B
	 * @param idMap m[hIDƃNXm[h̃}bv
	 */
	public void setRecursiveNode(Map<Integer,ClassNode> idMap) {
		if(source == target) classNode = idMap.get(source);
	}
	
	/**
	 * UMLNX}tH[}bgł̊֘A̕\LԂB
	 * @return ֘A̕\L
	 */
	@Override String umlFormat() {
		return super.umlFormat() +
			SEP + multiplicity_s + SEP + multiplicity_t +
			SEP + navigability_s + SEP + navigability_t + 
			SEP + role_s + SEP + role_t + recursiveArc();
	}
	private String recursiveArc() {
		if(classNode == null) return "";
		Rectangle b = classNode.bounds();
		int x1 = b.x + b.width;
		int x0 = x1 - 2 * UNIT;
		int x2 = x1 + 2 * UNIT;
		int y1 = b.y;
		int y0 = y1 - 2 * UNIT;
		int y2 = y1 + 2 * UNIT;
		return SEP + "FREE_LINE" + SEP + 5 +
			":" + x0 + ":" + y1 + ":" + x0 + ":" + y0 + ":" + x2 + ":" + y0 + 
			":" + x2 + ":" + y2 + ":" + x1 + ":" + y2;
	}
}
