package ash.reverse.uml;
import java.util.List;
import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.HashSet;
import java.io.PrintStream;
import java.awt.Font;
import ash.reverse.parser.Visibility;
import ash.reverse.struct.ObjectRecord;
import ash.reverse.struct.FileRecord;
import ash.reverse.struct.ClassRecord;

/**
 * ̃t@CL^AŒ`ĂpbP[W𒊏oA
 * pbP[W}o͂B
 */
public class PkgGenerator extends UMLDiagram {
	/**
	 * pbP[W}o͂B
	 * @param out pbP[W}̏o͐
	 * @param fileList t@CǗ郊Xg
	 * @param font CAEgvZŎgptHg
	 * @param rflag OpbP[WQ
	 * @param dflag `Ă^̕\
	 */
	public static void generate(PrintStream out, List<FileRecord> fileList,
								Font font, boolean rflag, boolean dflag) {
		PkgGenerator gen = new PkgGenerator();
		// CAEgvZŎgptHgݒ肷B
		gen.setFont(font);			// UMLDiagram̃\bh

		// pbP[W}̃p[^ݒ肷B
		gen.setParams(rflag, dflag);

		// pbP[W}̃Ot\̏inodeList  relListj𐶐B
		gen.generatePkgInfo(fileList);

		// Ot\񂩂pbP[W}𐶐B
		gen.generateDiagram(out);	// UMLDiagram̃\bh
	}

	/**
	 * pbP[W|[go͂B
	 * @param out pbP[W}̏o͐
	 * @param fileList t@CǗ郊Xg
	 */
	public static void generateRep(PrintStream out, List<FileRecord> fileList) {
		PkgGenerator gen = new PkgGenerator();
		gen.setParams(true, true);
		gen.generatePkgInfo(fileList);
		gen.generateReport(out);
	}

	/**
	 * pbP[W}̃p[^ݒ肷B
	 * @param rflag OpbP[WQ
	 * @param dflag `Ă^̕\
	 */
	void setParams(boolean rflag, boolean dflag) {
		this.rflag = rflag;
		this.dflag = dflag;
	}

	private boolean rflag;				// OpbP[WQ
	private boolean dflag;				// `Ă^̕\

	private static final String DEFAULTPKG = "*default*";
	private static final String ON_DEMAND = "  *  ";

	/** pbP[W̎ʎq̘A */
	private int pkgseq = 0;

	/** ˑ֌W̃x̘A */
	private int refseq = 0;

	/** 錾pbP[WƎQƃpbP[W̖OƋL^̃}bv */
	private Map<String,PackageRec>
		packageMap = new LinkedHashMap<String,PackageRec>();

	/** ̌^̊Ԃ̈ˑ֌W̒Pꉻ */
	private Set<String> dependsSet = new HashSet<String>();

	/**
	 * pbP[W}̃Ot\̏inodeList  relListj𐶐B
	 * @param fileList t@CǗ郊Xg
	 */
	void generatePkgInfo(List<FileRecord> fileList) {
		// packageŐ錾ꂽpbP[W`pbP[WƂēo^B
		// `pbP[Wŏɓo^ĂB
		for(FileRecord filerec : fileList) {
			PackageRec prec = findPackage(filerec.pkgname());
			prec.defined = true;
			// pbP[WɊ܂܂^o^B
			for(ObjectRecord rec : filerec.members())
				registerClass(prec, (ClassRecord)rec);
		}
		// importŌ^錾ĂpbP[Wo^B
		for(FileRecord filerec : fileList) {
			// If}h錾̃pbP[WQƂo^B
			for(String pkgname : filerec.onDemandSet()) {
				findPackage(pkgname).referedOnDemand = true;
			}
			// QƃpbP[WɎQƂĂ^o^Aˑ֌Wݒ肷B
			PackageRec prec = findPackage(filerec.pkgname());
			for(Map.Entry<String,String> e : filerec.typePkgMap().entrySet()) {
				String typeName = e.getKey();
				String pkgname = e.getValue();
				prec.addReference(findPackage(pkgname), typeName);
			}
		}

		// ͂\[XR[hpbP[W}̃Ot\𐶐B
		for(PackageRec prec : packageMap.values()) {
			// QƂĂ邪`ĂȂ^o^B
			prec.appendRef();
			if(prec.defined || rflag) generateGraphInfo(prec);
		}
	}

	/**
	 * pbP[WΉpbP[WԂB
	 * pbP[W󕶎̏ꍇ DEFAULTPKG ƂB
	 * o^̏ꍇ͓o^B
	 * @param name pbP[W(ex. java.util)
	 * @return pbP[W
	 */
	private PackageRec findPackage(String name) {
		if(name == null || name.isEmpty()) name = DEFAULTPKG;
		PackageRec prec = packageMap.get(name);
		if(prec == null) {
			prec = new PackageRec(++pkgseq, name);
			packageMap.put(name, prec);
		}
		return prec;
	}

	/**
	 * ͑Ώۂ̃pbP[W̒Œ`ꂽ^o^B
	 * @param prec ͑Ώۂ̃pbP[W
	 * @param crec ͂^
	 */
	private void registerClass(PackageRec prec, ClassRecord crec) {
		prec.addType(crec);
		for(ObjectRecord rec : crec.members()) {
			if(rec instanceof ClassRecord) {
				registerClass(prec, (ClassRecord)rec);
				//System.err.println(((ClassRecord)rec).qcn());
			}
		}
	}

	/**
	 * w肳ꂽpbP[WɊւpbP[W}𐶐B
	 * pbP[WNXAˑpbP[Wˑ^A^tB[hϐ
	 * ƂNX}ƂăOt\𐶐B
	 * @param prec pbP[W
	 */
	private void generateGraphInfo(PackageRec prec) {
		// nodeListɃpbP[Wm[ho^B
		String pinfo = "CLASS" + SEP + prec.id + SEP + prec.name + SEP + "null";
		ClassNode node = new ClassNode(prec.name, pinfo, 0);
		nodeList.add(node);
		node.setFontMetrics(fm);

		// ˑ֌W𐶐o^B
		for(PackageRec ref : prec.references) {
			if(ref.defined || rflag) {
				String arcID = "" + prec.id + "," + ref.id;
				if(!dependsSet.contains(arcID)) {
					dependsSet.add(arcID);
					String label = "ref" + (++refseq);
					relList.add(new Depends(prec.id, ref.id, label));
				}
			}
		}
		if(dflag) {
			// node Ɍ^`o^B
			for(ClassRecord trec : prec.typeList) {
				Visibility vis = trec.visibility();
				String name = trec.symbol() + trec.qcn();
				String cinfo = "ATTRIB" + SEP + name + SEP + "Class" + SEP + vis;
				node.addAttribute(name, cinfo, 0);
			}
			if(prec.referedOnDemand) {
				String cinfo =
					"ATTRIB" + SEP + ON_DEMAND + SEP + "Class" + SEP + "null";
				node.addAttribute(ON_DEMAND, cinfo, 0);
			}
		}
	}

	/**
	 * pbP[W|[go͂B
	 * @param out pbP[W|[g̏o͐
	 */
	void generateReport(PrintStream out) {
		for(PackageRec prec : packageMap.values()) {
			out.println(prec.name);
			for(ClassRecord trec : prec.typeList) {
				String spec = trec.visibility().symbol() + " " + trec.symbol();
				out.println("\t" + spec + "\t" + trec.qcn());
			}
			if(prec.referedOnDemand) out.println("\t\t*");

			for(PackageRec ref : prec.references)
				out.println("\t-->\t" + ref.name);
		}
	}
}

/**
 * 1̃pbP[WɊւێB
 */
class PackageRec {
	int id;							// pbP[W̎ʎq
	String name;					// pbP[W̖O(ex. java.util)
	boolean defined = false;		// packageŐ錾ꂽpbP[WȂtrue
	boolean referedOnDemand = false;	// If}hQ(*)Ȃtrue

	/** ̃pbP[WQƂĂpbP[W̃Xg */
	List<PackageRec> references = new ArrayList<PackageRec>();

	/** ̃pbP[WɊ܂܂^̃Xg */
	List<ClassRecord> typeList = new ArrayList<ClassRecord>();
	private Set<String> defSet = new HashSet<String>();
	private Set<String> refSet = new HashSet<String>();

	/**
	 * pbP[W̃RXgN^
	 * @param id pbP[Wʎq
	 * @param name pbP[W(ex. java.util)
	 */
	PackageRec(int id, String name) {
		this.id = id;
		this.name = name;
	}

	/**
	 * ̃pbP[W̒Œ`ꂽ^o^B
	 * @param trec ^
	 */
	public void addType(ClassRecord trec) {
		defSet.add(trec.qcn());
		typeList.add(trec);
	}

	/**
	 * QƂĂpbP[Wo^ło^B
	 * @param ref QƂĂpbP[W
	 * @param typeName QƂĂ^
	 */
	public void addReference(PackageRec ref, String typeName) {
		if(this != ref && !references.contains(ref)) references.add(ref);
		ref.refSet.add(typeName);
	}

	/**
	 * QƂĂ邪`ĂȂ^̃pbP[Wɓo^B
	 */
	public void appendRef() {
		for(String ref : refSet) {
			if(!defSet.contains(ref)) {
				ClassRecord crec = new ClassRecord("undef", ref, 0, null);
				crec.visibility(Visibility.PUBLIC);
				typeList.add(crec);
			}
		}
	}
}
