package ash.gui.editor.core;
import java.util.regex.Pattern;
import java.util.regex.Matcher;
import java.io.File;
import javax.swing.JTextArea;
import java.util.List;
import java.util.LinkedList;
import ash.util.FileUtil;
import ash.gui.core.GUIAdapter;

/**
 * t@CpXAFQCNAgrep̌ʁARpCG[AsG[ȂǂA
 * Yt@CI[v@\񋟂B
 * Yt@CT[`ۂ̃[gfBNgT[`pX̃Xg
 * o^ĂƂłB
 * <p>
 * eLXgGfB^܂̓R\[̃eLXg\̈ŁAt@CpX
 * IopenViewer(filePath)\bhĂԂA
 * t@CpXƍsԍ̏sɃJ[\ʒut
 * openFromTextArea(...)\bhĂԂƂɂāA
 * Yt@CI[vłB
 */
public class AshGUIViewer {
	/**
	 * T[`pX̃XgF
	 * T[`pXƂēo^ꂽfBNǵAt@CI[v̍ۂ
	 * ̔z̃t@CɂȂB
	 */
	private static List<String> searchPath = new LinkedList<String>();

	/**
	 * setspath <path>* ̎
	 * <p> w肳ꂽfBNgQT[`pXɐݒ肷B
	 */
	public static int resetSearchPath(String[] args) {
		searchPath.clear();
		return addSearchPath(args);
	}
	/**
	 * addspath <path>* ̎
	 * <p> w肳ꂽfBNgQT[`pXɒǉB
	 */
	public static int addSearchPath(String[] args) {
		if(args.length == 0) {
			for(String path : searchPath) System.out.println(path);
		} else {
			int i = 0;
			for(String root : args) {
				File f = GUIAdapter.findFile(root);
				if(f != null && f.isDirectory()) {
					String path = FileUtil.getPath(f);
					if(!searchPath.contains(path)) searchPath.add(i++, path);
				} else {
					System.err.println("directory requred: " + root);
				}
			}
		}
		return 0;
	}

	/**
	 * w肳ꂽt@CJB
	 * @param filePath I[vt@C̃pX܂FQCN
	 * @return w肳ꂽt@CI[vłtrue
	 */
	public static boolean openViewer(String filePath) {
		if(filePath == null) return false;
		if(openWithSearchPath(filePath)) return true;
		// FQCNJava\[Xt@CTB
		String path = filePath.replace('.', '/');
		if(openWithSearchPath(path + ".java")) return true;
		// FQCNNX菜Java\[Xt@CTB
		int i = path.lastIndexOf('/');
		if(i > 0) return openWithSearchPath(path.substring(0,i) + ".java");
		return false;
	}
	/**
	 * w肳ꂽt@CJAw肳ꂽsԍɃJ[\ʒutB
	 * t@C݃fBNgŌȂT[`pXTB
	 * @param filePath I[vt@C̃pX܂FQCN
	 * @return w肳ꂽt@CI[vłtrue
	 */
	private static boolean openWithSearchPath(String filePath) {
		if(_openViewer(filePath, "1")) return true;
		for(String root : searchPath) {
			if(_openViewer(root + filePath, "1")) return true;
		}
		return false;
	}

	/**
	 * w肳ꂽeLXgGǍ݂̃J[\ʒuAt@CpX
	 * sԍTA炻̃t@Ĉ̍sԍŃI[vB
	 * @param ta eLXgGA
	 * @return I[vłtrue
	 */
	public static boolean openFromTextArea(JTextArea ta) {
		String path = ta.getSelectedText();
		if(path != null && openViewer(path.trim())) return true;
		if(openFromTextArea(ta, "")) return true;
		for(String root : searchPath) {
			if(openFromTextArea(ta, root)) return true;
		}
		return false;
	}

	/**
	 * w肳ꂽeLXgGǍ݂̃J[\ʒuAt@CpX
	 * sԍTA炻̃t@CI[vB
	 * @param ta eLXgGA
	 * @param root [g̃pX
	 * @return I[vłtrue
	 */
	public static boolean openFromTextArea(JTextArea ta, String root) {
		if(!guiViewer.searchTarget(ta, root)) return false;
		return _openViewer(guiViewer.filePath, guiViewer.lineNum);
	}

	/**
	 * w肳ꂽt@CI[vAw肳ꂽsԍɃJ[\ʒutB
	 * @param filePath I[vt@C̃pX
	 * @param lineNum J[\ʒutsԍ
	 * @return I[vłtrue
	 */
	private static boolean _openViewer(String filePath, String lineNum){
		File f = GUIAdapter.findFile(filePath);
		if(f == null || !f.isFile()) return false;
		if(filePath.startsWith("~/"))
			filePath = System.getenv("HOME") + filePath.substring(1);
		GUIAdapter.openViewer(filePath, lineNum);
		return true;
	}

	/**
	 * CX^Xo[
	 */
	private AshGUIViewer() { }

	private static AshGUIViewer guiViewer = new AshGUIViewer();

	private String filePath;	// OpenViewer()\bhŎgpt@C̃pX
	private String lineNum;		// OpenViewer()\bhŎgpsԍ̕

	/**
	 * w肳ꂽeLXgGǍ݂̃J[\ʒuAt@CpX
	 * sԍTAtB[hϐfilePathlineNumɂꂼݒ肷B
	 * @param ta eLXgGA
	 * @param root [g̃pX
	 * @return t@Ctrue
	 */
	private boolean searchTarget(JTextArea ta, String root) {
		return
			guiViewer.searchRuntimeErrorFormat(ta, root) ||
			guiViewer.searchGrepFormat(ta, root);
	}

	// grep ̏o̓p^[
	static final String GREP_PAT =
		"(([a-zA-Z]:)?([^:*?'<>\"\\(\\)]+)):\\s*(\\d+):";
	//   $1=filePath  $3=path                   $4=lineNum
	// C:/Java/JUnit/junit4.4/src/junit/textui/TestRunner.java: 30:
	// src/ash/command/AshGrep.java: 13:
	private static Pattern grepPat = Pattern.compile(GREP_PAT);

	/**
	 * w肳ꂽeLXgGǍ݂̃J[\ʒuAgrep ̏o̓p^[
	 * t@CpXƍsԍTAtB[hϐfilePathlineNum
	 * ꂼݒ肷B
	 * @param ta eLXgGA
	 * @param root [g̃pX
	 * @return t@Ctrue
	 */
	private boolean searchGrepFormat(JTextArea ta, String root) {
		Matcher m = grepPat.matcher(getCurrentLine(ta));
		if(!m.find()) return false;
		filePath = m.group(1);
		lineNum = m.group(4);
		// ΃pXłȂꍇ́Aroot B
		if(!m.group(3).startsWith("/")) filePath = root + filePath;
		return true;
	}

	// sG[̏o̓p^[
	static final String FQCN_PAT = "([\\w.]*?)\\.?\\w+(\\$\\w+)?\\.[\\w\\$<>]+";
	//                              $1=package        $2=innerClass
	static final String ERR_PAT = FQCN_PAT + "\\((\\w+\\.java):\\s*(\\d+)\\)";
	//                                           $3=fileName       $4=lineNum
	// 	at junit.samples.SimpleTest.testDivideByZero(SimpleTest.java:52)
	//	at ash.gui.AshGrepDialog$AshGrepPanel.execGrep(AshGrepDialog.java:193)
	private static Pattern runtimeErrPat = Pattern.compile(ERR_PAT);

	/**
	 * w肳ꂽeLXgGǍ݂̃J[\ʒuA
	 * java sG[̏o̓p^[̃t@CpXƍsԍTA
	 * tB[hϐfilePathlineNumɂꂼݒ肷B
	 * @param ta eLXgGA
	 * @param root [g̃pX
	 * @return t@Ctrue
	 */
	private boolean searchRuntimeErrorFormat(JTextArea ta, String root) {
		Matcher m = runtimeErrPat.matcher(getCurrentLine(ta));
		if(!m.find()) return false;
		String path = m.group(1);		// junit.samples, ash.gui
		String fileName = m.group(3);	// SimpleTest.java, AshGrepDialog.java
		path = (path != null) ? path.replace('.', '/') + "/" : "";
		filePath = root + path + fileName;
		// filePath = junit/samples/SimpleTest.java
		lineNum = m.group(4);			// 52
		return true;
	}

	public static String getCurrentLine(JTextArea ta) {
		if(!guiViewer.currentLine(ta)) return "";
		return ta.getText().substring(guiViewer.start, guiViewer.end);
	}
	public static void selectCurrentLine(JTextArea ta) {
		if(guiViewer.currentLine(ta)) {
			ta.setSelectionStart(guiViewer.start);
			ta.setSelectionEnd(guiViewer.end);
		}
	}

	private int start = 0;
	private int end = 0;

	private boolean currentLine(JTextArea ta) {
		String text = ta.getText();
		int index = ta.getCaretPosition();
		if(text.length() <= index || text.charAt(index) == '\n') index--;
		if(0 <= index) {
			start = text.lastIndexOf('\n', index) + 1;
			end = text.indexOf('\n', index);
			if(end < 0) end = text.length();
			return (start < end);
		}
		return false;
	}
}
