package ash.gui.editor.core;
import java.io.File;
import java.util.List;
import java.util.ArrayList;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JScrollBar;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import java.awt.event.MouseEvent;
import java.awt.event.ActionEvent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuEvent;
import javax.swing.filechooser.FileFilter;
// VK_*: F, N, O, S, A, R, X, W, E, U, Z, R, Y, T, C, P, V, D, DELETE
import static java.awt.event.KeyEvent.*;
import ash.util.Log;
import ash.util.FileUtil;
import ash.gui.core.AshGUIFrame;
import ash.gui.core.AshMenu;
import ash.gui.core.AshPopupMenu;
import ash.gui.core.GUIAdapter;

/**
 * GfB^t[
 */
@SuppressWarnings("serial")
abstract public class AshEditorFrame extends AshGUIFrame {
	/**
	 * RXgN^F
	 * @j[o[Ac[o[A`̈AXe[^Xo[𐶐B
	 */
	public AshEditorFrame(String title) {
		super(title);
		showUntitled();
		showCursorPos(1, 0);
	}

	static final String UNTITLED = "Untitled";
	private void showUntitled() { setMessage(UNTITLED); }
	private void showFileName(String filename) {
		setMessage(FileUtil.normalPath(filename));
	}
	/*
	 * j[̍쐬
	 */
	protected static final String FILE_NEW    = actionName();
	protected static final String FILE_OPEN   = actionName();
	protected static final String FILE_SAVE   = actionName();
	protected static final String FILE_SAVEAS = actionName();
	protected static final String FILE_REVERT = actionName();
	protected static final String FILE_CLOSE  = actionName();
	protected static final String FILE_EXIT   = actionName();
	protected static final String EDIT_UNDO   = actionName();
	protected static final String EDIT_REDO   = actionName();
	protected static final String EDIT_COPY   = actionName();
	protected static final String EDIT_CUT    = actionName();
	protected static final String EDIT_PASTE  = actionName();
	protected static final String EDIT_DELETE = actionName();
	protected static final String EDIT_SELALL = actionName();
	protected static final String EDIT_SEARCH = actionName();
	protected static final String EDIT_NEXT   = actionName();
	protected static final String EDIT_PREV   = actionName();
	protected static final String EDIT_REGEX  = actionName();
	protected static final String EDIT_REPLACE= actionName();
	protected static final String EDIT_GOTO   = actionName();
	protected static final String VIEW_FONT   = actionName();
	protected static final String VIEW_STATUS = actionName();

	/*
	@Override protected JMenuBar createMenuBar() {
		assert Log.debug(1, "==>AshEditorFrame#createMenuBar()");
		JMenuBar mbar = new JMenuBar();
		mbar.add(new FileMenu());
		mbar.add(new EditMenu());
		mbar.add(new ViewMenu());
		return mbar;
	}
	*/
	protected class FileMenu extends AshMenu {
		public FileMenu() {
			construct();
		}
		protected void construct() {
			setup("t@C(F)");
			setActionListener(AshEditorFrame.this);
			add("VK(N)", FILE_NEW,  VK_N);
			add("J(O)", FILE_OPEN, VK_O);
			add("ۑ(S)", FILE_SAVE, VK_S);
			add("Otĕۑ(A)",  FILE_SAVEAS);
			add("A(R)", FILE_REVERT);
			addSeparator();
			add("I(X)", FILE_EXIT, VK_W);
		}
	}
	protected class EditMenu extends AshMenu {
		private JMenuItem cut, copy, delete, selAll;
		protected void constructUndo() {
			add("ɖ߂(U)",  EDIT_UNDO, VK_Z);
			add("蒼(R)",  EDIT_REDO, VK_Y);
		}
		protected void constructBasics() {
			cut    = add("؂(T)",  EDIT_CUT,    VK_X);
			copy   = add("Rs[(C)",    EDIT_COPY,   VK_C);
					 add("\t(P)",  EDIT_PASTE,  VK_V);
			delete = add("폜(D)",      EDIT_DELETE, VK_DELETE, 0);
			selAll = add("ׂđI(A)",EDIT_SELALL, VK_A);
		}
		@Override public void menuSelected(MenuEvent e) {
			//setMessage("ҏWj[I܂B");
			if(cut == null) return;
			boolean selected = editArea.isSelected();
			cut.setEnabled(selected);
			copy.setEnabled(selected);
			delete.setEnabled(selected);
			selAll.setEnabled(editArea.isSelectable());
		}
	}
	/*
	protected class ViewMenu extends AshMenu {
		ViewMenu() {
			setup("\(V)");
			setActionListener(AshEditorFrame.this);
			add("tHg(F)",   VIEW_FONT);
			addSeparator();
			add(makeStatusMenuItem());
		}
	}
	*/

	/*
	 * |bvAbvj[̍쐬Ǝs
	 */
	protected AshPopupMenu createPopupMenu(Component popupArea) {
		return new EditAreaPopup(popupArea);
	}
	protected class EditAreaPopup extends AshPopupMenu {
		private JMenuItem cut, copy, delete, selAll;
		protected EditAreaPopup(Component popupArea) { super(popupArea); }
		protected void construct() {
			setActionListener(AshEditorFrame.this);
			cut    = add("؂", EDIT_CUT);
			copy   = add("Rs[",   EDIT_COPY);
					 add("\t", EDIT_PASTE);
			delete = add("폜",     EDIT_DELETE);
					 addSeparator();
			selAll = add("ׂđI", EDIT_SELALL);
					 addSeparator();
					 add("",   FILE_CLOSE);
		}
		@Override protected void popupSelected(MouseEvent me) {
			boolean selected = editArea.isSelected();
			cut.setEnabled(selected);
			copy.setEnabled(selected);
			delete.setEnabled(selected);
			selAll.setEnabled(editArea.isSelectable());
		}
	}

	/*
	 * ANV̎s
	 *   ActionListener C^tF[X̎
	 */
	public void actionPerformed(ActionEvent ae) {
		String action = ae.getActionCommand();
		if(action.equals(FILE_NEW)) {			// VK쐬
			newFile();
		} else if(action.equals(FILE_OPEN)) {	// J
			openFile();
		} else if(action.equals(FILE_SAVE)) {	// ㏑ۑ
			saveFile(editArea);
		} else if(action.equals(FILE_SAVEAS)) {	// Otĕۑ
			saveAsFile(editArea);
		} else if(action.equals(FILE_REVERT)) {	// A
			revertFile(editArea);
		} else if(action.equals(FILE_CLOSE)) {	// N[Y
			closeFile();
		} else if(action.equals(FILE_EXIT)) {	// I
			disposeFrame();
		} else if(action.equals(EDIT_UNDO)) {	// AhD
			editArea.undo();
		} else if(action.equals(EDIT_REDO)) {	// hD
			editArea.redo();
		} else if(action.equals(EDIT_COPY)) {	// Rs[
			editArea.copy();
		} else if(action.equals(EDIT_CUT)) {	// Jbg
			editArea.cut();
		} else if(action.equals(EDIT_PASTE)) {	// y[Xg
			editArea.paste();
		} else if(action.equals(EDIT_DELETE)) {	// 폜
			editArea.delete();
		} else if(action.equals(EDIT_GOTO)) {	// sֈړ
			editArea.gotoLine();
		} else if(action.equals(EDIT_SELALL)) {	// SĂI
			editArea.selectAll();
		} else if(action.equals(VIEW_FONT)) {	// tHg
			editArea.setFont();
		} else {
			super.actionPerformed(ae);
		}
	}

	/**
	 * ҏWΏۂ̃hLgɑ΂GfB^̈𐶐B
	 * CX^XgNXŎȂ΂ȂȂB
	 * Factory Method p^[Kp
	 */
	abstract protected AshEditorArea createEditArea();
	protected void setEditArea(AshEditorArea editArea) {	// CA,20111006
		this.editArea = editArea;
	}
	private AshEditorArea editArea;							// CA,20111006
	private JTabbedPane tabbedPane;		// t@CҏW̏ꍇɎgpB
	private boolean isMultiEditor() { return tabbedPane != null; }
	private AshScrollPane scrollPane;
	private int findTabIndex(AshEditorArea ea) {
		int n = tabbedPane.getTabCount();
		for(int i = 0; i < n; i++) {
			AshScrollPane sp = (AshScrollPane)tabbedPane.getComponentAt(i);
			if(sp.editArea == ea) return i;
		}
		return -1;
	}
	private String getTabTitle(AshEditorArea ea) {
		if(tabbedPane == null) return UNTITLED;
		return tabbedPane.getTitleAt(findTabIndex(ea));
	}
	private void setTabTitle(AshEditorArea ea, String title) {
		tabbedPane.setTitleAt(findTabIndex(ea), title);
	}


	static int scrollBarPolicy = JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED;
	private static class AshScrollPane extends JScrollPane {
		AshEditorArea editArea;
		AshScrollPane(AshEditorArea editArea) {
			this.editArea = editArea;
			setViewportView(editArea.getEditArea());
			setEnabled(true);
			setHorizontalScrollBarPolicy(scrollBarPolicy);
		}
		JScrollBar getVScrollBar() { return verticalScrollBar; }
	}
	public final int getViewHeight() {
		return scrollPane.getHeight();
	}
	public final int getTopPixel() {
		return scrollPane.getVScrollBar().getValue();
	}
	public final void setTopPixel(int value) {
		scrollPane.getVScrollBar().setValue(value);
	}

	/**
	 * ҏẄ̕ύXmB
	 * @param ea ҏẄ
	 * @param text me
	 */
	void notifyUpdate(AshEditorArea ea, String text) {
		if(isMultiEditor()) {
			Log.debug(55, text);
			int index = findTabIndex(ea);
			if(ea != editArea) {
				resetEditArea(ea);
				tabbedPane.setSelectedIndex(index);
				scrollPane = (AshScrollPane)tabbedPane.getComponentAt(index);
			}
			if(ea.isModified()) {
				String title = getTabTitle(ea);
				if(!title.endsWith("*"))
					setTabTitle(ea, title + "*");
			}
		} else {
			super.setTitle(text);
		}
	}
	/**
	 * `̈̎擾FXN[@\ҏẄ(editArea)𐶐B
	 */
	@Override protected Component createWorkArea() {
  		return createEditor();
  	}
	/**
	 * XN[@\ҏẄ(editArea)𐶐B
	 */
	private AshScrollPane createEditor() {
		Log.debug(-55, "==> createEditor(): ");
		editArea = createEditArea();
  		createPopupMenu(editArea.getEditArea());
		scrollPane = new AshScrollPane(editArea);
		return scrollPane;
	}
	/**
	 * `̈̎擾Ft@CҏW@\^utyCԂB
	 */
	protected Component createMultiWorkArea() {
		tabbedPane = new JTabbedPane();
		tabbedPane.addChangeListener(new TabChangeListener());
		addEditorTab("*scratch*");
		return tabbedPane;
	}
	private void addEditorTab(String title) {
		AshScrollPane sp = createEditor();
		tabbedPane.addTab(title, sp);
		tabbedPane.setSelectedComponent(sp);
	}
	private class TabChangeListener implements ChangeListener {
		public void stateChanged(ChangeEvent e) {
			scrollPane = (AshScrollPane)tabbedPane.getSelectedComponent();
			resetEditArea(scrollPane.editArea);
		}
	}
	private void resetEditArea(AshEditorArea ea) {
		setEditArea(ea);
		File file = ea.getCurrentFile();
		if(file != null) showFileName(file.getPath());
	}
	/**
	 * w肳ꂽt@CI[viҏW\ԂɂjB
	 * łɃI[vĂꍇ͂̃^uIB
	 */
	public void findAndOpenFile(File file) {
		AshScrollPane sp = findEditorTab(file);
		if(sp == null) {
			Log.debug(55, "open: " + file.getPath());
			addEditorTab(file.getName());
			openFileSub(file);
		} else {
			Log.debug(55, "already opened: " + file.getPath());
			resetEditArea(sp.editArea);
			tabbedPane.setSelectedComponent(sp); 
			if(!editArea.isModified() || confirmCancel(file)) {
				openFileSub(file);
				updateTab(editArea);
			}
		}
	}
	private AshScrollPane findEditorTab(File file) {
		int n = tabbedPane.getTabCount();
		for(int i = 0; i < n; i++) {
			AshScrollPane sp = (AshScrollPane)tabbedPane.getComponentAt(i);
			File f = sp.editArea.getCurrentFile();
			if(file.equals(f)) return sp;
		}
		return null;
	}

	/*
	 *  Xe[^Xo[̃JX^}CY
	 */
	@Override protected String cursorPosDisplay(int row, int column) {
		int max = editArea.getLineCount();
		int ratio = (max == 0) ? 0 : (row*100 + max/2)/max;
		return ("--L" + row + "--C" + column + "--" + ratio + "%--");
	}

	/*
	 * t@C֘AR}h̎
	 */
	public void newFile() {			// t@CVKɍ쐬B
		if(isMultiEditor()) {
			addEditorTab(UNTITLED);
			editArea.newFile();
			showCursorPos(1, 0);
		} else if(confirmWriteBack(editArea)) {
			editArea.newFile();
			showUntitled();
			showCursorPos(1, 0);
		}
	}
	private void openFile() {		// t@CJB
		if(isMultiEditor() || confirmWriteBack(editArea)) {
			JFileChooser fc = getFileChooser(editArea);
			int ans = fc.showOpenDialog(getContentPane());
			if(ans == JFileChooser.APPROVE_OPTION)
				openFile(fc.getSelectedFile());
		}
	}
	private boolean saveFile(AshEditorArea ea) {	// t@C㏑ۑ
		if(ea.getCurrentFile() == null) return saveAsFile(ea);
		if(ea.isEditable()) {
			ea.writeFile();
			updateTab(ea);
			return true;
		}
		showMessage("ǂݍݐpłBۑł܂B");
		return false;
	}
	private boolean saveAsFile(AshEditorArea ea) {	// t@C𖼑Otĕۑ
		JFileChooser fc = getFileChooser(ea);
		while(true) {
			int ans = fc.showSaveDialog(getContentPane());
			if(ans != JFileChooser.APPROVE_OPTION) return false;
			File file = fc.getSelectedFile();
			if(!file.exists() || canOverride(file)) {
				if(ea.writeFile(file)) {
					showFileName(file.getPath());
					updateTab(ea);
				}
				break;
			}
		}
		return true;
	}
	private void revertFile(AshEditorArea ea) {	// t@CҏWȌԂɕA
		if(ea.isModified()) {
			File file = ea.getCurrentFile();
			if(file != null && confirmCancel(file)) {
				openFileSub(file);
				updateTab(ea);
			}
		}
	}

	private boolean canOverride(File file) {
		int ans = showConfirm("Lt@C͊ɑ݂Ă܂B" +
							  "㏑ėǂł?\n" +
							  findFileName(file), 
							  "㏑ۑ̊mF");
		return (ans == JOptionPane.YES_OPTION);
	}
	private boolean confirmCancel(File file) {
		int ans = showConfirm("Lt@C̃obt@͕ύXĂ܂B"+
							  "ύXėǂł?\n" +
							  findFileName(file),
							  "ύX̊mF");
		return (ans == JOptionPane.YES_OPTION);
	}
	private String findFileName(File file) {
		return (file != null) ? FileUtil.getPath(file) : "****";
	}
	private void updateTab(AshEditorArea ea) {
		File file = ea.getCurrentFile();
		if(isMultiEditor())
			setTabTitle(ea, file.getName());
	}

	/**
	 * GfB^t[IA\[XB
	 */
	@Override protected void disposeFrame() {
		if(confirmDispose()) {
			Log.debug(1, "==> AshEditorFrame#disposeFrame()");
			disposeEditorResource();
			dispose();
		}
	}
	@Override protected boolean confirmDispose() {
		if(!isMultiEditor()) return confirmWriteBack(editArea);
		int n = tabbedPane.getTabCount();
		for(int i = 0; i < n; i++) {
			AshScrollPane sp = (AshScrollPane)tabbedPane.getComponentAt(i);
			if(!confirmWriteBack(sp.editArea)) return false;
		}
		return true;
	}
	protected boolean confirmWriteBack(AshEditorArea ea) {
		if(ea.isModified()) {
			File file = ea.getCurrentFile();
			String fname = (file != null) ? findFileName(file) : getTabTitle(ea);
			int ans = showConfirm("L̃obt@͕ύXĂ܂B" +
								  "ύXۑ܂?\n" + fname);
			switch(ans) {
			case JOptionPane.YES_OPTION:	return saveFile(ea);
			case JOptionPane.NO_OPTION:		return true;
			case JOptionPane.CANCEL_OPTION:	return false;
			}
		}
		return true;
	}
	protected void disposeEditorResource() {}

	/**
	 * tB^[֌W
	 */
	private JFileChooser getFileChooser(AshEditorArea ea) {
		JFileChooser fc = new JFileChooser();
		fc.setCurrentDirectory(ea.getCurrentDirectory());
		File file = ea.getCurrentFile();
		if(file == null) file = new File(getTabTitle(ea));
		fc.setSelectedFile(file);
		if(fileFilter != null) fc.setFileFilter(fileFilter);
		return fc;
	}
	private AshFileFilter fileFilter = null;
	/**
	 * tB^[ݒ肷B
	 * tB^[̐ݒ́AAshEditor NX̊gNXsB
	 */
	public void setFileFilter(String description) {
		fileFilter = new AshFileFilter();
		fileFilter.description = description;
	}
	public void setFileFilter(String description, String[] suffixes) {
		setFileFilter(description);
		for(String suffix : suffixes) fileFilter.addSuffix(suffix);
	}
	public void addFileFilterSuffix(String suffix) {
		if(fileFilter == null) fileFilter = new AshFileFilter();
		fileFilter.addSuffix(suffix);
	}
	private static class AshFileFilter extends FileFilter {
		private List<String> suffixArray = new ArrayList<String>();
		String description = "Ash file";
		void addSuffix(String suffix) {
			suffixArray.add(suffix);
		}
		public boolean accept(File f) {
			if(suffixArray == null) return true;
			if(f.isDirectory()) return true;
			String name = f.getName();
			int index = name.lastIndexOf('.');
			String fileSuffix = (index < 0) ? "" : name.substring(index+1);
			for(String suffix : suffixArray)
				if(fileSuffix.equalsIgnoreCase(suffix)) return true;
			return false;
		}
		public String getDescription() { return description; }
	}

	public void openFile(String filename) {
		openFile(GUIAdapter.findFile(filename));
	}
	protected void closeFile() {
		if(isMultiEditor()) {
			if(tabbedPane.getSelectedIndex() > 0 && confirmWriteBack(editArea)) {
				tabbedPane.remove(scrollPane);
			}
		} else {
			disposeFrame();
		}
	}

	/*
	 * AshEditor Ă΂郁\bh
	 */
	/**
	 * w肳ꂽt@CI[viҏW\ԂɂjB
	 * t@CΉłłɃI[vĂꍇ͂̃^uIB
	 */
	public void openFile(File file) {
		if(isMultiEditor()) {
			findAndOpenFile(file);
		} else {
			openFileSub(file);
		}
	}
	private void openFileSub(File file) {
		editArea.openFile(file);
		showCursorPos(1, 0);
		showFileName(file.getPath());
	}
	public void setTextData(String title, String text) {
		if(title == null) title = UNTITLED;
		if(isMultiEditor()) addEditorTab(title);	// CA,090903 BUGGY?
		Log.debug(-55, "==> setTextData: " + text);
		editArea.setTextData(text);
	}
	public void setFileName(String filename) {
		showFileName(filename);
		editArea.setFileName(filename);
		if(isMultiEditor())
			setTabTitle(editArea, filename);
	}
	public void setEditable(boolean editable) {
		editArea.setEditable(editable);
	}
	public void setEditFont(Font font) {
		editArea.setFont(font);
	}
	public void setRowColumn(int rows, int columns) {
		editArea.setRowColumn(rows, columns);
	}
	public void showLine(int lineNum) {
		editArea.showLine(lineNum - 1);
	}
}
