package ash.gui.core;
import java.awt.Toolkit;
import java.awt.event.ActionListener;
import javax.swing.KeyStroke;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

/**
 * j[̍쐬Ɏgpx[XNXB
 * j[ڂ̍쐬ɂadd(...)\bhgpB
 */
@SuppressWarnings("serial")
public class AshMenu extends JMenu implements MenuListener, AshIMenu {
	final static int MASK = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
	private ActionListener listener = GUIAdapter.getListener();
	public void setup(String text) {
		setText(text);
		AshPanel.setMnemonic(this, text);
		addMenuListener(this);
	}
	public void setActionListener(ActionListener listener) {
		this.listener = listener;
	}

	@Override public JMenuItem add(String text, String action) {
		JMenuItem menuItem = new JMenuItem();
		menuItem.setText(text);
		AshPanel.setMnemonic(menuItem, text);
		menuItem.setActionCommand(action);
		menuItem.addActionListener(listener);
		super.add(menuItem);
		return menuItem;
	}

	public JMenuItem add(String text, String action, int acc) {
		JMenuItem menuItem = add(text, action);
		menuItem.setAccelerator(KeyStroke.getKeyStroke(acc, MASK));
		return menuItem;
	}

	public JMenuItem add(String text, String action, int acc, int mask) {
		JMenuItem menuItem = add(text, action);
		menuItem.setAccelerator(KeyStroke.getKeyStroke(acc, mask));
		return menuItem;
	}

	/*
	 * MenuListener ̃A_v^
	 */
	@Override public void menuSelected(MenuEvent e) {}
	@Override public void menuDeselected(MenuEvent e) {}
	@Override public void menuCanceled(MenuEvent e) {}
}
