/*
 * Decompiled with CFR 0.152.
 */
package ash.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;

public class StackTrace {
    private static int traceLevel = 10;
    private static List<String> patterns = new ArrayList<String>();

    public static void setTraceLevel(int n) {
        traceLevel = n;
    }

    public static int getTraceLevel() {
        return traceLevel;
    }

    public static void addFilter(String string) {
        patterns.add(string);
    }

    public static void resetFilter() {
        patterns = new ArrayList<String>();
    }

    public static void printFilters(PrintStream printStream) {
        for (String string : patterns) {
            printStream.println(string);
        }
    }

    public static void print(PrintStream printStream, Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stringWriter));
        String string = stringWriter.toString();
        try {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
            int n = 0;
            while ((string2 = bufferedReader.readLine()) != null) {
                if (StackTrace.filterLine(string2)) continue;
                printStream.println(string2);
                if (++n <= traceLevel) continue;
                break;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static boolean filterLine(String string) {
        for (String string2 : patterns) {
            if (string.indexOf(string2) <= 0) continue;
            return true;
        }
        return false;
    }
}

