/*
 * Decompiled with CFR 0.152.
 */
package ash.util;

import ash.util.GArc;
import ash.util.GNode;
import ash.util.PrintTree;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class Graph<T>
implements Iterable<GNode<T>> {
    private GNode<T> first = null;
    private GNode<T> last = null;
    private int nNode = 0;
    private int nArc = 0;
    private boolean arcAtLast = true;

    public void makeFromPair(BufferedReader bufferedReader) throws IOException {
        String string;
        while ((string = bufferedReader.readLine()) != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            String string2 = null;
            String string3 = null;
            try {
                string2 = stringTokenizer.nextToken();
                string3 = stringTokenizer.nextToken();
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
            if (string2 == null) continue;
            if (string3 == null) {
                this.store(string2);
                continue;
            }
            this.storePair(string2, string3);
        }
    }

    public void makeFromHier(BufferedReader bufferedReader) throws IOException {
        String string;
        String string2 = "????";
        while ((string = bufferedReader.readLine()) != null) {
            if (string.length() <= 0) continue;
            if (string.charAt(0) != '\t') {
                this.store(string);
                string2 = string;
                continue;
            }
            if ((string = string.substring(1)).length() <= 0) continue;
            this.storePair(string2, string);
        }
    }

    public void printPair(PrintStream printStream) {
        for (GNode<T> gNode : this) {
            if (!gNode.hasOut() && !gNode.hasIn()) {
                printStream.println(gNode.data);
            }
            for (GNode<T> gNode2 : gNode) {
                printStream.println(gNode.data + "\t" + gNode2.data);
            }
        }
    }

    public void printHier(PrintStream printStream) {
        for (GNode<T> gNode : this) {
            if (!gNode.hasOut() && gNode.hasIn()) continue;
            printStream.println(gNode.data);
            for (GNode<T> gNode2 : gNode) {
                printStream.println("\t" + gNode2.data);
            }
        }
    }

    public void printTree(PrintStream printStream) {
        PrintTree<T> printTree = new PrintTree<T>(10, printStream);
        for (GNode<T> gNode : this) {
            gNode.flag = 0;
        }
        for (GNode<T> gNode : this) {
            if (gNode.hasIn()) continue;
            printTree.printTree(gNode);
        }
        for (GNode<T> gNode : this) {
            if (gNode.flag != 0) continue;
            printTree.printTree(gNode);
        }
    }

    @Override
    public Iterator<GNode<T>> iterator() {
        return new Iterator<GNode<T>>(){
            GNode<T> cursor;
            {
                this.cursor = Graph.this.first;
            }

            @Override
            public boolean hasNext() {
                return this.cursor != null;
            }

            @Override
            public GNode<T> next() {
                if (this.cursor == null) {
                    throw new NoSuchElementException();
                }
                GNode gNode = this.cursor;
                this.cursor = this.cursor.next;
                return gNode;
            }

            @Override
            public void remove() {
            }
        };
    }

    public int nNode() {
        return this.nNode;
    }

    public int nArc() {
        return this.nArc;
    }

    public void initFlag(int n) {
        GNode<T> gNode = this.first;
        while (gNode != null) {
            gNode.flag = n;
            gNode = gNode.next;
        }
    }

    public GNode<T> get(int n) {
        if (n < 0) {
            return this.last;
        }
        GNode<T> gNode = this.first;
        while (gNode != null) {
            if (n-- == 0) {
                return gNode;
            }
            gNode = gNode.next;
        }
        return null;
    }

    public GNode<T> find(T t) {
        GNode<T> gNode = this.first;
        while (gNode != null) {
            if (t.equals(gNode.data)) {
                return gNode;
            }
            gNode = gNode.next;
        }
        return null;
    }

    public GNode<T> store(T t) {
        GNode<T> gNode = this.find(t);
        if (gNode == null) {
            gNode = new GNode<T>(t);
            this.addNode(gNode, -1);
        }
        return gNode;
    }

    public void add(T t, int n) {
        this.addNode(new GNode<T>(t), n);
    }

    public void addNode(GNode<T> gNode, int n) {
        if (this.first != null) {
            if (n == 0) {
                gNode.next = this.first;
                this.first = gNode;
            } else {
                GNode<T> gNode2 = this.get(n - 1);
                if (gNode2 == null) {
                    gNode2 = this.last;
                }
                gNode.next = gNode2.next;
                gNode2.next = gNode;
                if (gNode2 == this.last) {
                    this.last = gNode;
                }
            }
        } else {
            gNode.next = null;
            this.last = gNode;
            this.first = this.last;
        }
        ++this.nNode;
    }

    public void deleteNode(GNode<T> gNode) {
        this.deleteArcs(gNode);
        --this.nNode;
        if (this.first == gNode) {
            this.first = gNode.next;
            if (this.first == null) {
                this.last = null;
            }
        } else {
            GNode<T> gNode2 = this.first;
            while (gNode2.next != gNode) {
                gNode2 = gNode2.next;
            }
            gNode2.next = gNode.next;
            if (gNode == this.last) {
                this.last = gNode2;
            }
        }
    }

    void reset() {
        this.last = null;
        this.first = null;
        this.nArc = 0;
        this.nNode = 0;
    }

    void compressArcs() {
        GNode<T> gNode = this.first;
        while (gNode != null) {
            GArc gArc = gNode.firstA;
            while (gArc != null) {
                GNode gNode2 = gArc.nodeB;
                GArc gArc2 = gArc.nextA;
                while (gArc2 != null) {
                    GArc gArc3 = gArc2;
                    gArc2 = gArc2.nextA;
                    if (gArc3.nodeB != gNode2) continue;
                    this.deleteArc(gArc3);
                }
                gArc = gArc.nextA;
            }
            gNode = gNode.next;
        }
    }

    void deleteAllArcs() {
        GNode<T> gNode = this.first;
        while (gNode != null) {
            this.deleteArcs(gNode);
            gNode = gNode.next;
        }
    }

    void deleteArcs(GNode<T> gNode) {
        while (gNode.firstA != null) {
            this.deleteArc(gNode.firstA);
        }
        while (gNode.firstB != null) {
            this.deleteArc(gNode.firstB);
        }
    }

    void unlinkAllArcA() {
        GNode<T> gNode = this.first;
        while (gNode != null) {
            GArc gArc = gNode.firstB;
            while (gArc != null) {
                this.unlinkArcA(gArc);
                gArc = gArc.nextB;
            }
            gNode = gNode.next;
        }
    }

    void unlinkAllArcB() {
        GNode<T> gNode = this.first;
        while (gNode != null) {
            GArc gArc = gNode.firstA;
            while (gArc != null) {
                this.unlinkArcB(gArc);
                gArc = gArc.nextA;
            }
            gNode = gNode.next;
        }
    }

    void storePair(T t, T t2) {
        GNode<T> gNode = this.store(t);
        GNode<T> gNode2 = this.store(t2);
        GArc gArc = gNode.firstA;
        while (gArc != null) {
            if (gArc.nodeB == gNode2) {
                return;
            }
            gArc = gArc.nextA;
        }
        this.addArc(new GArc(), gNode, gNode2);
    }

    void addArc(GArc<T> gArc, GNode<T> gNode, GNode<T> gNode2) {
        this.linkArcA(gArc, gNode);
        this.linkArcB(gArc, gNode2);
        ++this.nArc;
    }

    void deleteArc(GArc<T> gArc) {
        this.unlinkArcA(gArc);
        this.unlinkArcB(gArc);
        --this.nArc;
    }

    void changeArcA(GArc<T> gArc, GNode<T> gNode) {
        this.unlinkArcA(gArc);
        this.linkArcA(gArc, gNode);
    }

    void changeArcB(GArc<T> gArc, GNode<T> gNode) {
        this.unlinkArcB(gArc);
        this.linkArcB(gArc, gNode);
    }

    private void linkArcA(GArc<T> gArc, GNode<T> gNode) {
        gArc.nodeA = gNode;
        if (this.arcAtLast) {
            if (gNode.firstA != null) {
                GArc gArc2 = gNode.firstA;
                while (gArc2.nextA != null) {
                    gArc2 = gArc2.nextA;
                }
                gArc2.nextA = gArc;
            } else {
                gNode.firstA = gArc;
            }
        } else {
            gArc.nextA = gNode.firstA;
            gNode.firstA = gArc;
        }
    }

    private void linkArcB(GArc<T> gArc, GNode<T> gNode) {
        gArc.nodeB = gNode;
        if (this.arcAtLast) {
            if (gNode.firstB != null) {
                GArc gArc2 = gNode.firstB;
                while (gArc2.nextB != null) {
                    gArc2 = gArc2.nextB;
                }
                gArc2.nextB = gArc;
            } else {
                gNode.firstB = gArc;
            }
        } else {
            gArc.nextB = gNode.firstB;
            gNode.firstB = gArc;
        }
    }

    private void unlinkArcA(GArc<T> gArc) {
        GArc gArc2 = gArc.nodeA.firstA;
        if (gArc2 == gArc) {
            gArc.nodeA.firstA = gArc.nextA;
        } else {
            while (gArc2.nextA != gArc) {
                gArc2 = gArc2.nextA;
                if (gArc2 != null) continue;
                return;
            }
            gArc2.nextA = gArc.nextA;
        }
        gArc.nextA = null;
        gArc.nodeA = null;
    }

    private void unlinkArcB(GArc<T> gArc) {
        GArc gArc2 = gArc.nodeB.firstB;
        if (gArc2 == gArc) {
            gArc.nodeB.firstB = gArc.nextB;
        } else {
            while (gArc2.nextB != gArc) {
                gArc2 = gArc2.nextB;
                if (gArc2 != null) continue;
                return;
            }
            gArc2.nextB = gArc.nextB;
        }
        gArc.nextB = null;
        gArc.nodeB = null;
    }

    void copy(Graph<T> graph) {
        GNode gNode;
        HashMap<GNode<T>, GNode> hashMap = new HashMap<GNode<T>, GNode>();
        this.reset();
        GNode<T> gNode2 = graph.first;
        while (gNode2 != null) {
            gNode = new GNode(gNode2.data);
            hashMap.put(gNode2, gNode);
            this.addNode(gNode, -1);
            gNode2 = gNode2.next;
        }
        gNode2 = graph.first;
        while (gNode2 != null) {
            gNode = (GNode)hashMap.get(gNode2);
            GArc gArc = gNode2.firstA;
            while (gArc != null) {
                this.addArc(new GArc(gArc.data), gNode, (GNode)hashMap.get(gArc.nodeB));
                gArc = gArc.nextA;
            }
            gNode2 = gNode2.next;
        }
        this.checkLink();
    }

    void merge(Graph<T> graph) {
        if (graph.first == null) {
            return;
        }
        if (this.first != null) {
            this.last.next = graph.first;
        } else {
            this.first = graph.first;
        }
        this.last = graph.last;
        this.nNode += graph.nNode;
        this.nArc += graph.nArc;
        graph.last = null;
        graph.first = null;
        graph.nArc = 0;
        graph.nNode = 0;
    }

    public void checkLink() {
        if (!this.assertLink()) {
            System.err.println("***** CheckLink Failed ! *****");
        }
    }

    private boolean assertLink() {
        GNode<T> gNode = null;
        GNode<T> gNode2 = this.first;
        while (gNode2 != null) {
            GArc gArc = gNode2.firstA;
            while (gArc != null) {
                if (gArc.nodeA != gNode2) {
                    return false;
                }
                gArc = gArc.nextA;
            }
            gArc = gNode2.firstB;
            while (gArc != null) {
                if (gArc.nodeB != gNode2) {
                    return false;
                }
                gArc = gArc.nextB;
            }
            gNode = gNode2;
            gNode2 = gNode2.next;
        }
        return gNode == this.last;
    }

    public void printGraph() {
        System.err.println("==>printGraph():");
        GNode<T> gNode = this.first;
        while (gNode != null) {
            System.err.println(gNode);
            GArc gArc = gNode.firstA;
            while (gArc != null) {
                System.err.println("\t" + gArc);
                gArc = gArc.nextA;
            }
            System.err.println("\t======");
            gArc = gNode.firstB;
            while (gArc != null) {
                System.err.println("\t" + gArc);
                gArc = gArc.nextB;
            }
            gNode = gNode.next;
        }
    }
}

